/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.tool.mealplan.spec.details;

import ch.icit.pegasus.client.gui.modules.product.details.utils.CopyCateringServiceScheduleVariantPopup;
import ch.icit.pegasus.client.gui.screentemplates.details.AVariantDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.InnerPopUpListener2;
import ch.icit.pegasus.client.gui.utils.buttons.AddButton;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.DeleteButton;
import ch.icit.pegasus.client.gui.utils.datechooser.DateChooser;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDDateChooser;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDTextField;
import ch.icit.pegasus.client.gui.utils.skins.SizedSkin1Field;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.mealplan.MealPlanServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.SystemSettingsServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.client.validator.ValidationUtil;
import ch.icit.pegasus.server.core.dtos.masterdata.ModificationStateE;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete_;
import ch.icit.pegasus.server.core.dtos.mealplan.CateringServiceScheduleComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.CateringServiceScheduleComplete_;
import ch.icit.pegasus.server.core.dtos.mealplan.CateringServiceScheduleVariantComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.CateringServiceScheduleVariantComplete_;
import ch.icit.pegasus.server.core.dtos.mealplan.CateringServiceScheduleVariantReference;
import ch.icit.pegasus.server.core.dtos.mealplan.MealPlanLight;
import ch.icit.pegasus.server.core.dtos.mealplan.MealPlanLight_;
import ch.icit.pegasus.server.core.dtos.recipe.RecipeComplete_;
import ch.icit.pegasus.server.core.dtos.recipe.RecipeVariantLight_;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.CateringServiceAccess;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.IDTO;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.sql.Date;
import java.util.ArrayList;
import java.util.List;

public class VariantDetailsPanel<T extends IDTO>
extends AVariantDetailsPanel<T> {
    private static final long serialVersionUID = 1L;

    public VariantDetailsPanel(RowEditor<T> editor, RDProvider provider) {
        super((RowEditor)editor, provider);
    }

    @Override
    public Class getCommittingClass(Node<?> node) {
        return CateringServiceScheduleVariantComplete.class;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        boolean shouldEnable = isEnabled;
        MealPlanLight mp = (MealPlanLight)this.editor.getModel().getNode().getChildNamed(CateringServiceScheduleComplete_.mealplan).getValue();
        if (mp != null) {
            shouldEnable = mp.getState() == ModificationStateE.DRAFT && shouldEnable;
        }
        super.setEnabled(shouldEnable);
    }

    @Override
    public List<TableColumnInfo> getColumns() {
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        int tw = 2 * this.table.getCellPadding() + DateChooser.getPreferredWidth(this, false);
        int tw2 = 2 * this.table.getCellPadding() + DateChooser.getPreferredWidth(this, true);
        columns.add(new TableColumnInfo(Words.FROM, null, null, null, "", tw, tw, tw));
        columns.add(new TableColumnInfo(Words.TO, null, null, null, "", tw2, tw2, tw2));
        columns.add(new TableColumnInfo(Words.COMMENT, null, null, null, "", 30, Integer.MAX_VALUE, 30));
        tw = 3 * this.table.getCellPadding() + 2 * DeleteButton.getPreferredWidth(SizedSkin1Field.SkinSize.MEDIUM);
        columns.add(new TableColumnInfo("", null, null, null, "", tw, tw, tw));
        ((TableColumnInfo)columns.get(0)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(1)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(2)).setxExpand(1.0);
        ((TableColumnInfo)columns.get(3)).setxExpand(0.0);
        return columns;
    }

    @Override
    public List<ScreenValidationObject> validateParagraph() {
        this.table.updateOrder();
        ArrayList<ScreenValidationObject> o = new ArrayList<ScreenValidationObject>();
        Date t = new PeriodComplete((Date)this.editor.getModel().getNode().getChildNamed(new DtoField[]{RecipeComplete_.period, PeriodComplete_.startDate}).getValue(), null).getStartDate();
        long lastDate = t.getTime();
        --lastDate;
        boolean b = false;
        for (Table2RowPanel p : this.table.getRows()) {
            o.addAll(((TableRowImpl)p).validateRow());
            Date s = (Date)p.getModel().getNode().getChildNamed(new DtoField[]{RecipeVariantLight_.validityPeriod, PeriodComplete_.startDate}).getValue();
            Date e = (Date)p.getModel().getNode().getChildNamed(new DtoField[]{RecipeVariantLight_.validityPeriod, PeriodComplete_.endDate}).getValue();
            PeriodComplete pc = new PeriodComplete(s, e);
            Date d = pc.getStartDate();
            if (lastDate + 1L != d.getTime()) {
                b = true;
            }
            d = pc.getEndDate();
            lastDate = d.getTime();
        }
        Date d = (Date)this.editor.getModel().getNode().getChildNamed(new DtoField[]{RecipeComplete_.period, PeriodComplete_.endDate}).getValue();
        long endDate = new PeriodComplete(null, d).getEndDate().getTime();
        if (lastDate != endDate) {
            b = true;
        }
        if (b) {
            o.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Ensure the given Catering Service Variants aren't overlapping. Avoid gaps between each Catering Service Variant"));
        }
        if (this.table.getRowCount() == 0) {
            o.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Every Catering Service needs atleast one variant."));
        }
        return o;
    }

    @Override
    public Table2RowPanel getTableRow(Table2RowModel model) {
        return new TableRowImpl(model);
    }

    @Override
    public void reloadVariant(final Node n, final Table2RowPanel panel) {
        this.editor.showCommittingAnimation(Words.LOAD_DATA);
        this.editor.setEnabled(false);
        CateringServiceScheduleVariantComplete c = (CateringServiceScheduleVariantComplete)n.getValue(CateringServiceScheduleVariantComplete.class);
        if (c == null) {
            ThreadSafeExecutable run = new ThreadSafeExecutable(this){

                @Override
                public Node<?> loadData() throws Exception {
                    CateringServiceScheduleVariantComplete r;
                    Node node = n;
                    SystemSettingsComplete s = (SystemSettingsComplete)((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getSettingsCached().getValue();
                    CateringServiceScheduleVariantReference ref = (CateringServiceScheduleVariantReference)n.getValue(CateringServiceScheduleVariantReference.class);
                    if (ref == null && (r = (CateringServiceScheduleVariantComplete)n.getValue(CateringServiceScheduleVariantComplete.class)) != null) {
                        ref = new CateringServiceScheduleVariantReference(r.getId());
                    }
                    if (ref == null) {
                        throw new ClientServerCallException("Not Service Variant found");
                    }
                    CateringServiceScheduleVariantComplete cc = (CateringServiceScheduleVariantComplete)((MealPlanServiceManager)ServiceManagerRegistry.getService(MealPlanServiceManager.class)).getVariant(new CateringServiceScheduleVariantReference(ref.getId())).getValue();
                    n.removeExistingValues();
                    n.setValue((Object)cc, 0L);
                    return n;
                }

                @Override
                public RemoteLoader getInvoker() {
                    return new RemoteLoader(){

                        public void remoteObjectLoaded(Node<?> node) {
                            VariantDetailsPanel.this.updatePanels(node, panel);
                            VariantDetailsPanel.this.editor.createFocusCycle();
                        }

                        public void errorOccurred(ClientException exception) {
                            VariantDetailsPanel.this.errorOccurred(exception);
                        }
                    };
                }

                @Override
                public long getID() {
                    return 0L;
                }
            };
            ThreadSafeLoader.run(run);
        } else {
            this.updatePanels(n, panel);
        }
    }

    @Override
    public boolean isVariantParent(Node<?> node) {
        return node.getValue() instanceof CateringServiceScheduleComplete;
    }

    private class TableRowImpl
    extends Table2RowPanel
    implements ButtonListener {
        private static final long serialVersionUID = 1L;
        private RDDateChooser startDate;
        private RDDateChooser endDate;
        private RDTextField internalComment;
        private AddButton cloneButton;
        private DeleteButton delete;

        public TableRowImpl(Table2RowModel m) {
            super(m);
            this.setSelectable(true);
            boolean isAccepted = VariantDetailsPanel.this.editor.getModel().getNode().getChildNamed(new DtoField[]{CateringServiceScheduleComplete_.mealplan, MealPlanLight_.state}).getValue() == ModificationStateE.ACCEPTED;
            this.startDate = new RDDateChooser(VariantDetailsPanel.this.provider);
            this.startDate.setOverrideName(CateringServiceAccess.EDIT_VARIANT_PERIOD);
            this.startDate.setNode(m.getNode().getChildNamed(new DtoField[]{CateringServiceScheduleVariantComplete_.validityPeriod, PeriodComplete_.startDate}));
            this.endDate = new RDDateChooser(VariantDetailsPanel.this.provider);
            this.endDate.setOverrideName(CateringServiceAccess.EDIT_VARIANT_PERIOD);
            this.endDate.setCheckBoxEnabled();
            this.endDate.setNode(m.getNode().getChildNamed(new DtoField[]{CateringServiceScheduleVariantComplete_.validityPeriod, PeriodComplete_.endDate}));
            this.internalComment = new RDTextField(VariantDetailsPanel.this.provider);
            this.internalComment.setOverrideName(CateringServiceScheduleVariantComplete_.internalComment);
            this.internalComment.setNode(this.model.getNode().getChildNamed(CateringServiceScheduleVariantComplete_.internalComment));
            boolean isDeletable = VariantDetailsPanel.this.provider.isWritable(CateringServiceAccess.DELETE_VARIANT) && !isAccepted;
            boolean isAddable = VariantDetailsPanel.this.provider.isWritable(CateringServiceAccess.EDIT_VARIANT_PERIOD);
            if (isDeletable && !isAccepted) {
                this.delete = new DeleteButton(SizedSkin1Field.SkinSize.SMALL);
            }
            if (isAddable && m.getNode().getChildNamed(new String[]{"id"}).getValue() != null) {
                this.cloneButton = new AddButton(SizedSkin1Field.SkinSize.SMALL);
            }
            if (this.delete != null) {
                this.delete.addButtonListener(this);
            }
            if (this.cloneButton != null) {
                this.cloneButton.addButtonListener(this);
            }
            this.setLayout(new Layout());
            this.add(this.startDate);
            this.add(this.endDate);
            if (this.cloneButton != null) {
                this.add(this.cloneButton);
            }
            if (this.delete != null) {
                this.add(this.delete);
            }
            this.add(this.internalComment);
        }

        @Override
        public Color getRowColor(Table2RowPanel p) {
            boolean isNew = this.model.getNode().getChildNamed(new String[]{"newOne"}) != null;
            Color background = null;
            if (isNew) {
                background = new Color(100, 100, 100);
                return background;
            }
            return this.model.getParentModel().getTable().getColor4Index(this.colorIndex);
        }

        @Override
        public void updateRow(Node<?> node) {
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.startDate.kill();
            this.endDate.kill();
            if (this.delete != null) {
                this.delete.kill();
            }
            if (this.cloneButton != null) {
                this.cloneButton.kill();
            }
            this.internalComment.kill();
            this.startDate = null;
            this.endDate = null;
            this.delete = null;
            this.cloneButton = null;
            this.internalComment = null;
        }

        @Override
        public List<Component> getFocusComponents() {
            ArrayList<Component> a = new ArrayList<Component>();
            CheckedListAdder.addToList(a, this.startDate);
            CheckedListAdder.addToList(a, this.endDate);
            CheckedListAdder.addToList(a, this.internalComment);
            CheckedListAdder.addToList(a, this.cloneButton);
            CheckedListAdder.addToList(a, this.delete);
            return a;
        }

        @Override
        public Object getObject4Column(int column) {
            return this.startDate.getNode().getValue();
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            super.setEnabled(isEnabled);
            this.startDate.setEnabled(isEnabled);
            this.endDate.setEnabled(isEnabled);
            this.internalComment.setEnabled(isEnabled);
            if (this.delete != null) {
                this.delete.setEnabled(isEnabled);
            }
            if (this.cloneButton != null) {
                this.cloneButton.setEnabled(isEnabled);
            }
        }

        protected List<ScreenValidationObject> validateRow() {
            return ValidationUtil.validatePeriod((Node<Date>)this.getModel().getNode().getChildNamed(new DtoField[]{RecipeVariantLight_.validityPeriod, PeriodComplete_.startDate}), (Node<Date>)this.getModel().getNode().getChildNamed(new DtoField[]{RecipeVariantLight_.validityPeriod, PeriodComplete_.endDate}), this.startDate, this.endDate);
        }

        @Override
        public void buttonPressed(Button source, int x, int y) {
            if (source == this.delete) {
                this.model.getNode().getParent().removeChild(this.model.getNode(), System.currentTimeMillis());
            } else if (source == this.cloneButton) {
                InnerPopUp2 popUp = InnerPopUp2.getInnerPopUp();
                popUp.setAttributes(this.cloneButton, true, true, Words.COPY_VARIANT);
                popUp.setView(new CopyCateringServiceScheduleVariantPopup(this.model.getNode()));
                popUp.showPopUp(x, y, -1, -1, new InnerPopUpListener2(){

                    @Override
                    public void popUpClosed(InnerPopUp2 source, Object ... xargs) {
                        if (xargs == null) {
                            return;
                        }
                        Node nNode = (Node)xargs[0];
                        VariantDetailsPanel.this.table.getModel().getNode().addChild(nNode, 0L);
                        for (Table2RowPanel p : VariantDetailsPanel.this.table.getRows()) {
                            TableRowImpl i = (TableRowImpl)p;
                            i.enableVariantEdit();
                        }
                    }
                }, this.cloneButton);
            }
        }

        protected void enableVariantEdit() {
            this.startDate.showEditorAnyWay();
            this.endDate.showEditorAnyWay();
        }

        private class Layout
        extends DefaultLayout {
            private Layout() {
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TableRowImpl.this.getDefaultRowHeight());
            }

            @Override
            public void layoutContainer(Container parent) {
                int currentX = 0;
                int w = TableRowImpl.this.model.getParentModel().getColumnWidth(0);
                TableRowImpl.this.startDate.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.startDate.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.startDate.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.startDate.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(1);
                TableRowImpl.this.endDate.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.endDate.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.endDate.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.endDate.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(2);
                TableRowImpl.this.internalComment.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.internalComment.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.internalComment.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.internalComment.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(3);
                TableRowImpl.this.setControlsX(currentX);
                int ax = currentX + TableRowImpl.this.getCellPadding();
                if (TableRowImpl.this.cloneButton != null) {
                    TableRowImpl.this.cloneButton.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.cloneButton.getPreferredSize().getHeight()) / 2.0));
                    TableRowImpl.this.cloneButton.setSize(TableRowImpl.this.cloneButton.getPreferredSize());
                    ax = TableRowImpl.this.cloneButton.getX() + TableRowImpl.this.cloneButton.getWidth() + TableRowImpl.this.getCellPadding();
                }
                if (TableRowImpl.this.delete != null) {
                    TableRowImpl.this.delete.setLocation(ax, (int)(((double)parent.getHeight() - TableRowImpl.this.delete.getPreferredSize().getHeight()) / 2.0));
                    TableRowImpl.this.delete.setSize(TableRowImpl.this.delete.getPreferredSize());
                }
            }
        }
    }
}

