/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.tool.mealplan.spec.details;

import ch.icit.pegasus.client.converter.MealTypeConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.submodules.tool.mealplan.spec.details.utils.popupinsert.EditLoadingGroupPopupInsert;
import ch.icit.pegasus.client.gui.table.DefaultDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2ButtonHandler;
import ch.icit.pegasus.client.gui.table2.Table2Model;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.InnerPopUpListener2;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.DeleteButton;
import ch.icit.pegasus.client.gui.utils.buttons.EditButton;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.popup.PopupType;
import ch.icit.pegasus.client.gui.utils.skins.SizedSkin1Field;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.mealplan.MealPlanServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.masterdata.ModificationStateE;
import ch.icit.pegasus.server.core.dtos.mealplan.ALoadingGroupComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.CateringServicePartComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.CateringServicePartComplete_;
import ch.icit.pegasus.server.core.dtos.mealplan.CateringServiceRotationComplete_;
import ch.icit.pegasus.server.core.dtos.mealplan.CateringServiceScheduleComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.CateringServiceScheduleComplete_;
import ch.icit.pegasus.server.core.dtos.mealplan.CateringServiceScheduleVariantComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.CateringServiceScheduleVariantComplete_;
import ch.icit.pegasus.server.core.dtos.mealplan.CateringServiceScheduleVariantReference;
import ch.icit.pegasus.server.core.dtos.mealplan.LoadingGroupTemplateComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.LoadingGroupTemplateComplete_;
import ch.icit.pegasus.server.core.dtos.mealplan.MealPlanLight;
import ch.icit.pegasus.server.core.dtos.mealplan.MealPlanLight_;
import ch.icit.pegasus.server.core.dtos.supply.CustomerLight;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.IDTO;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class LoadingGroupsDetailsPanel<T extends IDTO>
extends DefaultDetailsPanel<T> {
    private static final long serialVersionUID = 1L;
    private Table2 table;
    private Node<MealPlanLight> mpNode;

    public LoadingGroupsDetailsPanel(RowEditor<T> editor, Node<MealPlanLight> mpNode) {
        super(editor, null);
        this.mpNode = mpNode;
        this.setTitleText(Words.LOADING_GROUPS);
        this.table = new Table2(true, Words.ADD, false, false);
        this.table.setButtonHandler(new Table2ButtonHandler(){

            @Override
            public void childRemoved() {
            }

            @Override
            public void addButtonPressed(int x, int y, Button source) {
                LoadingGroupsDetailsPanel.this.editor.showCommittingAnimation(Words.ADD_NEW_LOADING_GROUP);
                LoadingGroupsDetailsPanel.this.editor.setEnabled(false);
                ThreadSafeExecutable run = new ThreadSafeExecutable(){

                    @Override
                    public Node<?> loadData() throws Exception {
                        LoadingGroupTemplateComplete ng = new LoadingGroupTemplateComplete();
                        ng.setMaxPax(Integer.valueOf(0));
                        ng.setMinPax(Integer.valueOf(0));
                        ng.setContainingService((CateringServiceScheduleComplete)LoadingGroupsDetailsPanel.this.editor.getModel().getNode().getValue());
                        ng.setClientOId(Long.valueOf(ADTO.getNextId()));
                        ng.setName("" + (LoadingGroupsDetailsPanel.this.table.getRowCount() + 1));
                        Node n = INodeCreator.getDefaultImpl().getNode4DTO((Object)ng, true, false);
                        LoadingGroupsDetailsPanel.this.table.getModel().getNode().addChild(n, 0L);
                        Iterator it = LoadingGroupsDetailsPanel.this.editor.getModel().getNode().getChildNamed(CateringServiceScheduleComplete_.variants).getFailSafeChildIterator();
                        while (it.hasNext()) {
                            Node v = (Node)it.next();
                            if (v.getValue(CateringServiceScheduleVariantComplete.class) == null) {
                                CateringServiceScheduleVariantReference ref = (CateringServiceScheduleVariantReference)v.getValue(CateringServiceScheduleVariantReference.class);
                                CateringServiceScheduleVariantComplete cv = (CateringServiceScheduleVariantComplete)((MealPlanServiceManager)ServiceManagerRegistry.getService(MealPlanServiceManager.class)).getVariant(ref).getValue();
                                Node cvn = v;
                                cvn.setValue((Object)cv, 0L);
                            }
                            Node cvn = v;
                            LoadingGroupsDetailsPanel.this.processAddLoadingGroup((Node<CateringServiceScheduleVariantComplete>)cvn, ng);
                        }
                        return null;
                    }

                    @Override
                    public RemoteLoader getInvoker() {
                        return new RemoteLoader(){

                            public void remoteObjectLoaded(Node<?> node) {
                                LoadingGroupsDetailsPanel.this.editor.hideCommittingAnimation();
                                LoadingGroupsDetailsPanel.this.editor.setEnabled(true);
                            }

                            public void errorOccurred(ClientException exception) {
                                InnerPopupFactory.showErrorDialog((Exception)((Object)exception), (Component)LoadingGroupsDetailsPanel.this);
                                LoadingGroupsDetailsPanel.this.editor.hideCommittingAnimation();
                                LoadingGroupsDetailsPanel.this.editor.setEnabled(true);
                            }
                        };
                    }

                    @Override
                    public long getID() {
                        return 0L;
                    }
                };
                ThreadSafeLoader.run(run);
            }
        });
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        columns.add(new TableColumnInfo(Words.NAME, null, null, null, "", 40, 40, 40));
        columns.add(new TableColumnInfo(Words.MEAL_TYPE, null, null, null, "", 80, 80, 80));
        int tw = 2 * this.table.getCellPadding() + this.table.getInnerCellPadding() + 2 * DeleteButton.getPreferredWidth(SizedSkin1Field.SkinSize.MEDIUM);
        columns.add(new TableColumnInfo("", null, null, null, "", tw, tw, tw));
        ((TableColumnInfo)columns.get(0)).setxExpand(1.0);
        ((TableColumnInfo)columns.get(1)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(2)).setxExpand(0.0);
        this.table.setModel(new Table2Model(columns, model -> new TableRowImpl(model)));
        this.table.setProgress(1.0f);
        this.setCustomLayouter(new Layout());
        this.addToView(this.table);
    }

    protected void removeLoadingGroup(final Node<LoadingGroupTemplateComplete> lg) {
        this.editor.showCommittingAnimation(Words.REMOVE_LOADING_GROUP);
        this.editor.setEnabled(false);
        ThreadSafeExecutable run = new ThreadSafeExecutable(){

            @Override
            public Node<?> loadData() throws Exception {
                Iterator it = LoadingGroupsDetailsPanel.this.editor.getModel().getNode().getChildNamed(CateringServiceScheduleComplete_.variants).getFailSafeChildIterator();
                while (it.hasNext()) {
                    Node v = (Node)it.next();
                    if (v.getValue(CateringServiceScheduleVariantComplete.class) == null) {
                        CateringServiceScheduleVariantReference ref = (CateringServiceScheduleVariantReference)v.getValue(CateringServiceScheduleVariantReference.class);
                        CateringServiceScheduleVariantComplete cv = (CateringServiceScheduleVariantComplete)((MealPlanServiceManager)ServiceManagerRegistry.getService(MealPlanServiceManager.class)).getVariant(ref).getValue();
                        Node cvn = v;
                        cvn.setValue((Object)cv, 0L);
                    }
                    Node cvn = v;
                    LoadingGroupsDetailsPanel.this.processRemoveLoadingGroup((Node<CateringServiceScheduleVariantComplete>)cvn, (LoadingGroupTemplateComplete)lg.getValue());
                }
                LoadingGroupsDetailsPanel.this.editor.getModel().getNode().getChildNamed(CateringServiceScheduleComplete_.loadingGroups).removeChild(lg, 0L);
                return null;
            }

            @Override
            public RemoteLoader getInvoker() {
                return new RemoteLoader(){

                    public void remoteObjectLoaded(Node<?> node) {
                        LoadingGroupsDetailsPanel.this.editor.hideCommittingAnimation();
                        LoadingGroupsDetailsPanel.this.editor.setEnabled(true);
                    }

                    public void errorOccurred(ClientException exception) {
                        InnerPopupFactory.showErrorDialog((Exception)((Object)exception), (Component)LoadingGroupsDetailsPanel.this);
                        LoadingGroupsDetailsPanel.this.editor.hideCommittingAnimation();
                        LoadingGroupsDetailsPanel.this.editor.setEnabled(true);
                    }
                };
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    private void processAddLoadingGroup(Node<CateringServiceScheduleVariantComplete> node, LoadingGroupTemplateComplete group) {
        Iterator it = node.getChildNamed(CateringServiceScheduleVariantComplete_.rotations).getFailSafeChildIterator();
        while (it.hasNext()) {
            Node rotation = (Node)it.next();
            Iterator it2 = rotation.getChildNamed(CateringServiceRotationComplete_.parts).getFailSafeChildIterator();
            boolean found = false;
            while (it2.hasNext()) {
                Node part = (Node)it2.next();
                if (!group.equals(part.getChildNamed(CateringServicePartComplete_.loadingGroup).getValue())) continue;
                found = true;
            }
            if (found) continue;
            CateringServicePartComplete p = new CateringServicePartComplete();
            p.setClientOId(Long.valueOf(ADTO.getNextId()));
            p.setLoadingGroup((ALoadingGroupComplete)group);
            p.setNumber(Integer.valueOf(rotation.getChildNamed(CateringServiceRotationComplete_.parts).getChildCount() + 1));
            Node pn = INodeCreator.getDefaultImpl().getNode4DTO((Object)p, false, false);
            rotation.getChildNamed(CateringServiceRotationComplete_.parts).addChild(pn, 0L);
        }
    }

    private void processRemoveLoadingGroup(Node<CateringServiceScheduleVariantComplete> node, LoadingGroupTemplateComplete group) {
        Iterator it = node.getChildNamed(CateringServiceScheduleVariantComplete_.rotations).getFailSafeChildIterator();
        while (it.hasNext()) {
            Node rotation = (Node)it.next();
            Iterator it2 = rotation.getChildNamed(CateringServiceRotationComplete_.parts).getFailSafeChildIterator();
            boolean found = false;
            while (it2.hasNext() && !found) {
                Node part = (Node)it2.next();
                if (!group.equals(part.getChildNamed(CateringServicePartComplete_.loadingGroup).getValue())) continue;
                found = true;
                rotation.getChildNamed(CateringServiceRotationComplete_.parts).removeChild(part, 0L);
            }
            if (!found) continue;
            int count = 1;
            it2 = rotation.getChildNamed(CateringServiceRotationComplete_.parts).getFailSafeChildIterator();
            while (it2.hasNext()) {
                Node part = (Node)it2.next();
                part.getChildNamed(CateringServicePartComplete_.number).setValue((Object)count++, 0L);
            }
        }
    }

    @Override
    public void setNode(Node<?> node) {
        super.setNode(node);
        this.table.getModel().setNode(this.editor.getModel().getNode().getChildNamed(CateringServiceScheduleComplete_.loadingGroups));
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> a = new ArrayList<Component>();
        CheckedListAdder.addToList(a, this.table);
        return a;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.table != null) {
            this.table.kill();
        }
        this.table = null;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        boolean shouldEnable = isEnabled;
        MealPlanLight mp = (MealPlanLight)this.editor.getModel().getNode().getChildNamed(CateringServiceScheduleComplete_.mealplan).getValue();
        if (mp != null) {
            shouldEnable = mp.getState() == ModificationStateE.DRAFT && shouldEnable;
        }
        super.setEnabled(isEnabled);
        this.table.setEnabled(isEnabled);
        if (!shouldEnable && this.table.getAddButton() != null) {
            this.table.getAddButton().setEnabled(false);
        }
    }

    @Override
    public void switchState(Button.ButtonState newState) {
    }

    @Override
    public void requestFocusInWindowNow() {
    }

    private class TableRowImpl
    extends Table2RowPanel
    implements ButtonListener {
        private static final long serialVersionUID = 1L;
        private TextField name;
        private TextLabel mealType;
        private EditButton edit;
        private DeleteButton delete;

        public TableRowImpl(Table2RowModel m) {
            super(m);
            this.setUseControlSkin(Table2RowPanel.TableControlsType.FOUR);
            this.name = new TextField(m.getNode().getChildNamed(LoadingGroupTemplateComplete_.name));
            this.mealType = new TextLabel(m.getNode().getChildNamed(LoadingGroupTemplateComplete_.mealType), ConverterRegistry.getConverter(MealTypeConverter.class));
            this.edit = new EditButton();
            this.edit.getFader().setPermanent(true);
            this.delete = new DeleteButton();
            this.delete.addButtonListener(this);
            this.setLayout(new Layout());
            this.edit.addButtonListener(this);
            this.add(this.name);
            this.add(this.mealType);
            this.add(this.edit);
            this.add(this.delete);
        }

        @Override
        public void requestFocusInWindowNow() {
            if (this.edit != null) {
                this.edit.requestFocusInWindowNow();
            }
        }

        @Override
        public void buttonPressed(Button source, int x, int y) {
            if (source == this.edit) {
                this.showEditPopup(x, y);
            } else if (source == this.delete) {
                LoadingGroupsDetailsPanel.this.removeLoadingGroup((Node<LoadingGroupTemplateComplete>)this.model.getNode());
            }
        }

        private void showEditPopup(int x, int y) {
            InnerPopUp2 popUp = InnerPopUp2.getInnerPopUp();
            popUp.setAttributes(this.edit, false, false, "Config Insert");
            LoadingGroupsDetailsPanel.this.editor.getModel().getNode().getChildNamed(CateringServiceScheduleComplete_.loadingGroups);
            final EditLoadingGroupPopupInsert t = new EditLoadingGroupPopupInsert((Node<ALoadingGroupComplete>)this.model.getNode(), (Node<CustomerLight>)LoadingGroupsDetailsPanel.this.mpNode.getChildNamed(MealPlanLight_.customer));
            popUp.setView(t);
            boolean shouldEnable = this.isEnabled();
            MealPlanLight mp = (MealPlanLight)LoadingGroupsDetailsPanel.this.editor.getModel().getNode().getChildNamed(CateringServiceScheduleComplete_.mealplan).getValue();
            if (mp != null) {
                shouldEnable = mp.getState() == ModificationStateE.DRAFT && shouldEnable;
            }
            t.setEnabled(shouldEnable);
            popUp.showPopUp(x, y, -1, -1, new InnerPopUpListener2(){

                @Override
                public void popUpClosed(InnerPopUp2 source, Object ... xargs) {
                    Node n = t.getSelectedItem();
                    TableRowImpl.this.model.getNode().getChildNamed(LoadingGroupTemplateComplete_.insertType).setValue(n.getValue(), System.currentTimeMillis());
                }
            }, this.edit, PopupType.NORMAL);
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            super.setEnabled(isEnabled);
            boolean shouldEnable = isEnabled;
            MealPlanLight mp = (MealPlanLight)LoadingGroupsDetailsPanel.this.editor.getModel().getNode().getChildNamed(CateringServiceScheduleComplete_.mealplan).getValue();
            if (mp != null) {
                shouldEnable = mp.getState() == ModificationStateE.DRAFT && shouldEnable;
            }
            this.name.setEnabled(isEnabled && shouldEnable);
            this.mealType.setEnabled(isEnabled && shouldEnable);
            this.edit.setEnabled(isEnabled);
            this.delete.setEnabled(isEnabled && this.isDeletable() && shouldEnable);
        }

        private boolean isDeletable() {
            try {
                List stowedGroups = (List)LoadingGroupsDetailsPanel.this.editor.getModel().getNode().getChildNamed(new String[]{"referencedLoadingGroups"}).getValue();
                if (stowedGroups.contains(this.model.getNode().getValue())) {
                    return false;
                }
            }
            catch (Exception e) {
                return false;
            }
            return true;
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.name.kill();
            this.mealType.kill();
            this.delete.kill();
            this.edit.kill();
            this.name = null;
            this.mealType = null;
            this.delete = null;
            this.edit = null;
        }

        @Override
        public List<Component> getFocusComponents() {
            ArrayList<Component> a = new ArrayList<Component>();
            CheckedListAdder.addToList(a, this.edit);
            CheckedListAdder.addToList(a, this.delete);
            return a;
        }

        @Override
        public Object getObject4Column(int column) {
            return null;
        }

        private class Layout
        extends DefaultLayout {
            private Layout() {
            }

            @Override
            public void layoutContainer(Container parent) {
                int w = TableRowImpl.this.getModel().getParentModel().getColumnWidth(0);
                int currentX = 0;
                TableRowImpl.this.name.setLocation(TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.name.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.name.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.name.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.getModel().getParentModel().getColumnWidth(1);
                TableRowImpl.this.mealType.setLocation(TableRowImpl.this.getCellPadding() + currentX, (int)(((double)parent.getHeight() - TableRowImpl.this.mealType.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.mealType.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.mealType.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.getModel().getParentModel().getColumnWidth(2);
                TableRowImpl.this.setControlsX(currentX);
                TableRowImpl.this.edit.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.edit.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.edit.setSize(TableRowImpl.this.edit.getPreferredSize());
                TableRowImpl.this.delete.setLocation(TableRowImpl.this.edit.getX() + TableRowImpl.this.edit.getWidth() + TableRowImpl.this.getInnerCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.delete.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.delete.setSize(TableRowImpl.this.delete.getPreferredSize());
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TableRowImpl.this.getDefaultRowHeight());
            }
        }
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            LoadingGroupsDetailsPanel.this.table.setLocation(0, 0);
            LoadingGroupsDetailsPanel.this.table.setSize(parent.getWidth(), parent.getHeight());
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension(0, 250);
        }
    }
}

