/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.tool.mealplan.spec.details;

import ch.icit.pegasus.client.gui.table.DefaultDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2Factory;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.server.core.dtos.masterdata.ModificationStateE;
import ch.icit.pegasus.server.core.dtos.mealplan.CateringServiceScheduleComplete_;
import ch.icit.pegasus.server.core.dtos.mealplan.CateringServiceScheduleVariantComplete_;
import ch.icit.pegasus.server.core.dtos.mealplan.MealPlanLight;
import ch.icit.pegasus.server.core.dtos.product.ProductCatalogLight;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.IDTO;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public class CatalogDetailsPanel<T extends IDTO>
extends DefaultDetailsPanel<T> {
    private static final long serialVersionUID = 1L;
    private TitledItem<SearchTextField2<ProductCatalogLight>> spmlCatalog;
    private TitledItem<SearchTextField2<ProductCatalogLight>> alaCarteCatalog;

    public CatalogDetailsPanel(RowEditor<T> editor, RDProvider provider, Node<MealPlanLight> currentMealPlan) {
        super(editor, provider);
        this.setTitleText(Words.CATALOGS);
        this.setCustomLayouter(new Layout());
        this.spmlCatalog = new TitledItem<SearchTextField2<ProductCatalogLight>>(SearchTextField2Factory.getSPMLProductCatalogSearchField(true, null), Words.SPECIAL_MEAL_CATALOG, TitledItem.TitledItemOrientation.NORTH);
        this.alaCarteCatalog = new TitledItem<SearchTextField2<ProductCatalogLight>>(SearchTextField2Factory.getALaCarteProductCatalogSearchField(true, null), Words.ALA_CARTE_CATALOG, TitledItem.TitledItemOrientation.NORTH);
        this.addToView(this.spmlCatalog);
        this.addToView(this.alaCarteCatalog);
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        boolean shouldEnable = isEnabled;
        MealPlanLight mp = (MealPlanLight)this.editor.getModel().getNode().getChildNamed(CateringServiceScheduleComplete_.mealplan).getValue();
        if (mp != null) {
            shouldEnable = mp.getState() == ModificationStateE.DRAFT && shouldEnable;
        }
        super.setEnabled(shouldEnable);
        this.spmlCatalog.setEnabled(shouldEnable);
        this.alaCarteCatalog.setEnabled(shouldEnable);
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.spmlCatalog.kill();
        this.spmlCatalog = null;
        this.alaCarteCatalog.kill();
        this.alaCarteCatalog = null;
    }

    @Override
    public void setNode(Node<?> node) {
        this.spmlCatalog.getElement().setNode(node.getChildNamed(CateringServiceScheduleVariantComplete_.spmlCatalog));
        this.alaCarteCatalog.getElement().setNode(node.getChildNamed(CateringServiceScheduleVariantComplete_.alaCarteCatalog));
        this.setEnabled(this.isEnabled());
    }

    @Override
    public void requestFocusInWindowNow() {
        this.spmlCatalog.requestFocusInWindowNow();
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> a = new ArrayList<Component>();
        CheckedListAdder.addToList(a, this.spmlCatalog);
        CheckedListAdder.addToList(a, this.alaCarteCatalog);
        return a;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = CatalogDetailsPanel.this.verticalBorder;
            h = (int)((double)h + CatalogDetailsPanel.this.spmlCatalog.getPreferredSize().getHeight());
            h += CatalogDetailsPanel.this.inner_verticalBorder;
            h = (int)((double)h + CatalogDetailsPanel.this.alaCarteCatalog.getPreferredSize().getHeight());
            return new Dimension(0, h += CatalogDetailsPanel.this.verticalBorder);
        }

        @Override
        public void layoutContainer(Container parent) {
            CatalogDetailsPanel.this.spmlCatalog.setLocation(CatalogDetailsPanel.this.horizontalBorder, CatalogDetailsPanel.this.verticalBorder);
            CatalogDetailsPanel.this.spmlCatalog.setSize(parent.getWidth() - 2 * CatalogDetailsPanel.this.horizontalBorder, (int)CatalogDetailsPanel.this.spmlCatalog.getPreferredSize().getHeight());
            CatalogDetailsPanel.this.alaCarteCatalog.setLocation(CatalogDetailsPanel.this.horizontalBorder, CatalogDetailsPanel.this.spmlCatalog.getY() + CatalogDetailsPanel.this.spmlCatalog.getHeight() + CatalogDetailsPanel.this.inner_verticalBorder);
            CatalogDetailsPanel.this.alaCarteCatalog.setSize(parent.getWidth() - 2 * CatalogDetailsPanel.this.horizontalBorder, (int)CatalogDetailsPanel.this.alaCarteCatalog.getPreferredSize().getHeight());
        }
    }
}

