/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.popuppanels;

import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.combobox.InputComboBox;
import ch.icit.pegasus.client.gui.utils.combobox.InputComboBox2;
import ch.icit.pegasus.client.gui.utils.panels.LoadingAnimation;
import ch.icit.pegasus.client.gui.utils.popup.PopUpInsert;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.textfield.NumberTextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextFieldType;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.node.impls.ViewNode;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.supply.SupplyServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.toolkits.nodebased.UnitConversionToolkitNodeBased;
import ch.icit.pegasus.server.core.dtos.auth.UserComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.delivery.ArticleDeliverableComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.delivery.ArticleDeliverableLight;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleComplete;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleLight;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleReference;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.utils.StoreToolkit;
import ch.icit.pegasus.server.core.dtos.utils.TransactionType;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;

public class AmountChangingPopupInsert
extends PopUpInsert
implements RemoteLoader {
    private static final long serialVersionUID = 1L;
    private TitledItem<Component> amount;
    private TextLabel unitRO;
    private LoadingAnimation animation;
    private boolean isAnimation;
    private SystemSettingsComplete settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
    private UserComplete currentUser = ((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentUser();

    public AmountChangingPopupInsert(Node amount, final Node unit, Node labelText, Node deliveryInstruction) {
        Node deliveryItem = deliveryInstruction.getParent();
        this.setLayout(new Layout());
        if (deliveryItem.getValue() instanceof ArticleDeliverableLight || deliveryItem.getValue() instanceof ArticleDeliverableComplete) {
            final Node art = deliveryItem.getChildNamed(new String[]{"article"});
            if (unit.getValue() == null) {
                unit.setValue((Object)((BasicArticleLight)art.getValue(BasicArticleLight.class)).getBaseUnit(), 0L);
            }
            InputComboBox2 box = new InputComboBox2(amount, unit, InputComboBox.InputComboBoxType.PRICE_AND_UNIT_LONG);
            box.setUseLongAsInteger();
            this.amount = new TitledItem<InputComboBox2>(box, Words.AMOUNT, TitledItem.TitledItemOrientation.NORTH);
            if (art.getValue(BasicArticleComplete.class) == null) {
                this.showAnimation(Words.LOAD_ARTICLE);
                ThreadSafeExecutable run = new ThreadSafeExecutable(this){

                    @Override
                    public Node<?> loadData() throws Exception {
                        BasicArticleLight l = (BasicArticleLight)art.getValue(BasicArticleLight.class);
                        BasicArticleComplete lc = (BasicArticleComplete)((SupplyServiceManager)ServiceManagerRegistry.getService(SupplyServiceManager.class)).getBasicArticle((BasicArticleReference)l).getValue();
                        art.removeExistingValues();
                        art.setValue((Object)lc, 0L);
                        if (unit.getValue() == null) {
                            unit.setValue((Object)lc.getBaseUnit(), 0L);
                        }
                        return art;
                    }

                    @Override
                    public RemoteLoader getInvoker() {
                        return AmountChangingPopupInsert.this;
                    }

                    @Override
                    public long getID() {
                        return 0L;
                    }
                };
                ThreadSafeLoader.run(run);
            } else {
                this.remoteObjectLoaded(art);
            }
        } else {
            NumberTextField box = new NumberTextField(amount, TextFieldType.INT);
            this.amount = new TitledItem<NumberTextField>(box, Words.AMOUNT, TitledItem.TitledItemOrientation.NORTH);
            SystemSettingsComplete settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
            this.unitRO = new TextLabel(settings.getPieceUnit().getShortName());
            this.add(this.amount);
            this.add(this.unitRO);
        }
        if (this.isAnimation) {
            this.amount.setProgress(0.0f);
            if (this.unitRO != null) {
                this.unitRO.setProgress(0.0f);
            }
        } else {
            this.amount.setProgress(1.0f);
            if (this.unitRO != null) {
                this.unitRO.setProgress(1.0f);
            }
        }
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.amount.kill();
        this.amount = null;
        if (this.unitRO != null) {
            this.unitRO.kill();
        }
        this.unitRO = null;
        if (this.animation != null) {
            this.hideAnimation();
        }
    }

    private void showAnimation(String text) {
        if (!this.isAnimation) {
            if (this.animation == null) {
                this.animation = new LoadingAnimation();
            }
            this.animation.stateChanged(text);
            this.isAnimation = true;
            this.add((Component)this.animation, 0);
            this.animation.fadeIn();
            this.animation.start();
        }
    }

    private void hideAnimation() {
        if (this.isAnimation) {
            this.isAnimation = false;
            if (this.animation != null) {
                this.animation.stop();
                this.animation.kill();
                this.animation = null;
            }
        }
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> a = new ArrayList<Component>();
        a.addAll(this.amount.getFocusComponents());
        return a;
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        if (isOK == PopupAction.CANCEL) {
            return null;
        }
        return new Object[1];
    }

    @Override
    public boolean isClosableWithEnter() {
        return true;
    }

    @Override
    public boolean isInnerComponent(Component c) {
        InputComboBox2 i;
        return this.amount.getElement() != null && this.amount.getElement() instanceof InputComboBox2 && (i = (InputComboBox2)this.amount.getElement()).isInnerComponent(c);
    }

    @Override
    public boolean tryToGrabFocus() {
        return false;
    }

    @Override
    public void remoteObjectLoaded(Node<?> node) {
        this.hideAnimation();
        BasicArticleComplete article = (BasicArticleComplete)node.getValue(BasicArticleComplete.class);
        Timestamp validity = new Timestamp(System.currentTimeMillis());
        List possibleUnits = StoreToolkit.getPossibleUnits((BasicArticleLight)article, null, (Timestamp)validity, (TransactionType)TransactionType.IN_STOWING_LIST, (UserComplete)this.currentUser, null, null, (SystemSettingsComplete)this.settings);
        ViewNode poss = UnitConversionToolkitNodeBased.getUnitList(possibleUnits);
        if (this.amount != null) {
            ((InputComboBox2)this.amount.getElement()).setPossibleUnits((Node)poss);
            this.add(this.amount);
            if (this.unitRO != null) {
                this.add(this.unitRO);
                this.unitRO.fadeIn();
            }
            this.amount.fadeIn();
        }
        this.invalidate();
        this.validate();
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            if (AmountChangingPopupInsert.this.isAnimation) {
                AmountChangingPopupInsert.this.animation.setLocation((int)((double)parent.getWidth() - AmountChangingPopupInsert.this.animation.getPreferredSize().getWidth()) / 2, (int)((double)parent.getHeight() - AmountChangingPopupInsert.this.animation.getPreferredSize().getHeight()) / 2);
                AmountChangingPopupInsert.this.animation.setSize(AmountChangingPopupInsert.this.animation.getPreferredSize());
            } else {
                AmountChangingPopupInsert.this.amount.setLocation(10, 10);
                AmountChangingPopupInsert.this.amount.setSize((int)AmountChangingPopupInsert.this.amount.getPreferredSize().getWidth(), (int)AmountChangingPopupInsert.this.amount.getPreferredSize().getHeight());
                if (AmountChangingPopupInsert.this.unitRO != null) {
                    AmountChangingPopupInsert.this.unitRO.setLocation(AmountChangingPopupInsert.this.amount.getX() + AmountChangingPopupInsert.this.amount.getWidth() + 5, (int)((double)(AmountChangingPopupInsert.this.amount.getY() + AmountChangingPopupInsert.this.amount.getHeight()) - AmountChangingPopupInsert.this.unitRO.getPreferredSize().getHeight()));
                    AmountChangingPopupInsert.this.unitRO.setSize(AmountChangingPopupInsert.this.unitRO.getPreferredSize());
                }
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension(0, (int)(10.0 + AmountChangingPopupInsert.this.amount.getPreferredSize().getHeight() + 10.0));
        }
    }
}

