/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.list;

import ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.PegasusSubModule;
import ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.list.ListView;
import ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.utils.FadeInOutPanel;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.tabbed.TabButton;
import ch.icit.pegasus.client.gui.utils.tabbed.TabListener;
import ch.icit.pegasus.client.gui.utils.tabbed.TabbedButtonPanel;
import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class TabbedListView
extends FadeInOutPanel
implements TabListener {
    private static final long serialVersionUID = 1L;
    private Map<Button, ListView> listViews = new HashMap<Button, ListView>();
    private ListView selectedView;
    private TabbedButtonPanel buttonPanel;
    private boolean isPrefSizeSet;
    private Dimension prefSize;

    public TabbedListView(PegasusSubModule pegasus) {
        super(true);
        this.setHasBackground(true);
        this.setLayout(new TabbedListViewLayout());
        this.setOpaque(false);
        this.setProgress(1.0f);
        this.buttonPanel = new TabbedButtonPanel(false);
        this.buttonPanel.addTabListener(this);
        this.add(this.buttonPanel);
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        Set<Map.Entry<Button, ListView>> a = this.listViews.entrySet();
        for (Map.Entry<Button, ListView> b : a) {
            b.getKey().kill();
            b.getValue().kill();
        }
        this.listViews.clear();
        this.listViews = null;
        this.selectedView = null;
        this.buttonPanel.kill();
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        this.selectedView.setEnabled(isEnabled);
        this.buttonPanel.setEnabled(isEnabled);
    }

    public void setPreferredSize(int w, int h) {
        this.prefSize = new Dimension(w, h);
        this.isPrefSizeSet = true;
    }

    public void addListView(ListView view, TabButton but) {
        this.listViews.put(but, view);
        this.buttonPanel.addTabButton(but);
        if (this.selectedView == null) {
            this.selectListView(view);
        }
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setComposite(AlphaComposite.getInstance(3, this.theProgress));
        if (this.hasBackground) {
            g2.setColor(this.innerBackground);
            g2.fillRoundRect(0, 0, this.getWidth(), this.getHeight(), this.arcW, this.arcH);
        }
        if (this.hasSkin) {
            this.skin.paint(g2, 0, 0, this.getWidth(), this.getHeight(), Button.ButtonState.UP);
        }
        if (this.useCliping) {
            Shape r = this.getClipingArea();
            g2.clip(r);
        }
        this.paintChildren(g2);
    }

    private void selectListView(ListView l) {
        if (this.selectedView != null) {
            this.selectedView.fadeOut(false);
        }
        this.selectedView = l;
        if (this.selectedView != null) {
            this.add((Component)this.selectedView, 0);
            this.selectedView.fadeIn();
        }
        this.layoutPanel(this.getWidth(), this.getHeight(), false);
    }

    @Override
    public void layoutPanel(int w, int h, boolean resize) {
        this.setSize(w, h);
    }

    @Override
    public void movePanel(int x, int y, boolean smooth) {
        this.setLocation(x, y);
    }

    @Override
    public void newTabSelected(Button selectedTab) {
        ListView view = this.listViews.get(selectedTab);
        this.selectListView(view);
    }

    private class TabbedListViewLayout
    extends DefaultLayout {
        private TabbedListViewLayout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int w = parent.getWidth();
            int h = parent.getHeight();
            TabbedListView.this.layoutTitle(parent);
            int currentY = 0;
            currentY += TabbedListView.this.getTitleHeight();
            if (TabbedListView.this.selectedView != null) {
                TabbedListView.this.buttonPanel.setLocation(1, currentY);
                TabbedListView.this.buttonPanel.setSize(w - 2, (int)TabbedListView.this.buttonPanel.getPreferredSize().getHeight());
                TabbedListView.this.selectedView.movePanel(1, TabbedListView.this.buttonPanel.getY() + TabbedListView.this.buttonPanel.getHeight(), false);
                TabbedListView.this.selectedView.layoutPanel(w - 2, h - (TabbedListView.this.buttonPanel.getY() + TabbedListView.this.buttonPanel.getHeight()), false);
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = (int)TabbedListView.this.buttonPanel.getPreferredSize().getHeight();
            int w = (int)TabbedListView.this.buttonPanel.getPreferredSize().getWidth();
            if (TabbedListView.this.selectedView != null) {
                h = (int)((double)h + TabbedListView.this.selectedView.getPreferredSize().getHeight());
                if ((double)w < TabbedListView.this.selectedView.getPreferredSize().getWidth()) {
                    w = (int)TabbedListView.this.selectedView.getPreferredSize().getWidth();
                }
            }
            w = TabbedListView.this.isPrefSizeSet ? (int)TabbedListView.this.prefSize.getWidth() : (w += 25);
            return new Dimension(w, h);
        }
    }
}

