/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.galley.utils;

import ch.icit.pegasus.client.converter.CustomerConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.galley.utils.EquipmentConverter3;
import ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.galley.utils.GalleyEquipmentConverter2;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.CursorController;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.HorizontalSeparator;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.panels.ScrollableBackground;
import ch.icit.pegasus.client.gui.utils.popup.PopUpInsert;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2Factory;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2Listener;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.impls.DTOProxyNode;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.ViewNode;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.flight.StowingListServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.toolkits.LogicToolkit;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.GalleyEquipmentComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListTemplateComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListTemplateReference;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class TemplatePopup
extends PopUpInsert
implements SearchTextField2Listener,
ItemListener,
RemoteLoader {
    private static final long serialVersionUID = 1L;
    private boolean isWaiting = false;
    private LOADING_STATE currentState = LOADING_STATE.LOAD_STOWINGLIST;
    private ScrollableBackground viewPort;
    private TitledItem<TextLabel> customer;
    private TitledItem<SearchTextField2> stowingSearch;
    private HorizontalSeparator sep1;
    private TitledItem<ComboBox> galleys;
    private TitledItem<ComboBox> equipments;
    private final Node currentEquipement;
    private ArrayList<Node> usedObjects;

    public TemplatePopup(Node customerNode, Node currentEquipment, Node currentSTW) {
        this.currentEquipement = currentEquipment;
        this.customer = new TitledItem<TextLabel>(new TextLabel(customerNode, ConverterRegistry.getConverter(CustomerConverter.class)), "CUSTOMER", TitledItem.TitledItemOrientation.NORTH);
        this.stowingSearch = new TitledItem<SearchTextField2<StowingListTemplateComplete>>(SearchTextField2Factory.getStowingTemplateSearchField(false, new DTOProxyNode()), "STOWING LIST", TitledItem.TitledItemOrientation.NORTH);
        Object[] o = new Object[]{customerNode};
        this.stowingSearch.getElement().setAdditionalSearchField(o);
        this.stowingSearch.getElement().addSearchTextFieldListener(this);
        this.sep1 = new HorizontalSeparator();
        this.galleys = new TitledItem<ComboBox>(new ComboBox((Node)new DTOProxyNode(), null, ConverterRegistry.getConverter(GalleyEquipmentConverter2.class)), "GALLEYS", TitledItem.TitledItemOrientation.NORTH);
        this.galleys.getElement().addItemListener(this);
        this.equipments = new TitledItem<ComboBox>(new ComboBox((Node)new DTOProxyNode(), null, ConverterRegistry.getConverter(EquipmentConverter3.class)), "EQUIPMENTS", TitledItem.TitledItemOrientation.NORTH);
        this.equipments.getElement().addItemListener(this);
        this.viewPort = new ScrollableBackground(false);
        this.viewPort.getViewPort().setLayout(new Layout());
        this.viewPort.setInnerColor(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("innerpopup_extension_background")));
        this.setLayout(new PanelLayout());
        this.add(this.viewPort);
        this.galleys.setEnabled(false);
        this.equipments.setEnabled(false);
        this.viewPort.getViewPort().add(this.customer);
        this.viewPort.getViewPort().add(this.stowingSearch);
        this.viewPort.getViewPort().add(this.sep1);
        this.viewPort.getViewPort().add(this.galleys);
        this.viewPort.getViewPort().add(this.equipments);
    }

    public Node getSelectedEquipment() {
        return this.equipments.getElement().getNode();
    }

    public void showWaiting(boolean b) {
        if (this.galleys != null) {
            this.galleys.setEnabled(b);
        }
        if (this.equipments != null) {
            this.equipments.setEnabled(b);
        }
        this.isWaiting = !b;
        CursorController.showCursor(this, !b);
    }

    @Override
    public boolean tryToGrabFocus() {
        return true;
    }

    @Override
    public List<Component> getFocusComponents() {
        List<Component> a = this.stowingSearch.getFocusComponents();
        a.addAll(this.galleys.getFocusComponents());
        a.addAll(this.equipments.getFocusComponents());
        return a;
    }

    @Override
    public boolean isClosableWithEnter() {
        if (this.galleys.getElement().hasFocus()) {
            return !this.galleys.getElement().isPopupVisible();
        }
        if (this.equipments.getElement().hasFocus()) {
            return !this.equipments.getElement().isPopupVisible();
        }
        return true;
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        if (isOK == PopupAction.CANCEL) {
            return null;
        }
        Object[] o = new Object[]{this.getSelectedEquipment(), this.getSelectedStowingList()};
        return o;
    }

    private Object getSelectedStowingList() {
        return this.stowingSearch.getElement().getNode().getValue();
    }

    @Override
    public boolean isInnerComponent(Component c) {
        Component currentC;
        if (this.galleys.getElement().getCurrentPopUp() != null) {
            for (currentC = c; currentC != null; currentC = currentC.getParent()) {
                if (!currentC.equals(this.galleys.getElement().getCurrentPopUp())) continue;
                return true;
            }
        }
        if (this.equipments.getElement().getCurrentPopUp() != null) {
            for (currentC = c; currentC != null; currentC = currentC.getParent()) {
                if (!currentC.equals(this.equipments.getElement().getCurrentPopUp())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.viewPort.kill();
        this.viewPort = null;
        this.customer.kill();
        this.stowingSearch.kill();
        this.sep1.kill();
        this.galleys.kill();
        this.equipments.kill();
        this.customer = null;
        this.stowingSearch = null;
        this.sep1 = null;
        this.galleys = null;
        this.equipments = null;
    }

    @Override
    public void newValueSelected(SearchTextField2 source, final Node<?> n) {
        this.showWaiting(false);
        this.currentState = LOADING_STATE.LOAD_STOWINGLIST;
        if (n.getValue(StowingListTemplateComplete.class) == null) {
            CursorController.showCursor(this, true);
            ThreadSafeExecutable run = new ThreadSafeExecutable(this){

                @Override
                public Node<?> loadData() throws Exception {
                    StowingListTemplateComplete l = (StowingListTemplateComplete)n.getValue(StowingListTemplateComplete.class);
                    StowingListTemplateComplete lc = (StowingListTemplateComplete)((StowingListServiceManager)ServiceManagerRegistry.getService(StowingListServiceManager.class)).getStowingListTemplateComplete(new StowingListTemplateReference(l.getId())).getValue();
                    Node sc = n;
                    sc.setValue((Object)lc, 0L);
                    return n;
                }

                @Override
                public RemoteLoader getInvoker() {
                    return TemplatePopup.this;
                }

                @Override
                public long getID() {
                    return 0L;
                }
            };
            ThreadSafeLoader.run(run);
        } else {
            this.remoteObjectLoaded(n);
        }
    }

    private Node createGalleyList(Node galleysets) {
        ViewNode n = new ViewNode("");
        try {
            Iterator it = galleysets.getChildNamed(new String[]{"galleyEquipmentSets"}).getChilds();
            while (it.hasNext()) {
                Node nn = (Node)it.next();
                n.addChild(nn, 0L);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return n;
    }

    private Node createEquipmentList(Node currentGalleySet) {
        ArrayList<Node> usedObjects = new ArrayList<Node>();
        this.usedObjects = usedObjects;
        ViewNode n = new ViewNode("");
        if (currentGalleySet == null) {
            return n;
        }
        Node galleyEquipmentSpecifications = currentGalleySet.getChildNamed(new String[]{"galleyEquipmentSpecifications"});
        if (galleyEquipmentSpecifications == null) {
            return n;
        }
        Iterator it = galleyEquipmentSpecifications.getChilds();
        while (it.hasNext()) {
            Node spec = (Node)it.next();
            if (spec == null || spec.getChildNamed(new String[]{"usedGalleyEquipment"}) == null) continue;
            Iterator it2 = spec.getChildNamed(new String[]{"usedGalleyEquipment"}).getChilds();
            while (it2.hasNext()) {
                Boolean b;
                Node equ = (Node)it2.next();
                if (equ.getChildNamed(new String[]{"inUse"}) == null || equ.getChildNamed(new String[]{"inUse"}).getValue() == null || !(b = (Boolean)equ.getChildNamed(new String[]{"inUse"}).getValue()).booleanValue()) continue;
                n.addChild(equ, 0L);
                GalleyEquipmentComplete e = (GalleyEquipmentComplete)equ.getValue();
                GalleyEquipmentComplete target = (GalleyEquipmentComplete)this.currentEquipement.getValue();
                if (LogicToolkit.areDimensionsEquals(e.getEquipmentType().getSize(), target.getEquipmentType().getSize())) continue;
                usedObjects.add(equ);
            }
        }
        return n;
    }

    @Override
    public void remoteObjectLoaded(Node<?> node) {
        if (this.isKilled()) {
            return;
        }
        switch (this.currentState) {
            case LOAD_STOWINGLIST: {
                if (node != null) {
                    this.galleys.getElement().removeItemListener(this);
                    this.galleys.getElement().refreshPossibleValues(this.createGalleyList(node));
                    this.galleys.getElement().addItemListener(this);
                    this.itemStateChanged(new ItemEvent(this.galleys.getElement(), 0, this.galleys.getElement().getSelectedItem(), 1));
                    break;
                }
                this.galleys.getElement().removeAll();
            }
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() == 1) {
            if (e.getSource() == this.galleys.getElement()) {
                this.equipments.getElement().refreshPossibleValues(this.createEquipmentList((Node)this.galleys.getElement().getSelectedItem()));
                this.equipments.getElement().updateSelectableValues(this.usedObjects);
                if (this.isWaiting) {
                    this.showWaiting(true);
                }
            } else if (e.getSource() == this.equipments.getElement()) {
                if (this.isWaiting) {
                    this.showWaiting(true);
                }
                if (this.popup != null) {
                    this.popup.enableOKButton(true);
                }
            }
        }
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = 5;
            h = (int)((double)h + TemplatePopup.this.customer.getPreferredSize().getHeight());
            h += 10;
            h = (int)((double)h + TemplatePopup.this.stowingSearch.getPreferredSize().getHeight());
            h += 5;
            h = (int)((double)h + TemplatePopup.this.sep1.getPreferredSize().getHeight());
            h += 5;
            h = (int)((double)h + TemplatePopup.this.galleys.getPreferredSize().getHeight());
            h += 10;
            h = (int)((double)h + TemplatePopup.this.equipments.getPreferredSize().getHeight());
            return new Dimension(0, h += 5);
        }

        @Override
        public void layoutContainer(Container parent) {
            int currentY = 5;
            TemplatePopup.this.customer.setLocation(0, currentY);
            TemplatePopup.this.customer.setSize(parent.getWidth(), (int)TemplatePopup.this.customer.getPreferredSize().getHeight());
            currentY += TemplatePopup.this.customer.getHeight();
            TemplatePopup.this.stowingSearch.setLocation(0, currentY += 10);
            TemplatePopup.this.stowingSearch.setSize(parent.getWidth(), (int)TemplatePopup.this.stowingSearch.getPreferredSize().getHeight());
            currentY += TemplatePopup.this.stowingSearch.getHeight();
            TemplatePopup.this.sep1.setLocation(0, currentY += 5);
            TemplatePopup.this.sep1.setSize(parent.getWidth(), (int)TemplatePopup.this.sep1.getPreferredSize().getHeight());
            currentY += TemplatePopup.this.sep1.getHeight();
            TemplatePopup.this.galleys.setLocation(0, currentY += 5);
            TemplatePopup.this.galleys.setSize(parent.getWidth(), (int)TemplatePopup.this.galleys.getPreferredSize().getHeight());
            currentY += TemplatePopup.this.galleys.getHeight();
            TemplatePopup.this.equipments.setLocation(0, currentY += 10);
            TemplatePopup.this.equipments.setSize(parent.getWidth(), (int)TemplatePopup.this.equipments.getPreferredSize().getHeight());
        }
    }

    private class PanelLayout
    extends DefaultLayout {
        private PanelLayout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension(0, 0);
        }

        @Override
        public void layoutContainer(Container parent) {
            TemplatePopup.this.viewPort.setLocation(0, 0);
            TemplatePopup.this.viewPort.setSize(parent.getSize());
        }
    }

    private static enum LOADING_STATE {
        LOAD_STOWINGLIST;

    }
}

