/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.galley;

import ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.galley.GalleyBox;
import ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.galley.GalleyGridPanel;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.animators.AlphaFader;
import ch.icit.pegasus.client.gui.utils.panels.defaults.JPanelFadable;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.impls.Node;
import java.awt.BasicStroke;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Area;
import java.util.ArrayList;
import java.util.Iterator;

public class GalleyGrid
extends JPanelFadable
implements MouseListener {
    private static final long serialVersionUID = 1L;
    protected ArrayList<GalleyBox> theBoxes = new ArrayList();
    private int theGridSizeX = 50;
    private int theGridSizeY = 50;
    private double theGridCountX = 5.0;
    private double theGridCountY = 5.0;
    private int theSelectionOverHead = 0;
    private double theXMultiplier = 1.0;
    private double theYMultiplier = 1.0;
    private double theZMultiplier = 1.0;
    private boolean isShowGrid = false;
    private Point theDragPoint;
    protected Area theBoxArea = new Area();
    protected GalleyGridPanel theGalley;
    protected boolean isSubGalley = false;
    private boolean isPaintHalfLines = false;
    private AlphaFader<GalleyGrid> fader;
    private boolean isGridBoxAreaValid = false;
    private boolean isGridDisabled = false;
    private Area theInverseArea;

    public GalleyGrid(GalleyGridPanel g) {
        this.theGalley = g;
        this.install();
    }

    private void install() {
        this.fader = new AlphaFader<GalleyGrid>(this);
        this.setProgress(1.0f);
        this.addMouseListener(this);
        this.setOpaque(false);
        this.setLayout(null);
    }

    public boolean isGridBoxAreaValid() {
        return this.isGridBoxAreaValid;
    }

    public void setGridBoxAreaInvalid() {
        this.isGridBoxAreaValid = false;
    }

    public void validateGridBoxArea() {
        this.layoutBoxes(false);
    }

    public void addSpecialBox(GalleyBox g) {
    }

    public void ensureGridSize() {
        double mx = 0.0;
        double my = 0.0;
        for (GalleyBox box : this.theBoxes) {
            double cx = (int)(box.getDX() + box.getDWidth());
            double cy = (int)(box.getDY() + box.getDHeight());
            if (cx > mx) {
                mx = cx;
            }
            if (!(cy > my)) continue;
            my = cy;
        }
        int x = (int)mx;
        int y = (int)my;
        this.ensureGridSize(x + 1, y + 1, true);
    }

    public void addBox(GalleyBox box) {
        if (!this.theBoxes.contains(box)) {
            this.theBoxes.add(box);
        }
        this.add((Component)box, 0);
        this.layoutBoxes();
        box.setVisible(true);
    }

    @Override
    public void removeAll() {
        Iterator<GalleyBox> it = this.theBoxes.iterator();
        while (it.hasNext()) {
            GalleyBox box = it.next();
            box.kill();
            it.remove();
        }
        this.repaint(32L);
    }

    public void setPaintHalfSize(boolean b) {
        this.isPaintHalfLines = b;
    }

    public GalleyBox getIntersectingBox(int x, int y, boolean special) {
        for (GalleyBox box : this.theBoxes) {
            if (x <= box.getX() || x >= box.getX() + box.getWidth() || y <= box.getY() || y >= box.getY() + box.getHeight()) continue;
            return box;
        }
        return null;
    }

    public GalleyBox getIntersectingBox(int x, int y) {
        return this.getIntersectingBox(x, y, false);
    }

    public GalleyBox getBox4Coordinate(double x, double y) {
        for (GalleyBox box : this.theBoxes) {
            if (box.getDX() != x || box.getDY() != y) continue;
            return box;
        }
        return null;
    }

    public GalleyBox getBox4Coordinate2(double x, double y) {
        for (GalleyBox box : this.theBoxes) {
            if (!(box.getDX() <= x) || !(box.getDX() + box.getDWidth() > x) || !(box.getDY() <= y) || !(box.getDY() + box.getDHeight() > y)) continue;
            return box;
        }
        return null;
    }

    public void removeBox(GalleyBox galleyBox) {
        this.theBoxes.remove(galleyBox);
        this.layoutBoxes();
    }

    public void resetInset() {
        for (GalleyBox b : this.theBoxes) {
            b.useInset(0);
        }
    }

    public int isEmptyField(int x, int y, double xdSize, double ydSize, double zdSize) {
        if (this.isGridDisabled) {
            return 0;
        }
        if (xdSize > this.theGridCountX || ydSize > this.theGridCountY) {
            return 0;
        }
        double aXg = this.getDiscretIndexX(x, xdSize);
        double aYg = this.getDiscretIndexY(y, ydSize);
        if (aXg + xdSize > this.theGridCountX) {
            return 0;
        }
        if (aYg + ydSize > this.theGridCountY) {
            return 0;
        }
        aXg = aXg * (double)this.getGridSizeX() + (double)this.getGridOffsetX();
        aYg = aYg * (double)this.getGridSizeY() + (double)this.getGridOffsetY();
        double aWg = xdSize * (double)this.getGridSizeX();
        double aHg = ydSize * (double)this.getGridSizeY();
        if (x < this.getGridOffsetX() || y < this.getGridOffsetY()) {
            return 0;
        }
        if (this.theBoxArea.intersects(aXg, aYg, aWg, aHg)) {
            return 0;
        }
        return 1;
    }

    public int isDiscretEmptyField(double x, double y, double xdSize, double ydSize) {
        if (this.isGridDisabled) {
            return 0;
        }
        double aXg = x;
        double aYg = y;
        aXg = aXg * (double)this.getGridSizeX() + (double)this.getGridOffsetX();
        aYg = aYg * (double)this.getGridSizeY() + (double)this.getGridOffsetY();
        double aWg = xdSize * (double)this.getGridSizeX();
        double aHg = ydSize * (double)this.getGridSizeY();
        if (aXg < (double)this.getGridOffsetX() || aYg < (double)this.getGridOffsetY()) {
            return 1;
        }
        if (y + ydSize > this.getGridCountY() || x + xdSize > this.getGridCountX()) {
            return 1;
        }
        if (this.theBoxArea.intersects(aXg, aYg, aWg, aHg)) {
            return 2;
        }
        return 3;
    }

    public void layoutBoxes() {
        this.layoutBoxes(false);
    }

    public void layoutBoxes(boolean smooth) {
        this.theBoxArea = new Area();
        Object preViewBox = null;
        int gridOffsetX = this.getGridOffsetX();
        int gridOffsetY = this.getGridOffsetY();
        for (GalleyBox aBox : (ArrayList)this.theBoxes.clone()) {
            double nx = 0.0;
            nx = this.isSubGalley ? (double)gridOffsetX + aBox.getDZ() * (double)this.getGridSizeX() : (double)gridOffsetX + aBox.getDX() * (double)this.getGridSizeX();
            double ny = (double)gridOffsetY + aBox.getDY() * (double)this.getGridSizeY();
            aBox.movePanel((int)nx, (int)ny, smooth);
            aBox.layoutPanel(this.getGridSizeX(), this.getGridSizeY(), this.isSubGalley);
            this.theBoxArea.add(new Area(new Rectangle(aBox.getX(), aBox.getY(), aBox.getWidth() - 1, aBox.getHeight() - 1)));
        }
        this.theBoxArea.add(new Area(new Rectangle(0, 0, gridOffsetX, this.getHeight())));
        this.theBoxArea.add(new Area(new Rectangle(0, 0, this.getWidth(), gridOffsetY)));
        this.theBoxArea.add(new Area(new Rectangle(0, this.getHeight() - gridOffsetY, this.getWidth(), gridOffsetY)));
        this.theBoxArea.add(new Area(new Rectangle(this.getWidth() - gridOffsetX, 0, gridOffsetX, this.getHeight())));
        this.theInverseArea = new Area(new Rectangle(0, 0, this.getWidth(), this.getHeight()));
        this.theInverseArea.subtract(this.theBoxArea);
        this.isGridBoxAreaValid = true;
    }

    public void setMultiplier(double xm, double ym, double zm) {
        this.theXMultiplier = xm;
        this.theYMultiplier = ym;
        this.theZMultiplier = zm;
    }

    public void showGrid(boolean showGrid) {
        if (showGrid != this.isShowGrid) {
            this.isShowGrid = showGrid;
            if (!this.isShowGrid) {
                this.theDragPoint = null;
            }
            if (this.getParent() != null) {
                this.getParent().repaint(32L);
            }
        }
    }

    public int getGridOffsetX() {
        return (int)(((double)this.getWidth() - this.theGridCountX * (double)this.theGridSizeX) / 2.0);
    }

    public int getGridOffsetY() {
        return (int)(((double)this.getHeight() - this.theGridCountY * (double)this.theGridSizeY) / 2.0);
    }

    public void highlightPoint(int x, int y) {
        if (x == -1 && y == -1) {
            this.theDragPoint = null;
            return;
        }
        if (this.theDragPoint == null) {
            this.theDragPoint = new Point(x, y);
        } else {
            this.theDragPoint.setLocation(x, y);
        }
    }

    public boolean isHighLighted() {
        return this.theDragPoint != null;
    }

    public boolean intersectsBox(int x, int y) {
        return this.theBoxArea.contains(x, y);
    }

    public void layoutGrid(int w, int h) {
        int aHeight = h;
        int aWidth = w;
        if (!this.isGridDisabled) {
            if ((double)aHeight % this.theGridCountY == 0.0) {
                aHeight -= 5;
            }
            if ((double)aWidth % this.theGridCountX == 0.0) {
                aWidth -= 5;
            }
            this.theGridSizeY = (int)((double)aHeight / this.theGridCountY);
            this.theGridSizeX = (int)((double)aWidth / this.theGridCountX);
            if (this.theGridSizeX % 2 != 0) {
                --this.theGridSizeX;
            }
            if (this.theGridSizeY % 2 != 0) {
                --this.theGridSizeY;
            }
        }
        this.setSize(w, h);
        this.layoutBoxes();
    }

    public double getDiscretIndexX(int v, double xwidth) {
        int cx = (int)(((double)this.getWidth() - this.theGridCountX * (double)this.theGridSizeX) / 2.0);
        double aColumn = (v - cx) / this.theGridSizeX;
        if (xwidth < 1.0) {
            double kCoord = 0.0;
            aColumn = v - cx;
            double vv = this.theGridCountX * (double)this.theGridSizeX * (xwidth / this.theGridCountX);
            double cc = 0.0;
            double nc = vv;
            for (int count = 0; !(count >= 7 || aColumn > cc && aColumn <= nc && aColumn >= cc && aColumn < nc || !(nc <= this.theGridCountX * (double)this.theGridSizeX)); ++count) {
                cc = nc;
                nc += vv;
                kCoord += xwidth;
            }
            aColumn = kCoord;
        }
        return aColumn;
    }

    public double getDiscretIndexY(int v, double yheight) {
        if (this.isGridDisabled) {
            return 0.0;
        }
        double ah = 0.5;
        int cy = (int)(((double)this.getHeight() - this.theGridCountY * (double)this.theGridSizeY) / 2.0);
        if (this.theGridSizeY == 0) {
            return 0.0;
        }
        double aRow = (v - cy) / this.theGridSizeY;
        if (ah < 1.0 && (double)v - ((double)cy + aRow * (double)this.theGridSizeY) > (double)(this.theGridSizeY / 2)) {
            aRow += ah;
        }
        return aRow;
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Stroke backStroke = g2.getStroke();
        g2.setColor(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("gc_galley_grid_line_color")));
        if (!this.isShowGrid) {
            float[] dash = new float[]{2.0f};
            g2.setStroke(new BasicStroke(1.0f, 0, 0, 1.0f, dash, 0.0f));
        } else {
            g2.setColor(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("gc_grid_emptyspace_color")));
            g2.fill(this.theInverseArea);
            g2.setColor(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("gc_galley_grid_line_color")));
        }
        if (!this.isGridDisabled) {
            int i;
            int cx = (int)(((double)this.getWidth() - this.theGridCountX * (double)this.theGridSizeX) / 2.0);
            int cy = (int)(((double)this.getHeight() - this.theGridCountY * (double)this.theGridSizeY) / 2.0);
            if (this.isPaintHalfLines) {
                i = 0;
                while ((double)i <= this.theGridCountX * 2.0) {
                    g2.drawLine(cx + i * (this.theGridSizeX / 2), 0, cx + i * (this.theGridSizeX / 2), this.getHeight() - 1);
                    ++i;
                }
            } else {
                double count = this.theGridCountX;
                int i2 = 0;
                while ((double)i2 <= count) {
                    g2.drawLine(cx + i2 * this.theGridSizeX, 0, cx + i2 * this.theGridSizeX, this.getHeight() - 1);
                    ++i2;
                }
                if (this.theGridCountX < 1.0) {
                    g2.drawLine(this.getWidth() - (cx + 1), 0, this.getWidth() - (cx + 1), this.getHeight() - 1);
                }
            }
            i = 0;
            while ((double)i <= this.theGridCountY) {
                g2.drawLine(0, cy + i * this.theGridSizeY, this.getWidth() - 1, cy + i * this.theGridSizeY);
                ++i;
            }
        }
        g2.setStroke(backStroke);
        this.paintChildren(g2);
    }

    public boolean containsBox(GalleyBox box) {
        return this.theBoxes.contains(box);
    }

    public void selectNode(Node parent, int level) {
        for (GalleyBox box : this.theBoxes) {
            if (box.getNode() != parent) continue;
            this.theGalley.setSelectedBox(box, level);
            return;
        }
    }

    public GalleyBox getBox4Node(Node node) {
        for (GalleyBox box : this.theBoxes) {
            if (box.getNode() != node) continue;
            return box;
        }
        return null;
    }

    public GalleyBox getInsertBox4Node(Node node) {
        for (GalleyBox box : this.theBoxes) {
            if (box.getBoxNode() != node) continue;
            return box;
        }
        return null;
    }

    public Point getDragPoint() {
        return this.theDragPoint;
    }

    public double getGridCountX() {
        return this.theGridCountX;
    }

    public double getGridCountY() {
        return this.theGridCountY;
    }

    public int getSelectionOverHead() {
        return this.theSelectionOverHead;
    }

    public int getGridSizeX() {
        return this.theGridSizeX;
    }

    public int getGridSizeY() {
        return this.theGridSizeY;
    }

    public boolean isShowGrid() {
        if (this.isGridDisabled) {
            return false;
        }
        return this.isShowGrid;
    }

    public boolean isDraggableBox(Node<Integer> node) {
        return true;
    }

    public void ensureGridSize(double w, double h, boolean doitAnyWay) {
        if (this.isGridDisabled) {
            return;
        }
        boolean needsRevalidate = false;
        if (this.theGridCountX < w || doitAnyWay) {
            this.setGridXCount((int)w);
            needsRevalidate = true;
        }
        if (this.theGridCountY < h || doitAnyWay) {
            this.setGridYCount((int)h);
            needsRevalidate = true;
        }
        if (needsRevalidate) {
            this.layoutGrid(this.getWidth(), this.getHeight());
        }
    }

    public void setGridXCount(double x) {
        this.theGridCountX = x;
        if (this.theGridCountX == 0.0) {
            this.isGridDisabled = true;
        } else {
            this.isGridDisabled = false;
            this.layoutGrid(this.getWidth(), this.getHeight());
        }
    }

    public void setGridYCount(double y) {
        this.theGridCountY = y;
        if (this.theGridCountY == 0.0) {
            this.isGridDisabled = true;
        } else {
            this.isGridDisabled = false;
            this.theGalley.gridResized(this.theGridCountX, this.theGridCountY);
            this.layoutGrid(this.getWidth(), this.getHeight());
        }
    }

    public boolean isBoxSelectable(Node<Integer> node) {
        return true;
    }

    public double getMultiplierX() {
        return this.theXMultiplier;
    }

    public double getMultiplierY() {
        return this.theYMultiplier;
    }

    public double getMultiplierZ() {
        return this.theZMultiplier;
    }

    public Dimension getGridSize() {
        return new Dimension(this.theGridSizeX, this.theGridSizeY);
    }

    public void setSubGrid(boolean b) {
        this.isSubGalley = b;
    }

    public boolean isSubGrid() {
        return this.isSubGalley;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        GalleyBox b = this.theGalley.getSelectedBox();
        this.theGalley.selectBox(null, 0, 0);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    public int getChildCount() {
        return this.theBoxes.size();
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.theBoxes == null) {
            return;
        }
        for (GalleyBox box : (ArrayList)this.theBoxes.clone()) {
            box.kill();
        }
        this.theBoxes.clear();
        this.theBoxes = null;
        this.theDragPoint = null;
        this.theBoxArea = null;
        this.theGalley = null;
        this.fader.kill();
        this.fader = null;
        this.theInverseArea = null;
    }
}

