/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.galley;

import ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.PegasusGalleyModel;
import ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.PegasusSubModule;
import ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.galley.AbstractGalleyBoxEditor;
import ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.galley.DragController;
import ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.galley.GalleyBox;
import ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.galley.GalleyBoxEditor;
import ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.galley.GalleyGrid;
import ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.galley.GalleyGridPanel;
import ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.galley.GalleyModel;
import ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.galley.GalleySpecialGrid;
import ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.galley.SubGalley;
import ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.utils.LayoutManager;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.InnerPopUpListener2;
import ch.icit.pegasus.client.gui.utils.Selectable;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.TextButton;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.focus.CustomFocusCyclePolicy;
import ch.icit.pegasus.client.gui.utils.focus.Focusable;
import ch.icit.pegasus.client.gui.utils.focus.VisibleContainer;
import ch.icit.pegasus.client.gui.utils.numericstepper.NumericStepper;
import ch.icit.pegasus.client.gui.utils.numericstepper.NumericStepperListener;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.laf.LafListener;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeListener;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.util.toolkits.MasterDataToolkit;
import ch.icit.pegasus.server.core.dtos.flightschedule.aircraft.GalleyComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.GalleyEquipmentComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.GalleyEquipmentInsertComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.GalleyEquipmentSetComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.GalleyEquipmentSetTypeE;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListTemplateComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.GalleyEquipmentTypeComplete;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class Galley
extends GalleyGridPanel
implements LafListener,
ItemListener,
NumericStepperListener,
Focusable,
ButtonListener,
InnerPopUpListener2 {
    private static final long serialVersionUID = 1L;
    public static final int NORMAL_MODE = 3;
    public static final int SPECIAL_MODE = 5;
    protected GalleyGrid oldGrid;
    private SubGalley subGalley;
    private Node currentCustomer;
    private boolean blocking = false;
    protected AbstractGalleyBoxEditor galleyBoxEditor;
    protected TitledItem<ComboBox> galleySelection;
    protected TitledItem<ComboBox> typeSelection;
    protected Button fitGridSize;
    protected TitledItem<NumericStepper> gridSizeChangeH;
    protected TitledItem<NumericStepper> gridSizeChangeV;
    private GalleyEquipmentSetTypeE currentSet = GalleyEquipmentSetTypeE.CABINE;
    protected GalleyBox losePositionBox;
    private ArrayList<DummyCBElement> addedGalleys = new ArrayList();

    public Galley(PegasusSubModule pegasus, GalleyModel peg) {
        this(pegasus, peg, true);
    }

    public Galley(PegasusSubModule pegasus, GalleyModel peg, boolean hasTitle) {
        super(pegasus, hasTitle);
        this.theModel = peg;
        this.install();
        this.lafAttributeChanged("All attribues changed");
        this.theModel.setView(this);
        this.oldGrid = this.theGrid;
        this.createFocusCycle();
    }

    public void setCurrentCustomer(Node cc) {
        this.currentCustomer = cc;
    }

    public void setLosePositionNode(Node losePositionNode) {
        if (this.losePositionBox != null) {
            this.losePositionBox.kill();
            this.losePositionBox = null;
        }
        if (losePositionNode != null) {
            GalleyBox b;
            this.losePositionBox = b = new GalleyBox(this.pegasus, losePositionNode, this, true);
            this.losePositionBox.setEditorEnabled(false);
            this.losePositionBox.fadeIn();
            this.add((Component)this.losePositionBox, 0);
        }
    }

    public AbstractGalleyBoxEditor getGalleyEditor() {
        return this.galleyBoxEditor;
    }

    @Override
    public GalleyEquipmentSetTypeE getCurrentEquipmentType() {
        return this.currentSet;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        this.galleySelection.setEnabled(isEnabled);
        if (this.typeSelection != null) {
            this.typeSelection.setEnabled(isEnabled);
        }
        if (this.fitGridSize != null) {
            this.fitGridSize.setEnabled(isEnabled);
        }
        if (this.gridSizeChangeH != null) {
            this.gridSizeChangeH.setEnabled(isEnabled);
        }
        if (this.gridSizeChangeV != null) {
            this.gridSizeChangeV.setEnabled(isEnabled);
        }
    }

    @Override
    public Node getSelectedGalley() {
        DummyCBElement galleyName = (DummyCBElement)this.galleySelection.getElement().getSelectedItem();
        if (galleyName != null) {
            for (DummyCBElement n : this.addedGalleys) {
                if (n == galleyName) {
                    return n.getNode();
                }
                if (n.getNode() == null || galleyName.getNode() == null || n.getNode() != galleyName.getNode()) continue;
                return n.getNode();
            }
        }
        return null;
    }

    @Override
    public void deactivateEditorIfDeleted(GalleyBox b) {
        if (this.theSelectedBox == b) {
            this.deactivateEditor();
        }
    }

    @Override
    protected void deactivateEditor() {
        this.activateEditor4Box(null);
    }

    @Override
    public void insertSelectivGalley(Node v) {
        boolean found = false;
        for (int i = 0; i < this.galleySelection.getElement().getItemCount(); ++i) {
            DummyCBElement e = (DummyCBElement)this.galleySelection.getElement().getItemAt(i);
            if (!e.getNode().getValue().equals(v.getValue())) continue;
            found = true;
        }
        if (!found) {
            this.galleySelection.getElement().removeItemListener(this);
            DummyCBElement element = new DummyCBElement(v);
            this.galleySelection.getElement().addItem(element);
            if (!this.addedGalleys.contains(element)) {
                this.addedGalleys.add(element);
                this.galleySelection.getElement().addItemListener(this);
            }
        }
    }

    private void ensureSelection() {
        DummyCBElement selection = (DummyCBElement)this.galleySelection.getElement().getSelectedItem();
        if (selection != null) {
            if (selection.getNode() != this.theModel.getNode()) {
                this.theModel.setNode((Node<String>)selection.getNode());
            }
        } else {
            this.theModel.setNode(null);
        }
    }

    @Override
    public void setSelectedGalley(Node galleyNode) {
        this.galleySelection.getElement().removeItemListener(this);
        for (DummyCBElement n : this.addedGalleys) {
            if (n.getNode() != galleyNode) continue;
            this.galleySelection.getElement().setSelectedItem(n);
            this.galleySelection.getElement().addItemListener(this);
            this.ensureSelection();
            return;
        }
        this.galleySelection.getElement().addItemListener(this);
        this.ensureSelection();
    }

    @Override
    public void selectFirstGalley() {
        if (this.galleySelection.getElement().getItemCount() > 0) {
            this.galleySelection.getElement().removeItemListener(this);
            int newindex = 0;
            if (this.theModel.getPegasusState() == 3 && this.galleySelection.getElement().getItemCount() > 1) {
                newindex = 1;
            }
            this.galleySelection.getElement().setSelectedItem(null);
            this.galleySelection.getElement().setSelectedItem(this.galleySelection.getElement().getItemAt(newindex));
            this.galleySelection.getElement().addItemListener(this);
        }
    }

    protected void createFocusCycle() {
        ArrayList<Component> a = new ArrayList<Component>();
        a.add(this.galleySelection.getElement());
        if (this.typeSelection != null) {
            a.add(this.typeSelection.getElement());
        }
        if (this.fitGridSize != null) {
            a.add(this.fitGridSize);
        }
        if (this.gridSizeChangeH != null) {
            a.add(this.gridSizeChangeH.getElement().getTextField());
            a.add(this.gridSizeChangeV.getElement().getTextField());
        }
        CustomFocusCyclePolicy.revalidateFocusCyclePolicy(a, this);
    }

    @Override
    public void selectBox(GalleyBox box, int x, int y) {
        if (this.theSelectedBox == null && box == null) {
            return;
        }
        GalleyBox backupBox = this.theSelectedBox;
        if (this.theSelectedBox != null && this.theSelectedBox.getNode() != null && !(this.theSelectedBox.getNode().getValue() instanceof GalleyEquipmentComplete)) {
            this.theSelectedBox.enableNameEdit(false, true);
        }
        if (this.theSelectedBox != null) {
            this.getGrid().resetInset();
        }
        int hint = 5;
        Node node = null;
        if (box == null) {
            node = this.getSelectedGalley();
            hint = 3;
        } else {
            node = this.theModel.getPegasusState() == 3 ? box.getNode() : (box.getBoxNode().getValue() instanceof GalleyEquipmentComplete ? box.getNode() : box.getBoxNode());
        }
        this.theSelectedBox = box;
        this.theGlobalSeletionController.newNodeSelected(node, box, hint, box);
        if (this.theSelectedBox != null && !(this.theSelectedBox.getNode().getValue() instanceof GalleyEquipmentComplete) && this.theModel.getPegasusState() == 3) {
            if (!this.theSelectedBox.ensureFocusOnNameEnterField(x, y)) {
                this.theSelectedBox.requestFocusInWindow();
            }
        } else if (this.theSelectedBox != null && this.theSelectedBox.getNode().getValue() instanceof GalleyEquipmentInsertComplete && !this.theSelectedBox.ensureFocusOnNameEnterField(x, y)) {
            this.theSelectedBox.requestFocusInWindow();
        }
        if (this.theSelectedBox == null && this.galleyBoxEditor != null) {
            this.deactivateEditor();
        }
    }

    @Override
    public void removeSelectivGalley(Node v) {
        for (DummyCBElement e : this.addedGalleys) {
            if (e.getNode() != v) continue;
            this.galleySelection.getElement().removeItemListener(this);
            this.galleySelection.getElement().removeItem(e);
            this.ensureSelection();
            return;
        }
        this.ensureSelection();
    }

    public void insertSpecialBox(Node<String> boxNode) {
        GalleyBox aBox = new GalleyBox(this.pegasus, boxNode, this);
        this.theGrid.addSpecialBox(aBox);
        aBox.fadeIn();
    }

    public GalleyBox getBox4ConcretCoordinates(double x, double y, boolean b) {
        if (this.theModel.getState() == 3) {
            return this.theGrid.getIntersectingBox((int)x, (int)y);
        }
        return ((GalleySpecialGrid)this.theGrid).getSpecialBox4Coordinate(x, y, b);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(0, 200);
    }

    protected void install() {
        this.oldGrid = new GalleyGrid(this);
        this.setHasBackground(true);
        this.theGrid = this.oldGrid;
        this.oldGrid.setGridXCount(5.0);
        this.oldGrid.setGridYCount(8.0);
        if (this.theModel.needsSubgalley()) {
            this.subGalley = new SubGalley(this.pegasus, this, true);
            this.subGalley.setName("theSubGalley");
            this.subGalley.setLayoutManager(this.theLayoutManager);
            this.subGalley.setVisible(true);
        }
        this.galleyBoxEditor = new GalleyBoxEditor(((PegasusGalleyModel)this.theModel).getPegasus(), false);
        this.theGrid.setName("theGrid");
        this.theProgress = 1.0f;
        String galleySName = "";
        if (this.theModel.getPegasusState() == 3) {
            galleySName = Words.SHOW;
        } else {
            this.typeSelection = new TitledItem<ComboBox>(new ComboBox(), "", TitledItem.TitledItemOrientation.NORTH);
            this.typeSelection.getElement().addItem(GalleyEquipmentSetTypeE.CABINE);
            this.typeSelection.getElement().addItem(GalleyEquipmentSetTypeE.HOLD);
            this.typeSelection.getElement().addItemListener(this);
            this.add(this.typeSelection);
        }
        if (this.theModel.getPegasusState() == 3) {
            this.galleySelection = new TitledItem<ComboBox>(new ComboBox(), galleySName, TitledItem.TitledItemOrientation.WEST);
            this.galleySelection.setIgnorePrefWidth(true);
            this.fitGridSize = new TextButton(Words.FIT_GRID);
            this.fitGridSize.addButtonListener(this);
            this.gridSizeChangeV = new TitledItem<NumericStepper>(new NumericStepper(), Words.GRID_V, TitledItem.TitledItemOrientation.NORTH);
            this.gridSizeChangeH = new TitledItem<NumericStepper>(new NumericStepper(), Words.GRID_H, TitledItem.TitledItemOrientation.NORTH);
            this.gridSizeChangeH.getElement().setMinValue(1.0);
            this.gridSizeChangeV.getElement().setMinValue(1.0);
            this.gridSizeChangeH.getElement().setInputNr((int)this.theGrid.getGridCountX());
            this.gridSizeChangeV.getElement().setInputNr((int)this.theGrid.getGridCountY());
            this.gridSizeChangeH.getElement().addNumericStepperListener(this);
            this.gridSizeChangeV.getElement().addNumericStepperListener(this);
            this.add((Component)this.gridSizeChangeH, 0);
            this.add((Component)this.gridSizeChangeV, 0);
            this.add(this.fitGridSize);
        } else {
            this.galleySelection = new TitledItem<ComboBox>(new ComboBox(), galleySName, TitledItem.TitledItemOrientation.NORTH);
        }
        this.galleySelection.getElement().addItemListener(this);
        this.setLayout(new Layout());
        this.add(this.theGrid);
        this.add(this.galleySelection);
        this.add((Component)this.galleyBoxEditor, 0);
    }

    @Override
    public void movePanel(int x, int y, boolean smooth) {
        this.setLocation(x, y);
    }

    @Override
    public void removeBox(GalleyBox galleyBox) {
        this.theGrid.removeBox(galleyBox);
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setComposite(AlphaComposite.getInstance(3, this.theProgress));
        if (this.hasBackground) {
            g2.setColor(this.innerBackground);
            g2.fillRoundRect(0, 0, this.getWidth(), this.getHeight(), this.arcW, this.arcH);
        }
        if (this.hasSkin) {
            this.skin.paint(g2, 0, 0, this.getWidth(), this.getHeight(), Button.ButtonState.UP);
        }
        if (this.useCliping) {
            Shape r = this.getClipingArea();
            g2.clip(r);
        }
        this.paintChildren(g2);
    }

    @Override
    public void setLayoutManager(LayoutManager lay) {
        super.setLayoutManager(lay);
        if (this.subGalley != null) {
            this.subGalley.setLayoutManager(lay);
        }
    }

    @Override
    public void highlightGrid(int x, int y) {
        if (this.isEmptyField(x, y, this.theGrid.getMultiplierX(), this.theGrid.getMultiplierY(), this.theGrid.getMultiplierZ()) > 0) {
            if (this.theModel.getState() == 5) {
                GalleyBox aBox = ((GalleySpecialGrid)this.theGrid).getSpecialBox4Coordinate(x, y, false);
                this.theGrid.highlightPoint(aBox.getX(), aBox.getY());
                this.createHighLightShape();
            } else {
                this.theGrid.highlightPoint(x, y);
                this.createHighLightShape();
            }
        } else {
            this.theGrid.highlightPoint(-1, -1);
            if (this.selectionShape != null) {
                this.selectionShape.setProgress(0.0f);
            }
        }
    }

    @Override
    public void setNullSelection(boolean isNullSelection) {
    }

    @Override
    public void setDragController(DragController c) {
        super.setDragController(c);
        if (this.subGalley != null) {
            this.subGalley.setDragController(c);
        }
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.losePositionBox != null) {
            this.losePositionBox.kill();
            this.losePositionBox = null;
        }
        this.galleyBoxEditor.kill();
        this.galleyBoxEditor = null;
        this.oldGrid.kill();
        this.oldGrid = null;
        if (this.subGalley != null) {
            this.subGalley.kill();
            this.subGalley = null;
        }
        this.galleySelection.kill();
        this.galleySelection = null;
        if (this.typeSelection != null) {
            this.typeSelection.kill();
            this.typeSelection = null;
        }
        if (this.fitGridSize != null) {
            this.fitGridSize.kill();
            this.fitGridSize = null;
        }
        if (this.gridSizeChangeH != null) {
            this.gridSizeChangeH.kill();
            this.gridSizeChangeH = null;
        }
        if (this.gridSizeChangeV != null) {
            this.gridSizeChangeV.kill();
            this.gridSizeChangeV = null;
        }
        this.addedGalleys.clear();
        this.addedGalleys = null;
    }

    @Override
    public GalleyBox getBox4ConcretCoordinates(double x, double y) {
        return this.getBox4ConcretCoordinates(x, y, false);
    }

    @Override
    public void layoutPanel(int w, int h, boolean resize) {
    }

    public GalleyGrid getOldGrid() {
        return this.oldGrid;
    }

    public void setGrid(GalleyGrid g) {
        this.theGrid = g;
    }

    public GalleyGridPanel getSubGalley() {
        return this.subGalley;
    }

    @Override
    public void lafAttributeChanged(String att) {
        super.lafAttributeChanged(att);
        if (this.galleySelection != null) {
            this.galleySelection.setTitleFont(AttributesConverter.getFont4String(LafLoader.getLafLoader().getAttribute("default_font"), LafLoader.getLafLoader().getAttribute("default_font_size"), LafLoader.getLafLoader().getAttribute("default_font_type")));
            if (this.gridSizeChangeH != null) {
                this.gridSizeChangeH.setTitleFont(AttributesConverter.getFont4String(LafLoader.getLafLoader().getAttribute("default_font"), LafLoader.getLafLoader().getAttribute("default_font_size"), LafLoader.getLafLoader().getAttribute("default_font_type")));
                this.gridSizeChangeV.setTitleFont(AttributesConverter.getFont4String(LafLoader.getLafLoader().getAttribute("default_font"), LafLoader.getLafLoader().getAttribute("default_font_size"), LafLoader.getLafLoader().getAttribute("default_font_type")));
            }
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() == 1) {
            if (e.getSource() == this.galleySelection.getElement()) {
                Node newGalley = this.getSelectedGalley();
                this.getGlobalSelectionContoller().newNodeSelected(newGalley, this, 3, null);
                this.theGrid.ensureGridSize();
            } else if (e.getSource() == this.typeSelection.getElement()) {
                this.currentSet = (GalleyEquipmentSetTypeE)this.typeSelection.getElement().getSelectedItem();
                this.itemStateChanged(new ItemEvent(this.galleySelection.getElement(), 123, this.galleySelection.getElement().getSelectedItem(), 1));
            }
        }
    }

    @Override
    public void valueChanged(NumericStepper source) {
        if (source == this.gridSizeChangeH.getElement()) {
            this.blocking = true;
            this.theGrid.setGridXCount(((Integer)source.getInputNr()).intValue());
            this.blocking = false;
        } else if (source == this.gridSizeChangeV.getElement()) {
            this.blocking = true;
            this.theGrid.setGridYCount(((Integer)source.getInputNr()).intValue());
            this.blocking = false;
        }
        this.activateEditor4Box(this.theSelectedBox);
        this.theGrid.layoutGrid(this.theGrid.getWidth(), this.theGrid.getHeight());
        this.theGrid.repaint(32L);
    }

    private void ensureEnclosingGalleyBoxes(GalleyBox currentBox) {
        double cx = currentBox.getDX() + currentBox.getDWidth();
        double cy = currentBox.getDY();
        GalleyBox rN = this.getGrid().getBox4Coordinate(cx, cy);
        if (rN != null && this.galleyBoxEditor.getPegasus().isBoxSplittable(rN) && rN.isUseAlternatives()) {
            rN.useInset(3);
        }
        cx = currentBox.getDX();
        GalleyBox uN = this.getGrid().getBox4Coordinate2(cx, cy -= 0.01);
        if (uN != null && this.galleyBoxEditor.getPegasus().isBoxSplittable(uN) && uN.isUseAlternatives()) {
            uN.useInset(5);
        }
    }

    @Override
    public void activateEditor4Box(GalleyBox box) {
        if (this.theSelectedBox != null && box != null) {
            if (this.theSelectedBox == this.losePositionBox) {
                if (this.galleyBoxEditor != null) {
                    this.deactivateEditor();
                }
                return;
            }
            this.theSelectedBox.setEditorEnabled(true);
            if (this.theModel.getPegasusState() == 3) {
                Node pos = this.theSelectedBox.getNode();
                if (pos.getChildNamed(new String[]{"alternativePositions"}).getChildCount() > 0) {
                    this.galleyBoxEditor.setState(5);
                    this.ensureEnclosingGalleyBoxes(this.theSelectedBox);
                } else if (this.galleyBoxEditor.getPegasus().isBoxSplittable(this.theSelectedBox)) {
                    this.galleyBoxEditor.setState(7);
                    this.ensureEnclosingGalleyBoxes(this.theSelectedBox);
                } else {
                    this.galleyBoxEditor.setState(11);
                }
                if (box.isResizable()) {
                    ((GalleyBoxEditor)this.galleyBoxEditor).ensureInfoButton(true);
                } else {
                    ((GalleyBoxEditor)this.galleyBoxEditor).ensureInfoButton(false);
                }
            } else {
                if (box == null || box.getEffectedNode() == null) {
                    return;
                }
                Node n = box.getEffectedNode().getChildNamed(new String[]{"labelConfiguration-display"});
                Node bo = box.getEffectedNode().getChildNamed(new String[]{"generateReservedSpaceLabels"});
                this.galleyBoxEditor.setState(3);
                GalleyEquipmentTypeComplete t = (GalleyEquipmentTypeComplete)box.getEffectedNode().getChildNamed(new String[]{"equipmentType"}).getValue();
                SystemSettingsComplete settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
                if (t.getCode().equals(settings.getLooseEquipmentType().getCode())) {
                    this.galleyBoxEditor.setLabelActive(false);
                } else {
                    Boolean b = true;
                    if (n != null && n.getValue() != null) {
                        b = (Boolean)n.getValue();
                    }
                    if (bo != null && bo.getValue() != null) {
                        b = b & (Boolean)bo.getValue() == false;
                    }
                    if (Boolean.TRUE.equals(b)) {
                        this.galleyBoxEditor.setLabelActive(true);
                    } else {
                        this.galleyBoxEditor.setLabelActive(false);
                    }
                }
            }
            if (this.galleyBoxEditor.getProgress() == 0.0f) {
                this.setComponentZOrder(this.galleyBoxEditor, 0);
                this.galleyBoxEditor.setLocation(box.getX() + this.theGrid.getX() - this.galleyBoxEditor.getXOffset(), box.getY() + this.theGrid.getY() - this.galleyBoxEditor.getYOffset());
                this.galleyBoxEditor.setSize(box.getWidth() + 2 * this.galleyBoxEditor.getXOffset(), box.getHeight() + 2 * this.galleyBoxEditor.getYOffset());
                this.galleyBoxEditor.fadeIn();
                this.invalidate();
            } else {
                this.setComponentZOrder(this.galleyBoxEditor, 0);
                this.galleyBoxEditor.setLocation(box.getX() + this.theGrid.getX() - this.galleyBoxEditor.getXOffset(), box.getY() + this.theGrid.getY() - this.galleyBoxEditor.getYOffset());
                this.galleyBoxEditor.setSize(box.getWidth() + 2 * this.galleyBoxEditor.getXOffset(), box.getHeight() + 2 * this.galleyBoxEditor.getYOffset());
                this.invalidate();
            }
        } else {
            if (this.theSelectedBox != null) {
                this.theSelectedBox.setEditorEnabled(false);
            }
            if (this.galleyBoxEditor.getProgress() > 0.0f) {
                this.galleyBoxEditor.fadeOut(false);
            }
        }
    }

    public void updateEditor(int isSplit) {
        if (isSplit == -1) {
            if (this.theModel.getPegasusState() == 3) {
                if (this.galleyBoxEditor.getPegasus().isBoxSplittable(this.theSelectedBox)) {
                    this.galleyBoxEditor.setState(7);
                } else {
                    this.galleyBoxEditor.setState(11);
                }
            } else {
                this.galleyBoxEditor.setState(5);
            }
        } else {
            this.galleyBoxEditor.setState(isSplit);
        }
    }

    @Override
    public AbstractGalleyBoxEditor getEditor() {
        return this.galleyBoxEditor;
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> a = new ArrayList<Component>();
        CheckedListAdder.addToList(a, this.galleySelection);
        CheckedListAdder.addToList(a, this.typeSelection);
        return a;
    }

    @Override
    public void setVisibleContainer(VisibleContainer pane) {
    }

    @Override
    public Selectable getSelectDelegationComponent() {
        return null;
    }

    @Override
    public void gridResized(double theGridCountX, double theGridCountY) {
        if (this.gridSizeChangeH != null && !this.blocking) {
            this.gridSizeChangeH.getElement().setInputNr((int)theGridCountX);
        }
        if (this.gridSizeChangeV != null && !this.blocking) {
            this.gridSizeChangeV.getElement().setInputNr((int)theGridCountY);
        }
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        double maxDX = 4.0;
        double maxDY = 7.0;
        if (this.theModel.getNode() == null) {
            return;
        }
        Node poses = this.theModel.getNode().getChildNamed(new String[]{"stowagePositionSpecifications"});
        Iterator it = poses.getChilds();
        while (it.hasNext()) {
            Node n = (Node)it.next();
            Node defaults = n.getChildNamed(new String[]{"defaultPositions"});
            Iterator it2 = defaults.getChilds();
            while (it2.hasNext()) {
                Node nn = (Node)it2.next();
                Node xn = nn.getChildNamed(new String[]{"location-x"});
                Node wn = nn.getChildNamed(new String[]{"type-size-width"});
                Node yn = nn.getChildNamed(new String[]{"location-y"});
                Node hn = nn.getChildNamed(new String[]{"type-size-height"});
                double nx = (Double)xn.getValue() + (Double)wn.getValue();
                double ny = (Double)yn.getValue() + (Double)hn.getValue();
                if (nx > maxDX) {
                    maxDX = nx;
                }
                if (!(ny > maxDY)) continue;
                maxDY = ny;
            }
        }
        this.ensureGridSize(maxDX + 1.0, maxDY + 1.0, true);
        this.theGrid.repaint(32L);
    }

    @Override
    public void requestFocusInWindowNow() {
        this.galleySelection.requestFocusInWindowNow();
    }

    @Override
    public void popUpClosed(InnerPopUp2 source, Object ... xargs) {
        if (xargs == null) {
            return;
        }
        Node n = (Node)xargs[0];
        Node n2 = null;
        Object stw = null;
        n2 = xargs[1] instanceof StowingListTemplateComplete ? INodeCreator.getDefaultImpl().getNode4DTO(xargs[1], false, false) : (Node)xargs[1];
        this.pegasus.tryToCopyBox(n);
        this.pegasus.tryToPasteBox(this.pegasus.getCurrentSelection(), n2);
    }

    public void clearGalleyList() {
        this.galleySelection.getElement().removeAllItems();
    }

    private class DummyCBElement
    implements NodeListener,
    Comparable<DummyCBElement> {
        private final Node node;

        public DummyCBElement(Node<?> n) {
            this.node = n;
        }

        public void childAdded(Node<?> source, Node<?> child) {
        }

        public void childRemoved(Node<?> source, Node<?> child) {
        }

        public Node getNode() {
            return this.node;
        }

        public void valueChanged(Node<?> node) {
        }

        public String toString() {
            if (this.node == null) {
                return "";
            }
            String retValue = "";
            if (this.node.getValue() instanceof GalleyComplete) {
                retValue = this.doForGalley(this.node);
            } else if (this.node.getValue() instanceof GalleyEquipmentSetComplete) {
                retValue = this.doForGalleyEquipement(this.node);
            } else if (this.node != null && this.node.getParent() != null && this.node.getParent().getValue() instanceof GalleyEquipmentSetComplete) {
                retValue = this.doForGalleyEquipement(this.node.getParent());
            }
            return retValue;
        }

        private String doForGalley(Node aN) {
            Node galleyName = aN.getChildNamed(new String[]{"code"});
            Node ccs = aN.getChildNamed(new String[]{"cabinClasses"});
            String retValue = (String)galleyName.getValue();
            String ccSTR = MasterDataToolkit.createCabinClassString(ccs);
            if (!(ccSTR = ccSTR.trim()).equals("")) {
                retValue = retValue + " (" + ccSTR + ")";
            }
            return retValue;
        }

        private String doForGalleyEquipement(Node aN) {
            Node galleyName = aN.getChildNamed(new String[]{"galleyCode"});
            Node ccs = aN.getChildNamed(new String[]{"cabinClasses"});
            String retValue = (String)galleyName.getValue();
            String ccSTR = MasterDataToolkit.createCabinClassString(ccs);
            if (!(ccSTR = ccSTR.trim()).equals("")) {
                retValue = retValue + " (" + ccSTR + ")";
            }
            return retValue;
        }

        @Override
        public int compareTo(DummyCBElement o) {
            return this.toString().compareTo(o.toString());
        }

        public boolean isSwingOnly() {
            return true;
        }

        public void childrenAdded(Node<?> source, Node<?> ... nodes) {
        }
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int h = parent.getHeight();
            int w = parent.getWidth();
            Galley.this.layoutTitle(Galley.this);
            if (Galley.this.isExpanded()) {
                int aBorder = 10;
                switch (Galley.this.theModel.getState()) {
                    case 3: {
                        if (Galley.this.theModel.getPegasusState() == 3) {
                            int titleHeight = 0;
                            titleHeight = Galley.this.getTitleHeight();
                            Galley.this.galleySelection.setLocation(aBorder, titleHeight + aBorder);
                            Galley.this.galleySelection.setSize(300, (int)Galley.this.galleySelection.getPreferredSize().getHeight());
                            Galley.this.theGrid.setVisible(true);
                            Galley.this.theGrid.setLocation(100, Galley.this.galleySelection.getY() + Galley.this.galleySelection.getHeight() + Galley.this.galleyBoxEditor.getHalfIconWidth());
                            Galley.this.theGrid.layoutGrid(w - (Galley.this.theGrid.getX() + Galley.this.galleyBoxEditor.getHalfIconWidth()), h - (Galley.this.theGrid.getY() + Galley.this.galleyBoxEditor.getHalfIconWidth()));
                            Galley.this.gridSizeChangeV.setSize(60, (int)Galley.this.gridSizeChangeV.getPreferredSize().getHeight());
                            Galley.this.gridSizeChangeV.setLocation(Galley.this.galleySelection.getX(), Galley.this.theGrid.getY() + Galley.this.theGrid.getHeight() - Galley.this.gridSizeChangeV.getHeight());
                            Galley.this.gridSizeChangeH.setSize(60, (int)Galley.this.gridSizeChangeH.getPreferredSize().getHeight());
                            Galley.this.gridSizeChangeH.setLocation(Galley.this.gridSizeChangeV.getX(), Galley.this.gridSizeChangeV.getY() - (aBorder / 2 + Galley.this.gridSizeChangeH.getHeight()));
                            Galley.this.fitGridSize.setSize(Galley.this.fitGridSize.getPreferredSize());
                            Galley.this.fitGridSize.setLocation(Galley.this.galleySelection.getX(), Galley.this.gridSizeChangeH.getY() - (aBorder + Galley.this.fitGridSize.getHeight()));
                            break;
                        }
                        int titleHeight = 0;
                        titleHeight = Galley.this.getTitleHeight();
                        int gw = parent.getWidth() - (aBorder + aBorder + 90 + aBorder + 90 + aBorder);
                        Galley.this.galleySelection.setLocation(aBorder, titleHeight + aBorder);
                        Galley.this.galleySelection.setSize(gw, (int)Galley.this.galleySelection.getPreferredSize().getHeight());
                        Galley.this.typeSelection.setLocation(Galley.this.galleySelection.getX() + Galley.this.galleySelection.getWidth() + aBorder, Galley.this.galleySelection.getY());
                        Galley.this.typeSelection.setSize(90, (int)Galley.this.typeSelection.getPreferredSize().getHeight());
                        if (Galley.this.losePositionBox != null) {
                            Galley.this.losePositionBox.setLocation(parent.getWidth() - (90 + aBorder), Galley.this.typeSelection.getY());
                            Galley.this.losePositionBox.setSize(90, Galley.this.typeSelection.getHeight());
                        }
                        Galley.this.theGrid.setVisible(true);
                        Galley.this.theGrid.setLocation(Galley.this.galleyBoxEditor.getHalfIconWidth(), Galley.this.galleySelection.getY() + Galley.this.galleySelection.getHeight() + Galley.this.galleyBoxEditor.getHalfIconWidth());
                        Galley.this.theGrid.layoutGrid(w - 2 * Galley.this.galleyBoxEditor.getHalfIconWidth(), h - (Galley.this.theGrid.getY() + Galley.this.galleyBoxEditor.getHalfIconWidth()));
                        break;
                    }
                }
            } else {
                Galley.this.theGrid.setVisible(false);
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return null;
        }
    }
}

