/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui;

import ch.icit.pegasus.client.comparators.controller.ComparatorRegistry;
import ch.icit.pegasus.client.converter.BasicArticleConverter;
import ch.icit.pegasus.client.converter.EquipmentTemplateConverter;
import ch.icit.pegasus.client.converter.ProductViewConverter;
import ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.DefaultListViewModel;
import ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.PegasusSubModule;
import ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.comparators.InventoryComparator;
import ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.list.ListView;
import ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.list.ListViewItem;
import ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.search.ArticleSearchAlgorithm;
import ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.search.EquipmentTemplateSearchAlgorithm;
import ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.search.ProductSearchAlgorithm;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeListener;
import ch.icit.pegasus.client.util.toolkits.MealPlanToolkit;
import ch.icit.pegasus.server.core.dtos.equipmenttemplate.EquipmentTemplateComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.CateringServiceComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.CateringServiceScheduleComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.CateringServiceScheduleComplete_;
import ch.icit.pegasus.server.core.dtos.mealplan.CateringServiceScheduleVariantComplete_;
import ch.icit.pegasus.server.core.dtos.mealplan.LoadingGroupComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.LoadingGroupTemplateComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.MealTypeComplete;
import ch.icit.pegasus.server.core.dtos.product.ProductComplete;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleLight;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.util.Triple;
import ch.icit.pegasus.server.core.util.Tuple;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;

public class InventoryListViewModel
extends DefaultListViewModel {
    protected Node theNode;
    protected ListView theList;
    protected ArrayList<Node> theListenChilds = new ArrayList();
    protected String theDefaultToolTip = "";
    protected Node services;
    protected Node products;
    protected Node equipments;
    protected Node articles;
    protected static String productSuperCatID = "Products";
    protected static String articleSuperCatID = "Articles";
    protected ListViewItem equipmentSuperCat;
    protected ListViewItem productSuperCat;
    protected ListViewItem articleSuperCat;
    private boolean isBlocked = false;
    public static String serviceString = "Services";
    public static String equipmentString = "Equipment Template";

    public InventoryListViewModel(ListView list, PegasusSubModule peg) {
        super(list, peg);
        this.theList = list;
        this.theList.setComparator(ComparatorRegistry.getComparator(InventoryComparator.class));
        serviceString = Words.SERVICES;
        this.theList.setTitle(Words.PRODUCTS);
    }

    @Override
    public void setDefaultToolTip(String tt) {
        this.theDefaultToolTip = tt;
    }

    @Override
    public Node getNode() {
        return this.theNode;
    }

    @Override
    public void setNode(Node node) {
        if (node == this.theNode) {
            return;
        }
        this.theList.resetList();
        if (this.theNode != null) {
            this.theNode.removeNodeListener((NodeListener)this);
        }
        for (Node n : this.theListenChilds) {
            n.removeNodeListener((NodeListener)this);
        }
        this.theListenChilds.clear();
        this.theNode = node;
        if (this.theNode != null) {
            this.isBlocked = true;
            this.theNode.addNodeListener((NodeListener)this);
            this.theNode.getAllChildAddEvents((NodeListener)this);
            this.isBlocked = false;
        }
        this.theList.updateOrder();
    }

    private ListViewItem ensureParentCategory(Node prod) {
        if (prod.getValue() instanceof ProductComplete) {
            if (this.productSuperCat == null) {
                this.productSuperCat = new ListViewItem(productSuperCatID, null, this.theList, 3, true, this.pegasus);
                this.theList.addChild(this.productSuperCat);
            }
            return this.productSuperCat;
        }
        if (prod.getValue() instanceof BasicArticleLight) {
            if (this.articleSuperCat == null) {
                this.articleSuperCat = new ListViewItem(articleSuperCatID, null, this.theList, 3, true, this.pegasus);
                this.theList.addChild(this.articleSuperCat);
            }
            return this.articleSuperCat;
        }
        if (prod.getValue() instanceof CateringServiceScheduleComplete || prod.getValue() instanceof CateringServiceComplete) {
            Node cat = prod.getChildNamed(new String[]{"type"});
            if (cat != null && cat.getValue() != null) {
                ListViewItem subCat;
                ListViewItem catItem = this.theList.getItem4Object(serviceString);
                if (catItem == null) {
                    catItem = new ListViewItem(serviceString, null, this.theList, 3, true, this.pegasus);
                    this.theList.addChild(catItem);
                }
                if ((subCat = catItem.getItem4Object(prod.getValue())) == null) {
                    subCat = new ListViewItem(prod.getValue(), catItem, this.theList, 5, true, this.pegasus);
                    catItem.addChild(subCat);
                }
                return subCat;
            }
        } else if (prod.getValue() instanceof EquipmentTemplateComplete) {
            if (this.equipmentSuperCat == null) {
                this.equipmentSuperCat = new ListViewItem(equipmentString, null, this.theList, 3, true, this.pegasus);
                this.theList.addChild(this.equipmentSuperCat);
            }
            return this.equipmentSuperCat;
        }
        return null;
    }

    public void childAdded(Node parent, Node child) {
        if (parent == this.theNode) {
            if (child.getName().equals("MealServices")) {
                if (this.services != null) {
                    this.services.removeNodeListener((NodeListener)this);
                }
                this.services = child;
                this.services.addNodeListener((NodeListener)this);
                this.services.getAllChildAddEventsFor((NodeListener)this, new String[0]);
            } else if (child.getName().equals("Products")) {
                ((ProductSearchAlgorithm)this.theList.getSearchAlgorithm(1)).setNode(child);
                if (this.products != null) {
                    this.products.removeNodeListener((NodeListener)this);
                }
                this.products = child;
                this.products.addNodeListener((NodeListener)this);
                this.products.getAllChildAddEventsFor((NodeListener)this, new String[0]);
            } else if (child.getName().equals("Articles")) {
                ((ArticleSearchAlgorithm)this.theList.getSearchAlgorithm(0)).setNode(child);
                if (this.articles != null) {
                    this.articles.removeNodeListener((NodeListener)this);
                }
                this.articles = child;
                this.articles.addNodeListener((NodeListener)this);
                this.articles.getAllChildAddEventsFor((NodeListener)this, new String[0]);
            } else if (child.getName().equals(equipmentString)) {
                ((EquipmentTemplateSearchAlgorithm)this.theList.getSearchAlgorithm(2)).setNode(child);
                if (this.equipments != null) {
                    this.equipments.removeNodeListener((NodeListener)this);
                }
                this.equipments = child;
                this.equipments.addNodeListener((NodeListener)this);
                this.equipments.getAllChildAddEventsFor((NodeListener)this, new String[0]);
            }
        } else if (parent == this.services) {
            if (child.getValue() instanceof CateringServiceComplete) {
                Node tn;
                ListViewItem aItem;
                ListViewItem p;
                String t;
                CateringServiceComplete service = (CateringServiceComplete)child.getValue();
                HashSet<Tuple> spmlSpaces = new HashSet<Tuple>();
                HashSet<Tuple> alaCarteSpaces = new HashSet<Tuple>();
                Iterator choices = child.getChildNamed(new String[]{"parts"}).getChilds();
                while (choices.hasNext()) {
                    Node n2 = (Node)choices.next();
                    ListViewItem aItem2 = null;
                    LoadingGroupComplete lg = (LoadingGroupComplete)n2.getChildNamed(new String[]{"loadingGroup"}).getValue();
                    if (Boolean.TRUE.equals(lg.getUseMealTypeSPMLStowage()) && lg.getMealType() != null) {
                        if (lg.getDeliverSpml().booleanValue()) {
                            spmlSpaces.add(new Tuple((Object)lg.getMealType(), (Object)lg.getContainingService()));
                        }
                        if (lg.getDeliverAlaCarte().booleanValue()) {
                            alaCarteSpaces.add(new Tuple((Object)lg.getMealType(), (Object)lg.getContainingService()));
                        }
                    }
                    String t2 = MealPlanToolkit.createServicePartString(n2.getChildNamed(new String[]{"loadingGroup"}), true);
                    ListViewItem p2 = this.ensureParentCategory(child);
                    aItem2 = p2 != null ? p2.getItem4Object(t2) : this.theList.getItem4Object(t2);
                    if (aItem2 != null) continue;
                    aItem2 = new ListViewItem(n2.getChildNamed(new String[]{"loadingGroup"}), p2, this.theList, 11, true, this.pegasus);
                    aItem2.addUserObject(t2);
                    if (p2 == null) {
                        this.theList.addChild(aItem2);
                        continue;
                    }
                    p2.addChild(aItem2);
                }
                for (Tuple spmlSpace : spmlSpaces) {
                    t = MealPlanToolkit.createMealTypeSPMLSpaceString((MealTypeComplete)spmlSpace.getS());
                    p = this.ensureParentCategory(child);
                    aItem = null;
                    aItem = p != null ? p.getItem4Object(t) : this.theList.getItem4Object(t);
                    tn = new Node();
                    tn.setValue((Object)t, 0L);
                    if (aItem != null) continue;
                    aItem = new ListViewItem(tn, p, this.theList, 11, true, this.pegasus);
                    aItem.addUserObject(new Triple(spmlSpace.getS(), spmlSpace.getT(), (Object)t));
                    if (p == null) {
                        this.theList.addChild(aItem);
                        continue;
                    }
                    p.addChild(aItem);
                }
                for (Tuple alaCarteSpace : alaCarteSpaces) {
                    t = MealPlanToolkit.createMealTypealaCarteSpaceString((MealTypeComplete)alaCarteSpace.getS());
                    p = this.ensureParentCategory(child);
                    aItem = null;
                    aItem = p != null ? p.getItem4Object(t) : this.theList.getItem4Object(t);
                    tn = new Node();
                    tn.setValue((Object)t, 0L);
                    if (aItem != null) continue;
                    aItem = new ListViewItem(tn, p, this.theList, 11, true, this.pegasus);
                    aItem.addUserObject(new Triple(alaCarteSpace.getS(), alaCarteSpace.getT(), (Object)t));
                    if (p == null) {
                        this.theList.addChild(aItem);
                        continue;
                    }
                    p.addChild(aItem);
                }
            } else {
                Node tn;
                ListViewItem p;
                String t;
                ListViewItem aItem;
                Iterator rotations;
                CateringServiceScheduleComplete service = (CateringServiceScheduleComplete)child.getValue(CateringServiceScheduleComplete.class);
                HashSet<Tuple> spmlSpaces = new HashSet<Tuple>();
                HashSet<Tuple> alaCarteSpaces = new HashSet<Tuple>();
                Node q = child.getChildNamed(CateringServiceScheduleComplete_.currentVariant);
                if (q.getChildNamed(new String[]{"rotations"}) != null && (rotations = q.getChildNamed(new String[]{"rotations"}).getChilds()).hasNext()) {
                    Node n = (Node)rotations.next();
                    Iterator parts = n.getChildNamed(new String[]{"parts"}).getChilds();
                    while (parts.hasNext()) {
                        Node n2 = (Node)parts.next();
                        aItem = null;
                        LoadingGroupTemplateComplete lg = (LoadingGroupTemplateComplete)n2.getChildNamed(new String[]{"loadingGroup"}).getValue();
                        if (lg.getUseMealTypeSPMLStowage().booleanValue() && lg.getMealType() != null) {
                            if (lg.getDeliverSpml().booleanValue()) {
                                spmlSpaces.add(new Tuple((Object)lg.getMealType(), (Object)lg.getContainingService().getBase()));
                            }
                            if (lg.getDeliverAlaCarte().booleanValue()) {
                                alaCarteSpaces.add(new Tuple((Object)lg.getMealType(), (Object)lg.getContainingService().getBase()));
                            }
                        }
                        String t3 = MealPlanToolkit.createServicePartString(n2.getChildNamed(new String[]{"loadingGroup"}), true);
                        ListViewItem p3 = this.ensureParentCategory(q.getChildNamed(CateringServiceScheduleVariantComplete_.base));
                        aItem = p3 != null ? p3.getItem4Object(t3) : this.theList.getItem4Object(t3);
                        if (aItem != null) continue;
                        aItem = new ListViewItem(n2.getChildNamed(new String[]{"loadingGroup"}), p3, this.theList, 11, true, this.pegasus);
                        aItem.addUserObject(t3);
                        if (p3 == null) {
                            this.theList.addChild(aItem);
                            continue;
                        }
                        p3.addChild(aItem);
                    }
                }
                for (Tuple spmlSpace : spmlSpaces) {
                    t = MealPlanToolkit.createMealTypeSPMLSpaceString((MealTypeComplete)spmlSpace.getS());
                    p = this.ensureParentCategory(child);
                    aItem = null;
                    aItem = p != null ? p.getItem4Object(t) : this.theList.getItem4Object(t);
                    tn = new Node();
                    tn.setValue((Object)t, 0L);
                    if (aItem != null) continue;
                    aItem = new ListViewItem(tn, p, this.theList, 11, true, this.pegasus);
                    aItem.addUserObject(new Triple(spmlSpace.getS(), spmlSpace.getT(), (Object)t));
                    if (p == null) {
                        this.theList.addChild(aItem);
                        continue;
                    }
                    p.addChild(aItem);
                }
                for (Tuple alaCarteSpace : alaCarteSpaces) {
                    t = MealPlanToolkit.createMealTypealaCarteSpaceString((MealTypeComplete)alaCarteSpace.getS());
                    p = this.ensureParentCategory(child);
                    aItem = null;
                    aItem = p != null ? p.getItem4Object(t) : this.theList.getItem4Object(t);
                    tn = new Node();
                    tn.setValue((Object)t, 0L);
                    if (aItem != null) continue;
                    aItem = new ListViewItem(tn, p, this.theList, 11, true, this.pegasus);
                    aItem.addUserObject(new Triple(alaCarteSpace.getS(), alaCarteSpace.getT(), (Object)t));
                    if (p == null) {
                        this.theList.addChild(aItem);
                        continue;
                    }
                    p.addChild(aItem);
                }
            }
        } else if (parent == this.products) {
            ListViewItem p = this.ensureParentCategory(child);
            child.setConverter(ProductViewConverter.class);
            ListViewItem aItem = null;
            aItem = p != null ? p.getItem4Object(child) : this.theList.getItem4Object(child);
            if (aItem == null) {
                aItem = new ListViewItem(child, p, this.theList, 11, true, this.pegasus);
                if (p == null) {
                    this.productSuperCat.addChild(aItem);
                } else {
                    p.addChild(aItem);
                }
            }
        } else if (parent == this.articles) {
            ListViewItem p = this.ensureParentCategory(child);
            child.setConverter(BasicArticleConverter.class);
            ListViewItem aItem = null;
            aItem = p != null ? p.getItem4Object(child) : this.theList.getItem4Object(child);
            if (aItem == null) {
                aItem = new ListViewItem(child, p, this.theList, 11, true, this.pegasus);
                if (p == null) {
                    this.articleSuperCat.addChild(aItem);
                } else {
                    p.addChild(aItem);
                }
            }
        } else if (parent == this.equipments) {
            ListViewItem p = this.ensureParentCategory(child);
            child.setConverter(EquipmentTemplateConverter.class);
            ListViewItem aItem = null;
            aItem = p != null ? p.getItem4Object(child) : this.theList.getItem4Object(child);
            if (aItem == null) {
                aItem = new ListViewItem(child, p, this.theList, 11, true, this.pegasus);
                if (p == null) {
                    this.equipmentSuperCat.addChild(aItem);
                } else {
                    p.addChild(aItem);
                }
            }
        }
        if (!this.isBlocked) {
            this.theList.updateOrder();
        }
    }

    public void childRemoved(Node parent, Node child) {
        ListViewItem item = this.theList.getItem4Object(child);
        if (item != null) {
            ListViewItem aParent = item.getParentItem();
            if (aParent != null) {
                aParent.removeChild(item);
                while (aParent.getType() > 3) {
                    if (aParent.getChilds().size() == 0) {
                        ListViewItem nP = aParent.getParentItem();
                        nP.removeChild(aParent);
                        aParent = nP;
                        continue;
                    }
                    aParent = aParent.getParentItem();
                }
            } else {
                this.theList.removeChild(item);
            }
            this.theList.layoutPanel(this.theList.getWidth(), this.theList.getHeight(), false);
        }
        if (this.theListenChilds.contains(child)) {
            this.theListenChilds.remove(child);
        }
        child.removeNodeListener((NodeListener)this);
    }

    @Override
    public boolean checkIfContains(Node node) {
        ListViewItem aItem = this.theList.getItem4Object(node);
        return aItem != null;
    }

    public void valueChanged(Node node) {
    }
}

