/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.tool.flight.rcdrawerbased.utils;

import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.SealTable;
import ch.icit.pegasus.client.gui.utils.popup.PopUpInsert;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.flightschedule.returnscount.ReturnsCountEquipmentComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.SealCheckE;
import ch.icit.pegasus.server.core.dtos.tracking.SealComplete;
import ch.icit.pegasus.server.core.dtos.tracking.SealTypeE;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.List;

public class SealRegisterPopup2
extends PopUpInsert {
    private static final long serialVersionUID = 1L;
    private SealTable table;
    private Node<ReturnsCountEquipmentComplete> returnsCountNode;
    private Node<List<SealComplete>> seals;

    public SealRegisterPopup2(Node<ReturnsCountEquipmentComplete> node) {
        this.returnsCountNode = node;
        this.seals = INodeCreator.getDefaultImpl().createNodes(((ReturnsCountEquipmentComplete)node.getValue()).getSeals(), false);
        int numberOfInboundSeals = ((ReturnsCountEquipmentComplete)node.getValue()).getEquipment().getEquipmentType().getNumberOfSeals();
        if (this.seals.getChildCount() != numberOfInboundSeals) {
            boolean first = true;
            while (this.seals.getChildCount() < numberOfInboundSeals) {
                SealComplete nSeal = new SealComplete();
                nSeal.setClientOId(Long.valueOf(ADTO.getNextId()));
                nSeal.setSequenceNumber(Integer.valueOf(this.seals.getChildCount()));
                nSeal.setPredefinedNumber(Integer.valueOf(0));
                nSeal.setSealNumber(Integer.valueOf(0));
                nSeal.setIdentifier(((ReturnsCountEquipmentComplete)node.getValue()).getEquipment().getPositionCode());
                if (first) {
                    nSeal.setIdentifier(nSeal.getIdentifier() + " " + "Front");
                    first = false;
                } else {
                    nSeal.setIdentifier(nSeal.getIdentifier() + " " + "Rear");
                }
                nSeal.setSealCheck(SealCheckE.PASSED);
                nSeal.setType(SealTypeE.INBOUND);
                Node seal = INodeCreator.getDefaultImpl().getNode4DTO((Object)nSeal, true, false);
                this.seals.addChild(seal, 0L);
            }
        }
        this.table = new SealTable(false, true, "Inbound Seals");
        this.table.setNode(this.seals);
        this.setLayout(new Layout());
        this.add(this.table);
    }

    @Override
    public boolean tryToGrabFocus() {
        return true;
    }

    @Override
    public List<Component> getFocusComponents() {
        return this.table.getFocusComponents();
    }

    @Override
    public boolean isClosableWithEnter() {
        return true;
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        if (isOK == PopupAction.CANCEL) {
            return null;
        }
        return new Object[1];
    }

    @Override
    public void popupClosed() {
        if (this.seals != null) {
            this.seals.commitThis();
            ((ReturnsCountEquipmentComplete)this.returnsCountNode.getValue()).setSeals((List)this.seals.getValue());
        }
        super.popupClosed();
    }

    @Override
    public boolean isInnerComponent(Component c) {
        return this.table.isInnerComponent(c);
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension(350, 200);
        }

        @Override
        public void layoutContainer(Container parent) {
            SealRegisterPopup2.this.table.setLocation(0, 0);
            SealRegisterPopup2.this.table.setSize(parent.getWidth(), parent.getHeight());
        }
    }
}

