/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.tool.flight.manualsales;

import ch.icit.pegasus.client.gui.submodules.tool.flight.rcdrawerbased.ReturnsCountDrawerBasedSubModule;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.ViewNode;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.flight.FlightServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.client.util.toolkits.StowingToolkit;
import ch.icit.pegasus.server.core.dtos.company.CostCenterComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightReference;
import ch.icit.pegasus.server.core.dtos.flightschedule.returnscount.ReturnsCountDeliverySpaceComplete_;
import ch.icit.pegasus.server.core.dtos.flightschedule.returnscount.ReturnsCountEquipmentComplete_;
import ch.icit.pegasus.server.core.dtos.flightschedule.returnscount.ReturnsCountFlightComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.returnscount.ReturnsCountParameterConfig;
import ch.icit.pegasus.server.core.dtos.flightschedule.returnscount.ReturnsCountProductComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.returnscount.ReturnsCountProductComplete_;
import ch.icit.pegasus.server.core.dtos.masterdata.QuantityComplete;
import ch.icit.pegasus.server.core.dtos.product.ProductComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.definition.SubModuleDefinitionComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.SubModuleAccessDefinition;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.FlightAccess;
import ch.icit.pegasus.server.core.dtos.supply.ProductCategoryLight;
import java.util.HashMap;
import java.util.Iterator;

public class ManualSalesSubModule
extends ReturnsCountDrawerBasedSubModule {
    private static final long serialVersionUID = 1L;
    private ViewNode n;

    @Override
    public ReturnsCountDrawerBasedSubModule.EditorType isManualSales() {
        return ReturnsCountDrawerBasedSubModule.EditorType.MANUAL_SALES;
    }

    @Override
    public SubModuleDefinitionComplete getSubModuleDefinition() {
        return FlightAccess.getSubModuleDefinition((SubModuleAccessDefinition)FlightAccess.TOOL_MANUAL_SALES);
    }

    @Override
    public ReturnsCountFlightComplete updateReturnsCountFlight(ReturnsCountFlightComplete r) throws ClientServerCallException {
        return (ReturnsCountFlightComplete)((FlightServiceManager)ServiceManagerRegistry.getService(FlightServiceManager.class)).updateManualSalesItem(r).getValue();
    }

    @Override
    public String getScreenTitle() {
        return FlightAccess.TOOL_MANUAL_SALES.getDisplayName();
    }

    @Override
    public ReturnsCountFlightComplete getReturnsCountFlight(Node<CostCenterComplete> cc) throws ClientServerCallException {
        return (ReturnsCountFlightComplete)((FlightServiceManager)ServiceManagerRegistry.getService(FlightServiceManager.class)).getManualSalesItems(new FlightReference(this.getFlight().getId()), new ReturnsCountParameterConfig(cc != null ? (CostCenterComplete)cc.getValue() : null, this.getFlight().getUpliftCount())).getValue();
    }

    @Override
    public void updateProductsBeforeSaving() {
        this.flightNode.commit();
        Iterator it = this.n.getFailSafeChildIterator();
        while (it.hasNext()) {
            Node c1n = (Node)it.next();
            Iterator it3 = c1n.getFailSafeChildIterator();
            while (it3.hasNext()) {
                Node cn = (Node)it3.next();
                int complementarySalesAmount = (Integer)cn.getChildNamed(ReturnsCountProductComplete_.complementarySalesAmount).getValue();
                int crewSalesAmount = (Integer)cn.getChildNamed(ReturnsCountProductComplete_.crewSalesAmount).getValue();
                int discountAmount = (Integer)cn.getChildNamed(ReturnsCountProductComplete_.discountAmount).getValue();
                int machineSalesAmount = (Integer)cn.getChildNamed(ReturnsCountProductComplete_.machineSalesAmount).getValue();
                Iterator it2 = cn.getChildNamed(new String[]{"affectedThings"}).getFailSafeChildIterator();
                while (it2.hasNext()) {
                    Node rc = (Node)it2.next();
                    int load = ((ReturnsCountProductComplete)rc.getValue()).getUseRevisedDeliveredAmount() != false ? ((ReturnsCountProductComplete)rc.getValue()).getRevisedDeliveredAmount() : ((ReturnsCountProductComplete)rc.getValue()).getCalculatedDeliveredAmount();
                    int sales = (int)(((double)load + 0.5) * (double)((ReturnsCountProductComplete)rc.getValue()).getConversionFactor().intValue());
                    int use = Math.min(sales, machineSalesAmount);
                    ((ReturnsCountProductComplete)rc.getValue()).setMachineSalesAmount(Integer.valueOf(use));
                    machineSalesAmount -= use;
                    use = Math.min(sales, discountAmount);
                    sales -= use;
                    discountAmount -= use;
                    ((ReturnsCountProductComplete)rc.getValue()).setDiscountAmount(Integer.valueOf(use));
                    use = Math.min(sales, complementarySalesAmount);
                    sales -= use;
                    complementarySalesAmount -= use;
                    ((ReturnsCountProductComplete)rc.getValue()).setComplementarySalesAmount(Integer.valueOf(use));
                    use = Math.min(sales, crewSalesAmount);
                    sales -= use;
                    crewSalesAmount -= use;
                    ((ReturnsCountProductComplete)rc.getValue()).setCrewSalesAmount(Integer.valueOf(use));
                }
            }
        }
    }

    @Override
    public void doSaveDocument() {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                ReturnsCountFlightComplete r = (ReturnsCountFlightComplete)ManualSalesSubModule.this.flightNode.getValue();
                if (r.getEquipments().isEmpty()) {
                    ViewNode rt = new ViewNode("Error");
                    rt.setValue((Object)new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "No Equipments found in current Flight."), 0L);
                    return rt;
                }
                boolean updateSeals = false;
                switch (ManualSalesSubModule.this.getFlight().getFlightState()) {
                    case CANCELLED: 
                    case CLOSED: 
                    case DISPATCHED: {
                        updateSeals = true;
                        break;
                    }
                    case EN_ROUTE: 
                    case OPEN: 
                    case PLANNED: {
                        updateSeals = false;
                        break;
                    }
                }
                if (updateSeals) {
                    StowingToolkit.ensureSeals((ReturnsCountFlightComplete)r);
                }
                ManualSalesSubModule.this.currentFlight = ManualSalesSubModule.this.updateReturnsCountFlight(r);
                return null;
            }

            @Override
            public RemoteLoader getInvoker() {
                return ManualSalesSubModule.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public Node createView(Node node) {
        this.n = new ViewNode("");
        ViewNode all = new ViewNode("");
        this.n.addChild((Node)all, 0L);
        HashMap<ProductCategoryLight, ViewNode> cats = new HashMap<ProductCategoryLight, ViewNode>();
        HashMap<ProductComplete, Node> productsMap = new HashMap<ProductComplete, Node>();
        Iterator it = node.getFailSafeChildIterator();
        while (it.hasNext()) {
            Node nn = (Node)it.next();
            Iterator it2 = nn.getChildNamed(ReturnsCountEquipmentComplete_.deliverySpaces).getFailSafeChildIterator();
            while (it2.hasNext()) {
                Node d = (Node)it2.next();
                Iterator it3 = d.getChildNamed(ReturnsCountDeliverySpaceComplete_.products).getFailSafeChildIterator();
                while (it3.hasNext()) {
                    Node r;
                    Node p = (Node)it3.next();
                    ViewNode n2 = (ViewNode)cats.get(((ReturnsCountProductComplete)p.getValue()).getProduct().getCurrentVariant().getCategory());
                    if (n2 == null) {
                        n2 = new ViewNode("");
                        n2.setValue((Object)((ReturnsCountProductComplete)p.getValue()).getProduct().getCurrentVariant().getCategory(), 0L);
                        cats.put(((ReturnsCountProductComplete)p.getValue()).getProduct().getCurrentVariant().getCategory(), n2);
                        this.n.addChild((Node)n2, 0L);
                    }
                    if ((r = (Node)productsMap.get(((ReturnsCountProductComplete)p.getValue()).getProduct())) == null) {
                        r = new Node();
                        ReturnsCountProductComplete prod = new ReturnsCountProductComplete();
                        prod.setCrewPrice(((ReturnsCountProductComplete)p.getValue()).getCrewPrice());
                        prod.setArticle(((ReturnsCountProductComplete)p.getValue()).getArticle());
                        prod.setArticleQuantity(new QuantityComplete(((ReturnsCountProductComplete)p.getValue()).getArticleQuantity()));
                        prod.setConversionFactor(((ReturnsCountProductComplete)p.getValue()).getConversionFactor());
                        prod.setDeliverySpace(((ReturnsCountProductComplete)p.getValue()).getDeliverySpace());
                        prod.setProduct(((ReturnsCountProductComplete)p.getValue()).getProduct());
                        r.setValue((Object)prod, 0L);
                        ViewNode allAffectedThings = new ViewNode("affectedThings");
                        r.addChild((Node)allAffectedThings, 0L);
                        productsMap.put(((ReturnsCountProductComplete)p.getValue()).getProduct(), r);
                    }
                    ((ReturnsCountProductComplete)r.getValue()).setCalculatedDeliveredAmount(Integer.valueOf(((ReturnsCountProductComplete)r.getValue()).getCalculatedDeliveredAmount() + ((ReturnsCountProductComplete)p.getValue()).getCalculatedDeliveredAmount()));
                    ((ReturnsCountProductComplete)r.getValue()).setComplementarySalesAmount(Integer.valueOf(((ReturnsCountProductComplete)r.getValue()).getComplementarySalesAmount() + ((ReturnsCountProductComplete)p.getValue()).getComplementarySalesAmount()));
                    ((ReturnsCountProductComplete)r.getValue()).setCountedAmount(Integer.valueOf(((ReturnsCountProductComplete)r.getValue()).getCountedAmount() + ((ReturnsCountProductComplete)p.getValue()).getCountedAmount()));
                    ((ReturnsCountProductComplete)r.getValue()).setCrewSalesAmount(Integer.valueOf(((ReturnsCountProductComplete)r.getValue()).getCrewSalesAmount() + ((ReturnsCountProductComplete)p.getValue()).getCrewSalesAmount()));
                    ((ReturnsCountProductComplete)r.getValue()).setDiscountAmount(Integer.valueOf(((ReturnsCountProductComplete)r.getValue()).getDiscountAmount() + ((ReturnsCountProductComplete)p.getValue()).getDiscountAmount()));
                    ((ReturnsCountProductComplete)r.getValue()).setMachineSalesAmount(Integer.valueOf(((ReturnsCountProductComplete)r.getValue()).getMachineSalesAmount() + ((ReturnsCountProductComplete)p.getValue()).getMachineSalesAmount()));
                    ((ReturnsCountProductComplete)r.getValue()).setMachineSoldAmount(Integer.valueOf(((ReturnsCountProductComplete)r.getValue()).getMachineSoldAmount() + ((ReturnsCountProductComplete)p.getValue()).getMachineSoldAmount()));
                    ((ReturnsCountProductComplete)r.getValue()).setMissingAmount(Integer.valueOf(((ReturnsCountProductComplete)r.getValue()).getMissingAmount() + ((ReturnsCountProductComplete)p.getValue()).getMissingAmount()));
                    ((ReturnsCountProductComplete)r.getValue()).setRevisedDeliveredAmount(Integer.valueOf(((ReturnsCountProductComplete)r.getValue()).getRevisedDeliveredAmount() + ((ReturnsCountProductComplete)p.getValue()).getRevisedDeliveredAmount()));
                    ((ReturnsCountProductComplete)r.getValue()).setSoldAmount(Integer.valueOf(((ReturnsCountProductComplete)r.getValue()).getSoldAmount() + ((ReturnsCountProductComplete)p.getValue()).getSoldAmount()));
                    ((ReturnsCountProductComplete)r.getValue()).setWasteAmount(Integer.valueOf(((ReturnsCountProductComplete)r.getValue()).getWasteAmount() + ((ReturnsCountProductComplete)p.getValue()).getWasteAmount()));
                    ViewNode allAffectedThings = (ViewNode)r.getChildNamed(new String[]{"affectedThings"});
                    Node pr = INodeCreator.getDefaultImpl().getNode4DTO(p.getValue(), false, true);
                    allAffectedThings.addChild(pr, 0L);
                    all.addChild(r, 0L);
                    n2.addChild(r, 0L);
                }
            }
        }
        return this.n;
    }
}

