/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.print.stowinglist.usage;

import ch.icit.pegasus.client.converter.FlightScheduleDetailedConverter;
import ch.icit.pegasus.client.converter.IntegerConverter;
import ch.icit.pegasus.client.converter.PeriodConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2Model;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.DeleteButton;
import ch.icit.pegasus.client.gui.utils.datechooser.DateChooser;
import ch.icit.pegasus.client.gui.utils.datechooser.DateChooserListener;
import ch.icit.pegasus.client.gui.utils.icons.ToogleSkinIcon;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.popup.inserts.DefaultScrollablePrintPopupInsert;
import ch.icit.pegasus.client.gui.utils.print.APrintConfigurationComplete;
import ch.icit.pegasus.client.gui.utils.print.PrintPopupToolkit;
import ch.icit.pegasus.client.gui.utils.skins.SizedSkin1Field;
import ch.icit.pegasus.client.gui.utils.skins.impls.defaults.DefaultSkins;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.ViewNode;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.flight.StowingListServiceManager;
import ch.icit.pegasus.client.services.interfaces.search.SearchServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.SearchException;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightScheduleLight_;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListTemplateComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListTemplateComplete_;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListTemplateReference;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListTemplateVariantLight_;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.search.ADtoSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.search.FlightScheduleSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.util.SearchResult;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.DateWrapper;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.ListWrapper;
import ch.icit.pegasus.server.core.dtos.utils.DateUtil;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class PrintStowingUsageComponent
extends DefaultScrollablePrintPopupInsert
implements DateChooserListener {
    private static final long serialVersionUID = 1L;
    private final Node<StowingListTemplateComplete> currentStowing;
    private TitledItem<Table2> table;
    private boolean isLoadingRemains = false;
    private TitledItem<DateChooser> afterDate;

    public PrintStowingUsageComponent(Node<StowingListTemplateComplete> currentNode) {
        super(true, false);
        this.currentStowing = currentNode;
        this.getViewContainer().setLayout(new Layout());
    }

    @Override
    public APrintConfigurationComplete<?> getPrintConfiguration() {
        return null;
    }

    private void loadItems() {
        this.createComponents();
        this.isLoadingRemains = true;
        this.popup.enableOKButton(false);
        this.popup.enableCancelButton(false);
        this.removeInheritedComponents();
        this.ensureAnimation(Words.LOAD_DATA);
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                StowingListTemplateComplete stowing = (StowingListTemplateComplete)PrintStowingUsageComponent.this.currentStowing.getValue();
                Date afterDateValue = new Date(PrintStowingUsageComponent.this.afterDate != null ? ((DateChooser)PrintStowingUsageComponent.this.afterDate.getElement()).getSelectedDate().getTime() : System.currentTimeMillis());
                FlightScheduleSearchConfiguration configuration = new FlightScheduleSearchConfiguration();
                configuration.setStowingList((StowingListTemplateReference)stowing);
                configuration.setFlightPeriod(new PeriodComplete(afterDateValue, DateUtil.getSQLInfinityDate()));
                configuration.setNumResults(Integer.MAX_VALUE);
                SearchResult r = ((SearchServiceManager)ServiceManagerRegistry.getService(SearchServiceManager.class)).search((ADtoSearchConfiguration)configuration);
                ViewNode nn = new ViewNode("");
                Node p1 = INodeCreator.getDefaultImpl().createNodes(r.getResults(), false);
                Iterator it = p1.getChilds();
                while (it.hasNext()) {
                    Node next = (Node)it.next();
                    nn.addChild(next, 0L);
                }
                return nn;
            }

            @Override
            public RemoteLoader getInvoker() {
                return PrintStowingUsageComponent.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public void setInnerPopUp(InnerPopUp2 ip) {
        super.setInnerPopUp(ip);
        this.loadItems();
    }

    public void remoteObjectLoaded(Node node) {
        if (this.isLoadingRemains) {
            if (node.getValue() == null) {
                this.popup.enableCancelButton(true);
                if (this.errorMSG == null) {
                    this.removeAnimation(false);
                    if (this.table == null) {
                        this.createInners();
                    }
                    this.table.getElement().getModel().setNode(node);
                    this.createComponents();
                    this.afterDate.setVisible(true);
                    this.table.setVisible(true);
                    this.popup.enableCancelButton(true);
                } else {
                    this.removeAnimation(true);
                }
            } else {
                ArrayList<ScreenValidationObject> rets = new ArrayList<ScreenValidationObject>();
                for (SearchException e : (List)node.getValue()) {
                    rets.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, e.getMessage()));
                }
                this.isError = true;
                this.errorMSG = ScreenValidationObject.createMessageString(rets, (String)"Unable to load Product usage:");
                this.removeAnimation(true);
            }
            this.isLoadingRemains = false;
        } else {
            super.remoteObjectLoaded(node);
        }
    }

    @Override
    public void removeInheritedComponents() {
        super.removeInheritedComponents();
        if (this.table != null) {
            this.table.setVisible(false);
        }
        if (this.afterDate != null) {
            this.afterDate.setVisible(false);
        }
    }

    private void createInners() {
        this.table = new TitledItem<Table2>(new Table2(false, null, true, false), "Stowing List used from given date", TitledItem.TitledItemOrientation.NORTH);
        this.table.setIgnorePrefHeight(true);
        this.table.getElement().setRequestFocusOnAdd(true);
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        columns.add(new TableColumnInfo(Words.NO_NUMBER, null, null, null, "", TableColumnInfo.numberColumnWidth, TableColumnInfo.numberColumnWidth, TableColumnInfo.numberColumnWidth));
        columns.add(new TableColumnInfo(Words.NAME, null, null, null, "", 80, 80, 80));
        columns.add(new TableColumnInfo(Words.PERIOD, null, null, null, "", TableColumnInfo.periodColumnWidth));
        columns.add(new TableColumnInfo(Words.DELETED, null, null, null, "", DeleteButton.getPreferredWidth(SizedSkin1Field.SkinSize.SMALL) + 2 * this.table.getElement().getCellPadding()));
        ((TableColumnInfo)columns.get(0)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(1)).setxExpand(1.0);
        ((TableColumnInfo)columns.get(2)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(3)).setxExpand(0.0);
        this.table.getElement().setModel(new Table2Model(columns, model -> new TableRowImpl(model)));
        this.table.setProgress(1.0f);
        this.afterDate = new TitledItem<DateChooser>(new DateChooser(INodeCreator.getDefaultImpl().getNode4DTO((Object)new Date(System.currentTimeMillis()), false, false)), Words.FROM, TitledItem.TitledItemOrientation.NORTH);
        this.afterDate.getElement().setIsTimestamp(false);
        this.afterDate.getElement().addDateChooserListener(this);
        this.getViewContainer().add(this.table);
        this.getViewContainer().add(this.afterDate);
    }

    @Override
    public String getTitleString() {
        return Words.STOWING_LIST;
    }

    @Override
    protected String getProgressText() {
        if (this.isLoadingRemains) {
            return Words.LOAD_DATA;
        }
        return Words.PRINT;
    }

    @Override
    public void dateChanged(DateChooser source, java.util.Date selectedDate) {
        this.loadItems();
    }

    @Override
    public String getTitleValue() {
        return (String)this.currentStowing.getChildNamed(new DtoField[]{StowingListTemplateComplete_.currentVariant, StowingListTemplateVariantLight_.name}).getValue();
    }

    @Override
    public boolean withSecondSeparator() {
        return true;
    }

    @Override
    protected void startPrinting() {
        super.startPrinting();
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                Date dueDate = (Date)((DateChooser)PrintStowingUsageComponent.this.afterDate.getElement()).getNode().getValue();
                PegasusFileComplete file = (PegasusFileComplete)((StowingListServiceManager)ServiceManagerRegistry.getService(StowingListServiceManager.class)).printStowingTemplateUsage(new ListWrapper(Collections.singletonList(PrintStowingUsageComponent.this.currentStowing.getValue())), new DateWrapper(dueDate)).getValue();
                PrintPopupToolkit.previewFile(file);
                return new ViewNode("");
            }

            @Override
            public RemoteLoader getInvoker() {
                return PrintStowingUsageComponent.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        return new Object[0];
    }

    @Override
    public boolean isClosableWithEnter() {
        return true;
    }

    @Override
    public boolean isInnerComponent(Component c) {
        return super.isInnerComponent(c);
    }

    private class TableRowImpl
    extends Table2RowPanel {
        private static final long serialVersionUID = 1L;
        private TextLabel number;
        private TextLabel name;
        private TextLabel period;
        private ToogleSkinIcon skin;

        public TableRowImpl(Table2RowModel m) {
            super(m);
            boolean deleted = false;
            this.number = new TextLabel(m.getNode().getChildNamed(FlightScheduleLight_.number), ConverterRegistry.getConverter(IntegerConverter.class));
            this.name = new TextLabel(m.getNode(), ConverterRegistry.getConverter(FlightScheduleDetailedConverter.class));
            this.period = new TextLabel(m.getNode().getChildNamed(FlightScheduleLight_.period), ConverterRegistry.getConverter(PeriodConverter.class));
            this.skin = new ToogleSkinIcon(DefaultSkins.CheckCrossBoxIcon, !deleted);
            this.number.setProgress(1.0f);
            this.name.setProgress(1.0f);
            this.skin.setProgress(1.0f);
            this.period.setProgress(1.0f);
            this.setLayout(new Layout());
            this.add(this.period);
            this.add(this.number);
            this.add(this.name);
            this.add(this.skin);
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.period.kill();
            this.number.kill();
            this.name.kill();
            this.skin.kill();
            this.period = null;
            this.number = null;
            this.name = null;
            this.skin = null;
        }

        @Override
        public List<Component> getFocusComponents() {
            return null;
        }

        @Override
        public Object getObject4Column(int column) {
            switch (column) {
                case 0: {
                    return this.number.getText();
                }
                case 1: {
                    return this.name.getText();
                }
                case 2: {
                    return this.period.getText();
                }
                case 3: {
                    return null;
                }
            }
            return null;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            this.period.setEnabled(isEnabled);
            this.number.setEnabled(isEnabled);
            this.name.setEnabled(isEnabled);
            this.skin.setEnabled(isEnabled);
        }

        private class Layout
        extends DefaultLayout {
            private Layout() {
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TableRowImpl.this.getDefaultRowHeight());
            }

            @Override
            public void layoutContainer(Container parent) {
                int currentX = 0;
                int w = TableRowImpl.this.model.getParentModel().getColumnWidth(0);
                TableRowImpl.this.number.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.number.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.number.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.number.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(1);
                TableRowImpl.this.name.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.name.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.name.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.name.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(2);
                TableRowImpl.this.period.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.period.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.period.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.period.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(3);
                TableRowImpl.this.skin.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.skin.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.skin.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.skin.getPreferredSize().getHeight());
            }
        }
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int cy = PrintStowingUsageComponent.this.layoutInheritedComponents(parent);
            cy += PrintStowingUsageComponent.this.border;
            if (PrintStowingUsageComponent.this.afterDate != null) {
                PrintStowingUsageComponent.this.afterDate.setLocation(PrintStowingUsageComponent.this.border, cy);
                PrintStowingUsageComponent.this.afterDate.setSize(PrintStowingUsageComponent.this.afterDate.getPreferredSize());
                cy = PrintStowingUsageComponent.this.afterDate.getY() + PrintStowingUsageComponent.this.afterDate.getHeight() + PrintStowingUsageComponent.this.border;
            }
            if (PrintStowingUsageComponent.this.table != null) {
                PrintStowingUsageComponent.this.table.setLocation(PrintStowingUsageComponent.this.border, cy);
                PrintStowingUsageComponent.this.table.setSize(parent.getWidth() - 2 * PrintStowingUsageComponent.this.border, parent.getHeight() - (cy + PrintStowingUsageComponent.this.border));
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = PrintStowingUsageComponent.this.getInheritedComponentsHeight() + PrintStowingUsageComponent.this.border;
            return new Dimension(0, h);
        }
    }
}

