/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.print.productcatalog.usage;

import ch.icit.pegasus.client.converter.IntegerConverter;
import ch.icit.pegasus.client.converter.PeriodConverter;
import ch.icit.pegasus.client.converter.StringConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2Model;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.DeleteButton;
import ch.icit.pegasus.client.gui.utils.datechooser.DateChooser;
import ch.icit.pegasus.client.gui.utils.datechooser.DateChooserListener;
import ch.icit.pegasus.client.gui.utils.icons.ToogleSkinIcon;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.popup.inserts.DefaultScrollablePrintPopupInsert;
import ch.icit.pegasus.client.gui.utils.print.APrintConfigurationComplete;
import ch.icit.pegasus.client.gui.utils.print.PrintPopupToolkit;
import ch.icit.pegasus.client.gui.utils.skins.SizedSkin1Field;
import ch.icit.pegasus.client.gui.utils.skins.impls.defaults.DefaultSkins;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.ViewNode;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.search.SearchServiceManager;
import ch.icit.pegasus.client.services.interfaces.supply.SupplyReportServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.SearchException;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.MealPlanLight;
import ch.icit.pegasus.server.core.dtos.mealplan.MealPlanLight_;
import ch.icit.pegasus.server.core.dtos.product.ProductCatalogLight;
import ch.icit.pegasus.server.core.dtos.product.ProductCatalogLight_;
import ch.icit.pegasus.server.core.dtos.product.ProductCatalogReference;
import ch.icit.pegasus.server.core.dtos.report.ReportingOutputFormatE;
import ch.icit.pegasus.server.core.dtos.search.ADtoSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.search.MealPlanSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.util.SearchResult;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.DateWrapper;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class PrintProductCatalogUsageComponent
extends DefaultScrollablePrintPopupInsert
implements DateChooserListener {
    private static final long serialVersionUID = 1L;
    private final Node<ProductCatalogLight> currentProduct;
    private TitledItem<DateChooser> dateChooser;
    private TitledItem<Table2> table;
    private boolean isLoadingRemains = false;

    public PrintProductCatalogUsageComponent(Node<ProductCatalogLight> currentNode) {
        super(true, false);
        this.currentProduct = currentNode;
        this.getViewContainer().setLayout(new Layout());
    }

    @Override
    public APrintConfigurationComplete<?> getPrintConfiguration() {
        return null;
    }

    @Override
    public void setInnerPopUp(InnerPopUp2 ip) {
        super.setInnerPopUp(ip);
        this.createComponents();
        this.loadItems();
    }

    private void loadItems() {
        this.isLoadingRemains = true;
        this.popup.enableOKButton(false);
        this.popup.enableCancelButton(false);
        this.removeInheritedComponents();
        this.ensureAnimation(Words.LOAD_DATA);
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                ProductCatalogReference catalog = (ProductCatalogReference)PrintProductCatalogUsageComponent.this.currentProduct.getValue();
                MealPlanSearchConfiguration ms = new MealPlanSearchConfiguration();
                ms.setProductCatalog(catalog);
                ms.setNumResults(Integer.MAX_VALUE);
                Timestamp date = new Timestamp(PrintProductCatalogUsageComponent.this.dateChooser != null ? ((Date)((DateChooser)PrintProductCatalogUsageComponent.this.dateChooser.getElement()).getNode().getValue()).getTime() : System.currentTimeMillis());
                ms.setPeriod(new PeriodComplete(new Date(date.getTime()), new Date(date.getTime())));
                SearchResult r2 = ((SearchServiceManager)ServiceManagerRegistry.getService(SearchServiceManager.class)).search((ADtoSearchConfiguration)ms);
                ViewNode nn = new ViewNode("");
                Node p2 = INodeCreator.getDefaultImpl().createNodes(r2.getResults(), false);
                Iterator it = p2.getChilds();
                while (it.hasNext()) {
                    Node next = (Node)it.next();
                    nn.addChild(next, 0L);
                }
                return nn;
            }

            @Override
            public RemoteLoader getInvoker() {
                return PrintProductCatalogUsageComponent.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public void dateChanged(DateChooser source, java.util.Date selectedDate) {
        this.loadItems();
    }

    public void remoteObjectLoaded(Node node) {
        if (this.isLoadingRemains) {
            if (node.getValue() == null) {
                this.popup.enableCancelButton(true);
                if (this.errorMSG == null) {
                    this.removeAnimation(false);
                    if (this.table == null) {
                        this.createInners();
                    }
                    this.dateChooser.setVisible(true);
                    this.table.getElement().getModel().setNode(node);
                    this.createComponents();
                    this.popup.enableCancelButton(true);
                } else {
                    this.removeAnimation(true);
                }
            } else {
                ArrayList<ScreenValidationObject> rets = new ArrayList<ScreenValidationObject>();
                for (SearchException e : (List)node.getValue()) {
                    rets.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, e.getMessage()));
                }
                this.isError = true;
                this.errorMSG = ScreenValidationObject.createMessageString(rets, (String)"Unable to load Product Catalog usage:");
                this.removeAnimation(true);
            }
            this.isLoadingRemains = false;
        } else {
            super.remoteObjectLoaded(node);
        }
    }

    @Override
    public void removeInheritedComponents() {
        super.removeInheritedComponents();
        if (this.table != null) {
            this.table.setVisible(false);
        }
        if (this.dateChooser != null) {
            this.dateChooser.setVisible(false);
        }
    }

    private void createInners() {
        this.table = new TitledItem<Table2>(new Table2(false, null, true, false), "ALL MEAL PLANS", TitledItem.TitledItemOrientation.NORTH);
        this.table.setIgnorePrefHeight(true);
        this.table.getElement().setRequestFocusOnAdd(true);
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        columns.add(new TableColumnInfo(Words.NO_NUMBER, null, null, null, "", TableColumnInfo.numberColumnWidth + 2 * this.table.getElement().getCellPadding()));
        columns.add(new TableColumnInfo(Words.NAME, null, null, null, "", 80, 80, 80));
        columns.add(new TableColumnInfo(Words.VALIDITY, null, null, null, "", TableColumnInfo.periodColumnWidth + 2 * this.table.getElement().getCellPadding()));
        columns.add(new TableColumnInfo(Words.DELETED, null, null, null, "", DeleteButton.getPreferredWidth(SizedSkin1Field.SkinSize.SMALL) + 2 * this.table.getElement().getCellPadding()));
        ((TableColumnInfo)columns.get(0)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(1)).setxExpand(1.0);
        ((TableColumnInfo)columns.get(2)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(3)).setxExpand(0.0);
        this.table.getElement().setModel(new Table2Model(columns, model -> new TableRowImpl(model)));
        this.table.setProgress(1.0f);
        this.dateChooser = new TitledItem<DateChooser>(new DateChooser(INodeCreator.getDefaultImpl().getNode4DTO((Object)new Date(System.currentTimeMillis()), false, false)), Words.DUE_DATE, TitledItem.TitledItemOrientation.NORTH);
        this.dateChooser.getElement().setIsTimestamp(false);
        this.dateChooser.getElement().addDateChooserListener(this);
        this.getViewContainer().add(this.table);
        this.getViewContainer().add(this.dateChooser);
    }

    @Override
    public String getTitleString() {
        return Words.PRODUCT_NAME;
    }

    @Override
    protected String getProgressText() {
        if (this.isLoadingRemains) {
            return "Load Product Catalog usage";
        }
        return "Print Product Catalog usage";
    }

    @Override
    public String getTitleValue() {
        return (String)this.currentProduct.getChildNamed(ProductCatalogLight_.title).getValue();
    }

    @Override
    public boolean withSecondSeparator() {
        return true;
    }

    @Override
    protected void startPrinting() {
        super.startPrinting();
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                Date dueDate = (Date)((DateChooser)PrintProductCatalogUsageComponent.this.dateChooser.getElement()).getNode().getValue();
                PegasusFileComplete file = (PegasusFileComplete)((SupplyReportServiceManager)ServiceManagerRegistry.getService(SupplyReportServiceManager.class)).printProductCatalogUsage(new ProductCatalogReference(((ProductCatalogLight)PrintProductCatalogUsageComponent.this.currentProduct.getValue()).getId()), new DateWrapper(dueDate), ReportingOutputFormatE.XLSX).getValue();
                PrintPopupToolkit.previewFile(file);
                return new ViewNode("");
            }

            @Override
            public RemoteLoader getInvoker() {
                return PrintProductCatalogUsageComponent.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        return new Object[0];
    }

    @Override
    public boolean isClosableWithEnter() {
        return true;
    }

    @Override
    public boolean isInnerComponent(Component c) {
        return super.isInnerComponent(c);
    }

    private class TableRowImpl
    extends Table2RowPanel {
        private static final long serialVersionUID = 1L;
        private TextLabel number;
        private TextLabel name;
        private TextLabel validity;
        private ToogleSkinIcon skin;

        public TableRowImpl(Table2RowModel m) {
            super(m);
            boolean deleted = false;
            if (m.getNode().getValue() instanceof MealPlanLight) {
                this.name = new TextLabel(m.getNode().getChildNamed(MealPlanLight_.name), ConverterRegistry.getConverter(StringConverter.class));
                this.number = new TextLabel(m.getNode().getChildNamed(MealPlanLight_.number), ConverterRegistry.getConverter(IntegerConverter.class));
                this.validity = new TextLabel(m.getNode().getChildNamed(MealPlanLight_.period), ConverterRegistry.getConverter(PeriodConverter.class));
                deleted = ((MealPlanLight)m.getNode().getValue()).getIsDeleted();
            }
            this.skin = new ToogleSkinIcon(DefaultSkins.CheckCrossBoxIcon, !deleted);
            this.validity.setProgress(1.0f);
            this.number.setProgress(1.0f);
            this.name.setProgress(1.0f);
            this.skin.setProgress(1.0f);
            this.setLayout(new Layout());
            this.add(this.validity);
            this.add(this.number);
            this.add(this.name);
            this.add(this.skin);
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.validity.kill();
            this.number.kill();
            this.name.kill();
            this.skin.kill();
            this.validity = null;
            this.number = null;
            this.name = null;
            this.skin = null;
        }

        @Override
        public List<Component> getFocusComponents() {
            return null;
        }

        @Override
        public Object getObject4Column(int column) {
            switch (column) {
                case 0: {
                    return this.validity.getText();
                }
                case 1: {
                    if (this.model.getNode().getValue() instanceof MealPlanLight) {
                        return this.model.getNode().getChildNamed(MealPlanLight_.number);
                    }
                }
                case 2: {
                    if (this.model.getNode().getValue() instanceof MealPlanLight) {
                        return this.model.getNode().getChildNamed(MealPlanLight_.name);
                    }
                }
                case 3: {
                    return null;
                }
            }
            return null;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            this.validity.setEnabled(isEnabled);
            this.number.setEnabled(isEnabled);
            this.name.setEnabled(isEnabled);
            this.skin.setEnabled(isEnabled);
        }

        private class Layout
        extends DefaultLayout {
            private Layout() {
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TableRowImpl.this.getDefaultRowHeight());
            }

            @Override
            public void layoutContainer(Container parent) {
                int currentX = 0;
                int w = TableRowImpl.this.model.getParentModel().getColumnWidth(0);
                TableRowImpl.this.number.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.number.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.number.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.number.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(1);
                TableRowImpl.this.name.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.name.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.name.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.name.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(2);
                TableRowImpl.this.validity.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.validity.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.validity.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.validity.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(3);
                TableRowImpl.this.skin.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.skin.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.skin.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.skin.getPreferredSize().getHeight());
            }
        }
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int cy = PrintProductCatalogUsageComponent.this.layoutInheritedComponents(parent);
            cy += PrintProductCatalogUsageComponent.this.border;
            if (PrintProductCatalogUsageComponent.this.dateChooser != null) {
                PrintProductCatalogUsageComponent.this.dateChooser.setLocation(PrintProductCatalogUsageComponent.this.border, cy);
                PrintProductCatalogUsageComponent.this.dateChooser.setSize(PrintProductCatalogUsageComponent.this.dateChooser.getPreferredSize());
                cy = PrintProductCatalogUsageComponent.this.dateChooser.getY() + PrintProductCatalogUsageComponent.this.dateChooser.getHeight() + PrintProductCatalogUsageComponent.this.border;
            }
            if (PrintProductCatalogUsageComponent.this.table != null) {
                PrintProductCatalogUsageComponent.this.table.setLocation(PrintProductCatalogUsageComponent.this.border, cy);
                PrintProductCatalogUsageComponent.this.table.setSize(parent.getWidth() - 2 * PrintProductCatalogUsageComponent.this.border, parent.getHeight() - (cy + PrintProductCatalogUsageComponent.this.border));
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = PrintProductCatalogUsageComponent.this.getInheritedComponentsHeight() + PrintProductCatalogUsageComponent.this.border;
            return new Dimension(0, h);
        }
    }
}

