/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.print.productcatalog.factsheet.excel;

import ch.icit.pegasus.client.gui.batch.BatchJob;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.HorizontalSeparator;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.datechooser.DateChooser;
import ch.icit.pegasus.client.gui.utils.filterchain.FilterChainConfiguration;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.print.DefaultScrollablePrintPopup2;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.report.ProductReportServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.HUDToolkit;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.server.core.dtos.auth.UserComplete;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.product.ProductCatalogLight;
import ch.icit.pegasus.server.core.dtos.product.ProductCatalogLight_;
import ch.icit.pegasus.server.core.dtos.product.ProductCatalogReference;
import ch.icit.pegasus.server.core.dtos.report.ProductFactSheetReportConfiguration;
import ch.icit.pegasus.server.core.dtos.report.ProductFactSheetsReportConfiguration;
import ch.icit.pegasus.server.core.dtos.rightmanagement.access.DataFieldAccessRightComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.access.ModuleAccessRightComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.ProductCatalogAccess;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.ListWrapper;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.i18n.WordsToolkit;
import ch.icit.pegasus.server.dtos.IDTO;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExportProductCatalogProductFactSheetComponent
extends DefaultScrollablePrintPopup2<ProductCatalogLight>
implements ButtonListener {
    private static final long serialVersionUID = 1L;
    private static Logger log = LoggerFactory.getLogger(ExportProductCatalogProductFactSheetComponent.class);
    private final Node<ProductCatalogLight> currentProduct;
    private final Node configNode;
    private TitledItem<DateChooser> dueDate;
    private HorizontalSeparator sep1;
    private TextLabel printOptionTitle;
    private TitledItem<CheckBox> includeManMinutes;
    private TitledItem<CheckBox> includeProductMM;
    private TitledItem<CheckBox> includeGroupMM;
    private TitledItem<CheckBox> includeComponentMM;
    private TitledItem<CheckBox> includeCosts;
    private TitledItem<CheckBox> includeMealPlanAndStowingListData;
    private TitledItem<ComboBox> includeTender;
    private TitledItem<CheckBox> resolveRecipesToArticles;
    private TitledItem<CheckBox> splitCostCenters;
    private boolean showProductionCosts = false;
    private boolean printExternalCostFactSheet = false;

    public ExportProductCatalogProductFactSheetComponent(Node<ProductCatalogLight> node) {
        super(false, false, false, null);
        this.currentProduct = node;
        Runnable r = () -> {
            UserComplete user = ((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentUser();
            ModuleAccessRightComplete r1 = HUDToolkit.getCurrentAccessRight(ProductCatalogAccess.MODULE_PRODUCT_CATALOG, user);
            for (DataFieldAccessRightComplete a : r1.getFieldAccessRights()) {
                if (a.getField().getName().equals(ProductCatalogAccess.SHOW_PRODUCTION_COSTS.getName())) {
                    this.showProductionCosts = true;
                    continue;
                }
                if (!a.getField().getName().equals(ProductCatalogAccess.PRINT_EXTERNAL_COST_FACT_SHEET.getName())) continue;
                this.printExternalCostFactSheet = true;
            }
        };
        this.loadBeforeShowing(r);
        ProductFactSheetReportConfiguration config = new ProductFactSheetReportConfiguration(null);
        config.setDueDate(new Timestamp(System.currentTimeMillis()));
        this.configNode = INodeCreator.getDefaultImpl().getNode4DTO((Object)config, false, false);
    }

    @Override
    public void insertElements() {
        this.getViewContainer().setLayout(new Layout());
        this.createComponents();
        Font f = AttributesConverter.getFont4String(LafLoader.getLafLoader().getAttribute("default_font"), LafLoader.getLafLoader().getAttribute("default_font_size"), LafLoader.getLafLoader().getAttribute("default_font_type"));
        Color fb = AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("default_foreground_color"));
        Node dNode = INodeCreator.getDefaultImpl().getNode4DTO((Object)new Date(System.currentTimeMillis()), false, false);
        this.dueDate = new TitledItem<DateChooser>(new DateChooser(dNode), Words.DUE_DATE, TitledItem.TitledItemOrientation.NORTH);
        this.dueDate.getElement().setIsTimestamp(true);
        this.sep1 = new HorizontalSeparator();
        this.printOptionTitle = new TextLabel(WordsToolkit.toUpperCase((String)Words.OPTIONS));
        this.printOptionTitle.setFont(AttributesConverter.getFont4String(LafLoader.getLafLoader().getAttribute("default_font"), LafLoader.getLafLoader().getAttribute("default_font_size"), LafLoader.getLafLoader().getAttribute("default_titled_item_font_type")));
        this.printOptionTitle.setForeground(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("default_titled_item_foreground")));
        this.includeCosts = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_COSTS_SALES_PRICE, TitledItem.TitledItemOrientation.EAST);
        this.includeCosts.setTitleFont(f);
        this.includeCosts.setTitleForeground(fb);
        this.includeCosts.getElement().setChecked(this.showProductionCosts);
        this.includeCosts.getElement().addButtonListener(this);
        this.includeTender = new TitledItem<ComboBox>(new ComboBox(), Words.TENDER, TitledItem.TitledItemOrientation.NORTH);
        this.includeTender.getElement().addItem(Words.ALL);
        this.includeTender.getElement().addItem(Words.TENDER);
        this.includeTender.getElement().addItem(Words.PRODUCTIVE);
        if (!this.printExternalCostFactSheet) {
            this.includeTender.getElement().setSelectedItem(Words.PRODUCTIVE);
        }
        this.includeMealPlanAndStowingListData = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_MEAL_PLAN_AND_STOWING_LIST, TitledItem.TitledItemOrientation.EAST);
        this.includeManMinutes = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_MAN_MINUTES_SHEET, TitledItem.TitledItemOrientation.EAST);
        this.includeProductMM = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_PRODUCT_MM_SHEET, TitledItem.TitledItemOrientation.EAST);
        this.includeGroupMM = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_GROUP_MM_SHEET, TitledItem.TitledItemOrientation.EAST);
        this.includeComponentMM = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_COMPONENT_MM_SHEET, TitledItem.TitledItemOrientation.EAST);
        this.resolveRecipesToArticles = new TitledItem<CheckBox>(new CheckBox(), Words.RESOLVE_RECIPES_TO_ARTICLES, TitledItem.TitledItemOrientation.EAST);
        this.splitCostCenters = new TitledItem<CheckBox>(new CheckBox(), Words.SPLIT_DEPARTMENTS, TitledItem.TitledItemOrientation.EAST);
        this.getViewContainer().add(this.dueDate);
        this.getViewContainer().add(this.sep1);
        this.getViewContainer().add(this.printOptionTitle);
        this.getViewContainer().add(this.includeCosts);
        this.getViewContainer().add(this.includeTender);
        this.getViewContainer().add(this.includeMealPlanAndStowingListData);
        this.getViewContainer().add(this.includeManMinutes);
        this.getViewContainer().add(this.includeProductMM);
        this.getViewContainer().add(this.includeGroupMM);
        this.getViewContainer().add(this.includeComponentMM);
        this.getViewContainer().add(this.resolveRecipesToArticles);
        this.getViewContainer().add(this.splitCostCenters);
        this.setEnabled(true);
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        this.sep1.setEnabled(isEnabled);
        this.printOptionTitle.setEnabled(isEnabled);
        this.includeCosts.setEnabled(isEnabled && this.showProductionCosts);
        this.includeTender.setEnabled(isEnabled && this.printExternalCostFactSheet);
        this.includeMealPlanAndStowingListData.setEnabled(isEnabled);
        this.resolveRecipesToArticles.setEnabled(isEnabled);
        this.includeManMinutes.setEnabled(isEnabled);
        this.includeProductMM.setEnabled(isEnabled);
        this.includeGroupMM.setEnabled(isEnabled);
        this.includeComponentMM.setEnabled(isEnabled);
        this.splitCostCenters.setEnabled(isEnabled);
    }

    @Override
    public void updateConfiguration(FilterChainConfiguration conf) {
        for (String[] s : conf.getProperties()) {
            String n = s[0];
            String v = s[1];
            Boolean b = Boolean.valueOf(v);
            if (n.equals("costs")) {
                this.includeCosts.getElement().setChecked(b);
            }
            if (n.equals("mp_stowing")) {
                this.includeMealPlanAndStowingListData.getElement().setChecked(b);
            }
            if (n.equals("resolveRecipesToArticles")) {
                this.resolveRecipesToArticles.getElement().setChecked(b);
            }
            if (n.equals("splitCostCenters")) {
                this.splitCostCenters.getElement().setChecked(b);
            }
            if (n.equals("manMinutes")) {
                this.includeManMinutes.getElement().setChecked(b);
            }
            if (n.equals("includeProductMM")) {
                this.includeProductMM.getElement().setChecked(b);
            }
            if (n.equals("includeGroupMM")) {
                this.includeGroupMM.getElement().setChecked(b);
            }
            if (!n.equals("includeComponentMM")) continue;
            this.includeComponentMM.getElement().setChecked(b);
        }
    }

    @Override
    public FilterChainConfiguration createFilterChainConfig() {
        FilterChainConfiguration conf = new FilterChainConfiguration();
        conf.addProperty("costs", "" + this.includeCosts.getElement().isChecked());
        conf.addProperty("mp_stowing", "" + this.includeMealPlanAndStowingListData.getElement().isChecked());
        conf.addProperty("resolveRecipesToArticles", "" + this.resolveRecipesToArticles.getElement().isChecked());
        conf.addProperty("splitCostCenters", "" + this.splitCostCenters.getElement().isChecked());
        conf.addProperty("manMinutes", "" + this.includeManMinutes.getElement().isChecked());
        conf.addProperty("includeProductMM", "" + this.includeProductMM.getElement().isChecked());
        conf.addProperty("includeGroupMM", "" + this.includeGroupMM.getElement().isChecked());
        conf.addProperty("includeComponentMM", "" + this.includeComponentMM.getElement().isChecked());
        return conf;
    }

    @Override
    protected String getProgressText() {
        return Words.EXPORT;
    }

    @Override
    public String getTitleString() {
        return Words.PRODUCT_FACT_SHEETS;
    }

    @Override
    public String getTitleValue() {
        return (String)this.currentProduct.getChildNamed(ProductCatalogLight_.title).getValue();
    }

    @Override
    public void setInnerPopUp(InnerPopUp2 ip) {
        super.setInnerPopUp(ip);
        ip.enablePreviewButton();
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        Object[] o = new Object[]{};
        return o;
    }

    @Override
    public boolean isClosableWithEnter() {
        return false;
    }

    @Override
    public boolean isInnerComponent(Component c) {
        return super.isInnerComponent(c);
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.printOptionTitle != null) {
            this.printOptionTitle.kill();
        }
        if (this.dueDate != null) {
            this.dueDate.kill();
        }
        if (this.sep1 != null) {
            this.sep1.kill();
        }
        if (this.includeCosts != null) {
            this.includeCosts.kill();
        }
        if (this.includeTender != null) {
            this.includeTender.kill();
        }
        if (this.includeMealPlanAndStowingListData != null) {
            this.includeMealPlanAndStowingListData.kill();
        }
        if (this.resolveRecipesToArticles != null) {
            this.resolveRecipesToArticles.kill();
        }
        if (this.includeManMinutes != null) {
            this.includeManMinutes.kill();
        }
        if (this.includeProductMM != null) {
            this.includeProductMM.kill();
        }
        if (this.includeGroupMM != null) {
            this.includeGroupMM.kill();
        }
        if (this.includeComponentMM != null) {
            this.includeComponentMM.kill();
        }
        if (this.splitCostCenters != null) {
            this.splitCostCenters.kill();
        }
        this.includeMealPlanAndStowingListData = null;
        this.includeTender = null;
        this.printOptionTitle = null;
        this.dueDate = null;
        this.sep1 = null;
        this.includeCosts = null;
        this.resolveRecipesToArticles = null;
        this.splitCostCenters = null;
        this.includeManMinutes = null;
        this.includeProductMM = null;
        this.includeGroupMM = null;
        this.includeComponentMM = null;
    }

    @Override
    public void addInheritedComponents() {
        super.addInheritedComponents();
        if (this.dueDate != null) {
            this.dueDate.setVisible(true);
        }
        if (this.sep1 != null) {
            this.sep1.setVisible(true);
        }
        if (this.printOptionTitle != null) {
            this.printOptionTitle.setVisible(true);
        }
        if (this.includeCosts != null) {
            this.includeCosts.setVisible(true);
        }
        if (this.includeTender != null) {
            this.includeTender.setVisible(true);
        }
        if (this.includeMealPlanAndStowingListData != null) {
            this.includeMealPlanAndStowingListData.setVisible(true);
        }
        if (this.resolveRecipesToArticles != null) {
            this.resolveRecipesToArticles.setVisible(true);
        }
        if (this.splitCostCenters != null) {
            this.splitCostCenters.setVisible(true);
        }
    }

    @Override
    public void removeInheritedComponents() {
        super.removeInheritedComponents();
        if (this.dueDate != null) {
            this.dueDate.setVisible(false);
        }
        if (this.sep1 != null) {
            this.sep1.setVisible(false);
        }
        if (this.printOptionTitle != null) {
            this.printOptionTitle.setVisible(false);
        }
        if (this.includeCosts != null) {
            this.includeCosts.setVisible(false);
        }
        if (this.includeTender != null) {
            this.includeTender.setVisible(false);
        }
        if (this.includeMealPlanAndStowingListData != null) {
            this.includeMealPlanAndStowingListData.setVisible(false);
        }
        if (this.resolveRecipesToArticles != null) {
            this.resolveRecipesToArticles.setVisible(false);
        }
    }

    @Override
    public ThreadSafeExecutable getJob() {
        return new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                log.info("Product Catalog (client): start generation");
                ExportProductCatalogProductFactSheetComponent.this.configNode.commit();
                Date date = null;
                date = ((DateChooser)ExportProductCatalogProductFactSheetComponent.this.dueDate.getElement()).getNode().getValue() instanceof Date ? (Date)((DateChooser)ExportProductCatalogProductFactSheetComponent.this.dueDate.getElement()).getNode().getValue() : (((DateChooser)ExportProductCatalogProductFactSheetComponent.this.dueDate.getElement()).getNode().getValue() instanceof Timestamp ? new Date(((Timestamp)((DateChooser)ExportProductCatalogProductFactSheetComponent.this.dueDate.getElement()).getNode().getValue()).getTime()) : new Date(System.currentTimeMillis()));
                ArrayList<ProductCatalogReference> catalogs = new ArrayList<ProductCatalogReference>();
                catalogs.add(new ProductCatalogReference(((ProductCatalogLight)ExportProductCatalogProductFactSheetComponent.this.currentProduct.getValue()).getId()));
                boolean showCosts = false;
                if (ExportProductCatalogProductFactSheetComponent.this.showProductionCosts) {
                    showCosts = ((CheckBox)ExportProductCatalogProductFactSheetComponent.this.includeCosts.getElement()).isChecked();
                }
                boolean includeMP_STW = false;
                if (ExportProductCatalogProductFactSheetComponent.this.includeMealPlanAndStowingListData != null) {
                    includeMP_STW = ((CheckBox)ExportProductCatalogProductFactSheetComponent.this.includeMealPlanAndStowingListData.getElement()).isChecked();
                }
                boolean manMinutes = ((CheckBox)ExportProductCatalogProductFactSheetComponent.this.includeManMinutes.getElement()).isChecked();
                boolean includeProductMMSheet = ((CheckBox)ExportProductCatalogProductFactSheetComponent.this.includeProductMM.getElement()).isChecked();
                boolean includeGroupMMSheet = ((CheckBox)ExportProductCatalogProductFactSheetComponent.this.includeGroupMM.getElement()).isChecked();
                boolean includeComponentMMSheet = ((CheckBox)ExportProductCatalogProductFactSheetComponent.this.includeComponentMM.getElement()).isChecked();
                Boolean showTender = false;
                if (!ExportProductCatalogProductFactSheetComponent.this.printExternalCostFactSheet) {
                    showTender = false;
                } else if (((ComboBox)ExportProductCatalogProductFactSheetComponent.this.includeTender.getElement()).getSelectedItem().equals(Words.ALL)) {
                    showTender = null;
                } else if (((ComboBox)ExportProductCatalogProductFactSheetComponent.this.includeTender.getElement()).getSelectedItem().equals(Words.TENDER)) {
                    showTender = true;
                } else if (((ComboBox)ExportProductCatalogProductFactSheetComponent.this.includeTender.getElement()).getSelectedItem().equals(Words.PRODUCTIVE)) {
                    showTender = false;
                }
                boolean resolveRecipes = ExportProductCatalogProductFactSheetComponent.this.resolveRecipesToArticles != null ? ((CheckBox)ExportProductCatalogProductFactSheetComponent.this.resolveRecipesToArticles.getElement()).isChecked() : false;
                boolean splitDepartments = ExportProductCatalogProductFactSheetComponent.this.splitCostCenters != null ? ((CheckBox)ExportProductCatalogProductFactSheetComponent.this.splitCostCenters.getElement()).isChecked() : false;
                ProductFactSheetsReportConfiguration configuration = new ProductFactSheetsReportConfiguration();
                configuration.setDueDate(date);
                configuration.setIncludeCosts(Boolean.valueOf(showCosts));
                configuration.setIncludeMpAndStwUsage(Boolean.valueOf(includeMP_STW));
                configuration.setResolveRecipesToArticles(Boolean.valueOf(resolveRecipes));
                configuration.setIncludeMMSheet(Boolean.valueOf(manMinutes));
                configuration.setShowProductComponentDepartmentsSeperately(Boolean.valueOf(splitDepartments));
                configuration.setIncludeProductMMSheet(Boolean.valueOf(includeProductMMSheet));
                configuration.setIncludeGroupMMSheet(Boolean.valueOf(includeGroupMMSheet));
                configuration.setIncludeComponentMMSheet(Boolean.valueOf(includeComponentMMSheet));
                configuration.setShowTender(showTender);
                configuration.setDto((IDTO)new ProductCatalogReference(((ProductCatalogLight)ExportProductCatalogProductFactSheetComponent.this.currentProduct.getValue()).getId()));
                log.info("Product Catalog (client): send request to server");
                PegasusFileComplete t = (PegasusFileComplete)((ProductReportServiceManager)ServiceManagerRegistry.getService(ProductReportServiceManager.class)).createProductFactSheetExportForCatalogs(new ListWrapper(catalogs), configuration).getValue();
                log.info("Product Catalog (client): report received, send it to desktop");
                ExportProductCatalogProductFactSheetComponent.this.processFile(t);
                Node b = new Node();
                b.setValue((Object)true, 0L);
                log.info("Product Catalog (client): all done");
                return b;
            }

            @Override
            public RemoteLoader getInvoker() {
                return ExportProductCatalogProductFactSheetComponent.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
    }

    @Override
    public Node<ProductCatalogLight> getCurrentNode() {
        return this.currentProduct;
    }

    @Override
    public BatchJob<ProductCatalogLight> createBatchJob(Node<ProductCatalogLight> value, ThreadSafeExecutable job) {
        return null;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int y = ExportProductCatalogProductFactSheetComponent.this.layoutInheritedComponents(parent);
            if (ExportProductCatalogProductFactSheetComponent.this.dueDate != null) {
                ExportProductCatalogProductFactSheetComponent.this.dueDate.setLocation(ExportProductCatalogProductFactSheetComponent.this.border, y + ExportProductCatalogProductFactSheetComponent.this.border / 2);
                ExportProductCatalogProductFactSheetComponent.this.dueDate.setSize(parent.getWidth() - 2 * ExportProductCatalogProductFactSheetComponent.this.border, (int)ExportProductCatalogProductFactSheetComponent.this.dueDate.getPreferredSize().getHeight());
                y = ExportProductCatalogProductFactSheetComponent.this.dueDate.getY() + ExportProductCatalogProductFactSheetComponent.this.dueDate.getHeight();
            }
            if (ExportProductCatalogProductFactSheetComponent.this.sep1 != null) {
                ExportProductCatalogProductFactSheetComponent.this.sep1.setLocation(0, y + ExportProductCatalogProductFactSheetComponent.this.border / 2);
                ExportProductCatalogProductFactSheetComponent.this.sep1.setSize(parent.getWidth(), (int)ExportProductCatalogProductFactSheetComponent.this.sep1.getPreferredSize().getHeight());
                y = ExportProductCatalogProductFactSheetComponent.this.sep1.getY() + ExportProductCatalogProductFactSheetComponent.this.sep1.getHeight();
            }
            if (ExportProductCatalogProductFactSheetComponent.this.printOptionTitle != null) {
                ExportProductCatalogProductFactSheetComponent.this.printOptionTitle.setLocation(ExportProductCatalogProductFactSheetComponent.this.border, y + ExportProductCatalogProductFactSheetComponent.this.border);
                ExportProductCatalogProductFactSheetComponent.this.printOptionTitle.setSize(parent.getWidth() - 2 * ExportProductCatalogProductFactSheetComponent.this.border, (int)ExportProductCatalogProductFactSheetComponent.this.printOptionTitle.getPreferredSize().getHeight());
                y = ExportProductCatalogProductFactSheetComponent.this.printOptionTitle.getY() + ExportProductCatalogProductFactSheetComponent.this.printOptionTitle.getHeight();
            }
            if (ExportProductCatalogProductFactSheetComponent.this.includeCosts != null) {
                ExportProductCatalogProductFactSheetComponent.this.includeCosts.setLocation(ExportProductCatalogProductFactSheetComponent.this.border, y + ExportProductCatalogProductFactSheetComponent.this.border / 2);
                ExportProductCatalogProductFactSheetComponent.this.includeCosts.setSize(parent.getWidth() - 2 * ExportProductCatalogProductFactSheetComponent.this.border, (int)ExportProductCatalogProductFactSheetComponent.this.includeCosts.getPreferredSize().getHeight());
                y = ExportProductCatalogProductFactSheetComponent.this.includeCosts.getY() + ExportProductCatalogProductFactSheetComponent.this.includeCosts.getHeight();
            }
            if (ExportProductCatalogProductFactSheetComponent.this.includeMealPlanAndStowingListData != null) {
                ExportProductCatalogProductFactSheetComponent.this.includeMealPlanAndStowingListData.setLocation(ExportProductCatalogProductFactSheetComponent.this.border, y + ExportProductCatalogProductFactSheetComponent.this.border / 2);
                ExportProductCatalogProductFactSheetComponent.this.includeMealPlanAndStowingListData.setSize(parent.getWidth() - 2 * ExportProductCatalogProductFactSheetComponent.this.border, (int)ExportProductCatalogProductFactSheetComponent.this.includeMealPlanAndStowingListData.getPreferredSize().getHeight());
                y = ExportProductCatalogProductFactSheetComponent.this.includeMealPlanAndStowingListData.getY() + ExportProductCatalogProductFactSheetComponent.this.includeMealPlanAndStowingListData.getHeight();
            }
            if (ExportProductCatalogProductFactSheetComponent.this.includeManMinutes != null) {
                ExportProductCatalogProductFactSheetComponent.this.includeManMinutes.setLocation(ExportProductCatalogProductFactSheetComponent.this.border, y + ExportProductCatalogProductFactSheetComponent.this.border / 2);
                ExportProductCatalogProductFactSheetComponent.this.includeManMinutes.setSize(parent.getWidth() - 2 * ExportProductCatalogProductFactSheetComponent.this.border, (int)ExportProductCatalogProductFactSheetComponent.this.includeManMinutes.getPreferredSize().getHeight());
                y = ExportProductCatalogProductFactSheetComponent.this.includeManMinutes.getY() + ExportProductCatalogProductFactSheetComponent.this.includeManMinutes.getHeight();
            }
            if (ExportProductCatalogProductFactSheetComponent.this.includeProductMM != null) {
                ExportProductCatalogProductFactSheetComponent.this.includeProductMM.setLocation(ExportProductCatalogProductFactSheetComponent.this.border, y + ExportProductCatalogProductFactSheetComponent.this.border / 2);
                ExportProductCatalogProductFactSheetComponent.this.includeProductMM.setSize(parent.getWidth() - 2 * ExportProductCatalogProductFactSheetComponent.this.border, (int)ExportProductCatalogProductFactSheetComponent.this.includeProductMM.getPreferredSize().getHeight());
                y = ExportProductCatalogProductFactSheetComponent.this.includeProductMM.getY() + ExportProductCatalogProductFactSheetComponent.this.includeProductMM.getHeight();
            }
            if (ExportProductCatalogProductFactSheetComponent.this.includeGroupMM != null) {
                ExportProductCatalogProductFactSheetComponent.this.includeGroupMM.setLocation(ExportProductCatalogProductFactSheetComponent.this.border, y + ExportProductCatalogProductFactSheetComponent.this.border / 2);
                ExportProductCatalogProductFactSheetComponent.this.includeGroupMM.setSize(parent.getWidth() - 2 * ExportProductCatalogProductFactSheetComponent.this.border, (int)ExportProductCatalogProductFactSheetComponent.this.includeGroupMM.getPreferredSize().getHeight());
                y = ExportProductCatalogProductFactSheetComponent.this.includeGroupMM.getY() + ExportProductCatalogProductFactSheetComponent.this.includeGroupMM.getHeight();
            }
            if (ExportProductCatalogProductFactSheetComponent.this.includeComponentMM != null) {
                ExportProductCatalogProductFactSheetComponent.this.includeComponentMM.setLocation(ExportProductCatalogProductFactSheetComponent.this.border, y + ExportProductCatalogProductFactSheetComponent.this.border / 2);
                ExportProductCatalogProductFactSheetComponent.this.includeComponentMM.setSize(parent.getWidth() - 2 * ExportProductCatalogProductFactSheetComponent.this.border, (int)ExportProductCatalogProductFactSheetComponent.this.includeComponentMM.getPreferredSize().getHeight());
                y = ExportProductCatalogProductFactSheetComponent.this.includeComponentMM.getY() + ExportProductCatalogProductFactSheetComponent.this.includeComponentMM.getHeight();
            }
            if (ExportProductCatalogProductFactSheetComponent.this.includeTender != null) {
                ExportProductCatalogProductFactSheetComponent.this.includeTender.setLocation(ExportProductCatalogProductFactSheetComponent.this.border, y + ExportProductCatalogProductFactSheetComponent.this.border / 2);
                ExportProductCatalogProductFactSheetComponent.this.includeTender.setSize(parent.getWidth() - 2 * ExportProductCatalogProductFactSheetComponent.this.border, (int)ExportProductCatalogProductFactSheetComponent.this.includeTender.getPreferredSize().getHeight());
                y = ExportProductCatalogProductFactSheetComponent.this.includeTender.getY() + ExportProductCatalogProductFactSheetComponent.this.includeTender.getHeight();
            }
            if (ExportProductCatalogProductFactSheetComponent.this.resolveRecipesToArticles != null) {
                ExportProductCatalogProductFactSheetComponent.this.resolveRecipesToArticles.setLocation(ExportProductCatalogProductFactSheetComponent.this.border, y + ExportProductCatalogProductFactSheetComponent.this.border);
                ExportProductCatalogProductFactSheetComponent.this.resolveRecipesToArticles.setSize(ExportProductCatalogProductFactSheetComponent.this.resolveRecipesToArticles.getPreferredSize());
                y = ExportProductCatalogProductFactSheetComponent.this.resolveRecipesToArticles.getY() + ExportProductCatalogProductFactSheetComponent.this.resolveRecipesToArticles.getHeight();
            }
            if (ExportProductCatalogProductFactSheetComponent.this.splitCostCenters != null) {
                ExportProductCatalogProductFactSheetComponent.this.splitCostCenters.setLocation(ExportProductCatalogProductFactSheetComponent.this.border, y + ExportProductCatalogProductFactSheetComponent.this.border);
                ExportProductCatalogProductFactSheetComponent.this.splitCostCenters.setSize(ExportProductCatalogProductFactSheetComponent.this.splitCostCenters.getPreferredSize());
                y = ExportProductCatalogProductFactSheetComponent.this.splitCostCenters.getY() + ExportProductCatalogProductFactSheetComponent.this.splitCostCenters.getHeight();
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = ExportProductCatalogProductFactSheetComponent.this.getInheritedComponentsHeight();
            int w = 250;
            h += ExportProductCatalogProductFactSheetComponent.this.border;
            if (ExportProductCatalogProductFactSheetComponent.this.dueDate != null) {
                h = (int)((double)h + ExportProductCatalogProductFactSheetComponent.this.dueDate.getPreferredSize().getHeight());
                h += ExportProductCatalogProductFactSheetComponent.this.border / 2;
            }
            if (ExportProductCatalogProductFactSheetComponent.this.sep1 != null) {
                h = (int)((double)h + ExportProductCatalogProductFactSheetComponent.this.sep1.getPreferredSize().getHeight());
                h += ExportProductCatalogProductFactSheetComponent.this.border;
            }
            if (ExportProductCatalogProductFactSheetComponent.this.printOptionTitle != null) {
                h = (int)((double)h + ExportProductCatalogProductFactSheetComponent.this.printOptionTitle.getPreferredSize().getHeight());
                h += ExportProductCatalogProductFactSheetComponent.this.border / 2;
            }
            if (ExportProductCatalogProductFactSheetComponent.this.includeCosts != null) {
                h = (int)((double)h + ExportProductCatalogProductFactSheetComponent.this.includeCosts.getPreferredSize().getHeight());
                h += ExportProductCatalogProductFactSheetComponent.this.border;
            }
            if (ExportProductCatalogProductFactSheetComponent.this.includeTender != null) {
                h = (int)((double)h + ExportProductCatalogProductFactSheetComponent.this.includeTender.getPreferredSize().getHeight());
                h += ExportProductCatalogProductFactSheetComponent.this.border;
            }
            if (ExportProductCatalogProductFactSheetComponent.this.includeMealPlanAndStowingListData != null) {
                h = (int)((double)h + ExportProductCatalogProductFactSheetComponent.this.includeMealPlanAndStowingListData.getPreferredSize().getHeight());
                h += ExportProductCatalogProductFactSheetComponent.this.border;
            }
            if (ExportProductCatalogProductFactSheetComponent.this.resolveRecipesToArticles != null) {
                h = (int)((double)h + ExportProductCatalogProductFactSheetComponent.this.resolveRecipesToArticles.getPreferredSize().getHeight());
                h += ExportProductCatalogProductFactSheetComponent.this.border;
            }
            return new Dimension(w, h);
        }
    }
}

