/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.print.mealplan.catalog;

import ch.icit.pegasus.client.gui.batch.BatchJob;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.datechooser.DateChooser;
import ch.icit.pegasus.client.gui.utils.filterchain.FilterChainConfiguration;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.print.DefaultScrollablePrintPopup2;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.report.ProductReportServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.HUDToolkit;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.server.core.dtos.auth.UserComplete;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportTypeE;
import ch.icit.pegasus.server.core.dtos.mealplan.MealPlanLight;
import ch.icit.pegasus.server.core.dtos.mealplan.MealPlanReference;
import ch.icit.pegasus.server.core.dtos.report.ProductCatalogReportConfiguration;
import ch.icit.pegasus.server.core.dtos.report.ReportingOutputFormatE;
import ch.icit.pegasus.server.core.dtos.rightmanagement.access.DataFieldAccessRightComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.access.ModuleAccessRightComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.ProductCatalogAccess;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.util.TimeUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.sql.Date;
import java.util.Calendar;

public class PrintMealPlanCatalogComponent
extends DefaultScrollablePrintPopup2<MealPlanLight> {
    private static final long serialVersionUID = 1L;
    private MealPlanLight currentProductCatalog;
    private TitledItem<CheckBox> showPricing;
    private TitledItem<CheckBox> useEnglishNames;
    private TitledItem<CheckBox> showDescription;
    private TitledItem<CheckBox> showArticlesFromRecipeInstaedOfRecipe;
    private TitledItem<CheckBox> useHDImages;
    private TitledItem<CheckBox> showTraces;
    private TitledItem<CheckBox> showAdditives;
    private TitledItem<CheckBox> showOtherDeclarations;
    private TitledItem<DateChooser> dueDate;
    private TitledItem<CheckBox> sortByMealPlan;
    private TitledItem<TextField> cycleDefinition;

    public PrintMealPlanCatalogComponent(MealPlanLight currentDTO) {
        super(false, false, ReportTypeE.PRODUCT_CATALOG);
        this.currentProductCatalog = currentDTO;
    }

    @Override
    public void updateConfiguration(FilterChainConfiguration conf) {
    }

    @Override
    public FilterChainConfiguration createFilterChainConfig() {
        return null;
    }

    @Override
    public void insertElements() {
        this.createComponents();
        this.getViewContainer().setLayout(new Layout());
        Calendar cal = TimeUtil.createCalendar();
        cal.setTimeInMillis(System.currentTimeMillis());
        cal.set(14, 0);
        cal.set(13, 0);
        cal.set(12, 0);
        cal.set(11, 0);
        Date today = new Date(cal.getTimeInMillis());
        this.dueDate = new TitledItem<DateChooser>(new DateChooser(INodeCreator.getDefaultImpl().getNode4DTO((Object)today, false, false)), "Due Date", TitledItem.TitledItemOrientation.NORTH);
        UserComplete user = ((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentUser();
        ModuleAccessRightComplete r = HUDToolkit.getCurrentAccessRight(ProductCatalogAccess.MODULE_PRODUCT_CATALOG, user);
        boolean sp = false;
        for (DataFieldAccessRightComplete a : r.getFieldAccessRights()) {
            if (!a.getField().getName().equals("showProductSales")) continue;
            sp = true;
        }
        if (sp) {
            this.showPricing = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_PRICES, TitledItem.TitledItemOrientation.EAST);
            this.getViewContainer().add(this.showPricing);
        }
        this.useEnglishNames = new TitledItem<CheckBox>(new CheckBox(), Words.USE_ENGLISH_NAME, TitledItem.TitledItemOrientation.EAST);
        this.showDescription = new TitledItem<CheckBox>(new CheckBox(), Words.SHOW_PRODUCT_DESCRIPTION, TitledItem.TitledItemOrientation.EAST);
        this.useHDImages = new TitledItem<CheckBox>(new CheckBox(), Words.USE_HIGH_DEF_IMAGES, TitledItem.TitledItemOrientation.EAST);
        this.showArticlesFromRecipeInstaedOfRecipe = new TitledItem<CheckBox>(new CheckBox(), Words.SHOW_ARTICLES_INSTAED_OF_RECIPE, TitledItem.TitledItemOrientation.EAST);
        this.showTraces = new TitledItem<CheckBox>(new CheckBox(), Words.SHOW_TRACES, TitledItem.TitledItemOrientation.EAST);
        this.sortByMealPlan = new TitledItem<CheckBox>(new CheckBox(), Words.SORT_BY_MEALPLAN, TitledItem.TitledItemOrientation.EAST);
        this.cycleDefinition = new TitledItem<TextField>(new TextField(), Words.CYCLE, TitledItem.TitledItemOrientation.NORTH);
        this.getViewContainer().add(this.showTraces);
        this.getViewContainer().add(this.useEnglishNames);
        this.getViewContainer().add(this.showDescription);
        this.getViewContainer().add(this.dueDate);
        this.getViewContainer().add(this.cycleDefinition);
        this.getViewContainer().add(this.useHDImages);
        this.getViewContainer().add(this.showArticlesFromRecipeInstaedOfRecipe);
        if (this.sortByMealPlan != null) {
            this.getViewContainer().add(this.sortByMealPlan);
        }
    }

    @Override
    public String getTitleString() {
        return Words.PRODUCT_CATALOG;
    }

    @Override
    public String getTitleValue() {
        return this.currentProductCatalog.getName();
    }

    @Override
    public void setInnerPopUp(InnerPopUp2 ip) {
        super.setInnerPopUp(ip);
        ip.enablePreviewButton();
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        Object[] o = new Object[]{};
        return o;
    }

    @Override
    public boolean isClosableWithEnter() {
        return false;
    }

    @Override
    public boolean isInnerComponent(Component c) {
        return super.isInnerComponent(c);
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
    }

    @Override
    public void addInheritedComponents() {
        super.addInheritedComponents();
        if (this.dueDate != null) {
            this.dueDate.setVisible(true);
        }
        if (this.showPricing != null) {
            this.showPricing.setVisible(true);
        }
        if (this.useEnglishNames != null) {
            this.useEnglishNames.setVisible(true);
        }
        if (this.showDescription != null) {
            this.showDescription.setVisible(true);
        }
        if (this.showTraces != null) {
            this.showTraces.setVisible(true);
        }
        if (this.showAdditives != null) {
            this.showAdditives.setVisible(true);
        }
        if (this.showOtherDeclarations != null) {
            this.showOtherDeclarations.setVisible(true);
        }
        if (this.sortByMealPlan != null) {
            this.sortByMealPlan.setVisible(true);
        }
        if (this.cycleDefinition != null) {
            this.cycleDefinition.setVisible(true);
        }
        if (this.useHDImages != null) {
            this.useHDImages.setVisible(true);
        }
        if (this.showArticlesFromRecipeInstaedOfRecipe != null) {
            this.showArticlesFromRecipeInstaedOfRecipe.setVisible(true);
        }
    }

    @Override
    public void removeInheritedComponents() {
        super.removeInheritedComponents();
        if (this.dueDate != null) {
            this.dueDate.setVisible(false);
        }
        if (this.showPricing != null) {
            this.showPricing.setVisible(false);
        }
        if (this.useEnglishNames != null) {
            this.useEnglishNames.setVisible(false);
        }
        if (this.showDescription != null) {
            this.showDescription.setVisible(false);
        }
        if (this.showTraces != null) {
            this.showTraces.setVisible(false);
        }
        if (this.showAdditives != null) {
            this.showAdditives.setVisible(false);
        }
        if (this.showOtherDeclarations != null) {
            this.showOtherDeclarations.setVisible(false);
        }
        if (this.sortByMealPlan != null) {
            this.sortByMealPlan.setVisible(false);
        }
        if (this.cycleDefinition != null) {
            this.cycleDefinition.setVisible(false);
        }
        if (this.useHDImages != null) {
            this.useHDImages.setVisible(false);
        }
        if (this.showArticlesFromRecipeInstaedOfRecipe != null) {
            this.showArticlesFromRecipeInstaedOfRecipe.setVisible(false);
        }
    }

    @Override
    public ThreadSafeExecutable getJob() {
        return new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                ProductCatalogReportConfiguration pcc = new ProductCatalogReportConfiguration(ReportTypeE.PRODUCT_CATALOG, ReportingOutputFormatE.PDF, PrintMealPlanCatalogComponent.this.getSelectedReport());
                pcc.setDueDate((Date)((DateChooser)PrintMealPlanCatalogComponent.this.dueDate.getElement()).getNode().getValue());
                if (PrintMealPlanCatalogComponent.this.showPricing != null) {
                    pcc.setIncludePrices(Boolean.valueOf(((CheckBox)PrintMealPlanCatalogComponent.this.showPricing.getElement()).isChecked()));
                } else {
                    pcc.setIncludePrices(Boolean.valueOf(false));
                }
                if (PrintMealPlanCatalogComponent.this.useEnglishNames != null) {
                    pcc.setUseEnglishName(Boolean.valueOf(((CheckBox)PrintMealPlanCatalogComponent.this.useEnglishNames.getElement()).isChecked()));
                } else {
                    pcc.setUseEnglishName(Boolean.valueOf(false));
                }
                if (PrintMealPlanCatalogComponent.this.showDescription != null) {
                    pcc.setShowProductDescrption(Boolean.valueOf(((CheckBox)PrintMealPlanCatalogComponent.this.showDescription.getElement()).isChecked()));
                } else {
                    pcc.setShowProductDescrption(Boolean.valueOf(false));
                }
                if (PrintMealPlanCatalogComponent.this.showTraces != null) {
                    pcc.setShowTraces(Boolean.valueOf(((CheckBox)PrintMealPlanCatalogComponent.this.showTraces.getElement()).isChecked()));
                } else {
                    pcc.setShowTraces(Boolean.valueOf(false));
                }
                if (PrintMealPlanCatalogComponent.this.showAdditives != null) {
                    pcc.setShowAdditive(Boolean.valueOf(((CheckBox)PrintMealPlanCatalogComponent.this.showAdditives.getElement()).isChecked()));
                } else {
                    pcc.setShowAdditive(Boolean.valueOf(false));
                }
                if (PrintMealPlanCatalogComponent.this.showOtherDeclarations != null) {
                    pcc.setShowOthers(Boolean.valueOf(((CheckBox)PrintMealPlanCatalogComponent.this.showOtherDeclarations.getElement()).isChecked()));
                } else {
                    pcc.setShowOthers(Boolean.valueOf(false));
                }
                if (PrintMealPlanCatalogComponent.this.sortByMealPlan != null) {
                    pcc.setSortByMealPlan(Boolean.valueOf(((CheckBox)PrintMealPlanCatalogComponent.this.sortByMealPlan.getElement()).isChecked()));
                } else {
                    pcc.setSortByMealPlan(Boolean.valueOf(false));
                }
                if (PrintMealPlanCatalogComponent.this.useHDImages != null) {
                    pcc.setUseHighDefImage(Boolean.valueOf(((CheckBox)PrintMealPlanCatalogComponent.this.useHDImages.getElement()).isChecked()));
                } else {
                    pcc.setUseHighDefImage(Boolean.valueOf(false));
                }
                if (PrintMealPlanCatalogComponent.this.showArticlesFromRecipeInstaedOfRecipe != null) {
                    pcc.setShowRecipeDetails(Boolean.valueOf(((CheckBox)PrintMealPlanCatalogComponent.this.showArticlesFromRecipeInstaedOfRecipe.getElement()).isChecked()));
                }
                pcc.setCycleDefinition(((TextField)PrintMealPlanCatalogComponent.this.cycleDefinition.getElement()).getText());
                pcc.setRebuildCatalog(Boolean.valueOf(true));
                PegasusFileComplete t = (PegasusFileComplete)((ProductReportServiceManager)ServiceManagerRegistry.getService(ProductReportServiceManager.class)).createMealPlanCatalogReport(new MealPlanReference(PrintMealPlanCatalogComponent.this.currentProductCatalog.getId()), pcc).getValue();
                PrintMealPlanCatalogComponent.this.processFile(t);
                Node b = new Node();
                b.setValue((Object)true, 0L);
                return b;
            }

            @Override
            public RemoteLoader getInvoker() {
                return PrintMealPlanCatalogComponent.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
    }

    @Override
    public Node<MealPlanLight> getCurrentNode() {
        return INodeCreator.getDefaultImpl().getNode4DTO((Object)this.currentProductCatalog, false, false);
    }

    @Override
    public BatchJob<MealPlanLight> createBatchJob(Node<MealPlanLight> value, ThreadSafeExecutable job) {
        return null;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int y = PrintMealPlanCatalogComponent.this.layoutInheritedComponents(parent) + PrintMealPlanCatalogComponent.this.border;
            PrintMealPlanCatalogComponent.this.dueDate.setLocation(PrintMealPlanCatalogComponent.this.border, y + PrintMealPlanCatalogComponent.this.border);
            PrintMealPlanCatalogComponent.this.dueDate.setSize(PrintMealPlanCatalogComponent.this.dueDate.getPreferredSize());
            y = PrintMealPlanCatalogComponent.this.dueDate.getY() + PrintMealPlanCatalogComponent.this.dueDate.getHeight() + PrintMealPlanCatalogComponent.this.border;
            if (PrintMealPlanCatalogComponent.this.showPricing != null) {
                PrintMealPlanCatalogComponent.this.showPricing.setLocation(PrintMealPlanCatalogComponent.this.border, y + PrintMealPlanCatalogComponent.this.border);
                PrintMealPlanCatalogComponent.this.showPricing.setSize(PrintMealPlanCatalogComponent.this.showPricing.getPreferredSize());
                y = PrintMealPlanCatalogComponent.this.showPricing.getY() + PrintMealPlanCatalogComponent.this.showPricing.getHeight() + PrintMealPlanCatalogComponent.this.border / 2;
            }
            if (PrintMealPlanCatalogComponent.this.useEnglishNames != null) {
                PrintMealPlanCatalogComponent.this.useEnglishNames.setLocation(PrintMealPlanCatalogComponent.this.border, y);
                PrintMealPlanCatalogComponent.this.useEnglishNames.setSize(PrintMealPlanCatalogComponent.this.useEnglishNames.getPreferredSize());
                y = PrintMealPlanCatalogComponent.this.useEnglishNames.getY() + PrintMealPlanCatalogComponent.this.useEnglishNames.getHeight() + PrintMealPlanCatalogComponent.this.border / 2;
            }
            if (PrintMealPlanCatalogComponent.this.showDescription != null) {
                PrintMealPlanCatalogComponent.this.showDescription.setLocation(PrintMealPlanCatalogComponent.this.border, y);
                PrintMealPlanCatalogComponent.this.showDescription.setSize(PrintMealPlanCatalogComponent.this.showDescription.getPreferredSize());
                y = PrintMealPlanCatalogComponent.this.showDescription.getY() + PrintMealPlanCatalogComponent.this.showDescription.getHeight() + PrintMealPlanCatalogComponent.this.border / 2;
            }
            if (PrintMealPlanCatalogComponent.this.showArticlesFromRecipeInstaedOfRecipe != null) {
                PrintMealPlanCatalogComponent.this.showArticlesFromRecipeInstaedOfRecipe.setLocation(PrintMealPlanCatalogComponent.this.border, y);
                PrintMealPlanCatalogComponent.this.showArticlesFromRecipeInstaedOfRecipe.setSize(PrintMealPlanCatalogComponent.this.showArticlesFromRecipeInstaedOfRecipe.getPreferredSize());
                y = PrintMealPlanCatalogComponent.this.showArticlesFromRecipeInstaedOfRecipe.getY() + PrintMealPlanCatalogComponent.this.showArticlesFromRecipeInstaedOfRecipe.getHeight() + PrintMealPlanCatalogComponent.this.border;
            }
            if (PrintMealPlanCatalogComponent.this.useHDImages != null) {
                PrintMealPlanCatalogComponent.this.useHDImages.setLocation(PrintMealPlanCatalogComponent.this.border, y);
                PrintMealPlanCatalogComponent.this.useHDImages.setSize(PrintMealPlanCatalogComponent.this.useHDImages.getPreferredSize());
                y = PrintMealPlanCatalogComponent.this.useHDImages.getY() + PrintMealPlanCatalogComponent.this.useHDImages.getHeight() + PrintMealPlanCatalogComponent.this.border;
            }
            if (PrintMealPlanCatalogComponent.this.showTraces != null) {
                PrintMealPlanCatalogComponent.this.showTraces.setLocation(PrintMealPlanCatalogComponent.this.border, y);
                PrintMealPlanCatalogComponent.this.showTraces.setSize(PrintMealPlanCatalogComponent.this.showTraces.getPreferredSize());
                y = PrintMealPlanCatalogComponent.this.showTraces.getY() + PrintMealPlanCatalogComponent.this.showTraces.getHeight() + PrintMealPlanCatalogComponent.this.border / 2;
            }
            if (PrintMealPlanCatalogComponent.this.showAdditives != null) {
                PrintMealPlanCatalogComponent.this.showAdditives.setLocation(PrintMealPlanCatalogComponent.this.border, y);
                PrintMealPlanCatalogComponent.this.showAdditives.setSize(PrintMealPlanCatalogComponent.this.showAdditives.getPreferredSize());
                y = PrintMealPlanCatalogComponent.this.showAdditives.getY() + PrintMealPlanCatalogComponent.this.showAdditives.getHeight() + PrintMealPlanCatalogComponent.this.border / 2;
            }
            if (PrintMealPlanCatalogComponent.this.showOtherDeclarations != null) {
                PrintMealPlanCatalogComponent.this.showOtherDeclarations.setLocation(PrintMealPlanCatalogComponent.this.border, y);
                PrintMealPlanCatalogComponent.this.showOtherDeclarations.setSize(PrintMealPlanCatalogComponent.this.showOtherDeclarations.getPreferredSize());
                y = PrintMealPlanCatalogComponent.this.showOtherDeclarations.getY() + PrintMealPlanCatalogComponent.this.showOtherDeclarations.getHeight() + PrintMealPlanCatalogComponent.this.border / 2;
            }
            if (PrintMealPlanCatalogComponent.this.sortByMealPlan != null) {
                PrintMealPlanCatalogComponent.this.sortByMealPlan.setLocation(PrintMealPlanCatalogComponent.this.border, y);
                PrintMealPlanCatalogComponent.this.sortByMealPlan.setSize(PrintMealPlanCatalogComponent.this.sortByMealPlan.getPreferredSize());
                y = PrintMealPlanCatalogComponent.this.sortByMealPlan.getY() + PrintMealPlanCatalogComponent.this.sortByMealPlan.getHeight() + PrintMealPlanCatalogComponent.this.border / 2;
            }
            if (PrintMealPlanCatalogComponent.this.cycleDefinition != null) {
                PrintMealPlanCatalogComponent.this.cycleDefinition.setLocation(PrintMealPlanCatalogComponent.this.border, y);
                PrintMealPlanCatalogComponent.this.cycleDefinition.setSize(PrintMealPlanCatalogComponent.this.cycleDefinition.getPreferredSize());
                y = PrintMealPlanCatalogComponent.this.cycleDefinition.getY() + PrintMealPlanCatalogComponent.this.cycleDefinition.getHeight() + PrintMealPlanCatalogComponent.this.border;
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = PrintMealPlanCatalogComponent.this.getInheritedComponentsHeight() + PrintMealPlanCatalogComponent.this.border;
            h = (int)((double)h + PrintMealPlanCatalogComponent.this.dueDate.getPreferredSize().getHeight());
            h += PrintMealPlanCatalogComponent.this.border;
            if (PrintMealPlanCatalogComponent.this.showPricing != null) {
                h = (int)((double)h + PrintMealPlanCatalogComponent.this.showPricing.getPreferredSize().getHeight());
                h += PrintMealPlanCatalogComponent.this.border / 2;
            }
            if (PrintMealPlanCatalogComponent.this.useEnglishNames != null) {
                h = (int)((double)h + PrintMealPlanCatalogComponent.this.useEnglishNames.getPreferredSize().getHeight());
                h += PrintMealPlanCatalogComponent.this.border / 2;
            }
            if (PrintMealPlanCatalogComponent.this.useHDImages != null) {
                h = (int)((double)h + PrintMealPlanCatalogComponent.this.useHDImages.getPreferredSize().getHeight());
                h += PrintMealPlanCatalogComponent.this.border / 2;
            }
            if (PrintMealPlanCatalogComponent.this.showDescription != null) {
                h = (int)((double)h + PrintMealPlanCatalogComponent.this.showDescription.getPreferredSize().getHeight());
                h += PrintMealPlanCatalogComponent.this.border / 2;
            }
            if (PrintMealPlanCatalogComponent.this.showArticlesFromRecipeInstaedOfRecipe != null) {
                h = (int)((double)h + PrintMealPlanCatalogComponent.this.showArticlesFromRecipeInstaedOfRecipe.getPreferredSize().getHeight());
                h += PrintMealPlanCatalogComponent.this.border;
            }
            if (PrintMealPlanCatalogComponent.this.showTraces != null) {
                h = (int)((double)h + PrintMealPlanCatalogComponent.this.showTraces.getPreferredSize().getHeight());
                h += PrintMealPlanCatalogComponent.this.border / 2;
            }
            if (PrintMealPlanCatalogComponent.this.showAdditives != null) {
                h = (int)((double)h + PrintMealPlanCatalogComponent.this.showAdditives.getPreferredSize().getHeight());
                h += PrintMealPlanCatalogComponent.this.border / 2;
            }
            if (PrintMealPlanCatalogComponent.this.showOtherDeclarations != null) {
                h = (int)((double)h + PrintMealPlanCatalogComponent.this.showOtherDeclarations.getPreferredSize().getHeight());
                h += PrintMealPlanCatalogComponent.this.border / 2;
            }
            if (PrintMealPlanCatalogComponent.this.sortByMealPlan != null) {
                h = (int)((double)h + PrintMealPlanCatalogComponent.this.sortByMealPlan.getPreferredSize().getHeight());
                h += PrintMealPlanCatalogComponent.this.border / 2;
            }
            if (PrintMealPlanCatalogComponent.this.cycleDefinition != null) {
                h = (int)((double)h + PrintMealPlanCatalogComponent.this.cycleDefinition.getPreferredSize().getHeight());
                h += PrintMealPlanCatalogComponent.this.border;
            }
            return new Dimension(0, h += PrintMealPlanCatalogComponent.this.border);
        }
    }
}

