/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.print.handlingcost.usage;

import ch.icit.pegasus.client.converter.FlightScheduleDetailedConverter;
import ch.icit.pegasus.client.converter.IntegerConverter;
import ch.icit.pegasus.client.converter.StringConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2Model;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.DeleteButton;
import ch.icit.pegasus.client.gui.utils.datechooser.DateChooser;
import ch.icit.pegasus.client.gui.utils.datechooser.DateChooserListener;
import ch.icit.pegasus.client.gui.utils.icons.ToogleSkinIcon;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.popup.inserts.DefaultScrollablePrintPopupInsert;
import ch.icit.pegasus.client.gui.utils.print.APrintConfigurationComplete;
import ch.icit.pegasus.client.gui.utils.print.PrintPopupToolkit;
import ch.icit.pegasus.client.gui.utils.skins.SizedSkin1Field;
import ch.icit.pegasus.client.gui.utils.skins.impls.defaults.DefaultSkins;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.ViewNode;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.search.SearchServiceManager;
import ch.icit.pegasus.client.services.interfaces.supply.SupplyReportServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.SearchException;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightScheduleLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightScheduleLight_;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListTemplateComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListTemplateComplete_;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListTemplateVariantLight_;
import ch.icit.pegasus.server.core.dtos.handlingcost.HandlingCostComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.product.ProductComplete_;
import ch.icit.pegasus.server.core.dtos.product.ProductVariantLight;
import ch.icit.pegasus.server.core.dtos.product.ProductVariantLight_;
import ch.icit.pegasus.server.core.dtos.report.ReportingOutputFormatE;
import ch.icit.pegasus.server.core.dtos.search.ADtoSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.search.FlightScheduleSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.search.ProductVariantSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.search.StowingListTemplateSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.util.SearchResult;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.DateWrapper;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class PrintHandlingCostUseageComponent
extends DefaultScrollablePrintPopupInsert
implements DateChooserListener {
    private static final long serialVersionUID = 1L;
    private final Node<HandlingCostComplete> currentProduct;
    private TitledItem<Table2> table;
    private TitledItem<DateChooser> dateChooser;
    private boolean isLoadingRemains = false;

    public PrintHandlingCostUseageComponent(Node<HandlingCostComplete> currentNode) {
        super(true, false);
        this.currentProduct = currentNode;
        this.getViewContainer().setLayout(new Layout());
    }

    @Override
    public APrintConfigurationComplete<?> getPrintConfiguration() {
        return null;
    }

    private void loadItems() {
        this.isLoadingRemains = true;
        this.popup.enableOKButton(false);
        this.popup.enableCancelButton(false);
        this.removeInheritedComponents();
        this.ensureAnimation(Words.LOAD_DATA);
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                Node next;
                HandlingCostComplete handling = (HandlingCostComplete)PrintHandlingCostUseageComponent.this.currentProduct.getValue();
                ProductVariantSearchConfiguration ps = new ProductVariantSearchConfiguration();
                ps.setHandling(handling);
                ps.setValidityDate(new Timestamp(PrintHandlingCostUseageComponent.this.dateChooser != null ? ((Date)((DateChooser)PrintHandlingCostUseageComponent.this.dateChooser.getElement()).getNode().getValue()).getTime() : System.currentTimeMillis()));
                ps.setNumResults(Integer.MAX_VALUE);
                FlightScheduleSearchConfiguration fs = new FlightScheduleSearchConfiguration();
                fs.setHandling(handling);
                Date dueDate = new Date(PrintHandlingCostUseageComponent.this.dateChooser != null ? ((Date)((DateChooser)PrintHandlingCostUseageComponent.this.dateChooser.getElement()).getNode().getValue()).getTime() : System.currentTimeMillis());
                fs.setFlightPeriod(new PeriodComplete(dueDate, dueDate));
                fs.setNumResults(Integer.MAX_VALUE);
                StowingListTemplateSearchConfiguration ss = new StowingListTemplateSearchConfiguration();
                ss.setValidityDate(new Timestamp(dueDate.getTime()));
                ss.setPeriod(new PeriodComplete(new Date(dueDate.getTime()), new Date(dueDate.getTime())));
                ss.setHandling(handling);
                ss.setNumResults(Integer.MAX_VALUE);
                SearchResult r = ((SearchServiceManager)ServiceManagerRegistry.getService(SearchServiceManager.class)).search((ADtoSearchConfiguration)ps);
                SearchResult r2 = ((SearchServiceManager)ServiceManagerRegistry.getService(SearchServiceManager.class)).search((ADtoSearchConfiguration)fs);
                SearchResult r3 = ((SearchServiceManager)ServiceManagerRegistry.getService(SearchServiceManager.class)).search((ADtoSearchConfiguration)ss);
                ViewNode nn = new ViewNode("");
                Node p1 = INodeCreator.getDefaultImpl().createNodes(r.getResults(), false);
                Node p2 = INodeCreator.getDefaultImpl().createNodes(r2.getResults(), false);
                Node p3 = INodeCreator.getDefaultImpl().createNodes(r3.getResults(), false);
                Iterator it = p1.getChilds();
                while (it.hasNext()) {
                    next = (Node)it.next();
                    nn.addChild(next, 0L);
                }
                it = p2.getChilds();
                while (it.hasNext()) {
                    next = (Node)it.next();
                    nn.addChild(next, 0L);
                }
                it = p3.getChilds();
                while (it.hasNext()) {
                    next = (Node)it.next();
                    nn.addChild(next, 0L);
                }
                return nn;
            }

            @Override
            public RemoteLoader getInvoker() {
                return PrintHandlingCostUseageComponent.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    public void remoteObjectLoaded(Node node) {
        if (this.isLoadingRemains) {
            if (node.getValue() == null) {
                this.popup.enableCancelButton(false);
                if (this.errorMSG == null) {
                    this.removeAnimation(false);
                    if (this.table == null) {
                        this.createInners();
                    }
                    this.dateChooser.setVisible(true);
                    this.table.getElement().getModel().setNode(node);
                    this.createComponents();
                    this.popup.enableCancelButton(true);
                } else {
                    this.removeAnimation(true);
                }
            } else {
                ArrayList<ScreenValidationObject> rets = new ArrayList<ScreenValidationObject>();
                for (SearchException e : (List)node.getValue()) {
                    rets.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, e.getMessage()));
                }
                this.isError = true;
                this.errorMSG = ScreenValidationObject.createMessageString(rets, (String)"Unable to load Handling Cost Usage:");
                this.removeAnimation(true);
            }
            this.isLoadingRemains = false;
        } else {
            super.remoteObjectLoaded(node);
        }
    }

    @Override
    public void setInnerPopUp(InnerPopUp2 ip) {
        super.setInnerPopUp(ip);
        this.createComponents();
        this.loadItems();
    }

    @Override
    public void dateChanged(DateChooser source, java.util.Date selectedDate) {
        this.loadItems();
    }

    @Override
    public void removeInheritedComponents() {
        super.removeInheritedComponents();
        if (this.table != null) {
            this.table.setVisible(false);
        }
        if (this.dateChooser != null) {
            this.dateChooser.setVisible(false);
        }
    }

    private void createInners() {
        this.table = new TitledItem<Table2>(new Table2(false, null, true, false), "HANDLING COST IS USED IN", TitledItem.TitledItemOrientation.NORTH);
        this.table.setIgnorePrefHeight(true);
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        columns.add(new TableColumnInfo("TYPE", null, null, null, "", 90, 90, 90));
        columns.add(new TableColumnInfo("NO", null, null, null, "", TableColumnInfo.numberColumnWidth, TableColumnInfo.numberColumnWidth, TableColumnInfo.numberColumnWidth));
        columns.add(new TableColumnInfo("NAME", null, null, null, "", 80, 80, 80));
        columns.add(new TableColumnInfo("Deleted", null, null, null, "", DeleteButton.getPreferredWidth(SizedSkin1Field.SkinSize.SMALL) + 2 * this.table.getElement().getCellPadding()));
        ((TableColumnInfo)columns.get(0)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(1)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(2)).setxExpand(1.0);
        ((TableColumnInfo)columns.get(3)).setxExpand(0.0);
        this.table.getElement().setModel(new Table2Model(columns, model -> new TableRowImpl(model)));
        this.table.setProgress(1.0f);
        this.dateChooser = new TitledItem<DateChooser>(new DateChooser(INodeCreator.getDefaultImpl().getNode4DTO((Object)new Date(System.currentTimeMillis()), false, false)), Words.DUE_DATE, TitledItem.TitledItemOrientation.NORTH);
        this.dateChooser.getElement().setIsTimestamp(false);
        this.dateChooser.getElement().addDateChooserListener(this);
        this.getViewContainer().add(this.table);
        this.getViewContainer().add(this.dateChooser);
    }

    @Override
    public String getTitleString() {
        return "HANDLING COST NAME";
    }

    @Override
    protected String getProgressText() {
        if (this.isLoadingRemains) {
            return "Load Handling Cost Usage";
        }
        return "Print Handling Cost Usage";
    }

    @Override
    public String getTitleValue() {
        if (this.currentProduct.getChildNamed(new String[]{"name"}) != null) {
            return (String)this.currentProduct.getChildNamed(new String[]{"name"}).getValue();
        }
        return "";
    }

    @Override
    public boolean withSecondSeparator() {
        return true;
    }

    @Override
    protected void startPrinting() {
        super.startPrinting();
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                Date dueDate = (Date)((DateChooser)PrintHandlingCostUseageComponent.this.dateChooser.getElement()).getNode().getValue();
                PegasusFileComplete file = (PegasusFileComplete)((SupplyReportServiceManager)ServiceManagerRegistry.getService(SupplyReportServiceManager.class)).printHandlingUsage((HandlingCostComplete)PrintHandlingCostUseageComponent.this.currentProduct.getValue(), new DateWrapper(dueDate), ReportingOutputFormatE.XLSX).getValue();
                PrintPopupToolkit.previewFile(file);
                return new ViewNode("");
            }

            @Override
            public RemoteLoader getInvoker() {
                return PrintHandlingCostUseageComponent.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        return new Object[0];
    }

    @Override
    public boolean isClosableWithEnter() {
        return true;
    }

    @Override
    public boolean isInnerComponent(Component c) {
        return super.isInnerComponent(c);
    }

    private class TableRowImpl
    extends Table2RowPanel {
        private static final long serialVersionUID = 1L;
        private TextLabel type;
        private TextLabel number;
        private TextLabel name;
        private ToogleSkinIcon skin;

        public TableRowImpl(Table2RowModel m) {
            super(m);
            boolean deleted = false;
            this.type = new TextLabel();
            if (m.getNode().getValue() instanceof ProductVariantLight) {
                this.type.setText("Product");
                this.name = new TextLabel(m.getNode().getChildNamed(ProductVariantLight_.name), ConverterRegistry.getConverter(StringConverter.class));
                if (m.getNode().getChildNamed(ProductVariantLight_.product).getValue() != null) {
                    this.number = new TextLabel(m.getNode().getChildNamed(new DtoField[]{ProductVariantLight_.product, ProductComplete_.number}), ConverterRegistry.getConverter(IntegerConverter.class));
                    deleted = ((ProductVariantLight)m.getNode().getValue()).getProduct().getIsDeleted();
                } else {
                    this.number = new TextLabel(m.getNode().getChildNamed(ProductVariantLight_.productNumber), ConverterRegistry.getConverter(IntegerConverter.class));
                    deleted = ((ProductVariantLight)m.getNode().getValue()).getProductDeleted();
                }
            } else if (m.getNode().getValue() instanceof StowingListTemplateComplete) {
                this.type.setText("Stowing");
                this.name = new TextLabel(m.getNode().getChildNamed(new DtoField[]{StowingListTemplateComplete_.currentVariant, StowingListTemplateVariantLight_.name}));
                this.number = new TextLabel(m.getNode().getChildNamed(StowingListTemplateComplete_.number), ConverterRegistry.getConverter(IntegerConverter.class));
                deleted = ((StowingListTemplateComplete)m.getNode().getValue()).getIsDeleted();
            } else if (m.getNode().getValue() instanceof FlightScheduleLight) {
                this.type.setText("Fli.Sched.");
                this.name = new TextLabel(m.getNode(), ConverterRegistry.getConverter(FlightScheduleDetailedConverter.class));
                this.number = new TextLabel(m.getNode().getChildNamed(FlightScheduleLight_.number), ConverterRegistry.getConverter(IntegerConverter.class));
                deleted = ((FlightScheduleLight)m.getNode().getValue()).getIsDeleted();
            } else {
                this.number = new TextLabel();
                this.name = new TextLabel();
            }
            this.skin = new ToogleSkinIcon(DefaultSkins.CheckCrossBoxIcon, !deleted);
            this.type.setProgress(1.0f);
            this.number.setProgress(1.0f);
            this.name.setProgress(1.0f);
            this.skin.setProgress(1.0f);
            this.setLayout(new Layout());
            this.add(this.type);
            this.add(this.number);
            this.add(this.name);
            this.add(this.skin);
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.type.kill();
            this.number.kill();
            this.name.kill();
            this.skin.kill();
            this.type = null;
            this.number = null;
            this.name = null;
            this.skin = null;
        }

        @Override
        public List<Component> getFocusComponents() {
            return null;
        }

        @Override
        public Object getObject4Column(int column) {
            switch (column) {
                case 0: {
                    return this.type.getText();
                }
                case 1: {
                    return this.model.getNode().getChildNamed(new String[]{"number"}).getValue();
                }
                case 2: {
                    return this.model.getNode().getChildNamed(new String[]{"name"}).getValue();
                }
                case 3: {
                    return null;
                }
            }
            return null;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            this.type.setEnabled(isEnabled);
            this.number.setEnabled(isEnabled);
            this.name.setEnabled(isEnabled);
            this.skin.setEnabled(isEnabled);
        }

        private class Layout
        extends DefaultLayout {
            private Layout() {
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TableRowImpl.this.getDefaultRowHeight());
            }

            @Override
            public void layoutContainer(Container parent) {
                int currentX = 0;
                int w = TableRowImpl.this.model.getParentModel().getColumnWidth(0);
                TableRowImpl.this.type.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.type.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.type.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.type.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(1);
                TableRowImpl.this.number.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.number.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.number.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.number.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(2);
                TableRowImpl.this.name.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.name.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.name.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.name.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(3);
                TableRowImpl.this.skin.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.skin.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.skin.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.skin.getPreferredSize().getHeight());
            }
        }
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int cy = PrintHandlingCostUseageComponent.this.layoutInheritedComponents(parent);
            cy += PrintHandlingCostUseageComponent.this.border;
            if (PrintHandlingCostUseageComponent.this.dateChooser != null) {
                PrintHandlingCostUseageComponent.this.dateChooser.setLocation(PrintHandlingCostUseageComponent.this.border, cy);
                PrintHandlingCostUseageComponent.this.dateChooser.setSize(PrintHandlingCostUseageComponent.this.dateChooser.getPreferredSize());
                cy = PrintHandlingCostUseageComponent.this.dateChooser.getY() + PrintHandlingCostUseageComponent.this.dateChooser.getHeight() + PrintHandlingCostUseageComponent.this.border;
            }
            if (PrintHandlingCostUseageComponent.this.table != null) {
                PrintHandlingCostUseageComponent.this.table.setLocation(PrintHandlingCostUseageComponent.this.border, cy);
                PrintHandlingCostUseageComponent.this.table.setSize(parent.getWidth() - 2 * PrintHandlingCostUseageComponent.this.border, parent.getHeight() - (cy + PrintHandlingCostUseageComponent.this.border));
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = PrintHandlingCostUseageComponent.this.getInheritedComponentsHeight() + PrintHandlingCostUseageComponent.this.border;
            return new Dimension(0, h);
        }
    }
}

