/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.export.twm.combined;

import ch.icit.pegasus.client.MainFrame;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.file.FileChooserUtil;
import ch.icit.pegasus.client.gui.utils.filterchain.FilterChainConfiguration;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.popup.inserts.DefaultScrollablePrintPopupInsert;
import ch.icit.pegasus.client.gui.utils.print.APrintConfigurationComplete;
import ch.icit.pegasus.client.io.FileTransferListener;
import ch.icit.pegasus.client.io.FileTransferState;
import ch.icit.pegasus.client.io.FileTransferUtil;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.DefaultServiceManager;
import ch.icit.pegasus.client.services.interfaces.supply.ThreeWayMatchServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.DownloadState;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.UserLight;
import ch.icit.pegasus.server.core.dtos.report.twm.TWMCombinedExportConfiguration;
import ch.icit.pegasus.server.core.dtos.threewaymatch.ThreeWayMatchLight;
import ch.icit.pegasus.server.core.dtos.threewaymatch.ThreeWayMatchLight_;
import ch.icit.pegasus.server.core.dtos.threewaymatch.ThreeWayMatchReference;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Container;
import java.awt.Dimension;
import java.io.File;

public class ExportTWMOrderInvoiceComponent
extends DefaultScrollablePrintPopupInsert
implements FileTransferListener {
    private static final long serialVersionUID = 1L;
    private Node<ThreeWayMatchLight> currentNode;
    private DownloadState downloaded;
    private File sourceFile;
    private File destinationFile;
    private boolean isOverride;
    private TextLabel options;
    private TitledItem<CheckBox> includeSummary;
    private TitledItem<CheckBox> includeNoSupplierInvoices;
    private TitledItem<CheckBox> includeNoOrderInvoices;
    private TitledItem<CheckBox> includeValueDifferenceInvoices;
    private TitledItem<CheckBox> includeAcceptedInvoices;
    private TitledItem<CheckBox> includeAllInvoices;
    private TitledItem<CheckBox> includeManuallyAcceptedInvoices;
    private TitledItem<CheckBox> includeSupplierOverview;
    private TitledItem<CheckBox> includeCanceledInvoices;
    private TitledItem<CheckBox> includeAllOrders;
    private TitledItem<CheckBox> useOnlyAttachedOrders;
    private TitledItem<CheckBox> includeApprovedOrders;
    private TitledItem<CheckBox> includeNotApprovedOrders;
    private TitledItem<CheckBox> includeNotCheckedOrders;
    private TitledItem<CheckBox> includeCustomerOwnedOrders;
    private TitledItem<CheckBox> ignoreUncheckedOrders;
    private TitledItem<ComboBox> sortBy;

    public ExportTWMOrderInvoiceComponent(Node<ThreeWayMatchLight> currentNode) {
        super(false, false);
        this.currentNode = currentNode;
        this.getViewContainer().setLayout(new Layout());
        this.createComponents();
    }

    @Override
    public void createComponents() {
        super.createComponents();
        this.options = new TextLabel(Words.OPTIONS);
        this.includeSummary = new TitledItem<CheckBox>(new CheckBox(), "Include Summary Sheet", TitledItem.TitledItemOrientation.EAST);
        this.includeAcceptedInvoices = new TitledItem<CheckBox>(new CheckBox(), "Include accepted Invoices Sheet", TitledItem.TitledItemOrientation.EAST);
        this.includeNoSupplierInvoices = new TitledItem<CheckBox>(new CheckBox(), "Include no Supplier Invoices Sheet", TitledItem.TitledItemOrientation.EAST);
        this.includeNoOrderInvoices = new TitledItem<CheckBox>(new CheckBox(), "Include no Order Invoices Sheet", TitledItem.TitledItemOrientation.EAST);
        this.includeValueDifferenceInvoices = new TitledItem<CheckBox>(new CheckBox(), "Include value difference Invoices Sheet", TitledItem.TitledItemOrientation.EAST);
        this.includeAllInvoices = new TitledItem<CheckBox>(new CheckBox(), "Include all Invoices Sheet", TitledItem.TitledItemOrientation.EAST);
        this.includeManuallyAcceptedInvoices = new TitledItem<CheckBox>(new CheckBox(), "Include manually accepted Invoices Sheet", TitledItem.TitledItemOrientation.EAST);
        this.includeSupplierOverview = new TitledItem<CheckBox>(new CheckBox(), "Include Supplier Summary Sheet", TitledItem.TitledItemOrientation.EAST);
        this.includeCanceledInvoices = new TitledItem<CheckBox>(new CheckBox(), "Include cancelled Invoices Sheet", TitledItem.TitledItemOrientation.EAST);
        this.includeAllOrders = new TitledItem<CheckBox>(new CheckBox(), "Include all Orders Sheet", TitledItem.TitledItemOrientation.EAST);
        this.includeApprovedOrders = new TitledItem<CheckBox>(new CheckBox(), "Include approved Orders Sheet", TitledItem.TitledItemOrientation.EAST);
        this.includeNotApprovedOrders = new TitledItem<CheckBox>(new CheckBox(), "Include not approved Orders Sheet", TitledItem.TitledItemOrientation.EAST);
        this.includeNotCheckedOrders = new TitledItem<CheckBox>(new CheckBox(), "Include not checked Orders Sheet", TitledItem.TitledItemOrientation.EAST);
        this.includeCustomerOwnedOrders = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_CUSTOMER_OWNED_ORDERS, TitledItem.TitledItemOrientation.EAST);
        this.useOnlyAttachedOrders = new TitledItem<CheckBox>(new CheckBox(), Words.USE_ONLY_ATTACHED_ORDERS, TitledItem.TitledItemOrientation.EAST);
        this.ignoreUncheckedOrders = new TitledItem<CheckBox>(new CheckBox(), Words.IGNORE_ORDER_STATE_CHECK, TitledItem.TitledItemOrientation.EAST);
        this.sortBy = new TitledItem<ComboBox>(new ComboBox(), Words.SORT_BY, TitledItem.TitledItemOrientation.NORTH);
        this.sortBy.getElement().addItem(Words.SUPPLIER);
        this.sortBy.getElement().addItem(Words.DATE);
        this.sortBy.getElement().addItem(Words.NONE);
        this.readConfiguration();
        this.getViewContainer().add(this.options);
        this.getViewContainer().add(this.includeSummary);
        this.getViewContainer().add(this.includeAcceptedInvoices);
        this.getViewContainer().add(this.includeNoSupplierInvoices);
        this.getViewContainer().add(this.includeNoOrderInvoices);
        this.getViewContainer().add(this.includeValueDifferenceInvoices);
        this.getViewContainer().add(this.includeAllInvoices);
        this.getViewContainer().add(this.includeManuallyAcceptedInvoices);
        this.getViewContainer().add(this.includeSupplierOverview);
        this.getViewContainer().add(this.includeCanceledInvoices);
        this.getViewContainer().add(this.includeAllOrders);
        this.getViewContainer().add(this.includeApprovedOrders);
        this.getViewContainer().add(this.includeNotApprovedOrders);
        this.getViewContainer().add(this.includeNotCheckedOrders);
        this.getViewContainer().add(this.useOnlyAttachedOrders);
        this.getViewContainer().add(this.ignoreUncheckedOrders);
        this.getViewContainer().add(this.includeCustomerOwnedOrders);
        this.getViewContainer().add(this.sortBy);
    }

    private void readConfiguration() {
        FilterChainConfiguration config = FilterChainConfiguration.loadConfiguration(this.getClass().getSimpleName(), (UserLight)((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentUser(), ((DefaultServiceManager)ServiceManagerRegistry.getService(DefaultServiceManager.class)).getServerName(), ((DefaultServiceManager)ServiceManagerRegistry.getService(DefaultServiceManager.class)).getCustomerCode());
        if (config != null) {
            for (String[] s : config.getProperties()) {
                String n = s[0];
                String v = s[1];
                Boolean b = Boolean.valueOf(v);
                switch (n) {
                    case "includeSummary": {
                        this.includeSummary.getElement().setChecked(b);
                        break;
                    }
                    case "includeAcceptedInvoices": {
                        this.includeAcceptedInvoices.getElement().setChecked(b);
                        break;
                    }
                    case "includeNoSupplierInvoices": {
                        this.includeNoSupplierInvoices.getElement().setChecked(b);
                        break;
                    }
                    case "includeNoOrderInvoices": {
                        this.includeNoOrderInvoices.getElement().setChecked(b);
                        break;
                    }
                    case "includeValueDifferenceInvoices": {
                        this.includeValueDifferenceInvoices.getElement().setChecked(b);
                        break;
                    }
                    case "includeAllInvoices": {
                        this.includeAllInvoices.getElement().setChecked(b);
                        break;
                    }
                    case "includeManuallyAcceptedInvoices": {
                        this.includeManuallyAcceptedInvoices.getElement().setChecked(b);
                        break;
                    }
                    case "includeSupplierOverview": {
                        this.includeSupplierOverview.getElement().setChecked(b);
                        break;
                    }
                    case "includeCanceledInvoices": {
                        this.includeCanceledInvoices.getElement().setChecked(b);
                        break;
                    }
                    case "includeAllOrders": {
                        this.includeAllOrders.getElement().setChecked(b);
                        break;
                    }
                    case "includeApprovedOrders": {
                        this.includeApprovedOrders.getElement().setChecked(b);
                        break;
                    }
                    case "includeNotApprovedOrders": {
                        this.includeNotApprovedOrders.getElement().setChecked(b);
                        break;
                    }
                    case "includeNotCheckedOrders": {
                        this.includeNotCheckedOrders.getElement().setChecked(b);
                        break;
                    }
                    case "useOnlyAttachedOrders": {
                        this.useOnlyAttachedOrders.getElement().setChecked(b);
                        break;
                    }
                    case "ignoreUncheckedOrders": {
                        this.ignoreUncheckedOrders.getElement().setChecked(b);
                        break;
                    }
                    case "includeCustomerOwnedOrders": {
                        this.includeCustomerOwnedOrders.getElement().setChecked(b);
                    }
                }
            }
        }
    }

    private void writeConfiguration() {
        FilterChainConfiguration conf = new FilterChainConfiguration();
        conf.addProperty("includeSummary", "" + this.includeSummary.getElement().isChecked());
        conf.addProperty("includeAcceptedInvoices", "" + this.includeAcceptedInvoices.getElement().isChecked());
        conf.addProperty("includeNoSupplierInvoices", "" + this.includeNoSupplierInvoices.getElement().isChecked());
        conf.addProperty("includeNoOrderInvoices", "" + this.includeNoOrderInvoices.getElement().isChecked());
        conf.addProperty("includeValueDifferenceInvoices", "" + this.includeValueDifferenceInvoices.getElement().isChecked());
        conf.addProperty("includeAllInvoices", "" + this.includeAllInvoices.getElement().isChecked());
        conf.addProperty("includeManuallyAcceptedInvoices", "" + this.includeManuallyAcceptedInvoices.getElement().isChecked());
        conf.addProperty("includeSupplierOverview", "" + this.includeSupplierOverview.getElement().isChecked());
        conf.addProperty("includeCanceledInvoices", "" + this.includeCanceledInvoices.getElement().isChecked());
        conf.addProperty("includeAllOrders", "" + this.includeAllOrders.getElement().isChecked());
        conf.addProperty("includeApprovedOrders", "" + this.includeApprovedOrders.getElement().isChecked());
        conf.addProperty("includeNotApprovedOrders", "" + this.includeNotApprovedOrders.getElement().isChecked());
        conf.addProperty("includeNotCheckedOrders", "" + this.includeNotCheckedOrders.getElement().isChecked());
        conf.addProperty("useOnlyAttachedOrders", "" + this.useOnlyAttachedOrders.getElement().isChecked());
        conf.addProperty("ignoreUncheckedOrders", "" + this.ignoreUncheckedOrders.getElement().isChecked());
        conf.addProperty("includeCustomerOwnedOrders", "" + this.includeCustomerOwnedOrders.getElement().isChecked());
        FilterChainConfiguration.saveConfiguration(this.getClass().getSimpleName(), (UserLight)((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentUser(), conf, ((DefaultServiceManager)ServiceManagerRegistry.getService(DefaultServiceManager.class)).getServerName(), ((DefaultServiceManager)ServiceManagerRegistry.getService(DefaultServiceManager.class)).getCustomerCode());
    }

    @Override
    public void removeInheritedComponents() {
        super.removeInheritedComponents();
        this.options.setVisible(false);
        this.includeSummary.setVisible(false);
        this.includeAcceptedInvoices.setVisible(false);
        this.includeNoSupplierInvoices.setVisible(false);
        this.includeNoOrderInvoices.setVisible(false);
        this.includeValueDifferenceInvoices.setVisible(false);
        this.includeAllInvoices.setVisible(false);
        this.includeManuallyAcceptedInvoices.setVisible(false);
        this.includeSupplierOverview.setVisible(false);
        this.includeCanceledInvoices.setVisible(false);
        this.includeAllOrders.setVisible(false);
        this.includeApprovedOrders.setVisible(false);
        this.includeNotApprovedOrders.setVisible(false);
        this.includeNotCheckedOrders.setVisible(false);
        this.useOnlyAttachedOrders.setVisible(false);
        this.ignoreUncheckedOrders.setVisible(false);
        this.includeCustomerOwnedOrders.setVisible(false);
        this.sortBy.setVisible(false);
    }

    @Override
    public void showInheritedComponents() {
        super.showInheritedComponents();
        this.options.setVisible(true);
        this.includeSummary.setVisible(true);
        this.includeAcceptedInvoices.setVisible(true);
        this.includeNoSupplierInvoices.setVisible(true);
        this.includeNoOrderInvoices.setVisible(true);
        this.includeValueDifferenceInvoices.setVisible(true);
        this.includeAllInvoices.setVisible(true);
        this.includeManuallyAcceptedInvoices.setVisible(true);
        this.includeSupplierOverview.setVisible(true);
        this.includeCanceledInvoices.setVisible(true);
        this.includeAllOrders.setVisible(true);
        this.includeApprovedOrders.setVisible(true);
        this.includeNotApprovedOrders.setVisible(true);
        this.includeNotCheckedOrders.setVisible(true);
        this.useOnlyAttachedOrders.setVisible(true);
        this.ignoreUncheckedOrders.setVisible(true);
        this.includeCustomerOwnedOrders.setVisible(true);
        this.sortBy.setVisible(true);
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.options != null) {
            this.options.kill();
        }
        this.options = null;
        if (this.includeSummary != null) {
            this.includeSummary.kill();
        }
        this.includeSummary = null;
        if (this.includeSupplierOverview != null) {
            this.includeSupplierOverview.kill();
        }
        this.includeSupplierOverview = null;
        if (this.includeAcceptedInvoices != null) {
            this.includeAcceptedInvoices.kill();
        }
        this.includeAcceptedInvoices = null;
        if (this.includeNoSupplierInvoices != null) {
            this.includeNoSupplierInvoices.kill();
        }
        this.includeNoSupplierInvoices = null;
        if (this.includeNoOrderInvoices != null) {
            this.includeNoOrderInvoices.kill();
        }
        this.includeNoOrderInvoices = null;
        if (this.includeValueDifferenceInvoices != null) {
            this.includeValueDifferenceInvoices.kill();
        }
        this.includeValueDifferenceInvoices = null;
        if (this.includeManuallyAcceptedInvoices != null) {
            this.includeManuallyAcceptedInvoices.kill();
        }
        this.includeManuallyAcceptedInvoices = null;
        if (this.includeAllInvoices != null) {
            this.includeAllInvoices.kill();
        }
        this.includeAllInvoices = null;
        if (this.includeCanceledInvoices != null) {
            this.includeCanceledInvoices.kill();
        }
        this.includeCanceledInvoices = null;
        if (this.includeAllOrders != null) {
            this.includeAllOrders.kill();
        }
        this.includeAllOrders = null;
        if (this.includeApprovedOrders != null) {
            this.includeApprovedOrders.kill();
        }
        this.includeApprovedOrders = null;
        if (this.includeNotApprovedOrders != null) {
            this.includeNotApprovedOrders.kill();
        }
        this.includeNotApprovedOrders = null;
        if (this.includeNotCheckedOrders != null) {
            this.includeNotCheckedOrders.kill();
        }
        this.includeNotCheckedOrders = null;
        if (this.sortBy != null) {
            this.sortBy.kill();
        }
        this.sortBy = null;
        if (this.useOnlyAttachedOrders != null) {
            this.useOnlyAttachedOrders.kill();
        }
        this.useOnlyAttachedOrders = null;
        if (this.ignoreUncheckedOrders != null) {
            this.ignoreUncheckedOrders.kill();
        }
        this.ignoreUncheckedOrders = null;
        if (this.includeCustomerOwnedOrders != null) {
            this.includeCustomerOwnedOrders.kill();
        }
        this.includeCustomerOwnedOrders = null;
    }

    @Override
    public APrintConfigurationComplete<?> getPrintConfiguration() {
        return null;
    }

    public void downloadFile(PegasusFileComplete fileReference) throws Exception {
        FileTransferUtil.download((PegasusFileComplete)fileReference, (FileTransferListener[])new FileTransferListener[]{this});
    }

    @Override
    public String getTitleString() {
        return "Three Way Match";
    }

    @Override
    public String getTitleValue() {
        String t = "???";
        if (this.currentNode.getChildNamed(ThreeWayMatchLight_.number).getValue() != null) {
            t = "" + this.currentNode.getChildNamed(ThreeWayMatchLight_.number).getValue() + " - " + (String)this.currentNode.getChildNamed(ThreeWayMatchLight_.name).getValue();
        }
        return t;
    }

    @Override
    protected String getProgressText() {
        return "Create Order & Invoice Export";
    }

    @Override
    protected String getFinishedText() {
        return "Export finished";
    }

    @Override
    public boolean isClosableWithEnter() {
        return false;
    }

    @Override
    public boolean withSecondSeparator() {
        return true;
    }

    @Override
    protected void startPrinting() {
        super.startPrinting();
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                ExportTWMOrderInvoiceComponent.this.writeConfiguration();
                ThreeWayMatchReference r = (ThreeWayMatchReference)ExportTWMOrderInvoiceComponent.this.currentNode.getValue(ThreeWayMatchReference.class);
                TWMCombinedExportConfiguration config = new TWMCombinedExportConfiguration();
                config.setIncludeAcceptedInvoices(((CheckBox)ExportTWMOrderInvoiceComponent.this.includeAcceptedInvoices.getElement()).isChecked());
                config.setIncludeNoSupplierInvoices(((CheckBox)ExportTWMOrderInvoiceComponent.this.includeNoSupplierInvoices.getElement()).isChecked());
                config.setIncludeNoOrderInvoices(((CheckBox)ExportTWMOrderInvoiceComponent.this.includeNoOrderInvoices.getElement()).isChecked());
                config.setIncludeValueDifferenceInvoices(((CheckBox)ExportTWMOrderInvoiceComponent.this.includeValueDifferenceInvoices.getElement()).isChecked());
                config.setIncludeAllInvoices(((CheckBox)ExportTWMOrderInvoiceComponent.this.includeAllInvoices.getElement()).isChecked());
                config.setIncludeManuallyAcceptedInvoices(((CheckBox)ExportTWMOrderInvoiceComponent.this.includeManuallyAcceptedInvoices.getElement()).isChecked());
                config.setIncludeSummary(((CheckBox)ExportTWMOrderInvoiceComponent.this.includeSummary.getElement()).isChecked());
                config.setIncludeSupplierOverview(((CheckBox)ExportTWMOrderInvoiceComponent.this.includeSupplierOverview.getElement()).isChecked());
                config.setIncludeCanceledInvoices(((CheckBox)ExportTWMOrderInvoiceComponent.this.includeCanceledInvoices.getElement()).isChecked());
                config.setIncludeAllOrders(((CheckBox)ExportTWMOrderInvoiceComponent.this.includeAllOrders.getElement()).isChecked());
                config.setIncludeApprovedOrders(((CheckBox)ExportTWMOrderInvoiceComponent.this.includeApprovedOrders.getElement()).isChecked());
                config.setIncludeNotApprovedOrders(((CheckBox)ExportTWMOrderInvoiceComponent.this.includeNotApprovedOrders.getElement()).isChecked());
                config.setIncludeNotCheckedOrders(((CheckBox)ExportTWMOrderInvoiceComponent.this.includeNotCheckedOrders.getElement()).isChecked());
                config.setIncludeSummary(((CheckBox)ExportTWMOrderInvoiceComponent.this.includeSummary.getElement()).isChecked());
                config.setIncludeSupplierOverview(((CheckBox)ExportTWMOrderInvoiceComponent.this.includeSupplierOverview.getElement()).isChecked());
                config.setShowOnlyAttachedOrders(((CheckBox)ExportTWMOrderInvoiceComponent.this.useOnlyAttachedOrders.getElement()).isChecked());
                config.setIgnoreUncheckedOrders(((CheckBox)ExportTWMOrderInvoiceComponent.this.ignoreUncheckedOrders.getElement()).isChecked());
                config.setIncludeCustomerOwnedOrders(((CheckBox)ExportTWMOrderInvoiceComponent.this.includeCustomerOwnedOrders.getElement()).isChecked());
                if (((ComboBox)ExportTWMOrderInvoiceComponent.this.sortBy.getElement()).getSelectedItem().equals(Words.SUPPLIER)) {
                    config.setSortBySupplier(true);
                } else if (((ComboBox)ExportTWMOrderInvoiceComponent.this.sortBy.getElement()).getSelectedItem().equals(Words.DATE)) {
                    config.setSortByDate(true);
                } else if (((ComboBox)ExportTWMOrderInvoiceComponent.this.sortBy.getElement()).getSelectedItem().equals(Words.NONE)) {
                    config.setSortByNone(true);
                }
                PegasusFileComplete file = (PegasusFileComplete)((ThreeWayMatchServiceManager)ServiceManagerRegistry.getService(ThreeWayMatchServiceManager.class)).createOrderInvoiceExport(r, config).getValue();
                ExportTWMOrderInvoiceComponent.this.downloadFile(file);
                return null;
            }

            @Override
            public RemoteLoader getInvoker() {
                return ExportTWMOrderInvoiceComponent.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public void remoteObjectLoaded(Node<?> node) {
        this.removeAnimation(false);
        if (this.downloaded == DownloadState.DOWNLOADED) {
            if (this.errorMSG != null) {
                this.showMessage(this.errorMSG);
                this.popup.setOkButtonText("CLOSE");
                this.popup.hideCancelButton();
            } else {
                super.remoteObjectLoaded(node);
            }
        } else if (this.downloaded != DownloadState.NOT_SAVED) {
            this.showMessage("Exported");
        }
        this.popup.enableCancelButton(true);
    }

    public void statusChanged(File file, FileTransferState state) {
        if (state.getState() == FileTransferState.State.FINISHED) {
            this.downloaded = DownloadState.DOWNLOADED;
            this.showSaveDialog(file);
        } else if (state.getState() != FileTransferState.State.NEW) {
            double d = (double)state.getTransferred() / (double)state.getSize();
            int i = (int)(d *= 100.0);
            this.animation.stateChanged("Download " + i + "%");
        }
    }

    @Override
    public void enterPressed(PopupAction isOK) {
        if (!this.isOverride) {
            super.enterPressed(isOK);
        } else {
            this.isOverride = false;
            if (this.destinationFile.exists()) {
                this.destinationFile.delete();
            }
            this.moveFile(this.sourceFile, this.destinationFile);
            this.popup.setCancelButtonText("Cancel");
            this.popup.enableCancelButton(false);
            this.downloaded = null;
            this.remoteObjectLoaded(this.currentNode);
        }
    }

    private void showSaveDialog(File file) {
        MainFrame.isTempRelease = true;
        File f = FileChooserUtil.saveFile(".xlsx");
        if (f != null) {
            File selectedFile = f;
            if (selectedFile.exists()) {
                this.sourceFile = file;
                this.destinationFile = selectedFile;
                this.isOverride = true;
                this.downloaded = DownloadState.NOT_SAVED;
                this.errorMSG = "File already exists. Do you want to override it?";
                this.removeInheritedComponents();
                this.processReturnValue(this.errorMSG);
                this.showMessage(this.errorMSG);
            } else {
                this.moveFile(file, selectedFile);
            }
        } else {
            this.downloaded = DownloadState.NOT_SAVED;
            this.removeInheritedComponents();
            this.popup.enableCancelButton(false);
            this.showMessage("<b>Operation canceled!</b>");
        }
        MainFrame.isTempRelease = false;
    }

    private void processReturnValue(String t) {
        if (t != null && t.isEmpty()) {
            t = null;
        }
        if (t == null) {
            this.isError = false;
            this.errorMSG = null;
        } else {
            this.isError = true;
            this.errorMSG = t;
        }
    }

    private void moveFile(File source, File destination) {
        try {
            if (!source.renameTo(destination)) {
                this.errorMSG = "Unable to save file";
            } else {
                this.showMessage("Exported");
            }
        }
        catch (Exception e) {
            this.errorMSG = e.getMessage();
        }
        this.isOverride = false;
    }

    public void exceptionOccurred(Exception exception) {
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        return null;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int y = ExportTWMOrderInvoiceComponent.this.layoutInheritedComponents(parent);
            ExportTWMOrderInvoiceComponent.this.options.setLocation(ExportTWMOrderInvoiceComponent.this.border, y + ExportTWMOrderInvoiceComponent.this.border);
            ExportTWMOrderInvoiceComponent.this.options.setSize(ExportTWMOrderInvoiceComponent.this.options.getPreferredSize());
            y = ExportTWMOrderInvoiceComponent.this.options.getY() + ExportTWMOrderInvoiceComponent.this.options.getHeight();
            ExportTWMOrderInvoiceComponent.this.includeSummary.setLocation(ExportTWMOrderInvoiceComponent.this.border, y + ExportTWMOrderInvoiceComponent.this.border);
            ExportTWMOrderInvoiceComponent.this.includeSummary.setSize(parent.getWidth() - 2 * ExportTWMOrderInvoiceComponent.this.border, (int)ExportTWMOrderInvoiceComponent.this.includeSummary.getPreferredSize().getHeight());
            y = ExportTWMOrderInvoiceComponent.this.includeSummary.getY() + ExportTWMOrderInvoiceComponent.this.includeSummary.getHeight();
            ExportTWMOrderInvoiceComponent.this.includeSupplierOverview.setLocation(ExportTWMOrderInvoiceComponent.this.border, y + ExportTWMOrderInvoiceComponent.this.border / 4);
            ExportTWMOrderInvoiceComponent.this.includeSupplierOverview.setSize(parent.getWidth() - 2 * ExportTWMOrderInvoiceComponent.this.border, (int)ExportTWMOrderInvoiceComponent.this.includeSupplierOverview.getPreferredSize().getHeight());
            y = ExportTWMOrderInvoiceComponent.this.includeSupplierOverview.getY() + ExportTWMOrderInvoiceComponent.this.includeSupplierOverview.getHeight();
            ExportTWMOrderInvoiceComponent.this.includeAllInvoices.setLocation(ExportTWMOrderInvoiceComponent.this.border, y + ExportTWMOrderInvoiceComponent.this.border);
            ExportTWMOrderInvoiceComponent.this.includeAllInvoices.setSize(parent.getWidth() - 2 * ExportTWMOrderInvoiceComponent.this.border, (int)ExportTWMOrderInvoiceComponent.this.includeAllInvoices.getPreferredSize().getHeight());
            y = ExportTWMOrderInvoiceComponent.this.includeAllInvoices.getY() + ExportTWMOrderInvoiceComponent.this.includeAllInvoices.getHeight();
            ExportTWMOrderInvoiceComponent.this.includeAcceptedInvoices.setLocation(ExportTWMOrderInvoiceComponent.this.border, y + ExportTWMOrderInvoiceComponent.this.border / 4);
            ExportTWMOrderInvoiceComponent.this.includeAcceptedInvoices.setSize(parent.getWidth() - 2 * ExportTWMOrderInvoiceComponent.this.border, (int)ExportTWMOrderInvoiceComponent.this.includeAcceptedInvoices.getPreferredSize().getHeight());
            y = ExportTWMOrderInvoiceComponent.this.includeAcceptedInvoices.getY() + ExportTWMOrderInvoiceComponent.this.includeAcceptedInvoices.getHeight();
            ExportTWMOrderInvoiceComponent.this.includeManuallyAcceptedInvoices.setLocation(ExportTWMOrderInvoiceComponent.this.border, y + ExportTWMOrderInvoiceComponent.this.border / 4);
            ExportTWMOrderInvoiceComponent.this.includeManuallyAcceptedInvoices.setSize(parent.getWidth() - 2 * ExportTWMOrderInvoiceComponent.this.border, (int)ExportTWMOrderInvoiceComponent.this.includeManuallyAcceptedInvoices.getPreferredSize().getHeight());
            y = ExportTWMOrderInvoiceComponent.this.includeManuallyAcceptedInvoices.getY() + ExportTWMOrderInvoiceComponent.this.includeManuallyAcceptedInvoices.getHeight();
            ExportTWMOrderInvoiceComponent.this.includeValueDifferenceInvoices.setLocation(ExportTWMOrderInvoiceComponent.this.border, y + ExportTWMOrderInvoiceComponent.this.border / 4);
            ExportTWMOrderInvoiceComponent.this.includeValueDifferenceInvoices.setSize(parent.getWidth() - 2 * ExportTWMOrderInvoiceComponent.this.border, (int)ExportTWMOrderInvoiceComponent.this.includeValueDifferenceInvoices.getPreferredSize().getHeight());
            y = ExportTWMOrderInvoiceComponent.this.includeValueDifferenceInvoices.getY() + ExportTWMOrderInvoiceComponent.this.includeValueDifferenceInvoices.getHeight();
            ExportTWMOrderInvoiceComponent.this.includeNoSupplierInvoices.setLocation(ExportTWMOrderInvoiceComponent.this.border, y + ExportTWMOrderInvoiceComponent.this.border / 4);
            ExportTWMOrderInvoiceComponent.this.includeNoSupplierInvoices.setSize(parent.getWidth() - 2 * ExportTWMOrderInvoiceComponent.this.border, (int)ExportTWMOrderInvoiceComponent.this.includeNoSupplierInvoices.getPreferredSize().getHeight());
            y = ExportTWMOrderInvoiceComponent.this.includeNoSupplierInvoices.getY() + ExportTWMOrderInvoiceComponent.this.includeNoSupplierInvoices.getHeight();
            ExportTWMOrderInvoiceComponent.this.includeNoOrderInvoices.setLocation(ExportTWMOrderInvoiceComponent.this.border, y + ExportTWMOrderInvoiceComponent.this.border / 4);
            ExportTWMOrderInvoiceComponent.this.includeNoOrderInvoices.setSize(parent.getWidth() - 2 * ExportTWMOrderInvoiceComponent.this.border, (int)ExportTWMOrderInvoiceComponent.this.includeNoOrderInvoices.getPreferredSize().getHeight());
            y = ExportTWMOrderInvoiceComponent.this.includeNoOrderInvoices.getY() + ExportTWMOrderInvoiceComponent.this.includeNoOrderInvoices.getHeight();
            ExportTWMOrderInvoiceComponent.this.includeCanceledInvoices.setLocation(ExportTWMOrderInvoiceComponent.this.border, y + ExportTWMOrderInvoiceComponent.this.border / 4);
            ExportTWMOrderInvoiceComponent.this.includeCanceledInvoices.setSize(parent.getWidth() - 2 * ExportTWMOrderInvoiceComponent.this.border, (int)ExportTWMOrderInvoiceComponent.this.includeCanceledInvoices.getPreferredSize().getHeight());
            y = ExportTWMOrderInvoiceComponent.this.includeCanceledInvoices.getY() + ExportTWMOrderInvoiceComponent.this.includeCanceledInvoices.getHeight();
            ExportTWMOrderInvoiceComponent.this.includeAllOrders.setLocation(ExportTWMOrderInvoiceComponent.this.border, y + ExportTWMOrderInvoiceComponent.this.border);
            ExportTWMOrderInvoiceComponent.this.includeAllOrders.setSize(parent.getWidth() - 2 * ExportTWMOrderInvoiceComponent.this.border, (int)ExportTWMOrderInvoiceComponent.this.includeAllOrders.getPreferredSize().getHeight());
            y = ExportTWMOrderInvoiceComponent.this.includeAllOrders.getY() + ExportTWMOrderInvoiceComponent.this.includeAllOrders.getHeight();
            ExportTWMOrderInvoiceComponent.this.useOnlyAttachedOrders.setLocation(ExportTWMOrderInvoiceComponent.this.border, y + ExportTWMOrderInvoiceComponent.this.border / 4);
            ExportTWMOrderInvoiceComponent.this.useOnlyAttachedOrders.setSize(parent.getWidth() - 2 * ExportTWMOrderInvoiceComponent.this.border, (int)ExportTWMOrderInvoiceComponent.this.useOnlyAttachedOrders.getPreferredSize().getHeight());
            y = ExportTWMOrderInvoiceComponent.this.useOnlyAttachedOrders.getY() + ExportTWMOrderInvoiceComponent.this.useOnlyAttachedOrders.getHeight();
            ExportTWMOrderInvoiceComponent.this.includeApprovedOrders.setLocation(ExportTWMOrderInvoiceComponent.this.border, y + ExportTWMOrderInvoiceComponent.this.border / 4);
            ExportTWMOrderInvoiceComponent.this.includeApprovedOrders.setSize(parent.getWidth() - 2 * ExportTWMOrderInvoiceComponent.this.border, (int)ExportTWMOrderInvoiceComponent.this.includeApprovedOrders.getPreferredSize().getHeight());
            y = ExportTWMOrderInvoiceComponent.this.includeApprovedOrders.getY() + ExportTWMOrderInvoiceComponent.this.includeApprovedOrders.getHeight();
            ExportTWMOrderInvoiceComponent.this.includeNotApprovedOrders.setLocation(ExportTWMOrderInvoiceComponent.this.border, y + ExportTWMOrderInvoiceComponent.this.border / 4);
            ExportTWMOrderInvoiceComponent.this.includeNotApprovedOrders.setSize(parent.getWidth() - 2 * ExportTWMOrderInvoiceComponent.this.border, (int)ExportTWMOrderInvoiceComponent.this.includeNotApprovedOrders.getPreferredSize().getHeight());
            y = ExportTWMOrderInvoiceComponent.this.includeNotApprovedOrders.getY() + ExportTWMOrderInvoiceComponent.this.includeNotApprovedOrders.getHeight();
            ExportTWMOrderInvoiceComponent.this.includeNotCheckedOrders.setLocation(ExportTWMOrderInvoiceComponent.this.border, y + ExportTWMOrderInvoiceComponent.this.border / 4);
            ExportTWMOrderInvoiceComponent.this.includeNotCheckedOrders.setSize(parent.getWidth() - 2 * ExportTWMOrderInvoiceComponent.this.border, (int)ExportTWMOrderInvoiceComponent.this.includeNotCheckedOrders.getPreferredSize().getHeight());
            y = ExportTWMOrderInvoiceComponent.this.includeNotCheckedOrders.getY() + ExportTWMOrderInvoiceComponent.this.includeNotCheckedOrders.getHeight();
            ExportTWMOrderInvoiceComponent.this.ignoreUncheckedOrders.setLocation(ExportTWMOrderInvoiceComponent.this.border, y + ExportTWMOrderInvoiceComponent.this.border / 4);
            ExportTWMOrderInvoiceComponent.this.ignoreUncheckedOrders.setSize(parent.getWidth() - 2 * ExportTWMOrderInvoiceComponent.this.border, (int)ExportTWMOrderInvoiceComponent.this.ignoreUncheckedOrders.getPreferredSize().getHeight());
            y = ExportTWMOrderInvoiceComponent.this.ignoreUncheckedOrders.getY() + ExportTWMOrderInvoiceComponent.this.ignoreUncheckedOrders.getHeight();
            ExportTWMOrderInvoiceComponent.this.includeCustomerOwnedOrders.setLocation(ExportTWMOrderInvoiceComponent.this.border, y + ExportTWMOrderInvoiceComponent.this.border / 4);
            ExportTWMOrderInvoiceComponent.this.includeCustomerOwnedOrders.setSize(parent.getWidth() - 2 * ExportTWMOrderInvoiceComponent.this.border, (int)ExportTWMOrderInvoiceComponent.this.includeCustomerOwnedOrders.getPreferredSize().getHeight());
            y = ExportTWMOrderInvoiceComponent.this.includeCustomerOwnedOrders.getY() + ExportTWMOrderInvoiceComponent.this.includeCustomerOwnedOrders.getHeight();
            ExportTWMOrderInvoiceComponent.this.sortBy.setLocation(ExportTWMOrderInvoiceComponent.this.border, y + ExportTWMOrderInvoiceComponent.this.border);
            ExportTWMOrderInvoiceComponent.this.sortBy.setSize(200, (int)ExportTWMOrderInvoiceComponent.this.sortBy.getPreferredSize().getHeight());
            y = ExportTWMOrderInvoiceComponent.this.sortBy.getY() + ExportTWMOrderInvoiceComponent.this.sortBy.getHeight();
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = ExportTWMOrderInvoiceComponent.this.getInheritedComponentsHeight();
            h += ExportTWMOrderInvoiceComponent.this.border;
            h = (int)((double)h + ExportTWMOrderInvoiceComponent.this.options.getPreferredSize().getHeight());
            h += ExportTWMOrderInvoiceComponent.this.border / 2;
            h = (int)((double)h + ExportTWMOrderInvoiceComponent.this.includeAcceptedInvoices.getPreferredSize().getHeight());
            h += ExportTWMOrderInvoiceComponent.this.border / 2;
            h = (int)((double)h + ExportTWMOrderInvoiceComponent.this.includeNoSupplierInvoices.getPreferredSize().getHeight());
            h += ExportTWMOrderInvoiceComponent.this.border / 2;
            h = (int)((double)h + ExportTWMOrderInvoiceComponent.this.includeNoOrderInvoices.getPreferredSize().getHeight());
            h += ExportTWMOrderInvoiceComponent.this.border / 2;
            h = (int)((double)h + ExportTWMOrderInvoiceComponent.this.includeValueDifferenceInvoices.getPreferredSize().getHeight());
            h += ExportTWMOrderInvoiceComponent.this.border / 2;
            h = (int)((double)h + ExportTWMOrderInvoiceComponent.this.includeAllInvoices.getPreferredSize().getHeight());
            h += ExportTWMOrderInvoiceComponent.this.border / 2;
            h = (int)((double)h + ExportTWMOrderInvoiceComponent.this.includeManuallyAcceptedInvoices.getPreferredSize().getHeight());
            h += ExportTWMOrderInvoiceComponent.this.border / 2;
            h = (int)((double)h + ExportTWMOrderInvoiceComponent.this.includeSummary.getPreferredSize().getHeight());
            h += ExportTWMOrderInvoiceComponent.this.border / 2;
            h = (int)((double)h + ExportTWMOrderInvoiceComponent.this.includeSupplierOverview.getPreferredSize().getHeight());
            h += ExportTWMOrderInvoiceComponent.this.border / 2;
            h = (int)((double)h + ExportTWMOrderInvoiceComponent.this.includeCanceledInvoices.getPreferredSize().getHeight());
            h += ExportTWMOrderInvoiceComponent.this.border;
            h = (int)((double)h + ExportTWMOrderInvoiceComponent.this.includeAllOrders.getPreferredSize().getHeight());
            h += ExportTWMOrderInvoiceComponent.this.border / 2;
            h = (int)((double)h + ExportTWMOrderInvoiceComponent.this.includeApprovedOrders.getPreferredSize().getHeight());
            h += ExportTWMOrderInvoiceComponent.this.border / 2;
            h = (int)((double)h + ExportTWMOrderInvoiceComponent.this.includeNotApprovedOrders.getPreferredSize().getHeight());
            h += ExportTWMOrderInvoiceComponent.this.border / 2;
            h = (int)((double)h + ExportTWMOrderInvoiceComponent.this.includeNotCheckedOrders.getPreferredSize().getHeight());
            h += ExportTWMOrderInvoiceComponent.this.border / 2;
            h = (int)((double)h + ExportTWMOrderInvoiceComponent.this.includeNotCheckedOrders.getPreferredSize().getHeight());
            h += ExportTWMOrderInvoiceComponent.this.border / 2;
            h = (int)((double)h + ExportTWMOrderInvoiceComponent.this.useOnlyAttachedOrders.getPreferredSize().getHeight());
            h += ExportTWMOrderInvoiceComponent.this.border / 2;
            h = (int)((double)h + ExportTWMOrderInvoiceComponent.this.ignoreUncheckedOrders.getPreferredSize().getHeight());
            h += ExportTWMOrderInvoiceComponent.this.border / 2;
            h = (int)((double)h + ExportTWMOrderInvoiceComponent.this.includeCustomerOwnedOrders.getPreferredSize().getHeight());
            h += ExportTWMOrderInvoiceComponent.this.border;
            h = (int)((double)h + ExportTWMOrderInvoiceComponent.this.sortBy.getPreferredSize().getHeight());
            return new Dimension(0, h += ExportTWMOrderInvoiceComponent.this.border);
        }
    }
}

