/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.analysis.twm.remote.invoice;

import ch.icit.pegasus.client.gui.batch.BatchJob;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.HorizontalSeparator;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.buttons.InfoButton;
import ch.icit.pegasus.client.gui.utils.buttons.RadioButton;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.datechooser.TitledPeriodEditor;
import ch.icit.pegasus.client.gui.utils.filterchain.FilterChainConfiguration;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.print.DefaultScrollablePrintPopup2;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.supply.ThreeWayMatchServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.report.twm.TWMInvoiceExportConfiguration;
import ch.icit.pegasus.server.core.dtos.threewaymatch.ThreeWayMatchLight;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.sql.Date;
import java.util.ArrayList;
import java.util.List;

public class ThreeWayMatchPeriodInvoiceAnalysisComponent
extends DefaultScrollablePrintPopup2<ThreeWayMatchLight> {
    private static final long serialVersionUID = 1L;
    private Node<TWMInvoiceExportConfiguration> configNode;
    private TitledPeriodEditor periodEditor;
    private TitledItem<TextField> numberChooser;
    private TitledItem<CheckBox> useOnlyAttachedOrders;
    private RadioButton choosePeriod;
    private RadioButton chooseNumbers;
    private InfoButton numberChooserInfo;
    private HorizontalSeparator sep1;
    private TitledItem<CheckBox> includeSummary;
    private TitledItem<CheckBox> includeNoSupplierInvoices;
    private TitledItem<CheckBox> includeNoOrderInvoices;
    private TitledItem<CheckBox> includeValueDifferenceInvoices;
    private TitledItem<CheckBox> includeAcceptedInvoices;
    private TitledItem<CheckBox> includeAllInvoices;
    private TitledItem<CheckBox> includeManuallyAcceptedInvoices;
    private TitledItem<CheckBox> includeSupplierOverview;
    private TitledItem<CheckBox> includeCanceledInvoices;
    private TitledItem<ComboBox> sortBy;
    public static final String START_DATE = "startDate";
    public static final String END_DATE = "endDate";
    public static final String INCLUDE_SUMMARY = "includeSummary";
    public static final String INCLUDE_NO_ORDER_INVOICES = "includeNoOrderInvoices";
    public static final String INCLUDE_NO_SUPPLIER_INVOICES = "includeNoSupplierInvoices";
    public static final String INCLUDE_VALUE_DIFFERENCE_INVOICES = "includeValueDifferenceInvoices";
    public static final String INCLUDE_ACCEPTED_INVOICES = "includeAcceptedInvoices";
    public static final String INCLUDE_ALL_INVOICES = "includeAllInvoices";
    public static final String INCLUDE_MANUALLY_ACCEPTED_INVOICES = "includeManuallyAcceptedInvoices";
    public static final String INCLUDE_SUPPLIER_OVERVIEW = "includeSupplierOverview";
    public static final String INCLUDE_CANCELED_INVOICES = "includeCanceledInvoices";
    public static final String USE_ONLY_ATTACHED_ORDERS = "showOnlyAttachedOrders";

    public ThreeWayMatchPeriodInvoiceAnalysisComponent() {
        super(false, false, false, false, null);
        TWMInvoiceExportConfiguration config = new TWMInvoiceExportConfiguration();
        config.setStartDate(new Date(System.currentTimeMillis()));
        config.setEndDate(new Date(System.currentTimeMillis()));
        this.configNode = INodeCreator.getDefaultImpl().getNode4DTO((Object)config, false, false);
    }

    @Override
    public List<Component> getFocusComponents() {
        List<Component> focusList = super.getFocusComponents();
        CheckedListAdder.addToList(focusList, this.periodEditor);
        return focusList;
    }

    @Override
    public boolean getIsPreviewAnyway() {
        return true;
    }

    @Override
    public void updateConfiguration(FilterChainConfiguration conf) {
        for (String[] s : conf.getProperties()) {
            String n = s[0];
            String v = s[1];
            if (n.equals(START_DATE)) {
                try {
                    long l = Long.valueOf(v);
                    this.periodEditor.getStartDateChooser().getNode().setValue((Object)new Date(l), 0L);
                }
                catch (Exception l) {}
                continue;
            }
            if (n.equals(END_DATE)) {
                try {
                    long l = Long.valueOf(v);
                    this.periodEditor.getEndDateChooser().getNode().setValue((Object)new Date(l), 0L);
                }
                catch (Exception l) {}
                continue;
            }
            Boolean b = Boolean.valueOf(v);
            switch (n) {
                case "includeSummary": {
                    this.includeSummary.getElement().setChecked(b);
                    break;
                }
                case "includeAcceptedInvoices": {
                    this.includeAcceptedInvoices.getElement().setChecked(b);
                    break;
                }
                case "includeNoSupplierInvoices": {
                    this.includeNoSupplierInvoices.getElement().setChecked(b);
                    break;
                }
                case "includeNoOrderInvoices": {
                    this.includeNoOrderInvoices.getElement().setChecked(b);
                    break;
                }
                case "includeValueDifferenceInvoices": {
                    this.includeValueDifferenceInvoices.getElement().setChecked(b);
                    break;
                }
                case "includeAllInvoices": {
                    this.includeAllInvoices.getElement().setChecked(b);
                    break;
                }
                case "includeManuallyAcceptedInvoices": {
                    this.includeManuallyAcceptedInvoices.getElement().setChecked(b);
                    break;
                }
                case "includeSupplierOverview": {
                    this.includeSupplierOverview.getElement().setChecked(b);
                    break;
                }
                case "includeCanceledInvoices": {
                    this.includeCanceledInvoices.getElement().setChecked(b);
                    break;
                }
                case "useOnlyAttachedOrders": {
                    this.useOnlyAttachedOrders.getElement().setChecked(b);
                }
            }
        }
    }

    @Override
    public FilterChainConfiguration createFilterChainConfig() {
        FilterChainConfiguration conf = new FilterChainConfiguration();
        conf.addProperty(START_DATE, "" + this.periodEditor.getStartDate().getTime());
        conf.addProperty(END_DATE, "" + this.periodEditor.getEndDate().getTime());
        conf.addProperty(INCLUDE_SUMMARY, "" + this.includeSummary.getElement().isChecked());
        conf.addProperty(INCLUDE_ACCEPTED_INVOICES, "" + this.includeAcceptedInvoices.getElement().isChecked());
        conf.addProperty(INCLUDE_NO_SUPPLIER_INVOICES, "" + this.includeNoSupplierInvoices.getElement().isChecked());
        conf.addProperty(INCLUDE_NO_ORDER_INVOICES, "" + this.includeNoOrderInvoices.getElement().isChecked());
        conf.addProperty(INCLUDE_VALUE_DIFFERENCE_INVOICES, "" + this.includeValueDifferenceInvoices.getElement().isChecked());
        conf.addProperty(INCLUDE_ALL_INVOICES, "" + this.includeAllInvoices.getElement().isChecked());
        conf.addProperty(INCLUDE_MANUALLY_ACCEPTED_INVOICES, "" + this.includeManuallyAcceptedInvoices.getElement().isChecked());
        conf.addProperty(INCLUDE_SUPPLIER_OVERVIEW, "" + this.includeSupplierOverview.getElement().isChecked());
        conf.addProperty(INCLUDE_CANCELED_INVOICES, "" + this.includeCanceledInvoices.getElement().isChecked());
        conf.addProperty("useOnlyAttachedOrders", "" + this.useOnlyAttachedOrders.getElement().isChecked());
        return conf;
    }

    @Override
    public void insertElements() {
        this.getViewContainer().setLayout(new Layout());
        this.createComponents();
        this.periodEditor = new TitledPeriodEditor((Node<Date>)this.configNode.getChildNamed(new String[]{START_DATE}), (Node<Date>)this.configNode.getChildNamed(new String[]{END_DATE}), true, null, (String)null);
        this.numberChooser = new TitledItem<TextField>(new TextField(), Words.NUMBERS, TitledItem.TitledItemOrientation.NORTH);
        this.numberChooserInfo = new InfoButton();
        this.numberChooserInfo.installStringViewer(Words.TWM_NUMBER_CHOOSER_INFO_TEXT);
        this.sep1 = new HorizontalSeparator();
        this.choosePeriod = new RadioButton();
        this.choosePeriod.setChecked(true);
        this.choosePeriod.addButtonListener(this);
        this.chooseNumbers = new RadioButton();
        this.chooseNumbers.addButtonListener(this);
        this.includeSummary = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.configNode.getChildNamed(new String[]{INCLUDE_SUMMARY})), Words.INCLUDE_SUMMARY_SHEET, TitledItem.TitledItemOrientation.EAST);
        this.includeAcceptedInvoices = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.configNode.getChildNamed(new String[]{INCLUDE_ACCEPTED_INVOICES})), Words.INCLUDE_ACCEPTED_INVOICES_SHEET, TitledItem.TitledItemOrientation.EAST);
        this.includeNoSupplierInvoices = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.configNode.getChildNamed(new String[]{INCLUDE_NO_SUPPLIER_INVOICES})), Words.INCLUDE_NO_SUPPLIER_INVOICES_SHEET, TitledItem.TitledItemOrientation.EAST);
        this.includeNoOrderInvoices = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.configNode.getChildNamed(new String[]{INCLUDE_NO_ORDER_INVOICES})), Words.INCLUDE_NO_ORDER_INVOICES_SHEET, TitledItem.TitledItemOrientation.EAST);
        this.includeValueDifferenceInvoices = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.configNode.getChildNamed(new String[]{INCLUDE_VALUE_DIFFERENCE_INVOICES})), Words.INCLUDE_VALUE_DIFFERENCE_INVOICES_SHEET, TitledItem.TitledItemOrientation.EAST);
        this.includeAllInvoices = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.configNode.getChildNamed(new String[]{INCLUDE_ALL_INVOICES})), Words.INCLUDE_ALL_INVOICES_SHEET, TitledItem.TitledItemOrientation.EAST);
        this.includeManuallyAcceptedInvoices = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.configNode.getChildNamed(new String[]{INCLUDE_MANUALLY_ACCEPTED_INVOICES})), Words.INCLUDE_MANUALLY_ACCEPTED_INVOICES_SHEET, TitledItem.TitledItemOrientation.EAST);
        this.includeSupplierOverview = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.configNode.getChildNamed(new String[]{INCLUDE_SUPPLIER_OVERVIEW})), Words.INCLUDE_SUPPLIER_SUMMARY_SHEET, TitledItem.TitledItemOrientation.EAST);
        this.includeCanceledInvoices = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.configNode.getChildNamed(new String[]{INCLUDE_CANCELED_INVOICES})), Words.INCLUDE_CANCELLED_INVOICES_SHEET, TitledItem.TitledItemOrientation.EAST);
        this.sortBy = new TitledItem<ComboBox>(new ComboBox(), Words.SORT_BY, TitledItem.TitledItemOrientation.NORTH);
        this.sortBy.getElement().addItem(Words.SUPPLIER);
        this.sortBy.getElement().addItem(Words.DATE);
        this.sortBy.getElement().addItem(Words.NONE);
        this.useOnlyAttachedOrders = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.configNode.getChildNamed(new String[]{USE_ONLY_ATTACHED_ORDERS})), Words.USE_ONLY_ATTACHED_ORDERS, TitledItem.TitledItemOrientation.EAST);
        this.getViewContainer().add(this.includeSummary);
        this.getViewContainer().add(this.includeAcceptedInvoices);
        this.getViewContainer().add(this.includeNoSupplierInvoices);
        this.getViewContainer().add(this.includeNoOrderInvoices);
        this.getViewContainer().add(this.includeValueDifferenceInvoices);
        this.getViewContainer().add(this.includeAllInvoices);
        this.getViewContainer().add(this.includeManuallyAcceptedInvoices);
        this.getViewContainer().add(this.includeSupplierOverview);
        this.getViewContainer().add(this.includeCanceledInvoices);
        this.getViewContainer().add(this.periodEditor);
        this.getViewContainer().add(this.sortBy);
        this.getViewContainer().add(this.numberChooserInfo);
        this.getViewContainer().add(this.numberChooser);
        this.getViewContainer().add(this.choosePeriod);
        this.getViewContainer().add(this.chooseNumbers);
        this.getViewContainer().add(this.sep1);
        this.getViewContainer().add(this.useOnlyAttachedOrders);
        this.setEnabled(true);
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        super.buttonPressed(source, x, y);
        if (source == this.chooseNumbers || source == this.choosePeriod) {
            this.setEnabled(this.isEnabled());
        }
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        boolean p = this.choosePeriod.isChecked();
        if (this.periodEditor != null) {
            this.periodEditor.setEnabled(isEnabled && p);
        }
        if (this.numberChooser != null) {
            this.numberChooser.setEnabled(isEnabled && !p);
        }
        if (this.includeSummary != null) {
            this.includeSummary.setEnabled(isEnabled);
        }
        if (this.includeAcceptedInvoices != null) {
            this.includeAcceptedInvoices.setEnabled(isEnabled);
        }
        if (this.includeNoSupplierInvoices != null) {
            this.includeNoSupplierInvoices.setEnabled(isEnabled);
        }
        if (this.includeNoOrderInvoices != null) {
            this.includeNoOrderInvoices.setEnabled(isEnabled);
        }
        if (this.includeValueDifferenceInvoices != null) {
            this.includeValueDifferenceInvoices.setEnabled(isEnabled);
        }
        if (this.includeAllInvoices != null) {
            this.includeAllInvoices.setEnabled(isEnabled);
        }
        if (this.includeManuallyAcceptedInvoices != null) {
            this.includeManuallyAcceptedInvoices.setEnabled(isEnabled);
        }
        if (this.includeSupplierOverview != null) {
            this.includeSupplierOverview.setEnabled(isEnabled);
        }
        if (this.includeCanceledInvoices != null) {
            this.includeCanceledInvoices.setEnabled(isEnabled);
        }
        if (this.sortBy != null) {
            this.sortBy.setEnabled(isEnabled);
        }
        if (this.useOnlyAttachedOrders != null) {
            this.useOnlyAttachedOrders.setEnabled(isEnabled);
        }
    }

    @Override
    public String getTitleString() {
        return Words.THREE_WAY_MATCH;
    }

    @Override
    public boolean isInnerComponent(Component c) {
        return super.isInnerComponent(c);
    }

    @Override
    public String getTitleValue() {
        return Words.ANALYSIS;
    }

    @Override
    public void setInnerPopUp(InnerPopUp2 ip) {
        super.setInnerPopUp(ip);
        ip.enablePreviewButton();
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        Object[] o = new Object[]{};
        return o;
    }

    @Override
    public boolean isClosableWithEnter() {
        return false;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.periodEditor != null) {
            this.periodEditor.kill();
        }
        this.periodEditor = null;
        if (this.includeSummary != null) {
            this.includeSummary.kill();
        }
        this.includeSummary = null;
        if (this.includeSupplierOverview != null) {
            this.includeSupplierOverview.kill();
        }
        this.includeSupplierOverview = null;
        if (this.includeAcceptedInvoices != null) {
            this.includeAcceptedInvoices.kill();
        }
        this.includeAcceptedInvoices = null;
        if (this.includeNoSupplierInvoices != null) {
            this.includeNoSupplierInvoices.kill();
        }
        this.includeNoSupplierInvoices = null;
        if (this.includeNoOrderInvoices != null) {
            this.includeNoOrderInvoices.kill();
        }
        this.includeNoOrderInvoices = null;
        if (this.includeValueDifferenceInvoices != null) {
            this.includeValueDifferenceInvoices.kill();
        }
        this.includeValueDifferenceInvoices = null;
        if (this.includeManuallyAcceptedInvoices != null) {
            this.includeManuallyAcceptedInvoices.kill();
        }
        this.includeManuallyAcceptedInvoices = null;
        if (this.includeAllInvoices != null) {
            this.includeAllInvoices.kill();
        }
        this.includeAllInvoices = null;
        if (this.includeCanceledInvoices != null) {
            this.includeCanceledInvoices.kill();
        }
        this.includeCanceledInvoices = null;
        if (this.sortBy != null) {
            this.sortBy.kill();
        }
        this.sortBy = null;
        if (this.numberChooser != null) {
            this.numberChooser.kill();
        }
        this.numberChooser = null;
        if (this.chooseNumbers != null) {
            this.chooseNumbers.kill();
        }
        this.chooseNumbers = null;
        if (this.choosePeriod != null) {
            this.choosePeriod.kill();
        }
        this.choosePeriod = null;
        if (this.numberChooserInfo != null) {
            this.numberChooserInfo.kill();
        }
        this.numberChooserInfo = null;
        if (this.sep1 != null) {
            this.sep1.kill();
        }
        this.sep1 = null;
        if (this.useOnlyAttachedOrders != null) {
            this.useOnlyAttachedOrders.kill();
        }
        this.useOnlyAttachedOrders = null;
    }

    @Override
    public void addInheritedComponents() {
        super.addInheritedComponents();
        if (this.periodEditor != null) {
            this.periodEditor.setVisible(true);
        }
        if (this.includeSummary != null) {
            this.includeSummary.setVisible(true);
        }
        if (this.includeAcceptedInvoices != null) {
            this.includeAcceptedInvoices.setVisible(true);
        }
        if (this.includeNoSupplierInvoices != null) {
            this.includeNoSupplierInvoices.setVisible(true);
        }
        if (this.includeNoOrderInvoices != null) {
            this.includeNoOrderInvoices.setVisible(true);
        }
        if (this.includeValueDifferenceInvoices != null) {
            this.includeValueDifferenceInvoices.setVisible(true);
        }
        if (this.includeAllInvoices != null) {
            this.includeAllInvoices.setVisible(true);
        }
        if (this.includeManuallyAcceptedInvoices != null) {
            this.includeManuallyAcceptedInvoices.setVisible(true);
        }
        if (this.includeSupplierOverview != null) {
            this.includeSupplierOverview.setVisible(true);
        }
        if (this.includeCanceledInvoices != null) {
            this.includeCanceledInvoices.setVisible(true);
        }
        if (this.sortBy != null) {
            this.sortBy.setVisible(true);
        }
        if (this.numberChooser != null) {
            this.numberChooser.setVisible(true);
        }
        if (this.chooseNumbers != null) {
            this.chooseNumbers.setVisible(true);
        }
        if (this.choosePeriod != null) {
            this.choosePeriod.setVisible(true);
        }
        if (this.numberChooserInfo != null) {
            this.numberChooserInfo.setVisible(true);
        }
        if (this.sep1 != null) {
            this.sep1.setVisible(true);
        }
        if (this.useOnlyAttachedOrders != null) {
            this.useOnlyAttachedOrders.setVisible(true);
        }
    }

    @Override
    public void removeInheritedComponents() {
        super.removeInheritedComponents();
        if (this.periodEditor != null) {
            this.periodEditor.setVisible(false);
        }
        if (this.includeSummary != null) {
            this.includeSummary.setVisible(false);
        }
        if (this.includeAcceptedInvoices != null) {
            this.includeAcceptedInvoices.setVisible(false);
        }
        if (this.includeNoSupplierInvoices != null) {
            this.includeNoSupplierInvoices.setVisible(false);
        }
        if (this.includeNoOrderInvoices != null) {
            this.includeNoOrderInvoices.setVisible(false);
        }
        if (this.includeValueDifferenceInvoices != null) {
            this.includeValueDifferenceInvoices.setVisible(false);
        }
        if (this.includeAllInvoices != null) {
            this.includeAllInvoices.setVisible(false);
        }
        if (this.includeManuallyAcceptedInvoices != null) {
            this.includeManuallyAcceptedInvoices.setVisible(false);
        }
        if (this.includeSupplierOverview != null) {
            this.includeSupplierOverview.setVisible(false);
        }
        if (this.includeCanceledInvoices != null) {
            this.includeCanceledInvoices.setVisible(false);
        }
        if (this.sortBy != null) {
            this.sortBy.setVisible(false);
        }
        if (this.numberChooser != null) {
            this.numberChooser.setVisible(false);
        }
        if (this.chooseNumbers != null) {
            this.chooseNumbers.setVisible(false);
        }
        if (this.choosePeriod != null) {
            this.choosePeriod.setVisible(false);
        }
        if (this.numberChooserInfo != null) {
            this.numberChooserInfo.setVisible(false);
        }
        if (this.sep1 != null) {
            this.sep1.setVisible(false);
        }
        if (this.useOnlyAttachedOrders != null) {
            this.useOnlyAttachedOrders.setVisible(false);
        }
    }

    @Override
    public ThreadSafeExecutable getJob() {
        return new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                ThreeWayMatchPeriodInvoiceAnalysisComponent.this.configNode.commit();
                TWMInvoiceExportConfiguration config = (TWMInvoiceExportConfiguration)ThreeWayMatchPeriodInvoiceAnalysisComponent.this.configNode.getValue();
                if (!ThreeWayMatchPeriodInvoiceAnalysisComponent.this.chooseNumbers.isChecked()) {
                    config.setStartDate(ThreeWayMatchPeriodInvoiceAnalysisComponent.this.periodEditor.getStartDate());
                    config.setEndDate(ThreeWayMatchPeriodInvoiceAnalysisComponent.this.periodEditor.getEndDate());
                } else {
                    config.setStartDate(null);
                    config.setEndDate(null);
                }
                config.setIncludeAcceptedInvoices(((CheckBox)ThreeWayMatchPeriodInvoiceAnalysisComponent.this.includeAcceptedInvoices.getElement()).isChecked());
                config.setIncludeNoSupplierInvoices(((CheckBox)ThreeWayMatchPeriodInvoiceAnalysisComponent.this.includeNoSupplierInvoices.getElement()).isChecked());
                config.setIncludeNoOrderInvoices(((CheckBox)ThreeWayMatchPeriodInvoiceAnalysisComponent.this.includeNoOrderInvoices.getElement()).isChecked());
                config.setIncludeValueDifferenceInvoices(((CheckBox)ThreeWayMatchPeriodInvoiceAnalysisComponent.this.includeValueDifferenceInvoices.getElement()).isChecked());
                config.setIncludeAllInvoices(((CheckBox)ThreeWayMatchPeriodInvoiceAnalysisComponent.this.includeAllInvoices.getElement()).isChecked());
                config.setIncludeManuallyAcceptedInvoices(((CheckBox)ThreeWayMatchPeriodInvoiceAnalysisComponent.this.includeManuallyAcceptedInvoices.getElement()).isChecked());
                config.setIncludeSummary(((CheckBox)ThreeWayMatchPeriodInvoiceAnalysisComponent.this.includeSummary.getElement()).isChecked());
                config.setIncludeSupplierOverview(((CheckBox)ThreeWayMatchPeriodInvoiceAnalysisComponent.this.includeSupplierOverview.getElement()).isChecked());
                config.setIncludeCanceledInvoices(((CheckBox)ThreeWayMatchPeriodInvoiceAnalysisComponent.this.includeCanceledInvoices.getElement()).isChecked());
                config.setShowOnlyAttachedOrders(((CheckBox)ThreeWayMatchPeriodInvoiceAnalysisComponent.this.useOnlyAttachedOrders.getElement()).isChecked());
                config.setTwmNumbers(ThreeWayMatchPeriodInvoiceAnalysisComponent.this.getTWMNumbers());
                config.setUseNumbers(ThreeWayMatchPeriodInvoiceAnalysisComponent.this.chooseNumbers.isChecked());
                if (((ComboBox)ThreeWayMatchPeriodInvoiceAnalysisComponent.this.sortBy.getElement()).getSelectedItem().equals(Words.SUPPLIER)) {
                    config.setSortBySupplier(true);
                } else if (((ComboBox)ThreeWayMatchPeriodInvoiceAnalysisComponent.this.sortBy.getElement()).getSelectedItem().equals(Words.DATE)) {
                    config.setSortByDate(true);
                } else if (((ComboBox)ThreeWayMatchPeriodInvoiceAnalysisComponent.this.sortBy.getElement()).getSelectedItem().equals(Words.NONE)) {
                    config.setSortByNone(true);
                }
                PegasusFileComplete t = (PegasusFileComplete)((ThreeWayMatchServiceManager)ServiceManagerRegistry.getService(ThreeWayMatchServiceManager.class)).createInvoiceSAPExport(config).getValue();
                ThreeWayMatchPeriodInvoiceAnalysisComponent.this.processFile(t);
                Node b = new Node();
                b.setValue((Object)true, 0L);
                return b;
            }

            @Override
            public RemoteLoader getInvoker() {
                return ThreeWayMatchPeriodInvoiceAnalysisComponent.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
    }

    private List<Integer> getTWMNumbers() {
        ArrayList<Integer> l = new ArrayList<Integer>();
        if (this.chooseNumbers.isChecked()) {
            String[] s;
            String t = this.numberChooser.getElement().getText();
            for (String ss : s = t.split(",")) {
                try {
                    int i = Integer.valueOf(ss);
                    l.add(i);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return l;
    }

    @Override
    public Node<ThreeWayMatchLight> getCurrentNode() {
        return null;
    }

    @Override
    public BatchJob<ThreeWayMatchLight> createBatchJob(Node<ThreeWayMatchLight> value, ThreadSafeExecutable job) {
        return null;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int y = ThreeWayMatchPeriodInvoiceAnalysisComponent.this.layoutInheritedComponents(parent) + ThreeWayMatchPeriodInvoiceAnalysisComponent.this.border;
            if (ThreeWayMatchPeriodInvoiceAnalysisComponent.this.periodEditor != null) {
                ThreeWayMatchPeriodInvoiceAnalysisComponent.this.periodEditor.setLocation((int)((double)ThreeWayMatchPeriodInvoiceAnalysisComponent.this.border + ThreeWayMatchPeriodInvoiceAnalysisComponent.this.choosePeriod.getPreferredSize().getWidth() + 3.0), y + ThreeWayMatchPeriodInvoiceAnalysisComponent.this.border / 2);
                ThreeWayMatchPeriodInvoiceAnalysisComponent.this.periodEditor.setSize((int)((double)parent.getWidth() - ((double)(2 * ThreeWayMatchPeriodInvoiceAnalysisComponent.this.border) + ThreeWayMatchPeriodInvoiceAnalysisComponent.this.choosePeriod.getPreferredSize().getWidth() + 3.0)), (int)ThreeWayMatchPeriodInvoiceAnalysisComponent.this.periodEditor.getPreferredSize().getHeight());
                ThreeWayMatchPeriodInvoiceAnalysisComponent.this.choosePeriod.setLocation(ThreeWayMatchPeriodInvoiceAnalysisComponent.this.border, y + 31);
                ThreeWayMatchPeriodInvoiceAnalysisComponent.this.choosePeriod.setSize(ThreeWayMatchPeriodInvoiceAnalysisComponent.this.choosePeriod.getPreferredSize());
                y = ThreeWayMatchPeriodInvoiceAnalysisComponent.this.periodEditor.getY() + ThreeWayMatchPeriodInvoiceAnalysisComponent.this.periodEditor.getHeight();
            }
            if (ThreeWayMatchPeriodInvoiceAnalysisComponent.this.numberChooser != null) {
                ThreeWayMatchPeriodInvoiceAnalysisComponent.this.numberChooser.setLocation((int)((double)ThreeWayMatchPeriodInvoiceAnalysisComponent.this.border + ThreeWayMatchPeriodInvoiceAnalysisComponent.this.chooseNumbers.getPreferredSize().getWidth() + 3.0), y + ThreeWayMatchPeriodInvoiceAnalysisComponent.this.border / 4);
                ThreeWayMatchPeriodInvoiceAnalysisComponent.this.numberChooser.setSize((int)((double)parent.getWidth() - ((double)(2 * ThreeWayMatchPeriodInvoiceAnalysisComponent.this.border) + ThreeWayMatchPeriodInvoiceAnalysisComponent.this.chooseNumbers.getPreferredSize().getWidth() + 3.0 + 3.0 + ThreeWayMatchPeriodInvoiceAnalysisComponent.this.numberChooserInfo.getPreferredSize().getWidth())), (int)ThreeWayMatchPeriodInvoiceAnalysisComponent.this.numberChooser.getPreferredSize().getHeight());
                ThreeWayMatchPeriodInvoiceAnalysisComponent.this.chooseNumbers.setLocation(ThreeWayMatchPeriodInvoiceAnalysisComponent.this.border, y + 27);
                ThreeWayMatchPeriodInvoiceAnalysisComponent.this.chooseNumbers.setSize(ThreeWayMatchPeriodInvoiceAnalysisComponent.this.chooseNumbers.getPreferredSize());
                ThreeWayMatchPeriodInvoiceAnalysisComponent.this.numberChooserInfo.setLocation(ThreeWayMatchPeriodInvoiceAnalysisComponent.this.numberChooser.getX() + ThreeWayMatchPeriodInvoiceAnalysisComponent.this.numberChooser.getWidth() + 3, ThreeWayMatchPeriodInvoiceAnalysisComponent.this.numberChooser.getY() + 24);
                ThreeWayMatchPeriodInvoiceAnalysisComponent.this.numberChooserInfo.setSize(ThreeWayMatchPeriodInvoiceAnalysisComponent.this.numberChooserInfo.getPreferredSize());
                y = ThreeWayMatchPeriodInvoiceAnalysisComponent.this.numberChooser.getY() + ThreeWayMatchPeriodInvoiceAnalysisComponent.this.numberChooser.getHeight();
            }
            if (ThreeWayMatchPeriodInvoiceAnalysisComponent.this.sep1 != null) {
                ThreeWayMatchPeriodInvoiceAnalysisComponent.this.sep1.setLocation(0, y + ThreeWayMatchPeriodInvoiceAnalysisComponent.this.border);
                ThreeWayMatchPeriodInvoiceAnalysisComponent.this.sep1.setSize(parent.getWidth(), (int)ThreeWayMatchPeriodInvoiceAnalysisComponent.this.sep1.getPreferredSize().getHeight());
                y = ThreeWayMatchPeriodInvoiceAnalysisComponent.this.sep1.getY() + ThreeWayMatchPeriodInvoiceAnalysisComponent.this.sep1.getHeight();
            }
            if (ThreeWayMatchPeriodInvoiceAnalysisComponent.this.includeSummary != null) {
                ThreeWayMatchPeriodInvoiceAnalysisComponent.this.includeSummary.setLocation(ThreeWayMatchPeriodInvoiceAnalysisComponent.this.border, y + ThreeWayMatchPeriodInvoiceAnalysisComponent.this.border);
                ThreeWayMatchPeriodInvoiceAnalysisComponent.this.includeSummary.setSize(ThreeWayMatchPeriodInvoiceAnalysisComponent.this.includeSummary.getPreferredSize());
                y = ThreeWayMatchPeriodInvoiceAnalysisComponent.this.includeSummary.getY() + ThreeWayMatchPeriodInvoiceAnalysisComponent.this.includeSummary.getHeight();
            }
            if (ThreeWayMatchPeriodInvoiceAnalysisComponent.this.includeSupplierOverview != null) {
                ThreeWayMatchPeriodInvoiceAnalysisComponent.this.includeSupplierOverview.setLocation(ThreeWayMatchPeriodInvoiceAnalysisComponent.this.border, y + ThreeWayMatchPeriodInvoiceAnalysisComponent.this.border / 4);
                ThreeWayMatchPeriodInvoiceAnalysisComponent.this.includeSupplierOverview.setSize(ThreeWayMatchPeriodInvoiceAnalysisComponent.this.includeSupplierOverview.getPreferredSize());
                y = ThreeWayMatchPeriodInvoiceAnalysisComponent.this.includeSupplierOverview.getY() + ThreeWayMatchPeriodInvoiceAnalysisComponent.this.includeSupplierOverview.getHeight();
            }
            if (ThreeWayMatchPeriodInvoiceAnalysisComponent.this.includeAllInvoices != null) {
                ThreeWayMatchPeriodInvoiceAnalysisComponent.this.includeAllInvoices.setLocation(ThreeWayMatchPeriodInvoiceAnalysisComponent.this.border, y + ThreeWayMatchPeriodInvoiceAnalysisComponent.this.border);
                ThreeWayMatchPeriodInvoiceAnalysisComponent.this.includeAllInvoices.setSize(ThreeWayMatchPeriodInvoiceAnalysisComponent.this.includeAllInvoices.getPreferredSize());
                y = ThreeWayMatchPeriodInvoiceAnalysisComponent.this.includeAllInvoices.getY() + ThreeWayMatchPeriodInvoiceAnalysisComponent.this.includeAllInvoices.getHeight();
            }
            if (ThreeWayMatchPeriodInvoiceAnalysisComponent.this.includeAcceptedInvoices != null) {
                ThreeWayMatchPeriodInvoiceAnalysisComponent.this.includeAcceptedInvoices.setLocation(ThreeWayMatchPeriodInvoiceAnalysisComponent.this.border, y + ThreeWayMatchPeriodInvoiceAnalysisComponent.this.border / 4);
                ThreeWayMatchPeriodInvoiceAnalysisComponent.this.includeAcceptedInvoices.setSize(ThreeWayMatchPeriodInvoiceAnalysisComponent.this.includeAcceptedInvoices.getPreferredSize());
                y = ThreeWayMatchPeriodInvoiceAnalysisComponent.this.includeAcceptedInvoices.getY() + ThreeWayMatchPeriodInvoiceAnalysisComponent.this.includeAcceptedInvoices.getHeight();
            }
            if (ThreeWayMatchPeriodInvoiceAnalysisComponent.this.includeManuallyAcceptedInvoices != null) {
                ThreeWayMatchPeriodInvoiceAnalysisComponent.this.includeManuallyAcceptedInvoices.setLocation(ThreeWayMatchPeriodInvoiceAnalysisComponent.this.border, y + ThreeWayMatchPeriodInvoiceAnalysisComponent.this.border / 4);
                ThreeWayMatchPeriodInvoiceAnalysisComponent.this.includeManuallyAcceptedInvoices.setSize(ThreeWayMatchPeriodInvoiceAnalysisComponent.this.includeManuallyAcceptedInvoices.getPreferredSize());
                y = ThreeWayMatchPeriodInvoiceAnalysisComponent.this.includeManuallyAcceptedInvoices.getY() + ThreeWayMatchPeriodInvoiceAnalysisComponent.this.includeManuallyAcceptedInvoices.getHeight();
            }
            if (ThreeWayMatchPeriodInvoiceAnalysisComponent.this.includeValueDifferenceInvoices != null) {
                ThreeWayMatchPeriodInvoiceAnalysisComponent.this.includeValueDifferenceInvoices.setLocation(ThreeWayMatchPeriodInvoiceAnalysisComponent.this.border, y + ThreeWayMatchPeriodInvoiceAnalysisComponent.this.border / 4);
                ThreeWayMatchPeriodInvoiceAnalysisComponent.this.includeValueDifferenceInvoices.setSize(ThreeWayMatchPeriodInvoiceAnalysisComponent.this.includeValueDifferenceInvoices.getPreferredSize());
                y = ThreeWayMatchPeriodInvoiceAnalysisComponent.this.includeValueDifferenceInvoices.getY() + ThreeWayMatchPeriodInvoiceAnalysisComponent.this.includeValueDifferenceInvoices.getHeight();
            }
            if (ThreeWayMatchPeriodInvoiceAnalysisComponent.this.includeNoSupplierInvoices != null) {
                ThreeWayMatchPeriodInvoiceAnalysisComponent.this.includeNoSupplierInvoices.setLocation(ThreeWayMatchPeriodInvoiceAnalysisComponent.this.border, y + ThreeWayMatchPeriodInvoiceAnalysisComponent.this.border / 4);
                ThreeWayMatchPeriodInvoiceAnalysisComponent.this.includeNoSupplierInvoices.setSize(ThreeWayMatchPeriodInvoiceAnalysisComponent.this.includeNoSupplierInvoices.getPreferredSize());
                y = ThreeWayMatchPeriodInvoiceAnalysisComponent.this.includeNoSupplierInvoices.getY() + ThreeWayMatchPeriodInvoiceAnalysisComponent.this.includeNoSupplierInvoices.getHeight();
            }
            if (ThreeWayMatchPeriodInvoiceAnalysisComponent.this.includeNoOrderInvoices != null) {
                ThreeWayMatchPeriodInvoiceAnalysisComponent.this.includeNoOrderInvoices.setLocation(ThreeWayMatchPeriodInvoiceAnalysisComponent.this.border, y + ThreeWayMatchPeriodInvoiceAnalysisComponent.this.border / 4);
                ThreeWayMatchPeriodInvoiceAnalysisComponent.this.includeNoOrderInvoices.setSize(ThreeWayMatchPeriodInvoiceAnalysisComponent.this.includeNoOrderInvoices.getPreferredSize());
                y = ThreeWayMatchPeriodInvoiceAnalysisComponent.this.includeNoOrderInvoices.getY() + ThreeWayMatchPeriodInvoiceAnalysisComponent.this.includeNoOrderInvoices.getHeight();
            }
            if (ThreeWayMatchPeriodInvoiceAnalysisComponent.this.includeCanceledInvoices != null) {
                ThreeWayMatchPeriodInvoiceAnalysisComponent.this.includeCanceledInvoices.setLocation(ThreeWayMatchPeriodInvoiceAnalysisComponent.this.border, y + ThreeWayMatchPeriodInvoiceAnalysisComponent.this.border);
                ThreeWayMatchPeriodInvoiceAnalysisComponent.this.includeCanceledInvoices.setSize(ThreeWayMatchPeriodInvoiceAnalysisComponent.this.includeCanceledInvoices.getPreferredSize());
                y = ThreeWayMatchPeriodInvoiceAnalysisComponent.this.includeCanceledInvoices.getY() + ThreeWayMatchPeriodInvoiceAnalysisComponent.this.includeCanceledInvoices.getHeight();
            }
            if (ThreeWayMatchPeriodInvoiceAnalysisComponent.this.useOnlyAttachedOrders != null) {
                ThreeWayMatchPeriodInvoiceAnalysisComponent.this.useOnlyAttachedOrders.setLocation(ThreeWayMatchPeriodInvoiceAnalysisComponent.this.border, y + ThreeWayMatchPeriodInvoiceAnalysisComponent.this.border);
                ThreeWayMatchPeriodInvoiceAnalysisComponent.this.useOnlyAttachedOrders.setSize(ThreeWayMatchPeriodInvoiceAnalysisComponent.this.useOnlyAttachedOrders.getPreferredSize());
                y = ThreeWayMatchPeriodInvoiceAnalysisComponent.this.useOnlyAttachedOrders.getY() + ThreeWayMatchPeriodInvoiceAnalysisComponent.this.useOnlyAttachedOrders.getHeight();
            }
            if (ThreeWayMatchPeriodInvoiceAnalysisComponent.this.sortBy != null) {
                ThreeWayMatchPeriodInvoiceAnalysisComponent.this.sortBy.setLocation(ThreeWayMatchPeriodInvoiceAnalysisComponent.this.border, y + ThreeWayMatchPeriodInvoiceAnalysisComponent.this.border);
                ThreeWayMatchPeriodInvoiceAnalysisComponent.this.sortBy.setSize(200, (int)ThreeWayMatchPeriodInvoiceAnalysisComponent.this.sortBy.getPreferredSize().getHeight());
                y = ThreeWayMatchPeriodInvoiceAnalysisComponent.this.sortBy.getY() + ThreeWayMatchPeriodInvoiceAnalysisComponent.this.sortBy.getHeight();
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = ThreeWayMatchPeriodInvoiceAnalysisComponent.this.getInheritedComponentsHeight();
            int w = 250;
            if (ThreeWayMatchPeriodInvoiceAnalysisComponent.this.periodEditor != null) {
                h = (int)((double)h + ThreeWayMatchPeriodInvoiceAnalysisComponent.this.periodEditor.getPreferredSize().getHeight());
                h += ThreeWayMatchPeriodInvoiceAnalysisComponent.this.border / 4;
            }
            if (ThreeWayMatchPeriodInvoiceAnalysisComponent.this.numberChooser != null) {
                h = (int)((double)h + ThreeWayMatchPeriodInvoiceAnalysisComponent.this.numberChooser.getPreferredSize().getHeight());
                h += ThreeWayMatchPeriodInvoiceAnalysisComponent.this.border;
            }
            if (ThreeWayMatchPeriodInvoiceAnalysisComponent.this.sep1 != null) {
                h = (int)((double)h + ThreeWayMatchPeriodInvoiceAnalysisComponent.this.sep1.getPreferredSize().getHeight());
                h += ThreeWayMatchPeriodInvoiceAnalysisComponent.this.border;
            }
            if (ThreeWayMatchPeriodInvoiceAnalysisComponent.this.includeSummary != null) {
                h = (int)((double)h + ThreeWayMatchPeriodInvoiceAnalysisComponent.this.includeSummary.getPreferredSize().getHeight());
                h += ThreeWayMatchPeriodInvoiceAnalysisComponent.this.border / 4;
            }
            if (ThreeWayMatchPeriodInvoiceAnalysisComponent.this.includeSupplierOverview != null) {
                h = (int)((double)h + ThreeWayMatchPeriodInvoiceAnalysisComponent.this.includeSupplierOverview.getPreferredSize().getHeight());
                h += ThreeWayMatchPeriodInvoiceAnalysisComponent.this.border;
            }
            if (ThreeWayMatchPeriodInvoiceAnalysisComponent.this.includeAcceptedInvoices != null) {
                h = (int)((double)h + ThreeWayMatchPeriodInvoiceAnalysisComponent.this.includeAcceptedInvoices.getPreferredSize().getHeight());
                h += ThreeWayMatchPeriodInvoiceAnalysisComponent.this.border / 4;
            }
            if (ThreeWayMatchPeriodInvoiceAnalysisComponent.this.includeNoSupplierInvoices != null) {
                h = (int)((double)h + ThreeWayMatchPeriodInvoiceAnalysisComponent.this.includeNoSupplierInvoices.getPreferredSize().getHeight());
                h += ThreeWayMatchPeriodInvoiceAnalysisComponent.this.border / 4;
            }
            if (ThreeWayMatchPeriodInvoiceAnalysisComponent.this.includeNoOrderInvoices != null) {
                h = (int)((double)h + ThreeWayMatchPeriodInvoiceAnalysisComponent.this.includeNoOrderInvoices.getPreferredSize().getHeight());
                h += ThreeWayMatchPeriodInvoiceAnalysisComponent.this.border / 4;
            }
            if (ThreeWayMatchPeriodInvoiceAnalysisComponent.this.includeValueDifferenceInvoices != null) {
                h = (int)((double)h + ThreeWayMatchPeriodInvoiceAnalysisComponent.this.includeValueDifferenceInvoices.getPreferredSize().getHeight());
                h += ThreeWayMatchPeriodInvoiceAnalysisComponent.this.border / 4;
            }
            if (ThreeWayMatchPeriodInvoiceAnalysisComponent.this.includeAllInvoices != null) {
                h = (int)((double)h + ThreeWayMatchPeriodInvoiceAnalysisComponent.this.includeAllInvoices.getPreferredSize().getHeight());
                h += ThreeWayMatchPeriodInvoiceAnalysisComponent.this.border / 4;
            }
            if (ThreeWayMatchPeriodInvoiceAnalysisComponent.this.includeManuallyAcceptedInvoices != null) {
                h = (int)((double)h + ThreeWayMatchPeriodInvoiceAnalysisComponent.this.includeManuallyAcceptedInvoices.getPreferredSize().getHeight());
                h += ThreeWayMatchPeriodInvoiceAnalysisComponent.this.border / 4;
            }
            if (ThreeWayMatchPeriodInvoiceAnalysisComponent.this.includeCanceledInvoices != null) {
                h = (int)((double)h + ThreeWayMatchPeriodInvoiceAnalysisComponent.this.includeCanceledInvoices.getPreferredSize().getHeight());
                h += ThreeWayMatchPeriodInvoiceAnalysisComponent.this.border;
            }
            if (ThreeWayMatchPeriodInvoiceAnalysisComponent.this.useOnlyAttachedOrders != null) {
                h = (int)((double)h + ThreeWayMatchPeriodInvoiceAnalysisComponent.this.useOnlyAttachedOrders.getPreferredSize().getHeight());
                h += ThreeWayMatchPeriodInvoiceAnalysisComponent.this.border;
            }
            if (ThreeWayMatchPeriodInvoiceAnalysisComponent.this.sortBy != null) {
                h += ThreeWayMatchPeriodInvoiceAnalysisComponent.this.border;
                h = (int)((double)h + ThreeWayMatchPeriodInvoiceAnalysisComponent.this.sortBy.getPreferredSize().getHeight());
            }
            return new Dimension(w, h += ThreeWayMatchPeriodInvoiceAnalysisComponent.this.border);
        }
    }
}

