/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.analysis.product.remote.updatetender;

import ch.icit.pegasus.client.gui.hud.externopentool.AnalysisSmartExternalOpenTool;
import ch.icit.pegasus.client.gui.submodules.analysis.util.DefaultServerSideAnalysisComponent;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.RadioButton;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.datechooser.DateChooser;
import ch.icit.pegasus.client.gui.utils.popup.inserts.export.itemimpl.ComboBoxAnalysisItem;
import ch.icit.pegasus.client.gui.utils.popup.inserts.export.itemimpl.DateChooserAnalysisItem;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.search.SearchResultIterator;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.supply.SupplyServiceManager;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.product.ProductComplete;
import ch.icit.pegasus.server.core.dtos.product.ProductReference;
import ch.icit.pegasus.server.core.dtos.search.ProductSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.search.ProductSearchTypeE;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.DateWrapper;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.ListWrapper;
import ch.icit.pegasus.server.core.general.ASearchConfiguration;
import ch.icit.pegasus.server.core.i18n.Words;
import java.sql.Date;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;

public class AnalysisProductUpdateTenderComponent
extends DefaultServerSideAnalysisComponent<ProductComplete, ProductReference> {
    private static final long serialVersionUID = 1L;
    private TitledItem<DateChooser> validityDate;
    private TitledItem<ComboBox> updateDirection;

    public AnalysisProductUpdateTenderComponent(AnalysisSmartExternalOpenTool<ProductComplete> defaultAnalysis) {
        super(defaultAnalysis, false, true);
    }

    @Override
    public void addOptionItems() {
        Node nd = INodeCreator.getDefaultImpl().getNode4DTO((Object)new Date(System.currentTimeMillis()), false, false);
        this.validityDate = new TitledItem<DateChooser>(new DateChooser(nd), Words.VALIDITY, TitledItem.TitledItemOrientation.NORTH);
        this.updateDirection = new TitledItem<ComboBox>(new ComboBox(), Words.TYPE, TitledItem.TitledItemOrientation.NORTH);
        this.updateDirection.getElement().addItem(Words.PRODUCTIV_TO_TENDER);
        this.updateDirection.getElement().addItem(Words.TENDER_TO_PRODUCTIV);
        this.addOptionsItem(new DateChooserAnalysisItem(this.validityDate, "dueDate"));
        this.addOptionsItem(new ComboBoxAnalysisItem(this.updateDirection, "direction"));
    }

    @Override
    public String getTitleString() {
        return Words.UPDATE_TENDER;
    }

    @Override
    public String getTitleValue() {
        return Words.PRODUCT;
    }

    @Override
    public ProductReference createReference(ProductComplete item) {
        return new ProductReference(item.getId());
    }

    @Override
    public PegasusFileComplete createReport() throws Exception {
        Object date = null;
        ArrayList<ProductReference> references = new ArrayList<ProductReference>();
        if (((RadioButton)this.numbers.getElement()).isChecked()) {
            String text = this.numberField.getText();
            String[] groups = text.split(",");
            HashSet<Integer> uniqueNumbers = new HashSet<Integer>();
            for (String group : groups) {
                String[] ranges = group.split("-");
                if (ranges.length == 2) {
                    int lower = Integer.valueOf(ranges[0]);
                    int upper = Integer.valueOf(ranges[1]);
                    for (int i = lower; i <= upper; ++i) {
                        uniqueNumbers.add(i);
                    }
                    continue;
                }
                uniqueNumbers.add(Integer.valueOf(ranges[0]));
            }
            for (Integer uniqueNumber : uniqueNumbers) {
                ProductSearchConfiguration configuration = new ProductSearchConfiguration();
                configuration.setProductSearchType(ProductSearchTypeE.PRODUCT_NUMBER);
                configuration.setNumber(uniqueNumber);
                SearchResultIterator sri = new SearchResultIterator((ASearchConfiguration)configuration);
                while (sri.hasNext()) {
                    references.add(new ProductReference(((ProductComplete)sri.next()).getId()));
                }
            }
        } else {
            Iterator s = this.getIterator();
            while (s.hasNext()) {
                references.add(new ProductReference(((ProductComplete)s.next()).getId()));
            }
        }
        boolean fromProductiveToTender = this.updateDirection.getElement().getSelectedItem().equals(Words.PRODUCTIV_TO_TENDER);
        Date d = (Date)this.validityDate.getElement().getNode().getValue();
        ((SupplyServiceManager)ServiceManagerRegistry.getService(SupplyServiceManager.class)).updateProductTenders(new ListWrapper(references), new DateWrapper(d), fromProductiveToTender);
        return null;
    }
}

