/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.analysis.flightschedule.stwchangelog;

import ch.icit.pegasus.client.gui.hud.externopentool.AnalysisSmartExternalOpenTool;
import ch.icit.pegasus.client.gui.submodules.analysis.util.DefaultServerSideAnalysisComponent;
import ch.icit.pegasus.client.gui.utils.datechooser.TitledPeriodEditor;
import ch.icit.pegasus.client.gui.utils.popup.inserts.export.itemimpl.PeriodEditorAnalysisItem;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.report.ProductReportServiceManager;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightScheduleLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightScheduleReference;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.ListWrapper;
import ch.icit.pegasus.server.core.services.exception.ServiceException;
import java.sql.Date;
import java.util.List;

public class AnalysisFlightScheduleStwChangeLogComponent
extends DefaultServerSideAnalysisComponent<FlightScheduleLight, FlightScheduleReference> {
    private static final long serialVersionUID = 1L;
    private TitledPeriodEditor period;

    public AnalysisFlightScheduleStwChangeLogComponent(AnalysisSmartExternalOpenTool<FlightScheduleLight> defaultAnalysis) {
        super(defaultAnalysis, false, true);
    }

    @Override
    public void addOptionItems() {
        PeriodComplete p = new PeriodComplete();
        p.setStartDate(new Date(System.currentTimeMillis()));
        p.setEndDate(new Date(System.currentTimeMillis()));
        this.period = new TitledPeriodEditor((Node<PeriodComplete>)INodeCreator.getDefaultImpl().getNode4DTO((Object)p, false, false), null);
        this.addOptionsItem(new PeriodEditorAnalysisItem(this.period, "period"));
    }

    @Override
    public String getTitleString() {
        return "Stw Change Log";
    }

    @Override
    public String getTitleValue() {
        return "Flight Schedule";
    }

    @Override
    public FlightScheduleReference createReference(FlightScheduleLight item) {
        return new FlightScheduleReference(item.getId());
    }

    @Override
    public PegasusFileComplete createReport() throws ServiceException {
        List schedules = this.loadItemReferences();
        PeriodComplete p = this.period.getPeriod();
        PegasusFileComplete file = (PegasusFileComplete)((ProductReportServiceManager)ServiceManagerRegistry.getService(ProductReportServiceManager.class)).exportFlightScheduleStwChangeLog(new ListWrapper(schedules), p).getValue();
        return file;
    }
}

