/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.analysis.flight.remote.pax.overview;

import ch.icit.pegasus.client.gui.hud.externopentool.AnalysisSmartExternalOpenTool;
import ch.icit.pegasus.client.gui.submodules.analysis.util.DefaultServerSideAnalysisComponent;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.popup.inserts.export.itemimpl.CheckBoxAnalysisItem;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.report.FlightReportServiceManager;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightReference;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.ListWrapper;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.services.exception.ServiceException;
import java.util.List;

public class AnalysisFlightPaxOverviewComponent
extends DefaultServerSideAnalysisComponent<FlightLight, FlightReference> {
    private static final long serialVersionUID = 1L;
    private TitledItem<CheckBox> includeNotMainClass;
    private TitledItem<CheckBox> splitNotMainClass;
    private TitledItem<CheckBox> groupHaulTypes;

    public AnalysisFlightPaxOverviewComponent(AnalysisSmartExternalOpenTool<FlightLight> defaultAnalysis) {
        super(defaultAnalysis);
    }

    @Override
    public void addOptionItems() {
        this.includeNotMainClass = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_NOT_MAIN_CLASS, TitledItem.TitledItemOrientation.EAST);
        this.splitNotMainClass = new TitledItem<CheckBox>(new CheckBox(), Words.SPLIT_NOT_MAIN_CLASS, TitledItem.TitledItemOrientation.EAST);
        this.groupHaulTypes = new TitledItem<CheckBox>(new CheckBox(), Words.GROUP_HAUL_TYPES, TitledItem.TitledItemOrientation.EAST);
        this.groupHaulTypes.getElement().setChecked(true);
        this.addOptionsItem(new CheckBoxAnalysisItem(this.includeNotMainClass, "notMain"));
        this.addOptionsItem(new CheckBoxAnalysisItem(this.splitNotMainClass, "splitNotMain"));
        this.addOptionsItem(new CheckBoxAnalysisItem(this.groupHaulTypes, "groupHaul"));
    }

    @Override
    public String getTitleString() {
        return Words.PAX_OVERVIEW;
    }

    @Override
    public FlightReference createReference(FlightLight item) {
        if (item.getId() != null) {
            return new FlightReference(item.getId());
        }
        return null;
    }

    @Override
    public boolean canExportAll() {
        return false;
    }

    @Override
    public PegasusFileComplete createReport() throws ServiceException {
        List s = this.loadItemReferences();
        PegasusFileComplete file = (PegasusFileComplete)((FlightReportServiceManager)ServiceManagerRegistry.getService(FlightReportServiceManager.class)).createPaxOverview(new ListWrapper(s), this.includeNotMainClass.getElement().isChecked(), this.splitNotMainClass.getElement().isChecked(), this.groupHaulTypes.getElement().isChecked()).getValue();
        return file;
    }
}

