/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.analysis.flight.remote.checkforupdates;

import ch.icit.pegasus.client.gui.hud.externopentool.AnalysisSmartExternalOpenTool;
import ch.icit.pegasus.client.gui.modules.retail.RetailModule;
import ch.icit.pegasus.client.gui.submodules.analysis.util.DefaultServerSideAnalysisComponent;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.supply.PickNPayServiceManager;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightReference;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.services.exception.ServiceException;
import ch.icit.pegasus.server.core.util.ServiceReturnWithMessage;
import java.util.ArrayList;
import javax.swing.SwingUtilities;

public class Check4UpdatesPickNPayDataComponent
extends DefaultServerSideAnalysisComponent<FlightLight, FlightReference> {
    private static final long serialVersionUID = 1L;

    public Check4UpdatesPickNPayDataComponent(AnalysisSmartExternalOpenTool<FlightLight> defaultAnalysis) {
        super(defaultAnalysis, false, false);
    }

    @Override
    public void setInnerPopUp(InnerPopUp2 ip) {
        super.setInnerPopUp(ip);
        ip.setPreviewButtonText("Continue");
        ip.hideOkButton();
    }

    @Override
    public void addOptionItems() {
    }

    @Override
    public String getTitleString() {
        return Words.CHECK_FOR_UPDATES;
    }

    @Override
    public boolean useSearch() {
        return false;
    }

    @Override
    public String getTitleText() {
        return "Press Continue to check for new Orders posted by Pick n Pay";
    }

    @Override
    public FlightReference createReference(FlightLight item) {
        if (item.getId() != null) {
            return new FlightReference(item.getId());
        }
        return null;
    }

    @Override
    public boolean canExportAll() {
        return false;
    }

    @Override
    public void errorOccurred(ClientException exception) {
        super.errorOccurred(exception);
        this.popup.enableCancelButton(true);
    }

    @Override
    public PegasusFileComplete createReport() throws ServiceException {
        ServiceReturnWithMessage serviceReturn = ((PickNPayServiceManager)ServiceManagerRegistry.getService(PickNPayServiceManager.class)).checkForUpdates();
        Boolean changes = (Boolean)serviceReturn.getObject();
        if (!changes.booleanValue()) {
            String t = "No changes found";
            SwingUtilities.invokeLater(() -> InnerPopupFactory.showOkMessage(this.getTitleString(), t, null, this, 350, 150));
        } else {
            ArrayList<ScreenValidationObject> warnings = new ArrayList<ScreenValidationObject>();
            for (String warning : serviceReturn.getMessage()) {
                warnings.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.WARNING, warning));
            }
            SwingUtilities.invokeLater(() -> InnerPopupFactory.showScreenValidationPopup(warnings, "", this));
        }
        RetailModule view = (RetailModule)this.externalOpenTool.getMainFrame().getCurrenScreen().getView();
        view.reloadData();
        return null;
    }
}

