/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.analysis.flight.local.update;

import ch.icit.pegasus.client.converter.FlightConverter;
import ch.icit.pegasus.client.converter.FlightDateConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.hud.externopentool.AnalysisSmartExternalOpenTool;
import ch.icit.pegasus.client.gui.screentemplates.overview.ScreenTableView;
import ch.icit.pegasus.client.gui.submodules.analysis.flight.local.update.utils.PaxUpdaterTable;
import ch.icit.pegasus.client.gui.submodules.analysis.flight.local.update.utils.PercentagePerClassTable;
import ch.icit.pegasus.client.gui.utils.HorizontalSeparator;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.panels.DateDurationPanelInt;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.popup.PopupType;
import ch.icit.pegasus.client.gui.utils.popup.inserts.DefaultTablePopupInsert;
import ch.icit.pegasus.client.gui.utils.popup.inserts.export.AnalysisPopupInsert;
import ch.icit.pegasus.client.gui.utils.popup.inserts.export.itemimpl.CheckBoxAnalysisItem;
import ch.icit.pegasus.client.gui.utils.popup.inserts.export.itemimpl.ComboBoxAnalysisItem;
import ch.icit.pegasus.client.gui.utils.popup.inserts.export.itemimpl.DateDurationPanelIntAnalysisItem;
import ch.icit.pegasus.client.gui.utils.popup.inserts.export.itemimpl.TableAnalysisItem;
import ch.icit.pegasus.client.gui.utils.popup.inserts.export.itemimpl.TextFieldAnalysisItem;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.node.DtoFieldConstants;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.ListNode;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.node.impls.ViewNode;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.flight.FlightServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.toolkits.FlightToolkit;
import ch.icit.pegasus.client.util.toolkits.PaxUpdateToolkit;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLegComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLegComplete_;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight_;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightReference;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightStateE;
import ch.icit.pegasus.server.core.dtos.flightschedule.PaxFigureComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.PaxFigureComplete_;
import ch.icit.pegasus.server.core.dtos.flightschedule.SeatConfigurationComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.SpecialMealOrderComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListLight_;
import ch.icit.pegasus.server.core.dtos.masterdata.CabinClassComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.PaxFigureTypeComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.AFlightAccess;
import ch.icit.pegasus.server.core.dtos.util.DateDurationComplete;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.ListWrapper;
import ch.icit.pegasus.server.core.i18n.Phrase;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.i18n.WordsToolkit;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class UpdatePaxForecastComponent
extends AnalysisPopupInsert<FlightLight>
implements ItemListener {
    private static final long serialVersionUID = 1L;
    private String text;
    private HorizontalSeparator sep1;
    private HorizontalSeparator sep2;
    private TitledItem<ComboBox> type;
    private TitledItem<TextField> percentage;
    private TitledItem<CheckBox> useClassSpecificForecast;
    private PercentagePerClassTable classSpecificTable;
    private TitledItem<CheckBox> autoOpenFlight;
    private TitledItem<CheckBox> includeCrew;
    private TitledItem<CheckBox> includeSPMLPaxUpdate;
    public static final boolean USE_PAX_FIGURE_TYPES = false;
    private List<TitledItem<CheckBox>> typesList = new ArrayList<TitledItem<CheckBox>>();
    private TitledItem<DateDurationPanelInt> durationField;
    private Node previewData;

    public UpdatePaxForecastComponent(AnalysisSmartExternalOpenTool<FlightLight> defaultAnalysis) {
        super(defaultAnalysis);
    }

    @Override
    public void addOptionItems() {
        this.isAutoCloseDisabled = true;
        this.type = new TitledItem<ComboBox>(new ComboBox(), Words.FORECAST_TYPE, TitledItem.TitledItemOrientation.NORTH);
        this.type.getElement().addItem(ForecastType.HISTORIC);
        this.type.getElement().addItem(ForecastType.PERCENTAGE);
        this.type.getFader().setPermanent(true);
        this.addOptionsItem(new ComboBoxAnalysisItem(this.type, "type"));
        this.type.getElement().addItemListener(this);
        this.percentage = new TitledItem<TextField>(new TextField(), Words.PERCENTAGE + "[0...1]", TitledItem.TitledItemOrientation.NORTH);
        this.percentage.getFader().setPermanent(true);
        this.addOptionsItem(new TextFieldAnalysisItem(this.percentage, "percentage"));
        this.useClassSpecificForecast = new TitledItem<CheckBox>(new CheckBox(), Words.USE_CLASS_SPECIFIC_FORECAST, TitledItem.TitledItemOrientation.EAST);
        this.useClassSpecificForecast.getElement().addButtonListener((button, x, y) -> this.setEnabled(this.isEnabled()));
        this.useClassSpecificForecast.getFader().setPermanent(true);
        this.addOptionsItem(new CheckBoxAnalysisItem(this.useClassSpecificForecast, "useClassSpecificForecast"));
        this.classSpecificTable = new PercentagePerClassTable();
        this.classSpecificTable.setNode(this.getCabinClasses());
        this.addOptionsItem(new TableAnalysisItem(this.classSpecificTable, "classSpecificPercentage"));
        this.durationField = new TitledItem<DateDurationPanelInt>(new DateDurationPanelInt(), Words.SEARCH_FLIGHT_WITHIN, TitledItem.TitledItemOrientation.NORTH);
        this.durationField.getFader().setPermanent(true);
        this.addOptionsItem(new DateDurationPanelIntAnalysisItem(this.durationField, "duration"));
        this.autoOpenFlight = new TitledItem<CheckBox>(new CheckBox(), Words.OPEN_PLANNED_FLIGHTS, TitledItem.TitledItemOrientation.EAST);
        this.autoOpenFlight.getFader().setPermanent(true);
        this.addOptionsItem(new CheckBoxAnalysisItem(this.autoOpenFlight, "autoOpen"));
        this.includeCrew = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_CREW_PAX, TitledItem.TitledItemOrientation.EAST);
        this.includeCrew.getFader().setPermanent(true);
        this.addOptionsItem(new CheckBoxAnalysisItem(this.includeCrew, "includeCrew"));
        this.includeSPMLPaxUpdate = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_SPML_FORECAST, TitledItem.TitledItemOrientation.EAST);
        this.includeSPMLPaxUpdate.getFader().setPermanent(true);
        this.addOptionsItem(new CheckBoxAnalysisItem(this.includeSPMLPaxUpdate, "spmlPaxUpdate"));
        this.showHistoricData();
        this.setEnabled(true);
    }

    private Node<List<CabinClassComplete>> getCabinClasses() {
        ViewNode node = new ViewNode("");
        for (CabinClassComplete cc : (List)NodeToolkit.getAffixList(CabinClassComplete.class).getValue()) {
            if (!cc.getShowSeparatelyOnReports().booleanValue()) continue;
            Node ccNode = INodeCreator.getDefaultImpl().getNode4DTO((Object)cc, false, true);
            ccNode.setName(DtoFieldConstants.FC_CABIN_CLASS);
            Node percentageNode = INodeCreator.getDefaultImpl().getNode4DTO((Object)0.0, false, false);
            percentageNode.setName(DtoFieldConstants.FC_CABIN_CLASS_PERCENTAGE);
            ViewNode parentNode = new ViewNode("Class " + cc.getCode());
            parentNode.addChild(ccNode, 0L);
            parentNode.addChild(percentageNode, 0L);
            node.addChild((Node)parentNode, 0L);
        }
        return node;
    }

    private void showHistoricData() {
        if (!this.includeSPMLPaxUpdate.getFader().isFaded()) {
            this.includeSPMLPaxUpdate.fadeIn();
        }
        if (!this.durationField.getFader().isFaded()) {
            this.durationField.fadeIn();
        }
        if (this.percentage.getFader().isFaded()) {
            this.percentage.fadeOut(false);
        }
        if (this.useClassSpecificForecast.getFader().isFaded()) {
            this.useClassSpecificForecast.fadeOut(false);
        }
        if (this.classSpecificTable.getFader().isFaded()) {
            this.classSpecificTable.fadeOut(false);
        }
    }

    private void showPercentageData() {
        if (this.includeSPMLPaxUpdate.getFader().isFaded()) {
            this.includeSPMLPaxUpdate.fadeOut(false);
        }
        if (this.durationField.getFader().isFaded()) {
            this.durationField.fadeOut(false);
        }
        if (!this.percentage.getFader().isFaded()) {
            this.percentage.fadeIn();
        }
        if (!this.useClassSpecificForecast.getFader().isFaded()) {
            this.useClassSpecificForecast.fadeIn();
        }
        if (!this.classSpecificTable.getFader().isFaded()) {
            this.classSpecificTable.fadeIn();
        }
    }

    @Override
    public String getPrefixText() {
        return Words.UPDATING;
    }

    @Override
    public void removeInheritedComponents() {
        super.removeInheritedComponents();
        if (this.sep1 != null) {
            this.sep1.setVisible(false);
        }
        if (this.sep2 != null) {
            this.sep2.setVisible(false);
        }
        if (this.includeCrew != null) {
            this.includeCrew.setVisible(false);
        }
        if (this.includeSPMLPaxUpdate != null) {
            this.includeSPMLPaxUpdate.setVisible(false);
        }
    }

    private void loadPreviewData() {
        this.ensureAnimation(Words.LOAD);
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                Iterator s = UpdatePaxForecastComponent.this.getIterator();
                HashSet<CabinClassComplete> usedCabinClasses = new HashSet<CabinClassComplete>();
                boolean includePax = ((CheckBox)UpdatePaxForecastComponent.this.includeCrew.getElement()).isChecked();
                ForecastType fp = (ForecastType)((Object)((ComboBox)UpdatePaxForecastComponent.this.type.getElement()).getSelectedItem());
                boolean ignoreEnRouteRestriction = UpdatePaxForecastComponent.this.externalOpenTool.getCurrentRDProvider().isWritable(AFlightAccess.IGNORE_EN_ROUTE_RESTRICTIONS);
                ListNode nodes = new ListNode();
                block6: while (s.hasNext()) {
                    UpdatePaxForecastComponent.this.updateItemCount();
                    FlightLight oldFlight = (FlightLight)s.next();
                    switch (oldFlight.getFlightState()) {
                        case CANCELLED: 
                        case CLOSED: 
                        case DELETED: 
                        case DISPATCHED: 
                        case EN_ROUTE: {
                            if (!ignoreEnRouteRestriction) continue block6;
                        }
                        case OPEN: 
                        case PLANNED: {
                            break;
                        }
                    }
                    FlightLight newFlight = PaxUpdateToolkit.getUpdateFlight(oldFlight, PaxUpdateToolkit.getFlightSearchDate(oldFlight, ((DateDurationPanelInt)UpdatePaxForecastComponent.this.durationField.getElement()).getDateDuration()), ((TextField)UpdatePaxForecastComponent.this.percentage.getElement()).getText(), fp == ForecastType.HISTORIC);
                    for (FlightLegComplete leg : oldFlight.getLegs()) {
                        if (!leg.getCateringLeg().booleanValue()) continue;
                        for (PaxFigureComplete pf : leg.getPaxFigures()) {
                            if (Boolean.TRUE.equals(pf.getCabinClass().getCrewClass())) {
                                if (!includePax) continue;
                                usedCabinClasses.add(pf.getCabinClass());
                                continue;
                            }
                            usedCabinClasses.add(pf.getCabinClass());
                        }
                        FlightLegComplete nleg = newFlight != null ? UpdatePaxForecastComponent.this.getFlightLeg(newFlight, leg) : null;
                        Node n = new Node();
                        Node ofNode = INodeCreator.getDefaultImpl().getNode4DTO((Object)oldFlight, false, true);
                        Node nfNode = newFlight != null ? INodeCreator.getDefaultImpl().getNode4DTO((Object)newFlight, false, true) : null;
                        ofNode.setName(DtoFieldConstants.orgFlight);
                        if (nfNode == null) continue;
                        nfNode.setName(DtoFieldConstants.templateFlight);
                        Node oLeg = INodeCreator.getDefaultImpl().getNode4DTO((Object)leg, false, true);
                        Node nLeg = INodeCreator.getDefaultImpl().getNode4DTO((Object)nleg, false, true);
                        oLeg.setName(DtoFieldConstants.orgLeg);
                        nLeg.setName(DtoFieldConstants.templateLeg);
                        n.addChild(ofNode, 0L);
                        n.addChild(nfNode, 0L);
                        n.addChild(oLeg, 0L);
                        n.addChild(nLeg, 0L);
                        nodes.addChild(n, 0L);
                    }
                }
                UpdatePaxForecastComponent.this.removeAnimation();
                UpdatePaxForecastComponent.this.previewData = (Node)nodes;
                InnerPopUp2 pop = InnerPopUp2.getInnerPopUp();
                pop.setAttributes(UpdatePaxForecastComponent.this, true, true, Words.UPDATE_PAX_FORECAST_PREVIEW);
                ArrayList<CabinClassComplete> allCC = new ArrayList<CabinClassComplete>();
                allCC.addAll(usedCabinClasses);
                double factor = 1.0;
                if (fp != ForecastType.HISTORIC) {
                    String text = ((TextField)UpdatePaxForecastComponent.this.percentage.getElement()).getText();
                    try {
                        factor = Double.valueOf(text);
                    }
                    catch (Exception e) {
                        factor = 1.0;
                    }
                }
                HashMap<CabinClassComplete, Double> byCabinClass = new HashMap<CabinClassComplete, Double>();
                Iterator it = UpdatePaxForecastComponent.this.classSpecificTable.getNode().getFailSafeChildIterator();
                while (it.hasNext()) {
                    Node n = (Node)it.next();
                    CabinClassComplete cabinClass = (CabinClassComplete)n.getChildNamed(DtoFieldConstants.FC_CABIN_CLASS).getValue(CabinClassComplete.class);
                    Double cabinFactor = (Double)n.getChildNamed(DtoFieldConstants.FC_CABIN_CLASS_PERCENTAGE).getValue(Double.class);
                    byCabinClass.put(cabinClass, cabinFactor);
                }
                PaxUpdaterTable r = fp == ForecastType.HISTORIC ? new PaxUpdaterTable(allCC, true, factor) : new PaxUpdaterTable(allCC, byCabinClass);
                r.getModel().setNode((Node)nodes);
                pop.setView(new DefaultTablePopupInsert<PaxUpdaterTable>(r));
                pop.showPopUpWithinScreenMiddle(700, 300, (source, args) -> {
                    if (args == null) {
                        UpdatePaxForecastComponent.this.popup.hidePopUp(args);
                    } else {
                        UpdatePaxForecastComponent.this.enterPressed(PopupAction.OK_FOREGROUND);
                    }
                }, UpdatePaxForecastComponent.this, PopupType.NORMAL);
                return nodes;
            }

            @Override
            public RemoteLoader getInvoker() {
                return UpdatePaxForecastComponent.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    private FlightLegComplete getFlightLeg(FlightLight flight, FlightLegComplete leg) {
        for (FlightLegComplete newLeg : flight.getLegs()) {
            if (!newLeg.getNumber().equals(leg.getNumber())) continue;
            return newLeg;
        }
        return null;
    }

    @Override
    public boolean isFileBased() {
        return false;
    }

    @Override
    public void enterPressed(PopupAction isOK) {
        switch (this.currentState) {
            case 5: {
                this.currentState = 3;
                this.enterPressed(isOK);
                break;
            }
            case 3: {
                this.currentState = 7;
                if (!this.validateInputs()) break;
                this.removeInheritedComponents();
                this.loadPreviewData();
                break;
            }
            case 7: {
                if (this.msg != null) {
                    this.msg.setVisible(false);
                }
                super.enterPressed(isOK);
            }
        }
    }

    private boolean validateInputs() {
        ForecastType fp = (ForecastType)((Object)this.type.getElement().getSelectedItem());
        if (fp == ForecastType.HISTORIC) {
            DateDurationComplete t = this.durationField.getElement().getDateDuration();
            if (t.getDuration() == null || t.getDuration() == 0.0) {
                this.durationField.getElement().setInvalid();
                return false;
            }
        } else if (fp == ForecastType.PERCENTAGE) {
            if (this.useClassSpecificForecast.getElement().isChecked()) {
                return true;
            }
            String t = this.percentage.getElement().getText();
            try {
                double d = Double.valueOf(t);
            }
            catch (NumberFormatException e) {
                this.percentage.getElement().setInvalid();
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean validateContent() {
        return true;
    }

    @Override
    public List<ScreenValidationObject> validateBeforePrint() {
        List<ScreenValidationObject> a = super.validateBeforePrint();
        ForecastType t = (ForecastType)((Object)this.type.getElement().getSelectedItem());
        if (t == ForecastType.PERCENTAGE && !this.useClassSpecificForecast.getElement().isChecked()) {
            String st = this.percentage.getElement().getText();
            if (st == null || st.isEmpty()) {
                a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_PERCENTAGE_VALUE_IS_SET));
            } else {
                try {
                    Double.valueOf(st);
                }
                catch (NumberFormatException e) {
                    a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_PERCENTAGE_VALUE_IS_SET));
                }
            }
        }
        return a;
    }

    @Override
    protected String getFinishedText() {
        return this.text;
    }

    @Override
    protected String getProgressText() {
        return WordsToolkit.toCapitalLetter((String)Words.PRINT);
    }

    @Override
    public String getTitleString() {
        return Words.UPDATE_PAX_FORECAST;
    }

    @Override
    public String getTitleValue() {
        return Words.ALL;
    }

    @Override
    public void setInnerPopUp(InnerPopUp2 ip) {
        super.setInnerPopUp(ip);
        ip.enablePreviewButton();
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        Object[] o = new Object[]{};
        return o;
    }

    @Override
    public boolean isClosableWithEnter() {
        return false;
    }

    @Override
    public boolean isInnerComponent(Component c) {
        return super.isInnerComponent(c);
    }

    @Override
    public void doProcessData() {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                UpdatePaxForecastComponent.this.writeConfigurationValues();
                FlightConverter flightConverter = (FlightConverter)ConverterRegistry.getConverter(FlightConverter.class);
                FlightDateConverter flightDateConverter = (FlightDateConverter)ConverterRegistry.getConverter(FlightDateConverter.class);
                HashSet<PaxFigureTypeComplete> usedTypes = new HashSet<PaxFigureTypeComplete>();
                boolean updateCrew = ((CheckBox)UpdatePaxForecastComponent.this.includeCrew.getElement()).isChecked();
                boolean useFinalPax = false;
                boolean hasFinalPax = false;
                for (TitledItem i : UpdatePaxForecastComponent.this.typesList) {
                    if (i.getUserObject() == null) {
                        hasFinalPax = true;
                        useFinalPax = ((CheckBox)i.getElement()).isChecked();
                        continue;
                    }
                    if (!((CheckBox)i.getElement()).isChecked()) continue;
                    usedTypes.add((PaxFigureTypeComplete)i.getUserObject());
                }
                if (!hasFinalPax) {
                    useFinalPax = true;
                }
                boolean openPlannedFlight = ((CheckBox)UpdatePaxForecastComponent.this.autoOpenFlight.getElement()).isChecked();
                boolean includeSPMLPax = false;
                if (UpdatePaxForecastComponent.this.includeSPMLPaxUpdate != null) {
                    includeSPMLPax = ((CheckBox)UpdatePaxForecastComponent.this.includeSPMLPaxUpdate.getElement()).isChecked();
                }
                HashMap<FlightLegComplete, FlightLight> legsToSave = new HashMap<FlightLegComplete, FlightLight>();
                HashMap<FlightLight, FlightComplete> flightsToSave = new HashMap<FlightLight, FlightComplete>();
                HashMap<FlightLight, FlightLight> updatedFlights = new HashMap<FlightLight, FlightLight>();
                PaxFigureTypeComplete paxType = null;
                List paxTypes = (List)NodeToolkit.getAffixList(PaxFigureTypeComplete.class).getValue();
                for (PaxFigureTypeComplete pf : paxTypes) {
                    if (!pf.getPredefined().booleanValue()) continue;
                    paxType = pf;
                }
                ForecastType ft = (ForecastType)((Object)((ComboBox)UpdatePaxForecastComponent.this.type.getElement()).getSelectedItem());
                boolean historic = ft == ForecastType.HISTORIC;
                Iterator it = UpdatePaxForecastComponent.this.previewData.getFailSafeChildIterator();
                while (it.hasNext()) {
                    Node object = (Node)it.next();
                    Node oldFlight = object.getChildNamed(DtoFieldConstants.orgFlight);
                    Node templateFlight = object.getChildNamed(DtoFieldConstants.templateFlight);
                    Node oldLeg = object.getChildNamed(DtoFieldConstants.orgLeg);
                    Node newLeg = object.getChildNamed(DtoFieldConstants.templateLeg);
                    FlightLight flight = (FlightLight)oldFlight.getValue();
                    updatedFlights.put(flight, (FlightLight)templateFlight.getValue());
                    flight.setSelectedPaxType(paxType);
                    Iterator paxCount = new HashMap<CabinClassComplete, Object>();
                    if (historic) {
                        Node paxFigures = newLeg.getChildNamed(FlightLegComplete_.paxFigures);
                        if (paxFigures != null) {
                            Iterator legIt = paxFigures.getFailSafeChildIterator();
                            while (legIt.hasNext()) {
                                Node pfl = (Node)legIt.next();
                                paxCount.put(((PaxFigureComplete)pfl.getValue()).getCabinClass(), pfl.getChildNamed(PaxFigureComplete_.number).getValue());
                            }
                        }
                    } else {
                        Iterator legIt = oldFlight.getChildNamed(new DtoField[]{FlightLight_.activeStowingList, StowingListLight_.seatConfigurations}).getFailSafeChildIterator();
                        while (legIt.hasNext()) {
                            Node pfl = (Node)legIt.next();
                            if (pfl.getChildNamed(DtoFieldConstants.SECOND_NUMBER) == null) continue;
                            paxCount.put(((SeatConfigurationComplete)pfl.getValue()).getCabinClass(), pfl.getChildNamed(DtoFieldConstants.SECOND_NUMBER).getValue());
                            pfl.removeChild(pfl.getChildNamed(DtoFieldConstants.SECOND_NUMBER), 0L);
                        }
                    }
                    if (Boolean.TRUE.equals(((FlightLight)oldFlight.getValue()).getCustomer().getUseMultiPax())) {
                        FlightToolkit.ensurePaxFigureTypesInserted((FlightLight)((FlightLight)oldFlight.getValue()));
                    }
                    PaxUpdateToolkit.updateForecastPax((FlightLight)oldFlight.getValue(), (FlightLight)templateFlight.getValue(), (FlightLegComplete)oldLeg.getValue(), (Map<CabinClassComplete, Integer>)((Object)paxCount));
                    legsToSave.put((FlightLegComplete)oldLeg.getValue(), (FlightLight)oldFlight.getValue());
                }
                UpdatePaxForecastComponent.this.text = Words.UPDATE_SUMMARY_TITLE;
                for (Map.Entry t : legsToSave.entrySet()) {
                    Set typeList;
                    FlightComplete fc = (FlightComplete)flightsToSave.get(t.getValue());
                    FlightLight fl = (FlightLight)t.getValue();
                    if (fc == null) {
                        if (fl.getId() == null) {
                            if (openPlannedFlight) {
                                fc = (FlightComplete)((FlightServiceManager)ServiceManagerRegistry.getService(FlightServiceManager.class)).getPlannedFlightComplete(fl).getValue();
                            }
                        } else {
                            fc = (FlightComplete)((FlightServiceManager)ServiceManagerRegistry.getService(FlightServiceManager.class)).getFlight(new FlightReference(fl.getId())).getValue();
                        }
                    }
                    if (fc == null) continue;
                    FlightLegComplete selectedLeg = null;
                    if (Boolean.TRUE.equals(fc.getCustomer().getUseMultiPax())) {
                        FlightToolkit.ensurePaxFigureTypesInserted((FlightLight)fc);
                    }
                    if ((typeList = UpdatePaxForecastComponent.this.createTypeList(fc)).contains(paxType)) {
                        fc.setSelectedPaxType(paxType);
                    } else {
                        fc.setSelectedPaxType(null);
                    }
                    flightsToSave.put(fl, fc);
                    for (FlightLegComplete l : fc.getLegs()) {
                        if (!l.getFlightScheduleLeg().getNumber().equals(((FlightLegComplete)t.getKey()).getFlightScheduleLeg().getNumber())) continue;
                        selectedLeg = l;
                    }
                    if (selectedLeg != null) {
                        for (PaxFigureComplete pf : selectedLeg.getPaxFigures()) {
                            if (Boolean.TRUE.equals(pf.getCabinClass().getCrewClass())) {
                                if (!updateCrew) continue;
                                pf.setNumber(this.getPax((FlightLegComplete)t.getKey(), pf.getCabinClass()));
                                continue;
                            }
                            pf.setNumber(this.getPax((FlightLegComplete)t.getKey(), pf.getCabinClass()));
                        }
                    }
                    if (!includeSPMLPax) continue;
                    FlightLight template = (FlightLight)updatedFlights.get(t.getValue());
                    if (!includeSPMLPax || template.getId() == null) continue;
                    FlightComplete nFlight = (FlightComplete)((FlightServiceManager)ServiceManagerRegistry.getService(FlightServiceManager.class)).getFlight(new FlightReference(template.getId())).getValue();
                    for (SpecialMealOrderComplete o : nFlight.getSpmlOrders()) {
                        if (o.getCount() <= 0 || PaxUpdateToolkit.hasOrder(o, fc.getSpmlOrders())) continue;
                        SpecialMealOrderComplete no = new SpecialMealOrderComplete();
                        no.setClientOId(Long.valueOf(ADTO.getNextId()));
                        no.setCabinClass(o.getCabinClass());
                        no.setCount(o.getCount());
                        no.setFlight((FlightReference)fc);
                        no.setMenuType(o.getMenuType());
                        no.setPaxName(o.getPaxName());
                        no.setPredefined(Boolean.valueOf(false));
                        no.setSeatNumber(o.getSeatNumber());
                        no.setStowingPosition(null);
                        for (FlightLegComplete l : o.getLegs()) {
                            FlightLegComplete nl = PaxUpdateToolkit.getLeg(l, fc.getLegs());
                            if (nl == null) continue;
                            no.getLegs().add(nl);
                        }
                        fc.getSpmlOrders().add(no);
                    }
                }
                for (FlightComplete flight : flightsToSave.values()) {
                    try {
                        if (flight.getId() == null) {
                            if (openPlannedFlight) {
                                flight.setFlightState(FlightStateE.OPEN);
                                flight = (FlightComplete)((FlightServiceManager)ServiceManagerRegistry.getService(FlightServiceManager.class)).create(flight, new ListWrapper(), flight.getActiveStowingList().getMatriculation()).getValue();
                            }
                        } else {
                            flight = (FlightComplete)((FlightServiceManager)ServiceManagerRegistry.getService(FlightServiceManager.class)).update(flight, new ListWrapper(), false, false, false, false).getObject();
                        }
                        UpdatePaxForecastComponent.this.text = UpdatePaxForecastComponent.this.text + Phrase.getPhrase((String)Phrase.FLIGHT_UPDATED, (Object[])new Object[]{flightConverter.convert((FlightLight)flight, null, new Object[0]), flightDateConverter.convert((FlightLight)flight, null, new Object[0])});
                    }
                    catch (Exception e) {
                        UpdatePaxForecastComponent.this.text = UpdatePaxForecastComponent.this.text + Phrase.getPhrase((String)Phrase.FLIGHT_NOT_UPDATED, (Object[])new Object[]{flightConverter.convert((FlightLight)flight, null, new Object[0]), flightDateConverter.convert((FlightLight)flight, null, new Object[0]), e.getMessage()});
                    }
                }
                UpdatePaxForecastComponent.this.text = "<html>" + UpdatePaxForecastComponent.this.text + "</html>";
                UpdatePaxForecastComponent.this.removeAnimation();
                UpdatePaxForecastComponent.this.showMessage(UpdatePaxForecastComponent.this.text);
                ((ScreenTableView)UpdatePaxForecastComponent.this.externalOpenTool.getMainFrame().getScreen().getView()).reloadData();
                return null;
            }

            private Integer getPax(FlightLegComplete key, CabinClassComplete cabinClass) {
                for (PaxFigureComplete f : key.getPaxFigures()) {
                    if (!f.getCabinClass().equals((Object)cabinClass)) continue;
                    return f.getNumber();
                }
                return 0;
            }

            @Override
            public RemoteLoader getInvoker() {
                return UpdatePaxForecastComponent.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    private Set<PaxFigureTypeComplete> createTypeList(FlightComplete flight) {
        HashSet<PaxFigureTypeComplete> typeMap = new HashSet<PaxFigureTypeComplete>();
        for (FlightLegComplete leg : flight.getLegs()) {
            for (PaxFigureComplete figure : leg.getPaxFigures()) {
                if (figure.getPaxFigureType() == null) continue;
                typeMap.add(figure.getPaxFigureType());
            }
        }
        return typeMap;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.classSpecificTable != null) {
            this.classSpecificTable.setEnabled(enabled && this.useClassSpecificForecast.getElement().isChecked());
        }
    }

    @Override
    protected void layoutTextMessage(Component parent) {
        this.textLabel.setLocation(this.border, this.border);
        this.textLabel.setSize(parent.getWidth() - 2 * this.border, parent.getHeight() - 2 * this.border);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() == 1) {
            if (this.type.getElement().getSelectedItem() == ForecastType.HISTORIC) {
                this.showHistoricData();
            } else {
                this.showPercentageData();
            }
        }
    }

    private static enum ForecastType {
        HISTORIC,
        PERCENTAGE;

    }
}

