/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.action.requisition.cancel;

import ch.icit.pegasus.client.converter.BasicArticleConverter;
import ch.icit.pegasus.client.converter.Converter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.submodules.action.purchase.cancel.ActionCancelPOOrderComponent;
import ch.icit.pegasus.client.gui.table.RowModel;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.supply.OrderServiceManager;
import ch.icit.pegasus.client.services.interfaces.supply.SupplyServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.HUDToolkit;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.server.core.dtos.auth.UserComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.StoreQuantityComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.UnitComplete;
import ch.icit.pegasus.server.core.dtos.ordering.OrderStateE;
import ch.icit.pegasus.server.core.dtos.ordering.RequisitionOrderComplete;
import ch.icit.pegasus.server.core.dtos.ordering.RequisitionOrderLight;
import ch.icit.pegasus.server.core.dtos.ordering.RequisitionOrderPositionComplete;
import ch.icit.pegasus.server.core.dtos.ordering.RequisitionOrderReference;
import ch.icit.pegasus.server.core.dtos.rightmanagement.access.DataFieldAccessRightComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.access.ModuleAccessRightComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.RequisitionOrderAccess;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleComplete;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleLight;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleReference;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.utils.UnitConversionToolkit;
import ch.icit.pegasus.server.core.i18n.Phrase;
import ch.icit.pegasus.server.core.i18n.Words;
import java.sql.Timestamp;

public class ActionCancelROOrderComponent
extends ActionCancelPOOrderComponent {
    private static final long serialVersionUID = 1L;
    protected boolean canCloseOrderAnyway;

    public ActionCancelROOrderComponent(Node<RequisitionOrderLight> node, RowModel<RequisitionOrderLight> model) {
        super(node, model);
    }

    @Override
    protected Class getGettingClass() {
        return RequisitionOrderComplete.class;
    }

    @Override
    public void enterPressed(PopupAction isOK) {
        this.removeInheritedComponents();
        if (this.emptyPositionShown && this.canBeClosed) {
            this.showMessage(this.getEnsureText());
            this.emptyPositionShown = false;
            this.popup.setCancelButtonText(Words.NO_ANSWER);
            this.popup.setOkButtonText(Words.YES);
            return;
        }
        if (!this.canBeClosed) {
            this.popup.hidePopUp(new Object[0]);
        }
        super.enterPressed(isOK);
    }

    @Override
    protected void loadComplete() {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                RequisitionOrderLight l = (RequisitionOrderLight)ActionCancelROOrderComponent.this.node.getValue(RequisitionOrderLight.class);
                RequisitionOrderComplete c = (RequisitionOrderComplete)((OrderServiceManager)ServiceManagerRegistry.getService(OrderServiceManager.class)).getRequisitionOrderByReference(new RequisitionOrderReference(l.getId())).getValue();
                UserComplete user = ((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentUser();
                ModuleAccessRightComplete r = HUDToolkit.getCurrentAccessRight(RequisitionOrderAccess.MODULE_REQUISITION, user);
                if (r != null) {
                    for (DataFieldAccessRightComplete a : r.getFieldAccessRights()) {
                        if (!a.getField().getName().equals(RequisitionOrderAccess.IGNORE_CLOSE_MAX_DIFFERENCE.getFieldName())) continue;
                        ActionCancelROOrderComponent.this.canCloseOrderAnyway = true;
                    }
                }
                ActionCancelROOrderComponent.this.canBeClosed = ActionCancelROOrderComponent.this.isOrderClosable(c, ActionCancelROOrderComponent.this.canCloseOrderAnyway);
                ActionCancelROOrderComponent.this.node.removeExistingValues();
                ActionCancelROOrderComponent.this.node.setValue((Object)c, 0L);
                return ActionCancelROOrderComponent.this.node;
            }

            @Override
            public RemoteLoader getInvoker() {
                return new RemoteLoader(){

                    public void remoteObjectLoaded(Node<?> node) {
                        ActionCancelROOrderComponent.this.installPort();
                    }

                    public void errorOccurred(ClientException exception) {
                        ActionCancelROOrderComponent.this.errorOccurred(exception);
                    }
                };
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    private boolean isOrderClosable(RequisitionOrderComplete order, boolean canCloseOrderAnyway2) throws ClientServerCallException {
        SystemSettingsComplete settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
        Timestamp validity = new Timestamp(order.getRequiredOn().getTime());
        if (!canCloseOrderAnyway2) {
            if (order.getState() == OrderStateE.PLACED) {
                return true;
            }
            for (RequisitionOrderPositionComplete position : order.getOrderPositions()) {
                StoreQuantityComplete orderedAmount = position.getQuantity();
                StoreQuantityComplete preparedAmount = position.getPreparedAmount();
                StoreQuantityComplete rejectedAmount = position.getRejectedAmount();
                StoreQuantityComplete deliveredAmount = position.getDeliveredAmount();
                BasicArticleComplete artC = (BasicArticleComplete)((SupplyServiceManager)ServiceManagerRegistry.getService(SupplyServiceManager.class)).getBasicArticle(new BasicArticleReference(position.getArticle().getId())).getValue();
                double oQty = UnitConversionToolkit.convertUnit((UnitComplete)orderedAmount.getUnit(), (UnitComplete)position.getArticle().getFloatStoreUnit(), (double)orderedAmount.getAmount().doubleValue(), (BasicArticleLight)artC, (Timestamp)validity);
                double dQty = UnitConversionToolkit.convertUnit((UnitComplete)deliveredAmount.getUnit(), (UnitComplete)position.getArticle().getFloatStoreUnit(), (double)deliveredAmount.getAmount().doubleValue(), (BasicArticleLight)artC, (Timestamp)validity);
                double maxOffset = settings.getCloseRequisitionMaxDifference() / 100.0;
                double dif = Math.abs(oQty - dQty);
                double difFactor = dif / oQty;
                if (!(difFactor > maxOffset)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    protected String getText4Order(Object order) {
        if (!this.canBeClosed) {
            String t = Words.ORDER_CAN_NOT_BE_CANCELED;
            t = t + "</html>";
            return t;
        }
        String t = Words.OPEN_POSITION_TITLE;
        Converter c = ConverterRegistry.getConverter(BasicArticleConverter.class);
        for (RequisitionOrderPositionComplete pos : ((RequisitionOrderComplete)order).getOrderPositions()) {
            if (pos.getState() == OrderStateE.CLOSED) continue;
            t = t + Phrase.getPhrase((String)Phrase.ARTICLE_LIST, (Object[])new Object[]{c.convert((Object)pos.getArticle(), null, new Object[0])});
        }
        t = t + "</html>";
        return t;
    }

    @Override
    public String getEnsureText() {
        return Words.ARE_YOU_SURE_TO_CANCEL_ORDER;
    }

    @Override
    protected void startPrinting() {
        this.startPrinting2();
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                if (ActionCancelROOrderComponent.this.canBeClosed) {
                    SystemSettingsComplete settings;
                    RequisitionOrderComplete o = (RequisitionOrderComplete)ActionCancelROOrderComponent.this.node.getValue(RequisitionOrderComplete.class);
                    RequisitionOrderComplete no = (RequisitionOrderComplete)((OrderServiceManager)ServiceManagerRegistry.getService(OrderServiceManager.class)).cancelRequisitionOrder(new RequisitionOrderReference(o.getId())).getValue();
                    if (o.getGeneratedFromOrder() == null && Boolean.TRUE.equals((settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue()).getSendNotificationWhenRequisitionIsDelivered())) {
                        no = (RequisitionOrderComplete)((OrderServiceManager)ServiceManagerRegistry.getService(OrderServiceManager.class)).sendDeliverNotificationCancel(new RequisitionOrderReference(no.getId())).getValue();
                    }
                    ActionCancelROOrderComponent.this.node.removeExistingValues();
                    ActionCancelROOrderComponent.this.node.setValue((Object)no, 0L);
                    ActionCancelROOrderComponent.this.node.updateNode();
                }
                return null;
            }

            @Override
            public RemoteLoader getInvoker() {
                return ActionCancelROOrderComponent.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }
}

