/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.action.article.nutrition.approve;

import ch.icit.pegasus.client.converter.BooleanConverter;
import ch.icit.pegasus.client.converter.DateTimeConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.table.RowModel;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.ScrollableTextArea;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBoxFactory;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.popup.LoadablePopupInsert;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.ViewNode;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.supply.SupplyServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.server.core.dtos.masterdata.UserLight;
import ch.icit.pegasus.server.core.dtos.supply.ArticleNutritionStateE;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleComplete;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleComplete_;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleLight;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleReference;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.sql.Timestamp;
import java.util.List;

public class ActionNutritionApproveComponent
extends LoadablePopupInsert {
    private static final long serialVersionUID = 1L;
    private Node<BasicArticleLight> node;
    private RowModel<BasicArticleLight> model;
    private TitledItem<TextLabel> approved;
    private TitledItem<TextLabel> lastApproved;
    private TitledItem<ScrollableTextArea> nutritionApproveComment;
    private TitledItem<ComboBox> nutritionApproveNow;

    public ActionNutritionApproveComponent(Node<BasicArticleLight> node, RowModel<BasicArticleLight> model) {
        this.node = node;
        this.model = model;
        this.setLayout(new Layout());
        this.showAnimation(Words.LOAD_DATA);
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.approved != null) {
            this.approved.kill();
            this.lastApproved.kill();
            this.nutritionApproveComment.kill();
            this.nutritionApproveNow.kill();
        }
        this.approved = null;
        this.lastApproved = null;
        this.nutritionApproveComment = null;
        this.nutritionApproveNow = null;
    }

    public void loadData() {
        ThreadSafeLoader.run(new ThreadSafeExecutable(){

            @Override
            public Node<?> loadData() throws Exception {
                BasicArticleLight l = (BasicArticleLight)ActionNutritionApproveComponent.this.node.getValue(BasicArticleLight.class);
                BasicArticleComplete b = (BasicArticleComplete)((SupplyServiceManager)ServiceManagerRegistry.getService(SupplyServiceManager.class)).getBasicArticle(new BasicArticleReference(l.getId())).getValue();
                ActionNutritionApproveComponent.this.node.removeExistingValues();
                ActionNutritionApproveComponent.this.node.setValue((Object)b, 0L);
                ActionNutritionApproveComponent.this.node.updateNode();
                if (b.getRequestNutritionUpdateUser() != null) {
                    UserLight u = (UserLight)((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getUserLight(b.getRequestNutritionUpdateUser()).getValue();
                    Node cn = ActionNutritionApproveComponent.this.node.getChildNamed(BasicArticleComplete_.requestNutritionUpdateUser);
                    cn.removeExistingValues();
                    cn.setValue((Object)u, 0L);
                }
                return null;
            }

            private void insertUI() {
                ActionNutritionApproveComponent.this.hideAnimation();
                ActionNutritionApproveComponent.this.approved = new TitledItem<TextLabel>(new TextLabel(ActionNutritionApproveComponent.this.node.getChildNamed(BasicArticleComplete_.nutritionApproved), ConverterRegistry.getConverter(BooleanConverter.class)), Words.APPROVED, TitledItem.TitledItemOrientation.WEST);
                ActionNutritionApproveComponent.this.lastApproved = new TitledItem<TextLabel>(new TextLabel(ActionNutritionApproveComponent.this.node.getChildNamed(BasicArticleComplete_.lastNutritionApproved), ConverterRegistry.getConverter(DateTimeConverter.class)), Words.LAST_APPROVE, TitledItem.TitledItemOrientation.WEST);
                ActionNutritionApproveComponent.this.nutritionApproveComment = new TitledItem<ScrollableTextArea>(new ScrollableTextArea((Node<String>)ActionNutritionApproveComponent.this.node.getChildNamed(BasicArticleComplete_.nutritionApproveComment)), Words.COMMENT, TitledItem.TitledItemOrientation.NORTH);
                ActionNutritionApproveComponent.this.nutritionApproveComment.setIgnorePrefHeight(true);
                ActionNutritionApproveComponent.this.nutritionApproveNow = new TitledItem<ComboBox>(ComboBoxFactory.getYesNoComboBox(false), Words.APPROVE_NUTRITION, TitledItem.TitledItemOrientation.WEST);
                ((ComboBox)ActionNutritionApproveComponent.this.nutritionApproveNow.getElement()).addItem("-");
                ((ComboBox)ActionNutritionApproveComponent.this.nutritionApproveNow.getElement()).setSelectedItem("-");
                ActionNutritionApproveComponent.this.approved.fadeIn();
                ActionNutritionApproveComponent.this.lastApproved.fadeIn();
                ActionNutritionApproveComponent.this.nutritionApproveComment.fadeIn();
                ActionNutritionApproveComponent.this.nutritionApproveNow.fadeIn();
                ActionNutritionApproveComponent.this.add(ActionNutritionApproveComponent.this.approved);
                ActionNutritionApproveComponent.this.add(ActionNutritionApproveComponent.this.lastApproved);
                ActionNutritionApproveComponent.this.add(ActionNutritionApproveComponent.this.nutritionApproveComment);
                ActionNutritionApproveComponent.this.add(ActionNutritionApproveComponent.this.nutritionApproveNow);
                ActionNutritionApproveComponent.this.popup.revalidate();
            }

            @Override
            public RemoteLoader getInvoker() {
                return new RemoteLoader(){

                    public void remoteObjectLoaded(Node<?> node) {
                        this.insertUI();
                    }

                    public void errorOccurred(ClientException exception) {
                    }
                };
            }

            @Override
            public long getID() {
                return 0L;
            }
        });
    }

    @Override
    public void enterPressed(PopupAction isOK) {
        if (isOK == PopupAction.OK_FOREGROUND) {
            this.approved.setVisible(false);
            this.lastApproved.setVisible(false);
            this.nutritionApproveComment.setVisible(false);
            this.nutritionApproveNow.setVisible(false);
            this.showAnimation(Words.SAVE_DATA);
            ThreadSafeLoader.run(this.getJob());
            this.popup.enableCancelButton(false);
            this.popup.enableOKButton(false);
        } else {
            super.enterPressed(isOK);
        }
    }

    public ThreadSafeExecutable getJob() {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                ActionNutritionApproveComponent.this.node.commitThis(BasicArticleComplete.class);
                BasicArticleComplete artC = (BasicArticleComplete)ActionNutritionApproveComponent.this.node.getValue(BasicArticleComplete.class);
                if (((ComboBox)ActionNutritionApproveComponent.this.nutritionApproveNow.getElement()).getSelectedItem() != null) {
                    if (((ComboBox)ActionNutritionApproveComponent.this.nutritionApproveNow.getElement()).getSelectedItem().equals(Words.YES)) {
                        artC.setNutritionApproved(Boolean.valueOf(true));
                        artC.setLastNutritionApproved(new Timestamp(System.currentTimeMillis()));
                        artC.setNutritionApproveState(ArticleNutritionStateE.APPROVED);
                    } else if (((ComboBox)ActionNutritionApproveComponent.this.nutritionApproveNow.getElement()).getSelectedItem().equals(Words.NO_ANSWER)) {
                        artC.setNutritionApproved(Boolean.valueOf(false));
                        artC.setLastNutritionApproved(new Timestamp(System.currentTimeMillis()));
                        artC.setNutritionApproveState(ArticleNutritionStateE.NOT_APPROVED);
                    }
                }
                BasicArticleComplete basicArticleComplete = (BasicArticleComplete)((SupplyServiceManager)ServiceManagerRegistry.getService(SupplyServiceManager.class)).approveNutrition(artC).getValue();
                ActionNutritionApproveComponent.this.node.removeExistingValues();
                ActionNutritionApproveComponent.this.node.setValue((Object)basicArticleComplete, 0L);
                ActionNutritionApproveComponent.this.node.updateNode();
                ActionNutritionApproveComponent.this.model.mergeNode(ActionNutritionApproveComponent.this.node, true);
                return new ViewNode("");
            }

            @Override
            public RemoteLoader getInvoker() {
                return new RemoteLoader(){

                    public void remoteObjectLoaded(Node<?> node) {
                        ActionNutritionApproveComponent.this.popup.hideCancelButton();
                        ActionNutritionApproveComponent.this.popup.setOkButtonText(Words.CLOSE);
                        ActionNutritionApproveComponent.this.popup.hideScheduled(300, Words.SUCCESSFUL);
                    }

                    public void errorOccurred(ClientException exception) {
                        InnerPopupFactory.showErrorDialog((Exception)exception, (Component)ActionNutritionApproveComponent.this);
                    }
                };
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        return run;
    }

    @Override
    public boolean tryToGrabFocus() {
        return false;
    }

    @Override
    public List<Component> getFocusComponents() {
        return null;
    }

    @Override
    public boolean isClosableWithEnter() {
        return false;
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        return null;
    }

    @Override
    public boolean isInnerComponent(Component c) {
        return this.nutritionApproveNow != null ? this.nutritionApproveNow.getElement().isInnerComponent(c) : false;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int currentY = ActionNutritionApproveComponent.this.border;
            if (ActionNutritionApproveComponent.this.approved != null) {
                currentY = (int)((double)currentY + (ActionNutritionApproveComponent.this.approved.getPreferredSize().getHeight() + (double)(ActionNutritionApproveComponent.this.border / 2)));
            }
            if (ActionNutritionApproveComponent.this.lastApproved != null) {
                currentY = (int)((double)currentY + (ActionNutritionApproveComponent.this.lastApproved.getPreferredSize().getHeight() + (double)ActionNutritionApproveComponent.this.border));
            }
            if (ActionNutritionApproveComponent.this.nutritionApproveComment != null) {
                currentY += 100 + ActionNutritionApproveComponent.this.border;
            }
            if (ActionNutritionApproveComponent.this.nutritionApproveNow != null) {
                currentY = (int)((double)currentY + (ActionNutritionApproveComponent.this.nutritionApproveNow.getPreferredSize().getHeight() + (double)ActionNutritionApproveComponent.this.border));
            }
            return new Dimension(0, currentY);
        }

        @Override
        public void layoutContainer(Container parent) {
            ActionNutritionApproveComponent.this.layoutAnimation(parent);
            int currentY = ActionNutritionApproveComponent.this.border;
            if (ActionNutritionApproveComponent.this.approved != null) {
                ActionNutritionApproveComponent.this.approved.setLocation(ActionNutritionApproveComponent.this.border, currentY);
                ActionNutritionApproveComponent.this.approved.setSize(parent.getWidth() - 2 * ActionNutritionApproveComponent.this.border, (int)ActionNutritionApproveComponent.this.approved.getPreferredSize().getHeight());
                currentY = ActionNutritionApproveComponent.this.approved.getY() + ActionNutritionApproveComponent.this.approved.getHeight() + ActionNutritionApproveComponent.this.border / 2;
            }
            if (ActionNutritionApproveComponent.this.lastApproved != null) {
                ActionNutritionApproveComponent.this.lastApproved.setLocation(ActionNutritionApproveComponent.this.border, currentY);
                ActionNutritionApproveComponent.this.lastApproved.setSize(parent.getWidth() - 2 * ActionNutritionApproveComponent.this.border, (int)ActionNutritionApproveComponent.this.lastApproved.getPreferredSize().getHeight());
                currentY = ActionNutritionApproveComponent.this.lastApproved.getY() + ActionNutritionApproveComponent.this.lastApproved.getHeight() + ActionNutritionApproveComponent.this.border;
            }
            if (ActionNutritionApproveComponent.this.nutritionApproveComment != null) {
                ActionNutritionApproveComponent.this.nutritionApproveComment.setLocation(ActionNutritionApproveComponent.this.border, currentY);
                ActionNutritionApproveComponent.this.nutritionApproveComment.setSize(parent.getWidth() - 2 * ActionNutritionApproveComponent.this.border, 100);
                currentY = ActionNutritionApproveComponent.this.nutritionApproveComment.getY() + ActionNutritionApproveComponent.this.nutritionApproveComment.getHeight() + ActionNutritionApproveComponent.this.border;
            }
            if (ActionNutritionApproveComponent.this.nutritionApproveNow != null) {
                ActionNutritionApproveComponent.this.nutritionApproveNow.setLocation(ActionNutritionApproveComponent.this.border, currentY);
                ActionNutritionApproveComponent.this.nutritionApproveNow.setSize(parent.getWidth() - 2 * ActionNutritionApproveComponent.this.border, (int)ActionNutritionApproveComponent.this.nutritionApproveNow.getPreferredSize().getHeight());
            }
        }
    }
}

