/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.screentemplates.details.builder;

import ch.icit.pegasus.client.gui.screentemplates.details.builder.ViewProducer;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;

public class RenderItem<T> {
    private DtoField<T> accessorField;
    private ItemType itemType;
    private ViewProducer producer;
    private Component view;
    private String fieldName;
    private RenderItem<?> referenceItem;
    private ItemOrientation orientation;
    private FillStyle fillStyle;

    public RenderItem(DtoField<T> accessorField, ItemType itemType, String fieldName, ViewProducer producer) {
        this.accessorField = accessorField;
        this.itemType = itemType;
        this.fieldName = fieldName;
        this.producer = producer;
    }

    public ItemOrientation getOrientation() {
        return this.orientation;
    }

    public void setOrientation(ItemOrientation orientation) {
        this.orientation = orientation;
    }

    public RenderItem<?> getReferenceItem() {
        return this.referenceItem;
    }

    public void setReferenceItem(RenderItem<?> referenceItem) {
        this.referenceItem = referenceItem;
    }

    public FillStyle getFillStyle() {
        return this.fillStyle;
    }

    public void setFillStyle(FillStyle fillStyle) {
        this.fillStyle = fillStyle;
    }

    public void createAndInsertItems(Container parent) {
        this.view = this.producer.produce();
        parent.add(parent);
    }

    public void updateView(Node<?> node) {
        this.producer.updateComponent(node, this.accessorField, this.view);
    }

    public void setLocation(int w, int h) {
        this.view.setLocation(w, h);
    }

    public static enum FillStyle {
        FIX,
        HORIZONTAL,
        VERTICAL,
        BOTH;

    }

    public static enum ItemOrientation {
        LEFT_OF,
        RIGHT_OF,
        ABOVE_OF,
        BELOW_OF;

    }

    public static enum ItemType {
        ItemNumber,
        StringField,
        MultiLineText,
        NumberField_int,
        NumberField_double,
        ComboBox;

    }
}

