/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.weeklyplan.details;

import ch.icit.pegasus.client.gui.table.DefaultDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.LocationUtil;
import ch.icit.pegasus.client.gui.utils.productionweeklyplan.ProductionWeeklyPlanViewTable;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.server.core.dtos.ILocalizedDTO;
import ch.icit.pegasus.server.core.dtos.company.CostCenterComplete;
import ch.icit.pegasus.server.core.dtos.production_new.WeeklyPlanComplete;
import ch.icit.pegasus.server.core.dtos.production_new.WeeklyPlanLight;
import ch.icit.pegasus.server.core.dtos.supply.CustomerLight;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public class WeeklyPlanDetailsPanel
extends DefaultDetailsPanel<WeeklyPlanLight> {
    private static final long serialVersionUID = 1L;
    private ProductionWeeklyPlanViewTable weeklyPlanView;

    public WeeklyPlanDetailsPanel(RowEditor<WeeklyPlanLight> editor, RDProvider provider) {
        super(editor, provider);
        this.setTitleText("Food Production");
        this.weeklyPlanView = new ProductionWeeklyPlanViewTable(provider, (Node<WeeklyPlanLight>)editor.getModel().getNode());
        this.setCustomLayouter(new Layout());
        this.addToView(this.weeklyPlanView);
    }

    @Override
    public void setNode(Node<?> node) {
        super.setNode(node);
        if (this.editor.getModel().isAddRow()) {
            WeeklyPlanComplete dto = (WeeklyPlanComplete)node.getValue();
            LocationUtil.ensureCurrentLocation((ILocalizedDTO)dto);
        }
        this.weeklyPlanView.setNode(node);
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        this.weeklyPlanView.setEnabled(isEnabled);
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.weeklyPlanView.kill();
        this.weeklyPlanView = null;
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> focusList = new ArrayList<Component>();
        return focusList;
    }

    @Override
    public void requestFocusInWindowNow() {
    }

    public void hideNotHighLightedTasks(boolean hideNotHighlightedTasks) {
    }

    public void filterByDepartment(CostCenterComplete department) {
    }

    public void filterByCustomer(CustomerLight customer) {
    }

    public void loadMatDispo(RemoteLoader callBack) {
        this.weeklyPlanView.loadMatDispo(callBack);
    }

    public void reloadFlights(RemoteLoader callBack) {
        this.weeklyPlanView.reloadFlights(callBack);
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension(0, 600);
        }

        @Override
        public void layoutContainer(Container parent) {
            int ww = (parent.getWidth() - (2 * WeeklyPlanDetailsPanel.this.horizontalBorder + WeeklyPlanDetailsPanel.this.inner_horizontalBorder)) / 2;
            WeeklyPlanDetailsPanel.this.weeklyPlanView.setLocation(0, 0);
            WeeklyPlanDetailsPanel.this.weeklyPlanView.setSize(parent.getWidth(), parent.getHeight());
        }
    }
}

