/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.wag;

import ch.icit.pegasus.client.converter.BooleanConverter;
import ch.icit.pegasus.client.converter.CustomerCodeConverter;
import ch.icit.pegasus.client.converter.DateConverter;
import ch.icit.pegasus.client.converter.FlightCustomsDocumentsConverter;
import ch.icit.pegasus.client.converter.FlightTrackingNumberConverter;
import ch.icit.pegasus.client.converter.LogTimeConverter;
import ch.icit.pegasus.client.converter.RestaurantConverter;
import ch.icit.pegasus.client.converter.WAGStateEConverter;
import ch.icit.pegasus.client.gui.modules.Module;
import ch.icit.pegasus.client.gui.modules.wag.WagModuleDataHandler;
import ch.icit.pegasus.client.gui.modules.wag.details.OrderDataDetailsPanel;
import ch.icit.pegasus.client.gui.modules.wag.details.ProductsDetailsPanel;
import ch.icit.pegasus.client.gui.modules.wag.details.RemarkDetailsPanel;
import ch.icit.pegasus.client.gui.screentemplates.overview.ScreenTableView;
import ch.icit.pegasus.client.gui.screentemplates.overview.data.IDataHandler;
import ch.icit.pegasus.client.gui.table.CombinedDetailsParagraph;
import ch.icit.pegasus.client.gui.table.InputMessageProvidedRowEditor;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.table.RowEditorFactory;
import ch.icit.pegasus.client.gui.table.RowModel;
import ch.icit.pegasus.client.gui.table.Table;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.utils.TableLayoutConstraint;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.datechooser.TitledPeriodEditor;
import ch.icit.pegasus.client.gui.utils.filterchain.FilterChainConfiguration;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.search.SearchAlgorithm;
import ch.icit.pegasus.client.search.controller.SearchAlgorithmRegistry;
import ch.icit.pegasus.client.search.impls.remote.FlightSearchAlgorithm;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.server.core.dtos.auth.UserComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight_;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightStateE;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.restaurant.RestaurantComplete;
import ch.icit.pegasus.server.core.dtos.restaurant.RestaurantDeliverySettingsComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.access.SubModuleAccessRightComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.definition.SubModuleDefinitionComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.AccessDefinitionComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.WagAccess;
import ch.icit.pegasus.server.core.dtos.search.FlightScheduleSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.search.FlightSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.search.FlightSearchTypeE;
import ch.icit.pegasus.server.core.dtos.utils.DateUtil;
import ch.icit.pegasus.server.core.general.ASearchConfiguration;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.search.SortDirection;
import ch.icit.pegasus.server.core.util.StringUtil;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;

public class WagModule
extends ScreenTableView<FlightLight, FlightSearchConfiguration.FLIGHT_COLUMN>
implements Module {
    private static final long serialVersionUID = 1L;
    private static final String FILTER_FLIGHT = "flight_number";
    private static final String FILTER_ORDER_NUMBER = "flight_order_number";
    private static final String FILTER_RESTAURANT = "flight_restaurant";
    private static final String FILTER_PERIOD = "flight_period";
    private String filterCriteria1;
    private String filterCriteriaOrderNumber;
    private RestaurantComplete filterRestaurant;
    private PeriodComplete filterPeriod;

    public WagModule() {
        super(FlightLight.class);
        this.isSynchronSearch = false;
        this.updateTitle();
        TextLabel title = this.getTitle();
        title.setText(Words.WEISSE_ARENA_GRUPPE);
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
    }

    @Override
    public AccessDefinitionComplete getInvoker() {
        return WagAccess.MODULE_WAG;
    }

    @Override
    public FilterChainConfiguration getDefaultConfiguration() {
        FilterChainConfiguration c = new FilterChainConfiguration();
        c.addProperty("sortedColumn", FlightScheduleSearchConfiguration.FLIGHT_SCHEDULE_COLUMN.OUTBOUND_CODE + "<>" + true);
        return c;
    }

    @Override
    protected boolean showDeletedComboBox() {
        return false;
    }

    @Override
    protected void createFilterChain(long id) {
        this.filterChain.setDefaultComboWidth(100);
        this.filterChain.overrideDefaultComboBoxWidth(140);
        this.filterChain.overrideDefaultSearchBoxWidth(140);
        this.filterChain.overrideDefaultSearchField2Width(130);
        String searchName = Words.DELIVERY_NO;
        this.filterChain.addSearchField(FILTER_FLIGHT, searchName, "");
        this.filterChain.addSearchField(FILTER_ORDER_NUMBER, "TRANSPORT NO", "");
        this.filterChain.addRestaurantSearchField(FILTER_RESTAURANT);
        PeriodComplete p = FilterChainConfiguration.getDefaultSearchPeriod();
        TitledPeriodEditor period = this.filterChain.addPeriodSelection(FILTER_PERIOD, p.getStartDate(), p.getEndDate(), "Period", true);
        period.setCheckBoxEnabled();
        this.filterChain.addResetButton();
    }

    @Override
    public ASearchConfiguration<FlightLight, FlightSearchConfiguration.FLIGHT_COLUMN> getModuleSearchParameters(Object name, Object value, boolean isReset, boolean getEmptyConfig, Component source) {
        if (isReset) {
            this.filterCriteria1 = null;
            this.filterCriteriaOrderNumber = null;
            this.filterPeriod = null;
            this.filterRestaurant = null;
        } else if (name == FILTER_FLIGHT) {
            this.filterCriteria1 = (String)value;
        } else if (name == FILTER_ORDER_NUMBER) {
            this.filterCriteriaOrderNumber = (String)value;
        } else if (name == FILTER_PERIOD) {
            TitledPeriodEditor ed = (TitledPeriodEditor)value;
            PeriodComplete per = new PeriodComplete();
            per.setStartDate(ed.getStartDate());
            per.setEndDate(ed.getEndDate());
            this.filterPeriod = per;
        } else if (name == FILTER_RESTAURANT) {
            this.filterRestaurant = value instanceof RestaurantComplete ? (RestaurantComplete)value : null;
        }
        FlightSearchConfiguration c = new FlightSearchConfiguration();
        c.setNumResults(this.numberOfShownResults);
        c.setFlightNumber(this.filterCriteria1);
        c.setCustomsDocumentId(this.filterCriteriaOrderNumber);
        c.setFilterByRestaurant(Boolean.valueOf(true));
        RestaurantDeliverySettingsComplete restaurantSettings = (RestaurantDeliverySettingsComplete)NodeToolkit.getAffixClass(RestaurantDeliverySettingsComplete.class).getValue();
        c.setCustomer(restaurantSettings.getDefaultStowingList().getCustomer());
        if (this.filterRestaurant != null) {
            c.getPossibleRestaurants().add(this.filterRestaurant);
        } else {
            UserComplete currentUser = ((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentUser();
            c.setPossibleRestaurants(currentUser.getAccessibleRestaurants());
        }
        c.setOnlyOpenFlights(Boolean.valueOf(true));
        if (this.filterPeriod != null && this.filterPeriod.getStartDate() != null && this.filterPeriod.getEndDate() != null) {
            c.setDayPeriod(new PeriodComplete(this.filterPeriod));
        } else {
            c.setDayPeriod(new PeriodComplete(DateUtil.getSQLDate((int)2020, (int)1, (int)1), DateUtil.getSQLInfinityDate()));
        }
        c.setSearchFlightType(FlightSearchTypeE.FLIGHT_CODE);
        if (!StringUtil.isBlank((String)this.filterCriteriaOrderNumber)) {
            c.setSearchFlightType(FlightSearchTypeE.CUSTOMS_DOCUMENT_ID);
            c.setFlightNumber(this.filterCriteriaOrderNumber);
        }
        if (this.currentColumnAttribute != null) {
            c.setSortColumn(this.currentColumnAttribute);
        }
        if (this.isAsc) {
            c.setSortDirection(SortDirection.ASCENDING);
        } else {
            c.setSortDirection(SortDirection.DESCENDING);
        }
        if (source == this.pagination) {
            c.setPageNumber(this.pagination.getCurrentPage() - 1);
        } else {
            c.setPageNumber(0);
        }
        if (c.getPageNumber() < 0) {
            c.setPageNumber(0);
        }
        return c;
    }

    @Override
    public boolean isAnalysisModuleAllowed(SubModuleAccessRightComplete subModule) {
        return subModule.getModule().getInvokingName().equals(WagAccess.ANALYSIS_ORDER_EXPORT.getIdentifier());
    }

    @Override
    public boolean isSmartScreenAllowed(SubModuleDefinitionComplete screen, RowModel<FlightLight> model) {
        try {
            if (model == null || model.getNode() == null || model.getNode().getValue() == null) {
                return false;
            }
            FlightLight flight = (FlightLight)model.getNode().getValue(FlightLight.class);
            if (flight.getId() == null) {
                return false;
            }
            if (screen.getInvokingName().equals(WagAccess.PRINT_WAG_DELIVERY_SLIP.getIdentifier())) {
                return true;
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    @Override
    public void remoteObjectLoaded(Node<?> node) {
        super.remoteObjectLoaded(node);
    }

    @Override
    public boolean isDeletable(RowModel<FlightLight> model) {
        FlightLight flight = (FlightLight)model.getNode().getValue(FlightLight.class);
        return !Boolean.TRUE.equals(flight.getIsInvoiceClosed()) && flight.getFlightState() == FlightStateE.OPEN;
    }

    @Override
    protected Table.SmartIconConfiguration getPossibleSmartIcons() {
        return Table.SmartIconConfiguration.TWO;
    }

    @Override
    protected RowEditorFactory<FlightLight> getRowEditorFactory() {
        return model -> {
            InputMessageProvidedRowEditor<FlightLight> rowEditor = new InputMessageProvidedRowEditor<FlightLight>(model, "Are you sure to save current order?");
            RDProvider p = this.createProvider(model.isAddRow());
            OrderDataDetailsPanel numberAndNamePanel = new OrderDataDetailsPanel((RowEditor<FlightLight>)rowEditor, p);
            RemarkDetailsPanel remarkPanel = new RemarkDetailsPanel((RowEditor<FlightLight>)rowEditor, p);
            ProductsDetailsPanel productsPanel = new ProductsDetailsPanel((RowEditor<FlightLight>)rowEditor, p);
            CombinedDetailsParagraph c1 = new CombinedDetailsParagraph();
            c1.add((Component)numberAndNamePanel, new TableLayoutConstraint(0, 0, 0.0, 1.0));
            c1.add((Component)remarkPanel, new TableLayoutConstraint(1, 0, 1.0, 1.0));
            CombinedDetailsParagraph c2 = new CombinedDetailsParagraph();
            c2.add((Component)c1, new TableLayoutConstraint(0, 0, 1.0, 1.0));
            rowEditor.add(c2, (Object)new TableLayoutConstraint(0, 0, 1.0, 1.0));
            rowEditor.add(productsPanel, (Object)new TableLayoutConstraint(0, 2, 1.0, 0.0));
            rowEditor.addToFocusQueue(numberAndNamePanel);
            rowEditor.addToFocusQueue(productsPanel);
            rowEditor.addToFocusQueue(remarkPanel);
            rowEditor.allInstalled();
            rowEditor.updateEnableStateToDetailsPanel();
            rowEditor.setVisibleContainer(this.getTable());
            return rowEditor;
        };
    }

    @Override
    protected IDataHandler getModuleDataHandler() {
        return new WagModuleDataHandler(this.loadingId, this);
    }

    @Override
    protected List<TableColumnInfo> getTableColumnInfo() {
        ArrayList<TableColumnInfo> info = new ArrayList<TableColumnInfo>();
        info.add(new TableColumnInfo(Words.STATE, "", (Class)WAGStateEConverter.class, (Enum<?>)FlightSearchConfiguration.FLIGHT_COLUMN.STATE, "", TableColumnInfo.state3WithExpandWidth, TableColumnInfo.state3WithExpandWidth, TableColumnInfo.state3WithExpandWidth));
        info.add(new TableColumnInfo(Words.DELIVERY_NO, "", (Class)FlightTrackingNumberConverter.class, (Enum<?>)FlightSearchConfiguration.FLIGHT_COLUMN.TRACKING_NUMBER, FlightLight_.trackingNumber, 100, 100, 100));
        info.add(new TableColumnInfo("Transport", "", (Class)FlightCustomsDocumentsConverter.class, (Enum<?>)FlightSearchConfiguration.FLIGHT_COLUMN.CUSTOMS_ORDER_ID, FlightLight_.customsDocuments, 180, 180, 180));
        info.add(new TableColumnInfo(Words.RESTAURANT, "", (Class)RestaurantConverter.class, (Enum<?>)FlightSearchConfiguration.FLIGHT_COLUMN.RESTAURANT, FlightLight_.restaurant, TableColumnInfo.flightCategoryWidth, TableColumnInfo.flightCategoryWidth, TableColumnInfo.flightCategoryWidth));
        info.add(new TableColumnInfo(Words.CUSTOMER, "", (Class)CustomerCodeConverter.class, (Enum<?>)FlightSearchConfiguration.FLIGHT_COLUMN.CARRIER, FlightLight_.customer, TableColumnInfo.customerCodeWidth, TableColumnInfo.customerCodeWidth, TableColumnInfo.customerCodeWidth));
        info.add(new TableColumnInfo(Words.DELIVERY_DATE, "", (Class)DateConverter.class, (Enum<?>)FlightSearchConfiguration.FLIGHT_COLUMN.PLANNED_DEPARTURE, FlightLight_.realstd, TableColumnInfo.dateColumnWidth + 15, TableColumnInfo.dateColumnWidth + 15, TableColumnInfo.dateColumnWidth + 15));
        info.add(new TableColumnInfo(Words.INVOICED, "", BooleanConverter.class, null, FlightLight_.isInvoiceClosed, TableColumnInfo.checkColumnWith, TableColumnInfo.checkColumnWith, TableColumnInfo.checkColumnWith));
        info.add(new TableColumnInfo(Words.LAST_UPDATE, "", (Class)LogTimeConverter.class, (Enum<?>)FlightSearchConfiguration.FLIGHT_COLUMN.LAST_UPDATE, FlightLight_.log, TableColumnInfo.dateTimeColumnWidth, TableColumnInfo.dateTimeColumnWidth, TableColumnInfo.dateTimeColumnWidth));
        return info;
    }

    @Override
    public SearchAlgorithm<FlightLight> getSearchAlgorithm() {
        return SearchAlgorithmRegistry.getSearchAlgorithm(FlightSearchAlgorithm.class);
    }
}

