/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.supplier.details;

import ch.icit.pegasus.client.converter.BondedStateEConverter;
import ch.icit.pegasus.client.converter.IntegerConverter;
import ch.icit.pegasus.client.converter.TaxZoneConverter;
import ch.icit.pegasus.client.converter.VendorTypeConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.table.DefaultDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.table.commiter.RemoteCommitter;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.LocationUtil;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.combobox.multiselection.MultiSupplierCertificationsComboBox;
import ch.icit.pegasus.client.gui.utils.focus.MutableFocusContainerListener;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDCheckBox;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDComboBox;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDImageChooser;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDMultiLocationComboBox;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDTextField;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.services.StaticEnumServiceManager;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.server.core.dtos.ILocalizedDTO;
import ch.icit.pegasus.server.core.dtos.masterdata.TaxZoneComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.VendorTypeComplete;
import ch.icit.pegasus.server.core.dtos.supply.SupplierComplete;
import ch.icit.pegasus.server.core.dtos.supply.SupplierComplete_;
import ch.icit.pegasus.server.core.dtos.supply.SupplierLight;
import ch.icit.pegasus.server.core.dtos.supply.SupplierLight_;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public class SpecDetailsPanel
extends DefaultDetailsPanel<SupplierLight> {
    private static final long serialVersionUID = 1L;
    private final boolean isSolarCompany;
    private TitledItem<TextLabel> number;
    private TitledItem<RDTextField> name;
    private TitledItem<RDTextField> customerNumber;
    private TitledItem<RDTextField> invoiceReferenceNumber;
    private TitledItem<RDTextField> invoiceReferenceNumber2;
    private TitledItem<RDImageChooser> imageChooser;
    private TitledItem<RDMultiLocationComboBox> locations;
    private TitledItem<MultiSupplierCertificationsComboBox> certification;
    private TitledItem<RDComboBox> taxZone;
    private TitledItem<RDComboBox> vendorType;
    private TitledItem<RDCheckBox> useForOrder;
    private TitledItem<RDCheckBox> includeDeliveryCosts;
    private TitledItem<RDCheckBox> customsRelevant;
    private TitledItem<RDComboBox> bondedState;

    public SpecDetailsPanel(RowEditor<SupplierLight> editor, RDProvider provider) {
        super(editor, provider);
        this.setOpaque(false);
        this.isSolarCompany = Boolean.TRUE.equals(((SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue()).getCompany().getSolarCompanyType());
        this.setTitleText(Words.SUPPLIER_SPECIFICATIONS);
        this.setCustomLayouter(new Layout());
        this.number = new TitledItem<TextLabel>(new TextLabel(null, ConverterRegistry.getConverter(IntegerConverter.class)), Words.NUMBER, TitledItem.TitledItemOrientation.NORTH);
        this.name = new TitledItem<RDTextField>(new RDTextField(provider), Words.NAME, TitledItem.TitledItemOrientation.NORTH);
        this.name.getElement().setValidateAfterTypeing();
        this.customerNumber = new TitledItem<RDTextField>(new RDTextField(provider), Words.CUSTOMER_NUMBER, TitledItem.TitledItemOrientation.NORTH);
        if (!this.isSolarCompany) {
            if (Boolean.TRUE.equals(this.viewSettings.getShowLocation())) {
                this.locations = new TitledItem<RDMultiLocationComboBox>(new RDMultiLocationComboBox(provider), Words.LOCATIONS, TitledItem.TitledItemOrientation.NORTH);
            }
            this.invoiceReferenceNumber = new TitledItem<RDTextField>(new RDTextField(provider), Words.INVOICE_REFERENCE_NO, TitledItem.TitledItemOrientation.NORTH);
            this.invoiceReferenceNumber2 = new TitledItem<RDTextField>(new RDTextField(provider), Words.INVOICE_REFERENCE_NO, TitledItem.TitledItemOrientation.NORTH);
            this.imageChooser = new TitledItem<RDImageChooser>(new RDImageChooser(provider), Words.SUPPLIER_LOGO, TitledItem.TitledItemOrientation.NORTH);
            this.certification = new TitledItem<MultiSupplierCertificationsComboBox>(new MultiSupplierCertificationsComboBox(null), Words.CERTIFICATION, TitledItem.TitledItemOrientation.NORTH);
            this.customsRelevant = new TitledItem<RDCheckBox>(new RDCheckBox(provider), Words.CUSTOMS_RELEVANT, TitledItem.TitledItemOrientation.EAST);
            this.taxZone = new TitledItem<RDComboBox>(new RDComboBox(provider, ConverterRegistry.getConverter(TaxZoneConverter.class), true), Words.ORIGIN, TitledItem.TitledItemOrientation.NORTH);
            this.vendorType = new TitledItem<RDComboBox>(new RDComboBox(provider, ConverterRegistry.getConverter(VendorTypeConverter.class), true), "Vendor Type", TitledItem.TitledItemOrientation.NORTH);
            this.bondedState = new TitledItem<RDComboBox>(new RDComboBox(provider, ConverterRegistry.getConverter(BondedStateEConverter.class)), Words.BONDED_STATE, TitledItem.TitledItemOrientation.NORTH);
            this.invoiceReferenceNumber.setProgress(1.0f);
            this.invoiceReferenceNumber2.setProgress(1.0f);
            this.imageChooser.setProgress(1.0f);
            this.certification.setProgress(1.0f);
            this.taxZone.setProgress(1.0f);
            this.vendorType.setProgress(1.0f);
            this.customsRelevant.setProgress(1.0f);
            this.bondedState.setProgress(1.0f);
            this.addToView(this.invoiceReferenceNumber);
            this.addToView(this.invoiceReferenceNumber2);
            this.addToView(this.imageChooser);
            if (Boolean.TRUE.equals(this.viewSettings.getShowLocation())) {
                this.addToView(this.locations);
            }
            this.addToView(this.certification);
            this.addToView(this.taxZone);
            this.addToView(this.vendorType);
            this.addToView(this.customsRelevant);
            this.addToView(this.bondedState);
        }
        this.number.getElement().setReadOnlyTextField(true);
        this.useForOrder = new TitledItem<RDCheckBox>(new RDCheckBox(provider), Words.USE_FOR_ORDER, TitledItem.TitledItemOrientation.EAST);
        this.includeDeliveryCosts = new TitledItem<RDCheckBox>(new RDCheckBox(provider), Words.INCLUDE_DELIVERY_COSTS, TitledItem.TitledItemOrientation.EAST);
        this.number.setProgress(1.0f);
        this.name.setProgress(1.0f);
        this.customerNumber.setProgress(1.0f);
        this.useForOrder.setProgress(1.0f);
        this.includeDeliveryCosts.setProgress(1.0f);
        this.addToView(this.number);
        this.addToView(this.name);
        this.addToView(this.customerNumber);
        this.addToView(this.useForOrder);
        this.addToView(this.includeDeliveryCosts);
    }

    @Override
    public void setNode(Node<?> node) {
        if (this.editor.getModel().isAddRow()) {
            SupplierComplete dto = (SupplierComplete)node.getValue();
            LocationUtil.ensureCurrentLocation((ILocalizedDTO)dto);
        }
        this.number.getElement().setNode(node.getChildNamed(SupplierComplete_.number));
        this.name.getElement().setNode(node.getChildNamed(SupplierComplete_.name));
        this.customerNumber.getElement().setNode(node.getChildNamed(SupplierComplete_.customerNumber));
        if (!this.isSolarCompany) {
            this.invoiceReferenceNumber.getElement().setNode(node.getChildNamed(SupplierComplete_.invoiceReferenceNumber));
            this.invoiceReferenceNumber2.getElement().setNode(node.getChildNamed(SupplierComplete_.invoiceReferenceNumber2));
            this.imageChooser.getElement().setNode(node.getChildNamed(SupplierComplete_.image));
            if (Boolean.TRUE.equals(this.viewSettings.getShowLocation())) {
                this.locations.getElement().setNode(node.getChildNamed(SupplierComplete_.eligibleLocations));
            }
            this.certification.getElement().setNode(node.getChildNamed(SupplierComplete_.supplierCerts));
            this.certification.getElement().setNode(node.getChildNamed(SupplierComplete_.supplierCerts));
            this.taxZone.getElement().refreshPossibleValues(NodeToolkit.getAffixList(TaxZoneComplete.class));
            this.taxZone.getElement().setNode(node.getChildNamed(SupplierLight_.taxZone));
            this.vendorType.getElement().refreshPossibleValues(NodeToolkit.getAffixList(VendorTypeComplete.class));
            this.vendorType.getElement().setNode(node.getChildNamed(SupplierComplete_.vendorType));
            this.customsRelevant.getElement().setNode(node.getChildNamed(SupplierLight_.customsRelevant));
            this.bondedState.getElement().refreshPossibleValues(StaticEnumServiceManager.getAllBondedStates());
            this.bondedState.getElement().setNode(node.getChildNamed(SupplierLight_.bondedState));
        }
        this.useForOrder.getElement().setNode(node.getChildNamed(SupplierLight_.useForOrder));
        this.includeDeliveryCosts.getElement().setNode(node.getChildNamed(SupplierComplete_.includeDeliveryCosts));
    }

    @Override
    public boolean grabsFocus() {
        return true;
    }

    @Override
    public void switchState(Button.ButtonState newState) {
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.number.kill();
        this.name.kill();
        this.customerNumber.kill();
        if (!this.isSolarCompany) {
            this.imageChooser.kill();
            if (Boolean.TRUE.equals(this.viewSettings.getShowLocation())) {
                this.locations.kill();
            }
            this.invoiceReferenceNumber.kill();
            this.invoiceReferenceNumber2.kill();
            this.certification.kill();
            this.taxZone.kill();
            this.vendorType.kill();
            this.customsRelevant.kill();
            this.bondedState.kill();
        }
        this.useForOrder.kill();
        this.includeDeliveryCosts.kill();
        this.number = null;
        this.name = null;
        this.customerNumber = null;
        this.imageChooser = null;
        this.locations = null;
        this.invoiceReferenceNumber = null;
        this.invoiceReferenceNumber2 = null;
        this.certification = null;
        this.useForOrder = null;
        this.taxZone = null;
        this.vendorType = null;
        this.includeDeliveryCosts = null;
        this.customsRelevant = null;
        this.bondedState = null;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        this.number.setEnabled(isEnabled);
        this.name.setEnabled(isEnabled);
        this.customerNumber.setEnabled(isEnabled);
        if (!this.isSolarCompany) {
            this.invoiceReferenceNumber.setEnabled(isEnabled);
            this.invoiceReferenceNumber2.setEnabled(isEnabled);
            this.imageChooser.setEnabled(isEnabled);
            if (Boolean.TRUE.equals(this.viewSettings.getShowLocation())) {
                this.locations.setEnabled(isEnabled);
            }
            this.certification.setEnabled(isEnabled);
            this.taxZone.setEnabled(isEnabled);
            this.customsRelevant.setEnabled(isEnabled);
            this.bondedState.setEnabled(isEnabled);
        }
        this.useForOrder.setEnabled(isEnabled);
        this.includeDeliveryCosts.setEnabled(isEnabled);
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> focusList = new ArrayList<Component>();
        CheckedListAdder.addToList(focusList, this.name);
        CheckedListAdder.addToList(focusList, this.customerNumber);
        CheckedListAdder.addToList(focusList, this.invoiceReferenceNumber);
        CheckedListAdder.addToList(focusList, this.invoiceReferenceNumber2);
        CheckedListAdder.addToList(focusList, this.imageChooser);
        CheckedListAdder.addToList(focusList, this.locations);
        CheckedListAdder.addToList(focusList, this.certification);
        CheckedListAdder.addToList(focusList, this.taxZone);
        CheckedListAdder.addToList(focusList, this.vendorType);
        CheckedListAdder.addToList(focusList, this.useForOrder);
        CheckedListAdder.addToList(focusList, this.includeDeliveryCosts);
        CheckedListAdder.addToList(focusList, this.customsRelevant);
        CheckedListAdder.addToList(focusList, this.bondedState);
        return focusList;
    }

    @Override
    public List<RemoteCommitter> commitParagraph() {
        if (!this.isSolarCompany) {
            return this.imageChooser.getElement().commitImage();
        }
        return null;
    }

    @Override
    public void requestFocusInWindowNow() {
        this.name.requestFocusInWindowNow();
    }

    @Override
    public void addFocusCycleChangeListener(MutableFocusContainerListener listener) {
        super.addFocusCycleChangeListener(listener);
        if (!this.isSolarCompany) {
            this.imageChooser.getElement().addFocusCycleChangeListener(listener);
        }
    }

    @Override
    public List<ScreenValidationObject> validateParagraph() {
        String t;
        ArrayList<ScreenValidationObject> validationObjects = new ArrayList<ScreenValidationObject>();
        if (this.name.getElement().isWritable() && ((t = (String)this.editor.getModel().getNode().getChildNamed(SupplierComplete_.name).getValue()) == null || t.isEmpty())) {
            this.name.getElement().setInvalid();
            validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_NAME_IS_SET));
        }
        if (!this.isSolarCompany && Boolean.TRUE.equals(this.viewSettings.getShowLocation()) && this.locations.getElement().isWritable() && this.locations.getElement().getNode().getChildCount() < 1) {
            this.locations.getElement().setInvalid();
            validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.AT_LEAST_ONE_LOCATION_MUST_BE_SET));
        }
        return validationObjects;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            SpecDetailsPanel.this.number.setLocation(SpecDetailsPanel.this.horizontalBorder, SpecDetailsPanel.this.verticalBorder);
            SpecDetailsPanel.this.number.setSize(50, (int)SpecDetailsPanel.this.number.getPreferredSize().getHeight());
            SpecDetailsPanel.this.name.setLocation(SpecDetailsPanel.this.number.getX() + SpecDetailsPanel.this.number.getWidth() + SpecDetailsPanel.this.horizontalBorder, SpecDetailsPanel.this.verticalBorder);
            SpecDetailsPanel.this.name.setSize(parent.getWidth() - (SpecDetailsPanel.this.name.getX() + SpecDetailsPanel.this.horizontalBorder), (int)SpecDetailsPanel.this.name.getPreferredSize().getHeight());
            SpecDetailsPanel.this.customerNumber.setLocation(SpecDetailsPanel.this.horizontalBorder, SpecDetailsPanel.this.name.getY() + SpecDetailsPanel.this.name.getHeight() + SpecDetailsPanel.this.inner_verticalBorder);
            SpecDetailsPanel.this.customerNumber.setSize(parent.getWidth() - 2 * SpecDetailsPanel.this.horizontalBorder, (int)SpecDetailsPanel.this.customerNumber.getPreferredSize().getHeight());
            int cy = SpecDetailsPanel.this.customerNumber.getY() + SpecDetailsPanel.this.customerNumber.getHeight();
            if (!SpecDetailsPanel.this.isSolarCompany) {
                int w2tl = (parent.getWidth() - (2 * SpecDetailsPanel.this.horizontalBorder + SpecDetailsPanel.this.inner_horizontalBorder)) / 2;
                SpecDetailsPanel.this.invoiceReferenceNumber.setLocation(SpecDetailsPanel.this.horizontalBorder, cy + SpecDetailsPanel.this.inner_verticalBorder);
                SpecDetailsPanel.this.invoiceReferenceNumber.setSize(w2tl, (int)SpecDetailsPanel.this.invoiceReferenceNumber.getPreferredSize().getHeight());
                SpecDetailsPanel.this.invoiceReferenceNumber2.setLocation(SpecDetailsPanel.this.invoiceReferenceNumber.getX() + SpecDetailsPanel.this.invoiceReferenceNumber.getWidth() + SpecDetailsPanel.this.inner_horizontalBorder, SpecDetailsPanel.this.invoiceReferenceNumber.getY());
                SpecDetailsPanel.this.invoiceReferenceNumber2.setSize(w2tl, (int)SpecDetailsPanel.this.invoiceReferenceNumber2.getPreferredSize().getHeight());
                SpecDetailsPanel.this.imageChooser.setLocation(SpecDetailsPanel.this.horizontalBorder, SpecDetailsPanel.this.invoiceReferenceNumber.getY() + SpecDetailsPanel.this.invoiceReferenceNumber.getHeight() + SpecDetailsPanel.this.inner_verticalBorder);
                SpecDetailsPanel.this.imageChooser.setSize(SpecDetailsPanel.this.imageChooser.getPreferredSize());
                cy = SpecDetailsPanel.this.imageChooser.getY() + SpecDetailsPanel.this.imageChooser.getHeight();
                int tw = 75;
                if (Boolean.TRUE.equals(SpecDetailsPanel.this.viewSettings.getShowLocation())) {
                    SpecDetailsPanel.this.locations.setLocation(SpecDetailsPanel.this.horizontalBorder, SpecDetailsPanel.this.imageChooser.getY() + SpecDetailsPanel.this.imageChooser.getHeight() + SpecDetailsPanel.this.inner_verticalBorder);
                    SpecDetailsPanel.this.locations.setSize(SpecDetailsPanel.this.locations.getPreferredSize());
                    cy = SpecDetailsPanel.this.locations.getY() + SpecDetailsPanel.this.locations.getHeight();
                    tw = (int)SpecDetailsPanel.this.locations.getPreferredSize().getWidth();
                }
                SpecDetailsPanel.this.certification.setLocation(SpecDetailsPanel.this.horizontalBorder, cy + SpecDetailsPanel.this.inner_verticalBorder);
                SpecDetailsPanel.this.certification.setSize(tw, (int)SpecDetailsPanel.this.certification.getPreferredSize().getHeight());
                SpecDetailsPanel.this.taxZone.setLocation(SpecDetailsPanel.this.horizontalBorder, SpecDetailsPanel.this.certification.getY() + SpecDetailsPanel.this.certification.getHeight() + SpecDetailsPanel.this.inner_verticalBorder);
                SpecDetailsPanel.this.taxZone.setSize(tw, (int)SpecDetailsPanel.this.taxZone.getPreferredSize().getHeight());
                SpecDetailsPanel.this.vendorType.setLocation(SpecDetailsPanel.this.taxZone.getX() + SpecDetailsPanel.this.taxZone.getWidth() + SpecDetailsPanel.this.horizontalBorder, SpecDetailsPanel.this.certification.getY() + SpecDetailsPanel.this.certification.getHeight() + SpecDetailsPanel.this.inner_verticalBorder);
                SpecDetailsPanel.this.vendorType.setSize(tw, (int)SpecDetailsPanel.this.vendorType.getPreferredSize().getHeight());
                cy = SpecDetailsPanel.this.vendorType.getY() + SpecDetailsPanel.this.vendorType.getHeight();
            }
            SpecDetailsPanel.this.useForOrder.setLocation(SpecDetailsPanel.this.horizontalBorder, cy + SpecDetailsPanel.this.verticalBorder);
            SpecDetailsPanel.this.useForOrder.setSize(SpecDetailsPanel.this.useForOrder.getPreferredSize());
            SpecDetailsPanel.this.includeDeliveryCosts.setLocation(SpecDetailsPanel.this.horizontalBorder, SpecDetailsPanel.this.useForOrder.getY() + SpecDetailsPanel.this.useForOrder.getHeight() + SpecDetailsPanel.this.inner_verticalBorder);
            SpecDetailsPanel.this.includeDeliveryCosts.setSize(SpecDetailsPanel.this.includeDeliveryCosts.getPreferredSize());
            if (!SpecDetailsPanel.this.isSolarCompany) {
                SpecDetailsPanel.this.customsRelevant.setLocation(SpecDetailsPanel.this.horizontalBorder, SpecDetailsPanel.this.includeDeliveryCosts.getY() + SpecDetailsPanel.this.includeDeliveryCosts.getHeight() + SpecDetailsPanel.this.inner_verticalBorder);
                SpecDetailsPanel.this.customsRelevant.setSize(SpecDetailsPanel.this.customsRelevant.getPreferredSize());
                SpecDetailsPanel.this.bondedState.setLocation(SpecDetailsPanel.this.horizontalBorder, SpecDetailsPanel.this.customsRelevant.getY() + SpecDetailsPanel.this.customsRelevant.getHeight() + SpecDetailsPanel.this.inner_verticalBorder);
                SpecDetailsPanel.this.bondedState.setSize(parent.getWidth() - 2 * SpecDetailsPanel.this.bondedState.getX(), (int)SpecDetailsPanel.this.bondedState.getPreferredSize().getHeight());
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = SpecDetailsPanel.this.verticalBorder;
            h = (int)((double)h + SpecDetailsPanel.this.name.getPreferredSize().getHeight());
            h += SpecDetailsPanel.this.inner_verticalBorder;
            h = (int)((double)h + SpecDetailsPanel.this.customerNumber.getPreferredSize().getHeight());
            h += SpecDetailsPanel.this.inner_verticalBorder;
            if (!SpecDetailsPanel.this.isSolarCompany) {
                h = (int)((double)h + SpecDetailsPanel.this.invoiceReferenceNumber.getPreferredSize().getHeight());
                h += SpecDetailsPanel.this.inner_verticalBorder;
                h = (int)((double)h + SpecDetailsPanel.this.imageChooser.getPreferredSize().getHeight());
                h += SpecDetailsPanel.this.inner_verticalBorder;
                if (Boolean.TRUE.equals(SpecDetailsPanel.this.viewSettings.getShowLocation())) {
                    h = (int)((double)h + SpecDetailsPanel.this.locations.getPreferredSize().getHeight());
                    h += SpecDetailsPanel.this.inner_verticalBorder;
                }
                h = (int)((double)h + SpecDetailsPanel.this.taxZone.getPreferredSize().getHeight());
                h += SpecDetailsPanel.this.inner_verticalBorder;
                h = (int)((double)h + SpecDetailsPanel.this.certification.getPreferredSize().getHeight());
                h += SpecDetailsPanel.this.inner_verticalBorder;
            }
            h = (int)((double)h + SpecDetailsPanel.this.useForOrder.getPreferredSize().getHeight());
            h += SpecDetailsPanel.this.inner_verticalBorder;
            h = (int)((double)h + SpecDetailsPanel.this.includeDeliveryCosts.getPreferredSize().getHeight());
            h += SpecDetailsPanel.this.inner_verticalBorder;
            if (!SpecDetailsPanel.this.isSolarCompany) {
                h = (int)((double)h + SpecDetailsPanel.this.customsRelevant.getPreferredSize().getHeight());
                h += SpecDetailsPanel.this.inner_verticalBorder;
                h = (int)((double)h + SpecDetailsPanel.this.bondedState.getPreferredSize().getHeight());
                h += SpecDetailsPanel.this.verticalBorder;
            }
            return new Dimension(300, h);
        }
    }
}

