/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.supplier.details;

import ch.icit.pegasus.client.converter.CurrencyConverter;
import ch.icit.pegasus.client.converter.SupplierDeliveryCostConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.modules.supplier.details.utils.ContactNameConverter;
import ch.icit.pegasus.client.gui.modules.supplier.details.utils.DeliveryCostConfigurationPopup;
import ch.icit.pegasus.client.gui.table.DefaultDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.InnerPopUpListener2;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.EditButton;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDCheckBox;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDComboBox;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDNumericStepper;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDTextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextFieldType;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeListener;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.node.impls.ViewNode;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.server.core.dtos.masterdata.CurrencyComplete;
import ch.icit.pegasus.server.core.dtos.supply.PriceComplete;
import ch.icit.pegasus.server.core.dtos.supply.PriceComplete_;
import ch.icit.pegasus.server.core.dtos.supply.SupplierComplete;
import ch.icit.pegasus.server.core.dtos.supply.SupplierComplete_;
import ch.icit.pegasus.server.core.dtos.supply.SupplierDeliveryCostTypeE;
import ch.icit.pegasus.server.core.dtos.supply.SupplierLight;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class PaymentDetailsPanel
extends DefaultDetailsPanel<SupplierLight>
implements NodeListener,
ButtonListener,
InnerPopUpListener2 {
    private static final long serialVersionUID = 1L;
    private final boolean isSolarCompany;
    private TitledItem<RDNumericStepper> terms;
    private TextLabel termsPostfix;
    private TitledItem<RDTextField> discount;
    private TextLabel discountUnit;
    private TitledItem<RDComboBox> currency;
    private TitledItem<RDComboBox> billingContact;
    private TitledItem<RDCheckBox> deliversDutyFree;
    private TitledItem<RDComboBox> deliveryCostType;
    private EditButton editButton;
    private final boolean isDeliveryEditable;

    public PaymentDetailsPanel(RowEditor<SupplierLight> editor, RDProvider provider) {
        super(editor, provider);
        this.isDeliveryEditable = provider.isWritable(SupplierComplete_.costType);
        this.isSolarCompany = Boolean.TRUE.equals(this.settings.getCompany().getSolarCompanyType());
        this.setOpaque(false);
        this.setTitleText(Words.PAYMENT_SETTINGS);
        this.setCustomLayouter(new Layout());
        this.terms = new TitledItem<RDNumericStepper>(new RDNumericStepper(provider, 3), Words.TERMS, TitledItem.TitledItemOrientation.NORTH);
        this.termsPostfix = new TextLabel(Words.DAYS);
        this.discount = new TitledItem<RDTextField>(new RDTextField(provider, TextFieldType.DOUBLE), Words.DISCOUNT, TitledItem.TitledItemOrientation.NORTH);
        this.discountUnit = new TextLabel("%");
        this.currency = new TitledItem<RDComboBox>(new RDComboBox(provider, ConverterRegistry.getConverter(CurrencyConverter.class)), Words.CURRENCY, TitledItem.TitledItemOrientation.NORTH);
        this.currency.getElement().refreshPossibleValues(NodeToolkit.getAffixList(CurrencyComplete.class));
        if (!this.isSolarCompany) {
            this.deliversDutyFree = new TitledItem<RDCheckBox>(new RDCheckBox(provider), Words.DELIVERS_DUTY_FREE, TitledItem.TitledItemOrientation.NORTH);
            this.addToView(this.deliversDutyFree);
        }
        this.billingContact = new TitledItem<RDComboBox>(new RDComboBox(provider, ConverterRegistry.getConverter(ContactNameConverter.class)), Words.CONTACT, TitledItem.TitledItemOrientation.NORTH);
        this.deliveryCostType = new TitledItem<RDComboBox>(new RDComboBox(provider, ConverterRegistry.getConverter(SupplierDeliveryCostConverter.class)), Words.DELIVERY_COST, TitledItem.TitledItemOrientation.NORTH);
        this.editButton = new EditButton();
        this.editButton.addButtonListener(this);
        if (editor.getModel().isAddRow()) {
            this.setNode(editor.getModel().getNode());
        }
        this.addToView(this.terms);
        this.addToView(this.termsPostfix);
        this.addToView(this.discount);
        this.addToView(this.discountUnit);
        this.addToView(this.currency);
        this.addToView(this.billingContact);
        this.addToView(this.deliveryCostType);
        this.addToView(this.editButton);
    }

    private void ensurePrice() {
        SupplierDeliveryCostTypeE ct = (SupplierDeliveryCostTypeE)this.editor.getModel().getNode().getChildNamed(SupplierComplete_.costType).getValue();
        long id = System.currentTimeMillis();
        switch (ct) {
            case FIX: {
                this.editor.getModel().getNode().getChildNamed(SupplierComplete_.minOrderValue).removeExistingValues();
                this.editor.getModel().getNode().getChildNamed(SupplierComplete_.minOrderValue).setValue(null, id);
                this.editor.getModel().getNode().getChildNamed(SupplierComplete_.minOrderValue).updateNode();
                if (this.editor.getModel().getNode().getChildNamed(SupplierComplete_.deliveryCost).getValue() != null) break;
                this.editor.getModel().getNode().getChildNamed(SupplierComplete_.deliveryCost).setValue((Object)new PriceComplete((CurrencyComplete)this.editor.getModel().getNode().getChildNamed(SupplierComplete_.paymentCurrency).getValue(), Double.valueOf(0.0)), id);
                this.editor.getModel().getNode().getChildNamed(SupplierComplete_.deliveryCost).updateNode();
                break;
            }
            case MINAMOUNT: {
                if (this.editor.getModel().getNode().getChildNamed(SupplierComplete_.minOrderValue).getValue() == null) {
                    this.editor.getModel().getNode().getChildNamed(SupplierComplete_.minOrderValue).setValue((Object)new PriceComplete((CurrencyComplete)this.editor.getModel().getNode().getChildNamed(SupplierComplete_.paymentCurrency).getValue(), Double.valueOf(0.0)), id);
                    this.editor.getModel().getNode().getChildNamed(SupplierComplete_.minOrderValue).updateNode();
                }
                if (this.editor.getModel().getNode().getChildNamed(SupplierComplete_.deliveryCost).getValue() != null) break;
                this.editor.getModel().getNode().getChildNamed(SupplierComplete_.deliveryCost).setValue((Object)new PriceComplete((CurrencyComplete)this.editor.getModel().getNode().getChildNamed(SupplierComplete_.paymentCurrency).getValue(), Double.valueOf(0.0)), id);
                this.editor.getModel().getNode().getChildNamed(SupplierComplete_.deliveryCost).updateNode();
                break;
            }
            case NONE: {
                this.editor.getModel().getNode().getChildNamed(SupplierComplete_.minOrderValue).removeExistingValues();
                this.editor.getModel().getNode().getChildNamed(SupplierComplete_.minOrderValue).setValue(null, id);
                this.editor.getModel().getNode().getChildNamed(SupplierComplete_.minOrderValue).updateNode();
                this.editor.getModel().getNode().getChildNamed(SupplierComplete_.deliveryCost).removeExistingValues();
                this.editor.getModel().getNode().getChildNamed(SupplierComplete_.deliveryCost).setValue(null, id);
                this.editor.getModel().getNode().getChildNamed(SupplierComplete_.deliveryCost).updateNode();
            }
        }
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        super.buttonPressed(source, x, y);
        if (source == this.editButton) {
            InnerPopUp2 popUp = InnerPopUp2.getInnerPopUp();
            popUp.setAttributes(source, true, true, Words.CONFIGURE_DELIVERY_COSTS);
            popUp.setView(new DeliveryCostConfigurationPopup(this.editor.getModel().getNode()));
            popUp.hideCancelButton();
            popUp.showPopUp(x, y, -1, -1, this, source);
        }
    }

    @Override
    public void setNode(Node<?> node) {
        this.terms.getElement().setNode(node.getChildNamed(SupplierComplete_.paymentDays));
        this.discount.getElement().setNode(node.getChildNamed(SupplierComplete_.discount));
        this.currency.getElement().setNode(node.getChildNamed(SupplierComplete_.paymentCurrency));
        this.billingContact.getElement().refreshPossibleValues(this.createBillingList());
        this.billingContact.getElement().setNode(node.getChildNamed(SupplierComplete_.billingContact));
        if (!this.isSolarCompany) {
            this.deliversDutyFree.getElement().setNode(node.getChildNamed(SupplierComplete_.deliverDutyFree));
        }
        if (node.getChildNamed(SupplierComplete_.costType).getValue() == null) {
            node.getChildNamed(SupplierComplete_.costType).setValue((Object)SupplierDeliveryCostTypeE.NONE, 0L);
        }
        this.deliveryCostType.getElement().refreshPossibleValues(NodeToolkit.getAffixList(SupplierDeliveryCostTypeE.class));
        this.deliveryCostType.getElement().setNode(node.getChildNamed(SupplierComplete_.costType));
        this.editor.getModel().getNode().getChildNamed(SupplierComplete_.costType).addNodeListener((NodeListener)this);
    }

    private Node<?> createBillingList() {
        ViewNode n = new ViewNode("BillingContacts");
        Iterator it = this.editor.getModel().getNode().getChildNamed(SupplierComplete_.contacts).getChilds();
        while (it.hasNext()) {
            Node nn = (Node)it.next();
            n.addChild(nn, 0L);
        }
        this.editor.getModel().getNode().getChildNamed(SupplierComplete_.contacts).addNodeListener((NodeListener)this);
        return n;
    }

    @Override
    public void switchState(Button.ButtonState newState) {
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> focusList = new ArrayList<Component>();
        CheckedListAdder.addToList(focusList, this.terms);
        if (this.currency.isEnabled()) {
            CheckedListAdder.addToList(focusList, this.currency);
        }
        CheckedListAdder.addToList(focusList, this.discount);
        CheckedListAdder.addToList(focusList, this.deliversDutyFree);
        CheckedListAdder.addToList(focusList, this.deliveryCostType);
        CheckedListAdder.addToList(focusList, this.editButton);
        CheckedListAdder.addToList(focusList, this.billingContact);
        return focusList;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        try {
            this.editor.getModel().getNode().getChildNamed(SupplierComplete_.contacts).removeNodeListener((NodeListener)this);
            this.editor.getModel().getNode().getChildNamed(SupplierComplete_.costType).removeNodeListener((NodeListener)this);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.terms.kill();
        this.termsPostfix.kill();
        this.discount.kill();
        this.discountUnit.kill();
        if (!this.isSolarCompany) {
            this.deliversDutyFree.kill();
        }
        this.deliveryCostType.kill();
        this.currency.kill();
        this.billingContact.kill();
        this.editButton.kill();
        this.terms = null;
        this.deliveryCostType = null;
        this.termsPostfix = null;
        this.discount = null;
        this.discountUnit = null;
        this.deliversDutyFree = null;
        this.currency = null;
        this.billingContact = null;
        this.editButton = null;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        this.terms.setEnabled(isEnabled);
        this.termsPostfix.setEnabled(isEnabled);
        this.discount.setEnabled(isEnabled);
        this.discountUnit.setEnabled(isEnabled);
        if (!this.isSolarCompany) {
            this.deliversDutyFree.setEnabled(isEnabled);
        }
        this.deliveryCostType.setEnabled(isEnabled);
        if (!this.editor.getModel().isAddRow()) {
            this.currency.setEnabled(isEnabled);
        }
        this.billingContact.setEnabled(isEnabled);
        this.editButton.setEnabled(isEnabled & this.isDeliveryEditable);
    }

    public void childAdded(Node<?> source, Node<?> child) {
        this.billingContact.getElement().getPossibleValues().addChild(child, 0L);
    }

    public void childRemoved(Node<?> source, Node<?> child) {
        this.billingContact.getElement().getPossibleValues().removeChild(child, 0L);
    }

    public void childrenAdded(Node<?> source, Node<?> ... nodes) {
    }

    public void valueChanged(Node<?> node) {
        this.ensurePrice();
    }

    @Override
    public void requestFocusInWindowNow() {
    }

    @Override
    public void popUpClosed(InnerPopUp2 source, Object ... xargs) {
    }

    @Override
    public List<ScreenValidationObject> validateParagraph() {
        ArrayList<ScreenValidationObject> validationObjects = new ArrayList<ScreenValidationObject>();
        if (this.currency.getElement().isWritable()) {
            SupplierComplete s = (SupplierComplete)this.editor.getModel().getNode().getValue(SupplierComplete.class);
            CurrencyComplete c = (CurrencyComplete)this.editor.getModel().getNode().getChildNamed(SupplierComplete_.paymentCurrency).getValue();
            if (!s.getPaymentCurrency().equals((Object)c)) {
                String msg = "";
                msg = "Currency changed! Please review all Article delivered by this Supplier.<br/><br/><b>To show this Articles:</b>";
                msg = msg + "<ul><li>Open Article module and select current Supplier in Filter Chain</li>";
                msg = msg + "<li>Open each Article and remove Supplier Condition</li>";
                msg = msg + "<li>Add Supplier Condition for given Supplier</li></ul>";
                msg = msg + "The Article's Supplier Price has the right Currency now.";
                validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.MESSAGE, msg));
            }
        }
        if (this.deliveryCostType.getElement().isWritable()) {
            SupplierDeliveryCostTypeE type = (SupplierDeliveryCostTypeE)this.editor.getModel().getNode().getChildNamed(SupplierComplete_.costType).getValue();
            switch (type) {
                case FIX: {
                    if (this.editor.getModel().getNode().getChildNamed(SupplierComplete_.deliveryCost).getValue() != null && this.editor.getModel().getNode().getChildNamed(new DtoField[]{SupplierComplete_.deliveryCost, PriceComplete_.price}).getValue() != null && this.editor.getModel().getNode().getChildNamed(new DtoField[]{SupplierComplete_.deliveryCost, PriceComplete_.currency}).getValue() != null) break;
                    validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_FIX_COST_ARE_SET));
                    break;
                }
                case MINAMOUNT: {
                    if (this.editor.getModel().getNode().getChildNamed(SupplierComplete_.minOrderValue).getValue() == null || this.editor.getModel().getNode().getChildNamed(new DtoField[]{SupplierComplete_.minOrderValue, PriceComplete_.price}).getValue() == null || this.editor.getModel().getNode().getChildNamed(new DtoField[]{SupplierComplete_.minOrderValue, PriceComplete_.currency}).getValue() == null) {
                        validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_MIN_ORDER_VALUE_IS_SET));
                    }
                    if (this.editor.getModel().getNode().getChildNamed(SupplierComplete_.deliveryCost).getValue() != null && this.editor.getModel().getNode().getChildNamed(new DtoField[]{SupplierComplete_.deliveryCost, PriceComplete_.price}).getValue() != null && this.editor.getModel().getNode().getChildNamed(new DtoField[]{SupplierComplete_.deliveryCost, PriceComplete_.currency}).getValue() != null) break;
                    validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_ORDER_COSTS_SET));
                    break;
                }
                case NONE: {
                    break;
                }
                default: {
                    this.editor.getModel().getNode().getChildNamed(SupplierComplete_.costType).setValue((Object)SupplierDeliveryCostTypeE.NONE, 0L);
                }
            }
        }
        return validationObjects;
    }

    public boolean isSwingOnly() {
        return true;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int aMinWidth = parent.getWidth() - 3 * PaymentDetailsPanel.this.horizontalBorder;
            PaymentDetailsPanel.this.terms.setLocation(PaymentDetailsPanel.this.horizontalBorder, PaymentDetailsPanel.this.verticalBorder);
            PaymentDetailsPanel.this.terms.setSize((int)((double)(aMinWidth /= 2) - (PaymentDetailsPanel.this.termsPostfix.getPreferredSize().getWidth() + 5.0)), (int)PaymentDetailsPanel.this.terms.getPreferredSize().getHeight());
            PaymentDetailsPanel.this.termsPostfix.setLocation(PaymentDetailsPanel.this.terms.getX() + PaymentDetailsPanel.this.terms.getWidth() + 5, (int)((double)(PaymentDetailsPanel.this.terms.getY() + PaymentDetailsPanel.this.terms.getHeight()) - PaymentDetailsPanel.this.termsPostfix.getPreferredSize().getHeight()));
            PaymentDetailsPanel.this.termsPostfix.setSize(PaymentDetailsPanel.this.termsPostfix.getPreferredSize());
            PaymentDetailsPanel.this.currency.setLocation(PaymentDetailsPanel.this.termsPostfix.getX() + PaymentDetailsPanel.this.termsPostfix.getWidth() + PaymentDetailsPanel.this.horizontalBorder, PaymentDetailsPanel.this.verticalBorder);
            PaymentDetailsPanel.this.currency.setSize(aMinWidth, (int)PaymentDetailsPanel.this.currency.getPreferredSize().getHeight());
            aMinWidth = parent.getWidth() - 3 * PaymentDetailsPanel.this.horizontalBorder;
            PaymentDetailsPanel.this.discount.setLocation(PaymentDetailsPanel.this.horizontalBorder, PaymentDetailsPanel.this.currency.getY() + PaymentDetailsPanel.this.currency.getHeight() + PaymentDetailsPanel.this.inner_verticalBorder);
            PaymentDetailsPanel.this.discount.setSize((int)((double)(aMinWidth /= 2) - (PaymentDetailsPanel.this.discountUnit.getPreferredSize().getWidth() + 5.0)), (int)PaymentDetailsPanel.this.discount.getPreferredSize().getHeight());
            PaymentDetailsPanel.this.discountUnit.setLocation(PaymentDetailsPanel.this.discount.getX() + PaymentDetailsPanel.this.discount.getWidth() + 5, (int)((double)(PaymentDetailsPanel.this.discount.getY() + PaymentDetailsPanel.this.discount.getHeight()) - PaymentDetailsPanel.this.discountUnit.getPreferredSize().getHeight()));
            PaymentDetailsPanel.this.discountUnit.setSize(PaymentDetailsPanel.this.discountUnit.getPreferredSize());
            if (!PaymentDetailsPanel.this.isSolarCompany) {
                PaymentDetailsPanel.this.deliversDutyFree.setLocation(PaymentDetailsPanel.this.discountUnit.getX() + PaymentDetailsPanel.this.discountUnit.getWidth() + PaymentDetailsPanel.this.inner_horizontalBorder, PaymentDetailsPanel.this.discount.getY());
                PaymentDetailsPanel.this.deliversDutyFree.setSize(PaymentDetailsPanel.this.deliversDutyFree.getPreferredSize());
            }
            PaymentDetailsPanel.this.deliveryCostType.setLocation(PaymentDetailsPanel.this.horizontalBorder, PaymentDetailsPanel.this.discount.getY() + PaymentDetailsPanel.this.discount.getHeight() + PaymentDetailsPanel.this.inner_verticalBorder);
            PaymentDetailsPanel.this.deliveryCostType.setSize(aMinWidth, (int)PaymentDetailsPanel.this.deliveryCostType.getPreferredSize().getHeight());
            PaymentDetailsPanel.this.editButton.setLocation(PaymentDetailsPanel.this.deliveryCostType.getX() + PaymentDetailsPanel.this.deliveryCostType.getWidth() + PaymentDetailsPanel.this.inner_horizontalBorder, (int)((double)(PaymentDetailsPanel.this.deliveryCostType.getY() + PaymentDetailsPanel.this.deliveryCostType.getHeight()) - (PaymentDetailsPanel.this.editButton.getPreferredSize().getHeight() + 3.0)));
            PaymentDetailsPanel.this.editButton.setSize(PaymentDetailsPanel.this.editButton.getPreferredSize());
            PaymentDetailsPanel.this.billingContact.setLocation(PaymentDetailsPanel.this.discount.getX(), PaymentDetailsPanel.this.deliveryCostType.getY() + PaymentDetailsPanel.this.deliveryCostType.getHeight() + PaymentDetailsPanel.this.inner_verticalBorder);
            PaymentDetailsPanel.this.billingContact.setSize(parent.getWidth() - 2 * PaymentDetailsPanel.this.horizontalBorder, (int)PaymentDetailsPanel.this.billingContact.getPreferredSize().getHeight());
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = PaymentDetailsPanel.this.verticalBorder;
            h = (int)((double)h + PaymentDetailsPanel.this.terms.getPreferredSize().getHeight());
            h += PaymentDetailsPanel.this.inner_verticalBorder;
            h = (int)((double)h + PaymentDetailsPanel.this.discount.getPreferredSize().getHeight());
            h += PaymentDetailsPanel.this.inner_verticalBorder;
            h = (int)((double)h + PaymentDetailsPanel.this.deliveryCostType.getPreferredSize().getHeight());
            h += PaymentDetailsPanel.this.inner_verticalBorder;
            h = (int)((double)h + PaymentDetailsPanel.this.billingContact.getPreferredSize().getHeight());
            return new Dimension(0, h += PaymentDetailsPanel.this.verticalBorder);
        }
    }
}

