/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.supplier.details;

import ch.icit.pegasus.client.converter.HolidayTypeCompleteConverter;
import ch.icit.pegasus.client.converter.OrderDeliveryWindowConverter;
import ch.icit.pegasus.client.converter.OrderTypeConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.modules.supplier.details.utils.ContactNameConverter;
import ch.icit.pegasus.client.gui.table.DefaultDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.InnerPopUpListener2;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.EditButton;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDCheckBox;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDComboBox;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDTextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextFieldType;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeListener;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.node.impls.ViewNode;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.server.core.dtos.masterdata.ContactComplete_;
import ch.icit.pegasus.server.core.dtos.masterdata.HolidayPlanTypeComplete;
import ch.icit.pegasus.server.core.dtos.ordering.OrderDeliveryWindowComplete;
import ch.icit.pegasus.server.core.dtos.supply.OrderTypeComplete;
import ch.icit.pegasus.server.core.dtos.supply.SupplierComplete_;
import ch.icit.pegasus.server.core.dtos.supply.SupplierLight;
import ch.icit.pegasus.server.core.dtos.supply.SupplierLight_;
import ch.icit.pegasus.server.core.dtos.system.PurchaseApprovalSettingsComplete;
import ch.icit.pegasus.server.core.dtos.utils.DateUtil;
import ch.icit.pegasus.server.core.i18n.Phrase;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class OrderDetailsPanel
extends DefaultDetailsPanel<SupplierLight>
implements NodeListener,
InnerPopUpListener2,
ItemListener {
    private static final long serialVersionUID = 1L;
    private final boolean isSolarCompany;
    private TitledItem<RDComboBox> orderBy;
    private RDTextField email;
    private TitledItem<RDComboBox> orderContact;
    private TitledItem<TextLabel> additionalConditions;
    private EditButton editAdditionalConditions;
    private TextLabel infoText;
    private TitledItem<RDCheckBox> knownSupplier;
    private final boolean isDeliveryConditionEditable;
    private TitledItem<RDComboBox> defaultDeliveryWindow;
    private TitledItem<RDCheckBox> overrideReceiveThreshold;
    private TitledItem<RDTextField> receiveThresholdUnderFlow;
    private TitledItem<RDTextField> receiveThresholdOverFlow;
    private TitledItem<RDComboBox> holidayPlanType;
    private TitledItem<RDTextField> defaultOrderRemark;
    private TitledItem<RDTextField> defaultOrderFooter;
    private TitledItem<RDCheckBox> ignorePurchaseApproval;
    private TitledItem<RDCheckBox> overrideApprovalTime;
    private TitledItem<RDTextField> approvalTime;

    public OrderDetailsPanel(RowEditor<SupplierLight> editor, RDProvider provider) {
        super(editor, provider);
        this.setOpaque(false);
        this.setTitleText(Words.ORDER_SETTINGS);
        this.setCustomLayouter(new Layout());
        this.isSolarCompany = Boolean.TRUE.equals(this.settings.getCompany().getSolarCompanyType());
        this.isDeliveryConditionEditable = provider.isWritable(SupplierComplete_.deliveryConditions);
        this.infoText = new TextLabel();
        this.infoText.setLineWrap(true, 0);
        this.infoText.setText(Words.EMAIL_FOR_SUPPLIER_TEXT);
        this.infoText.setFont(this.infoText.getFont().deriveFont(2));
        this.orderBy = new TitledItem<RDComboBox>(new RDComboBox(provider, ConverterRegistry.getConverter(OrderTypeConverter.class)), Words.ORDER_BY, TitledItem.TitledItemOrientation.NORTH);
        this.orderBy.getElement().refreshPossibleValues(NodeToolkit.getAffixList(OrderTypeComplete.class));
        this.orderBy.getElement().addItemListener(this);
        this.email = new RDTextField(provider);
        this.orderContact = new TitledItem<RDComboBox>(new RDComboBox(provider, ConverterRegistry.getConverter(ContactNameConverter.class)), Words.CONTACT, TitledItem.TitledItemOrientation.NORTH);
        if (!this.isSolarCompany) {
            this.holidayPlanType = new TitledItem<RDComboBox>(new RDComboBox(provider, ConverterRegistry.getConverter(HolidayTypeCompleteConverter.class), true), "Holiday Plan", TitledItem.TitledItemOrientation.NORTH);
            this.overrideReceiveThreshold = new TitledItem<RDCheckBox>(new RDCheckBox(provider), "Override Receive Threshold", TitledItem.TitledItemOrientation.EAST);
            this.overrideReceiveThreshold.getElement().addButtonListener((source, x, y) -> this.setEnabled(this.isEnabled()));
            this.receiveThresholdUnderFlow = new TitledItem<RDTextField>(new RDTextField(provider, TextFieldType.DOUBLE), "Receive Threshold Underflow [%]", TitledItem.TitledItemOrientation.NORTH);
            this.receiveThresholdOverFlow = new TitledItem<RDTextField>(new RDTextField(provider, TextFieldType.DOUBLE), "Receive Threshold Overflow [%]", TitledItem.TitledItemOrientation.NORTH);
            this.additionalConditions = new TitledItem<TextLabel>(new TextLabel(), Words.ADDITIONAL_ORDER_CONDITIONS, TitledItem.TitledItemOrientation.NORTH);
            this.editAdditionalConditions = new EditButton();
            this.editAdditionalConditions.addButtonListener(this);
            this.knownSupplier = new TitledItem<RDCheckBox>(new RDCheckBox(provider), Words.KNOWN_SUPPLIER, TitledItem.TitledItemOrientation.EAST);
        }
        this.defaultDeliveryWindow = new TitledItem<RDComboBox>(new RDComboBox(provider, ConverterRegistry.getConverter(OrderDeliveryWindowConverter.class)), Words.DELIVERY_TIME_WINDOW, TitledItem.TitledItemOrientation.NORTH);
        this.defaultOrderRemark = new TitledItem<RDTextField>(new RDTextField(provider), Words.DEFAULT_ORDER_REMARK, TitledItem.TitledItemOrientation.NORTH);
        this.defaultOrderFooter = new TitledItem<RDTextField>(new RDTextField(provider), Words.DEFAULT_ORDER_FOOTER, TitledItem.TitledItemOrientation.NORTH);
        PurchaseApprovalSettingsComplete purchaseReleaseSettings = (PurchaseApprovalSettingsComplete)NodeToolkit.getAffixClass(PurchaseApprovalSettingsComplete.class).getValue();
        if (Boolean.TRUE.equals(purchaseReleaseSettings.getUsePurchaseApproval())) {
            this.ignorePurchaseApproval = new TitledItem<RDCheckBox>(new RDCheckBox(provider), "Ignore Purchase Approval Process", TitledItem.TitledItemOrientation.EAST);
            this.overrideApprovalTime = new TitledItem<RDCheckBox>(new RDCheckBox(provider), "Override Purchase Approval Time", TitledItem.TitledItemOrientation.NORTH);
            this.approvalTime = new TitledItem<RDTextField>(new RDTextField(provider, TextFieldType.DAYTIME), "Purchase Approval Time", TitledItem.TitledItemOrientation.NORTH);
            this.overrideApprovalTime.getElement().addButtonListener((source, x, y) -> this.setEnabled(this.isEnabled()));
        }
        if (editor.getModel().isAddRow()) {
            this.setNode(editor.getModel().getNode());
        }
        this.addToView(this.orderBy);
        this.addToView(this.email);
        this.addToView(this.infoText);
        this.addToView(this.orderContact);
        this.addToView(this.defaultDeliveryWindow);
        this.addToView(this.defaultOrderRemark);
        this.addToView(this.defaultOrderFooter);
        if (!this.isSolarCompany) {
            this.addToView(this.additionalConditions);
            this.addToView(this.editAdditionalConditions);
            this.addToView(this.knownSupplier);
            this.addToView(this.overrideReceiveThreshold);
            this.addToView(this.receiveThresholdUnderFlow);
            this.addToView(this.receiveThresholdOverFlow);
            this.addToView(this.holidayPlanType);
        }
        if (this.ignorePurchaseApproval != null) {
            this.addToView(this.ignorePurchaseApproval);
            this.addToView(this.overrideApprovalTime);
            this.addToView(this.approvalTime);
        }
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        super.buttonPressed(source, x, y);
        if (source == this.editAdditionalConditions) {
            InnerPopupFactory.showEnterMessagePopup(Words.ADDITIONAL_ORDER_CONDITIONS, this, source, this.editor.getModel().getNode().getChildNamed(SupplierComplete_.deliveryConditions), x, y);
        }
    }

    @Override
    public void setNode(Node<?> node) {
        this.orderBy.getElement().setNode(node.getChildNamed(SupplierComplete_.orderType));
        this.email.setNode(node.getChildNamed(SupplierComplete_.orderContactNumber));
        this.orderContact.getElement().refreshPossibleValues(this.createOrderList());
        this.orderContact.getElement().setNode(node.getChildNamed(SupplierComplete_.orderContact));
        this.defaultDeliveryWindow.getElement().refreshPossibleValues(NodeToolkit.getAffixList(OrderDeliveryWindowComplete.class));
        this.defaultDeliveryWindow.getElement().setNode(node.getChildNamed(SupplierComplete_.defaultDeliveryWindow));
        this.defaultOrderRemark.getElement().setNode(node.getChildNamed(SupplierLight_.defaultOrderRemark));
        this.defaultOrderFooter.getElement().setNode(node.getChildNamed(SupplierComplete_.defaultOrderFooter));
        if (!this.isSolarCompany) {
            this.additionalConditions.getElement().setNode(node.getChildNamed(SupplierComplete_.deliveryConditions));
            this.knownSupplier.getElement().setNode(node.getChildNamed(SupplierComplete_.knownSupplier));
            this.overrideReceiveThreshold.getElement().setNode(node.getChildNamed(SupplierLight_.overrideReceiveThreshold));
            this.receiveThresholdUnderFlow.getElement().setNode(node.getChildNamed(SupplierLight_.receiveThresholdUnderFlow));
            this.receiveThresholdOverFlow.getElement().setNode(node.getChildNamed(SupplierLight_.receiveThresholdOverFlow));
            this.holidayPlanType.getElement().setNode(node.getChildNamed(SupplierComplete_.holidayPlanType));
            this.holidayPlanType.getElement().refreshPossibleValues(NodeToolkit.getAffixList(HolidayPlanTypeComplete.class));
        }
        if (this.ignorePurchaseApproval != null) {
            if (node.getChildNamed(SupplierComplete_.approvalTime).getValue() == null) {
                node.getChildNamed(SupplierComplete_.approvalTime).setValue((Object)DateUtil.getSQLTime((int)18, (int)0, (int)0), 0L);
            }
            this.ignorePurchaseApproval.getElement().setNode(node.getChildNamed(SupplierComplete_.ignoreApprovalProcess));
            this.overrideApprovalTime.getElement().setNode(node.getChildNamed(SupplierComplete_.overrideApprovalTime));
            this.approvalTime.getElement().setNode(node.getChildNamed(SupplierComplete_.approvalTime));
        }
    }

    private Node<?> createOrderList() {
        ViewNode n = new ViewNode("OrderContacts");
        Iterator it = this.editor.getModel().getNode().getChildNamed(SupplierComplete_.contacts).getChilds();
        while (it.hasNext()) {
            Node nn = (Node)it.next();
            n.addChild(nn, 0L);
        }
        this.editor.getModel().getNode().getChildNamed(SupplierComplete_.contacts).addNodeListener((NodeListener)this);
        return n;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.editor != null && this.editor.getModel() != null && this.editor.getModel().getNode() != null && this.editor.getModel().getNode().getChildNamed(SupplierComplete_.contacts) != null) {
            this.editor.getModel().getNode().getChildNamed(SupplierComplete_.contacts).removeNodeListener((NodeListener)this);
        }
        this.orderBy.kill();
        this.infoText.kill();
        this.email.kill();
        this.orderContact.kill();
        this.defaultDeliveryWindow.kill();
        this.defaultOrderRemark.kill();
        this.defaultOrderFooter.kill();
        if (!this.isSolarCompany) {
            this.additionalConditions.kill();
            this.editAdditionalConditions.kill();
            this.knownSupplier.kill();
            this.overrideReceiveThreshold.kill();
            this.receiveThresholdUnderFlow.kill();
            this.receiveThresholdOverFlow.kill();
            this.holidayPlanType.kill();
        }
        if (this.ignorePurchaseApproval != null) {
            this.ignorePurchaseApproval.kill();
            this.overrideApprovalTime.kill();
            this.approvalTime.kill();
        }
        this.orderBy = null;
        this.infoText = null;
        this.email = null;
        this.orderContact = null;
        this.additionalConditions = null;
        this.editAdditionalConditions = null;
        this.knownSupplier = null;
        this.defaultDeliveryWindow = null;
        this.overrideReceiveThreshold = null;
        this.receiveThresholdUnderFlow = null;
        this.receiveThresholdOverFlow = null;
        this.holidayPlanType = null;
        this.defaultOrderRemark = null;
        this.defaultOrderFooter = null;
        this.ignorePurchaseApproval = null;
        this.overrideApprovalTime = null;
        this.approvalTime = null;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        this.orderBy.setEnabled(isEnabled);
        this.infoText.setEnabled(isEnabled);
        this.email.setEnabled(isEnabled && this.canBeOrderedByEmail());
        this.orderContact.setEnabled(isEnabled);
        this.defaultDeliveryWindow.setEnabled(isEnabled);
        this.defaultOrderRemark.setEnabled(isEnabled);
        this.defaultOrderFooter.setEnabled(isEnabled);
        if (!this.isSolarCompany) {
            this.additionalConditions.setEnabled(isEnabled);
            this.editAdditionalConditions.setEnabled(isEnabled && this.isDeliveryConditionEditable);
            this.knownSupplier.setEnabled(isEnabled);
            this.overrideReceiveThreshold.setEnabled(isEnabled);
            this.receiveThresholdUnderFlow.setEnabled(isEnabled && this.overrideReceiveThreshold.getElement().isChecked());
            this.receiveThresholdOverFlow.setEnabled(isEnabled && this.overrideReceiveThreshold.getElement().isChecked());
            this.holidayPlanType.setEnabled(isEnabled);
        }
        if (this.ignorePurchaseApproval != null) {
            this.ignorePurchaseApproval.setEnabled(isEnabled);
            this.overrideApprovalTime.setEnabled(isEnabled);
            this.approvalTime.setEnabled(isEnabled && this.overrideApprovalTime.getElement().isChecked());
        }
    }

    private boolean canBeOrderedByEmail() {
        if (this.orderBy != null && this.orderBy.getElement() != null) {
            if (this.orderBy.getElement().getSelectedItem() == null) {
                return true;
            }
            if (((OrderTypeComplete)((Node)this.orderBy.getElement().getSelectedItem()).getValue()).getIsEmail() == null) {
                return false;
            }
            return ((OrderTypeComplete)((Node)this.orderBy.getElement().getSelectedItem()).getValue()).getIsEmail();
        }
        return true;
    }

    @Override
    public void switchState(Button.ButtonState newState) {
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> focusList = new ArrayList<Component>();
        CheckedListAdder.addToList(focusList, this.orderBy);
        CheckedListAdder.addToList(focusList, this.email);
        CheckedListAdder.addToList(focusList, this.orderContact);
        CheckedListAdder.addToList(focusList, this.editAdditionalConditions);
        CheckedListAdder.addToList(focusList, this.knownSupplier);
        CheckedListAdder.addToList(focusList, this.defaultDeliveryWindow);
        CheckedListAdder.addToList(focusList, this.overrideReceiveThreshold);
        CheckedListAdder.addToList(focusList, this.receiveThresholdUnderFlow);
        CheckedListAdder.addToList(focusList, this.receiveThresholdOverFlow);
        CheckedListAdder.addToList(focusList, this.holidayPlanType);
        CheckedListAdder.addToList(focusList, this.defaultOrderRemark);
        CheckedListAdder.addToList(focusList, this.defaultOrderFooter);
        CheckedListAdder.addToList(focusList, this.ignorePurchaseApproval);
        CheckedListAdder.addToList(focusList, this.overrideApprovalTime);
        CheckedListAdder.addToList(focusList, this.approvalTime);
        return focusList;
    }

    public void childAdded(Node<?> source, Node<?> child) {
        this.orderContact.getElement().getPossibleValues().addChild(child, 0L);
    }

    public void childRemoved(Node<?> source, Node<?> child) {
        this.orderContact.getElement().getPossibleValues().removeChild(child, 0L);
    }

    public void childrenAdded(Node<?> source, Node<?> ... nodes) {
    }

    @Override
    public List<ScreenValidationObject> validateParagraph() {
        ArrayList<ScreenValidationObject> validationObjects = new ArrayList<ScreenValidationObject>();
        if (this.orderBy.getElement().isWritable() && ((OrderTypeComplete)((Node)this.orderBy.getElement().getSelectedItem()).getValue()).getIsEmail() != null && ((OrderTypeComplete)((Node)this.orderBy.getElement().getSelectedItem()).getValue()).getIsEmail().booleanValue()) {
            String t = this.email.getText();
            if (t == null || t.isEmpty()) {
                try {
                    t = (String)this.editor.getModel().getNode().getChildNamed(new DtoField[]{SupplierComplete_.orderContact, ContactComplete_.email}).getValue();
                }
                catch (Exception e) {
                    t = "";
                }
                if (t == null || t.isEmpty()) {
                    validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ORDERS_ARE_SENT_BY_MAIL));
                }
            }
            if (t != null && !t.isEmpty()) {
                Pattern pattern = Pattern.compile("^[_A-Za-z0-9-\\+]+(\\.[_A-Za-z0-9-]+)*@[A-Za-z0-9-]+(\\.[A-Za-z0-9]+)*(\\.[A-Za-z]{2,})$");
                List<String> emails = Arrays.asList(t.replace(" ", "").split(";"));
                for (String emailString : emails) {
                    Matcher matcher = pattern.matcher(emailString);
                    if (matcher.matches()) continue;
                    validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Phrase.getPhrase((String)Phrase.MAIL_HAS_NOT_CORRECT_FORMAT, (Object[])new Object[]{emailString})));
                }
            }
        }
        return validationObjects;
    }

    public void valueChanged(Node<?> node) {
    }

    @Override
    public void requestFocusInWindowNow() {
    }

    @Override
    public void popUpClosed(InnerPopUp2 source, Object ... xargs) {
    }

    public boolean isSwingOnly() {
        return true;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() == 1) {
            this.setEnabled(this.isEnabled());
        }
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int aMinWidth = parent.getWidth() - 3 * OrderDetailsPanel.this.horizontalBorder;
            OrderDetailsPanel.this.orderBy.setLocation(OrderDetailsPanel.this.horizontalBorder, OrderDetailsPanel.this.verticalBorder);
            OrderDetailsPanel.this.orderBy.setSize(aMinWidth /= 2, (int)OrderDetailsPanel.this.orderBy.getPreferredSize().getHeight());
            OrderDetailsPanel.this.email.setLocation(OrderDetailsPanel.this.orderBy.getX() + OrderDetailsPanel.this.orderBy.getWidth() + 5, (int)((double)(OrderDetailsPanel.this.orderBy.getY() + OrderDetailsPanel.this.orderBy.getHeight()) - OrderDetailsPanel.this.email.getPreferredSize().getHeight()));
            OrderDetailsPanel.this.email.setSize(aMinWidth, (int)OrderDetailsPanel.this.email.getPreferredSize().getHeight());
            OrderDetailsPanel.this.infoText.setLocation(OrderDetailsPanel.this.horizontalBorder, OrderDetailsPanel.this.email.getY() + OrderDetailsPanel.this.email.getHeight() + OrderDetailsPanel.this.inner_verticalBorder);
            OrderDetailsPanel.this.infoText.setLineWrap(true, parent.getWidth() - 2 * OrderDetailsPanel.this.horizontalBorder);
            OrderDetailsPanel.this.infoText.setSize(parent.getWidth() - 2 * OrderDetailsPanel.this.horizontalBorder, (int)OrderDetailsPanel.this.infoText.getPreferredSize().getHeight());
            OrderDetailsPanel.this.orderContact.setLocation(OrderDetailsPanel.this.orderBy.getX(), OrderDetailsPanel.this.infoText.getY() + OrderDetailsPanel.this.infoText.getHeight() + OrderDetailsPanel.this.inner_verticalBorder);
            OrderDetailsPanel.this.orderContact.setSize(parent.getWidth() - 2 * OrderDetailsPanel.this.horizontalBorder, (int)OrderDetailsPanel.this.orderContact.getPreferredSize().getHeight());
            int cy = OrderDetailsPanel.this.orderContact.getY() + OrderDetailsPanel.this.orderContact.getHeight();
            if (!OrderDetailsPanel.this.isSolarCompany) {
                OrderDetailsPanel.this.additionalConditions.setLocation(OrderDetailsPanel.this.orderBy.getX(), cy + OrderDetailsPanel.this.inner_verticalBorder);
                OrderDetailsPanel.this.additionalConditions.setSize((int)((double)parent.getWidth() - ((double)(2 * OrderDetailsPanel.this.horizontalBorder + OrderDetailsPanel.this.inner_horizontalBorder) + OrderDetailsPanel.this.editAdditionalConditions.getPreferredSize().getWidth())), (int)OrderDetailsPanel.this.additionalConditions.getPreferredSize().getHeight());
                OrderDetailsPanel.this.editAdditionalConditions.setLocation(OrderDetailsPanel.this.additionalConditions.getX() + OrderDetailsPanel.this.additionalConditions.getWidth() + OrderDetailsPanel.this.inner_horizontalBorder, (int)((double)(OrderDetailsPanel.this.additionalConditions.getY() + OrderDetailsPanel.this.additionalConditions.getHeight()) - (OrderDetailsPanel.this.editAdditionalConditions.getPreferredSize().getHeight() + 3.0)));
                OrderDetailsPanel.this.editAdditionalConditions.setSize(OrderDetailsPanel.this.editAdditionalConditions.getPreferredSize());
                OrderDetailsPanel.this.knownSupplier.setLocation(OrderDetailsPanel.this.horizontalBorder, OrderDetailsPanel.this.additionalConditions.getY() + OrderDetailsPanel.this.additionalConditions.getHeight() + OrderDetailsPanel.this.verticalBorder);
                OrderDetailsPanel.this.knownSupplier.setSize(OrderDetailsPanel.this.knownSupplier.getPreferredSize());
                cy = OrderDetailsPanel.this.knownSupplier.getY() + OrderDetailsPanel.this.knownSupplier.getHeight();
            }
            OrderDetailsPanel.this.defaultDeliveryWindow.setLocation(OrderDetailsPanel.this.horizontalBorder, cy + OrderDetailsPanel.this.verticalBorder);
            OrderDetailsPanel.this.defaultDeliveryWindow.setSize(250, (int)OrderDetailsPanel.this.defaultDeliveryWindow.getPreferredSize().getHeight());
            cy = OrderDetailsPanel.this.defaultDeliveryWindow.getY() + OrderDetailsPanel.this.defaultDeliveryWindow.getHeight();
            if (!OrderDetailsPanel.this.isSolarCompany) {
                OrderDetailsPanel.this.overrideReceiveThreshold.setLocation(OrderDetailsPanel.this.horizontalBorder, OrderDetailsPanel.this.defaultDeliveryWindow.getY() + OrderDetailsPanel.this.defaultDeliveryWindow.getHeight() + OrderDetailsPanel.this.verticalBorder);
                OrderDetailsPanel.this.overrideReceiveThreshold.setSize(250, (int)OrderDetailsPanel.this.overrideReceiveThreshold.getPreferredSize().getHeight());
                OrderDetailsPanel.this.receiveThresholdUnderFlow.setLocation(OrderDetailsPanel.this.horizontalBorder, OrderDetailsPanel.this.overrideReceiveThreshold.getY() + OrderDetailsPanel.this.overrideReceiveThreshold.getHeight() + OrderDetailsPanel.this.verticalBorder / 2);
                OrderDetailsPanel.this.receiveThresholdUnderFlow.setSize(250, (int)OrderDetailsPanel.this.receiveThresholdUnderFlow.getPreferredSize().getHeight());
                OrderDetailsPanel.this.receiveThresholdOverFlow.setLocation(OrderDetailsPanel.this.horizontalBorder, OrderDetailsPanel.this.receiveThresholdUnderFlow.getY() + OrderDetailsPanel.this.receiveThresholdUnderFlow.getHeight() + OrderDetailsPanel.this.verticalBorder / 2);
                OrderDetailsPanel.this.receiveThresholdOverFlow.setSize(250, (int)OrderDetailsPanel.this.receiveThresholdOverFlow.getPreferredSize().getHeight());
                OrderDetailsPanel.this.holidayPlanType.setLocation(OrderDetailsPanel.this.horizontalBorder, OrderDetailsPanel.this.receiveThresholdOverFlow.getY() + OrderDetailsPanel.this.receiveThresholdOverFlow.getHeight() + OrderDetailsPanel.this.verticalBorder);
                OrderDetailsPanel.this.holidayPlanType.setSize(250, (int)OrderDetailsPanel.this.holidayPlanType.getPreferredSize().getHeight());
                cy = OrderDetailsPanel.this.holidayPlanType.getY() + OrderDetailsPanel.this.holidayPlanType.getHeight();
            }
            OrderDetailsPanel.this.defaultOrderRemark.setLocation(OrderDetailsPanel.this.horizontalBorder, cy + OrderDetailsPanel.this.verticalBorder);
            OrderDetailsPanel.this.defaultOrderRemark.setSize(250, (int)OrderDetailsPanel.this.defaultOrderRemark.getPreferredSize().getHeight());
            OrderDetailsPanel.this.defaultOrderFooter.setLocation(OrderDetailsPanel.this.horizontalBorder, OrderDetailsPanel.this.defaultOrderRemark.getY() + OrderDetailsPanel.this.defaultOrderRemark.getHeight() + OrderDetailsPanel.this.verticalBorder);
            OrderDetailsPanel.this.defaultOrderFooter.setSize(250, (int)OrderDetailsPanel.this.defaultOrderFooter.getPreferredSize().getHeight());
            if (OrderDetailsPanel.this.ignorePurchaseApproval != null) {
                OrderDetailsPanel.this.ignorePurchaseApproval.setLocation(OrderDetailsPanel.this.horizontalBorder, OrderDetailsPanel.this.defaultOrderFooter.getY() + OrderDetailsPanel.this.defaultOrderFooter.getHeight() + OrderDetailsPanel.this.verticalBorder);
                OrderDetailsPanel.this.ignorePurchaseApproval.setSize(OrderDetailsPanel.this.ignorePurchaseApproval.getPreferredSize());
                OrderDetailsPanel.this.overrideApprovalTime.setLocation(OrderDetailsPanel.this.horizontalBorder, OrderDetailsPanel.this.ignorePurchaseApproval.getY() + OrderDetailsPanel.this.ignorePurchaseApproval.getHeight() + OrderDetailsPanel.this.verticalBorder);
                OrderDetailsPanel.this.overrideApprovalTime.setSize(OrderDetailsPanel.this.overrideApprovalTime.getPreferredSize());
                OrderDetailsPanel.this.approvalTime.setLocation(OrderDetailsPanel.this.horizontalBorder, OrderDetailsPanel.this.overrideApprovalTime.getY() + OrderDetailsPanel.this.overrideApprovalTime.getHeight() + OrderDetailsPanel.this.verticalBorder);
                OrderDetailsPanel.this.approvalTime.setSize(OrderDetailsPanel.this.approvalTime.getPreferredSize());
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = OrderDetailsPanel.this.verticalBorder;
            h = (int)((double)h + OrderDetailsPanel.this.orderBy.getPreferredSize().getHeight());
            h += OrderDetailsPanel.this.inner_verticalBorder;
            OrderDetailsPanel.this.infoText.setLineWrap(true, parent.getWidth() - 2 * OrderDetailsPanel.this.horizontalBorder);
            h = (int)((double)h + OrderDetailsPanel.this.infoText.getPreferredSize().getHeight());
            h += OrderDetailsPanel.this.inner_verticalBorder;
            h = (int)((double)h + OrderDetailsPanel.this.orderContact.getPreferredSize().getHeight());
            h += OrderDetailsPanel.this.inner_verticalBorder;
            if (!OrderDetailsPanel.this.isSolarCompany) {
                h = (int)((double)h + OrderDetailsPanel.this.additionalConditions.getPreferredSize().getHeight());
                h += OrderDetailsPanel.this.verticalBorder;
                h = (int)((double)h + OrderDetailsPanel.this.knownSupplier.getPreferredSize().getHeight());
                h += OrderDetailsPanel.this.verticalBorder;
            }
            h = (int)((double)h + OrderDetailsPanel.this.defaultDeliveryWindow.getPreferredSize().getHeight());
            h += OrderDetailsPanel.this.verticalBorder;
            if (!OrderDetailsPanel.this.isSolarCompany) {
                h = (int)((double)h + OrderDetailsPanel.this.overrideReceiveThreshold.getPreferredSize().getHeight());
                h += OrderDetailsPanel.this.verticalBorder / 2;
                h = (int)((double)h + OrderDetailsPanel.this.receiveThresholdUnderFlow.getPreferredSize().getHeight());
                h += OrderDetailsPanel.this.verticalBorder / 2;
                h = (int)((double)h + OrderDetailsPanel.this.receiveThresholdOverFlow.getPreferredSize().getHeight());
                h += OrderDetailsPanel.this.verticalBorder;
                h = (int)((double)h + OrderDetailsPanel.this.holidayPlanType.getPreferredSize().getHeight());
                h += OrderDetailsPanel.this.verticalBorder;
            }
            h = (int)((double)h + OrderDetailsPanel.this.defaultOrderRemark.getPreferredSize().getHeight());
            h += OrderDetailsPanel.this.verticalBorder;
            h = (int)((double)h + OrderDetailsPanel.this.defaultOrderFooter.getPreferredSize().getHeight());
            h += OrderDetailsPanel.this.verticalBorder;
            if (OrderDetailsPanel.this.ignorePurchaseApproval != null) {
                h = (int)((double)h + OrderDetailsPanel.this.ignorePurchaseApproval.getPreferredSize().getHeight());
                h += OrderDetailsPanel.this.verticalBorder;
                h = (int)((double)h + OrderDetailsPanel.this.overrideApprovalTime.getPreferredSize().getHeight());
                h += OrderDetailsPanel.this.verticalBorder;
                h = (int)((double)h + OrderDetailsPanel.this.approvalTime.getPreferredSize().getHeight());
                h += OrderDetailsPanel.this.verticalBorder;
            }
            return new Dimension(0, h);
        }
    }
}

