/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.stock.details;

import ch.icit.pegasus.client.converter.IntegerConverter;
import ch.icit.pegasus.client.converter.QuantityConverter2Decimal;
import ch.icit.pegasus.client.converter.StringConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.screentemplates.details.TableDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2HeaderPanel;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.server.core.dtos.inventory.InventoryComplete_;
import ch.icit.pegasus.server.core.dtos.inventory.InventoryRecipeCountComplete_;
import ch.icit.pegasus.server.core.dtos.recipe.RecipeComplete_;
import ch.icit.pegasus.server.core.dtos.recipe.RecipeVariantLight_;
import ch.icit.pegasus.server.core.dtos.store.StoreLight;
import ch.icit.pegasus.server.core.dtos.store.StoreLight_;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public class RecipeCountDetailsPanel
extends TableDetailsPanel<StoreLight> {
    public RecipeCountDetailsPanel(RowEditor<StoreLight> editor, RDProvider provider) {
        super(editor, provider);
        this.setTitleText("Latest Recipe Count");
    }

    @Override
    public List<TableColumnInfo> getColumns(boolean add) {
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        columns.add(new TableColumnInfo("No", "", null, null, "", TableColumnInfo.numberColumnWidth));
        ((TableColumnInfo)columns.get(0)).setxExpand(0.0);
        columns.add(new TableColumnInfo("Name", "", null, null, "", 180, 180, 180));
        ((TableColumnInfo)columns.get(1)).setxExpand(1.0);
        columns.add(new TableColumnInfo("Store", "", null, null, "", 125, 125, 125));
        ((TableColumnInfo)columns.get(2)).setxExpand(0.0);
        columns.add(new TableColumnInfo("Count", "", null, null, "", 170, 170, 170));
        ((TableColumnInfo)columns.get(3)).setxExpand(0.0);
        return columns;
    }

    @Override
    public void setNode(Node<?> node) {
        super.setNode(node);
        this.table.getModel().setNode(node.getChildNamed(InventoryComplete_.recipeCounts));
    }

    @Override
    public void configTable(Table2 table) {
        table.setProvider(this.provider);
        table.setRequestFocusOnAdd(true);
    }

    @Override
    public void addButtonPressed(int x, int y, Button source) {
    }

    @Override
    public void childRemoved() {
    }

    @Override
    public Table2RowPanel generateView(Table2RowModel model, boolean isHeader) {
        if (isHeader) {
            return new Table2HeaderPanel(model, 7);
        }
        TableRowImpl p = new TableRowImpl(model, this.provider);
        p.setUseControlSkin(Table2RowPanel.TableControlsType.ONE);
        return p;
    }

    private class TableRowImpl
    extends Table2RowPanel {
        private TextLabel number;
        private TextLabel name;
        private TextLabel store;
        private TextLabel count;

        public TableRowImpl(Table2RowModel m, RDProvider provider) {
            super(m);
            this.number = new TextLabel(m.getNode().getChildNamed(new DtoField[]{InventoryRecipeCountComplete_.recipe, RecipeComplete_.number}), ConverterRegistry.getConverter(IntegerConverter.class));
            this.name = new TextLabel(m.getNode().getChildNamed(new DtoField[]{InventoryRecipeCountComplete_.recipe, RecipeComplete_.currentVariant, RecipeVariantLight_.name}), ConverterRegistry.getConverter(StringConverter.class));
            this.store = new TextLabel(m.getNode().getChildNamed(new DtoField[]{InventoryRecipeCountComplete_.store, StoreLight_.name}), ConverterRegistry.getConverter(StringConverter.class));
            this.count = new TextLabel(m.getNode().getChildNamed(InventoryRecipeCountComplete_.countQuantity), ConverterRegistry.getConverter(QuantityConverter2Decimal.class));
            this.setLayout(new Layout());
            this.add(this.number);
            this.add(this.name);
            this.add(this.store);
            this.add(this.count);
        }

        @Override
        public Object getObject4Column(int column) {
            return this.number.getText();
        }

        private class Layout
        extends DefaultLayout {
            private Layout() {
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TableRowImpl.this.getDefaultRowHeight());
            }

            @Override
            public void layoutContainer(Container parent) {
                int currentX = 0;
                int w = TableRowImpl.this.model.getParentModel().getColumnWidth(0);
                TableRowImpl.this.number.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.number.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.number.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.number.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(1);
                TableRowImpl.this.name.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.name.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.name.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.name.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(2);
                TableRowImpl.this.store.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.store.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.store.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.store.getPreferredSize().getHeight());
                TableRowImpl.this.setControlsX(currentX += w);
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(3);
                TableRowImpl.this.count.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.count.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.count.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.count.getPreferredSize().getHeight());
            }
        }
    }
}

