/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.serviceproduct.details;

import ch.icit.pegasus.client.gui.screentemplates.details.AbstractTemplateDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2Factory;
import ch.icit.pegasus.client.node.impls.DTOProxyNode;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.ViewNode;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.supply.SupplyServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.client.util.toolkits.copy.CopyTemplateToolkit;
import ch.icit.pegasus.server.core.dtos.serviceproduct.ServiceProductComplete;
import ch.icit.pegasus.server.core.dtos.serviceproduct.ServiceProductComplete_;
import ch.icit.pegasus.server.core.dtos.serviceproduct.ServiceProductReference;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.util.Iterator;

public class TemplateDetailsPanel
extends AbstractTemplateDetailsPanel<ServiceProductComplete> {
    private static final long serialVersionUID = 1L;

    public TemplateDetailsPanel(RowEditor editor, RDProvider provider) {
        super(editor, provider);
    }

    @Override
    public SearchTextField2 getSearchField() {
        return SearchTextField2Factory.getServiceProductSearchField(true, new DTOProxyNode());
    }

    @Override
    public String getSearchFieldTitle() {
        return Words.SERVICE_PRODUCT;
    }

    @Override
    public String getLoadingText() {
        return Words.COPY;
    }

    @Override
    public ThreadSafeExecutable getJob() {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                ServiceProductComplete dto = (ServiceProductComplete)TemplateDetailsPanel.this.getSelectedData();
                if (dto != null) {
                    dto = (ServiceProductComplete)((SupplyServiceManager)ServiceManagerRegistry.getService(SupplyServiceManager.class)).getServiceProduct(new ServiceProductReference(dto.getId())).getValue();
                    ServiceProductComplete spc = CopyTemplateToolkit.copyServiceProduct(dto);
                    spc.setClientOId(((ServiceProductComplete)TemplateDetailsPanel.this.editor.getModel().getNode().getValue()).getClientOId());
                    ViewNode ret = new ViewNode("ret");
                    ret.setValue((Object)spc, 0L);
                    return ret;
                }
                return null;
            }

            @Override
            public RemoteLoader getInvoker() {
                return null;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        return run;
    }

    @Override
    public void remoteObjectLoaded(Node<?> node) {
        if (node.getValue() instanceof ClientServerCallException) {
            InnerPopupFactory.showErrorDialog((Exception)((Object)((ClientServerCallException)((Object)node.getValue()))), (Component)this);
        } else {
            this.editor.getModel().getNode().removeDataIfPossilbe(ServiceProductComplete.class);
            this.editor.getModel().getNode().setValue(node.getValue(ServiceProductComplete.class), 0L);
            this.editor.getModel().getNode().updateNode();
            Iterator it = this.editor.getModel().getNode().getChildNamed(ServiceProductComplete_.variants).getChilds();
            while (it.hasNext()) {
                it.next();
            }
            this.editor.setNode(this.editor.getModel().getNode());
        }
        this.editor.setEnabled(true);
        this.editor.hideCommittingAnimation();
        this.invalidate();
    }
}

