/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.serviceproduct;

import ch.icit.pegasus.client.converter.CustomerCodeConverter;
import ch.icit.pegasus.client.converter.DefaultObject2ObjectConverter;
import ch.icit.pegasus.client.converter.IntegerConverter;
import ch.icit.pegasus.client.converter.PeriodConverter;
import ch.icit.pegasus.client.converter.PriceConverter3;
import ch.icit.pegasus.client.converter.StringConverter;
import ch.icit.pegasus.client.gui.modules.Module;
import ch.icit.pegasus.client.gui.modules.serviceproduct.ServiceProductModuleDataHandler;
import ch.icit.pegasus.client.gui.modules.serviceproduct.details.RecipeDetailsPanel;
import ch.icit.pegasus.client.gui.modules.serviceproduct.details.ServiceProductSpecificationDetailsPanel;
import ch.icit.pegasus.client.gui.modules.serviceproduct.details.TaxDetailsPanel;
import ch.icit.pegasus.client.gui.modules.serviceproduct.details.TemplateDetailsPanel;
import ch.icit.pegasus.client.gui.modules.serviceproduct.details.VariantDetailsPanel;
import ch.icit.pegasus.client.gui.modules.serviceproduct.details.VariantSpecificationDetailsPanel;
import ch.icit.pegasus.client.gui.screentemplates.overview.ScreenTableView;
import ch.icit.pegasus.client.gui.screentemplates.overview.data.IDataHandler;
import ch.icit.pegasus.client.gui.table.CombinedDetailsParagraph;
import ch.icit.pegasus.client.gui.table.DefaultDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.table.RowEditorFactory;
import ch.icit.pegasus.client.gui.table.RowModel;
import ch.icit.pegasus.client.gui.table.Table;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table.VariantMessageProvidedRowEditor;
import ch.icit.pegasus.client.gui.utils.TableLayoutConstraint;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBoxFactory;
import ch.icit.pegasus.client.gui.utils.datechooser.TitledPeriodEditor;
import ch.icit.pegasus.client.gui.utils.filterchain.FilterChainConfiguration;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.search.SearchAlgorithm;
import ch.icit.pegasus.client.search.controller.SearchAlgorithmRegistry;
import ch.icit.pegasus.client.search.impls.remote.ServiceProductSearchAlgorithm;
import ch.icit.pegasus.server.core.dtos.masterdata.ModificationStateE;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.definition.SubModuleDefinitionComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.AccessDefinitionComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.ServiceProductAccess;
import ch.icit.pegasus.server.core.dtos.search.AProductSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.search.AServiceProductSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.search.ServiceProductSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.serviceproduct.ServiceProductComplete;
import ch.icit.pegasus.server.core.dtos.serviceproduct.ServiceProductComplete_;
import ch.icit.pegasus.server.core.dtos.supply.CustomerLight;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.utils.CompanyUtil;
import ch.icit.pegasus.server.core.general.ASearchConfiguration;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.search.SortDirection;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;

public class ServiceProductModule
extends ScreenTableView<ServiceProductComplete, AServiceProductSearchConfiguration.SERVICE_PRODUCT_COLUMN>
implements Module {
    private static final long serialVersionUID = 1L;
    private static final String FILTER_PRODUCTNAME = "ProductName";
    private static final String FILTER_CUSTOMER = "Customer";
    private static final String FILTER_STATE = "State";
    private static final String FILTER_PERIOD = "Period";
    private ComboBox stateCombo;
    private String filterCriteria1;
    private CustomerLight filterCriteria2;
    private ModificationStateE filterCriteria5;
    private PeriodComplete filterCriteria6;
    private TitledPeriodEditor periodChooser;

    public ServiceProductModule() {
        super(ServiceProductComplete.class);
        this.isSynchronSearch = false;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.stateCombo.kill();
        this.periodChooser.kill();
        this.stateCombo = null;
        this.periodChooser = null;
    }

    @Override
    public AccessDefinitionComplete getInvoker() {
        return ServiceProductAccess.MODULE_SERVICE_PRODUCT;
    }

    @Override
    public FilterChainConfiguration getDefaultConfiguration() {
        FilterChainConfiguration c = new FilterChainConfiguration();
        c.addProperty("sortedColumn", AProductSearchConfiguration.PRODUCT_COLUMN.NUMBER + "<>" + true);
        c.addProperty(FILTER_PERIOD, FilterChainConfiguration.getDefaultSearchPeriodString());
        return c;
    }

    @Override
    protected void createFilterChain(long id) {
        this.filterChain.addSearchField(FILTER_PRODUCTNAME, Words.NUMBER_OR_NAME, "");
        this.filterChain.addCustomerSearchField(FILTER_CUSTOMER);
        PeriodComplete p = FilterChainConfiguration.getDefaultSearchPeriod();
        this.periodChooser = this.filterChain.addPeriodSelection(FILTER_PERIOD, p.getStartDate(), p.getEndDate(), "", true);
        this.periodChooser.setCheckBoxEnabled();
        this.stateCombo = ComboBoxFactory.getModificationStateComboBox(true);
        this.filterChain.addSelectionComboBox(this.stateCombo, 90, FILTER_STATE, Words.STATE, Words.ALL);
        this.filterChain.addResetButton();
    }

    @Override
    public ASearchConfiguration<ServiceProductComplete, AServiceProductSearchConfiguration.SERVICE_PRODUCT_COLUMN> getModuleSearchParameters(Object name, Object value, boolean isReset, boolean getEmptyConfig, Component source) {
        if (isReset) {
            this.filterCriteria1 = null;
            this.filterCriteria2 = null;
            this.filterCriteria5 = null;
            this.filterCriteria6 = null;
            this.periodChooser.setCheckBoxChecked(false);
        } else if (name == FILTER_PRODUCTNAME) {
            this.filterCriteria1 = (String)value;
        } else if (name == FILTER_CUSTOMER) {
            this.filterCriteria2 = value instanceof CustomerLight ? (CustomerLight)value : null;
        } else if (name == FILTER_STATE) {
            this.filterCriteria5 = value instanceof ModificationStateE ? (ModificationStateE)value : null;
        } else if (name == FILTER_PERIOD) {
            TitledPeriodEditor ed = (TitledPeriodEditor)value;
            PeriodComplete per = new PeriodComplete();
            per.setStartDate(ed.getStartDate());
            per.setEndDate(ed.getEndDate());
            this.filterCriteria6 = per;
        }
        ServiceProductSearchConfiguration c = new ServiceProductSearchConfiguration();
        c.setNumResults(this.numberOfShownResults);
        c.setCustomer(this.filterCriteria2);
        c.setState(this.filterCriteria5);
        c.setPeriod(this.filterCriteria6);
        String v = this.filterCriteria1;
        if (v != null) {
            try {
                Integer a = Integer.valueOf(v.trim());
                c.setNumber(a);
                c.setName(null);
            }
            catch (NumberFormatException e) {
                c.setNumber(null);
                c.setName(v);
            }
        }
        if (c.getName() != null && c.getName().isEmpty()) {
            c.setName(null);
        }
        if (this.currentColumnAttribute != null) {
            c.setSortColumn(this.currentColumnAttribute);
        }
        if (this.isAsc) {
            c.setSortDirection(SortDirection.ASCENDING);
        } else {
            c.setSortDirection(SortDirection.DESCENDING);
        }
        if (source == this.pagination) {
            c.setPageNumber(this.pagination.getCurrentPage() - 1);
        } else {
            c.setPageNumber(0);
        }
        if (c.getPageNumber() < 0) {
            c.setPageNumber(0);
        }
        return c;
    }

    @Override
    public void remoteObjectLoaded(Node<?> node) {
        super.remoteObjectLoaded(node);
    }

    @Override
    public SearchAlgorithm<ServiceProductComplete> getSearchAlgorithm() {
        return SearchAlgorithmRegistry.getSearchAlgorithm(ServiceProductSearchAlgorithm.class);
    }

    @Override
    public boolean isSmartScreenAllowed(SubModuleDefinitionComplete screen, RowModel<ServiceProductComplete> model) {
        return false;
    }

    @Override
    protected Table.SmartIconConfiguration getPossibleSmartIcons() {
        return Table.SmartIconConfiguration.TWO;
    }

    @Override
    protected RowEditorFactory<ServiceProductComplete> getRowEditorFactory() {
        return model -> {
            VariantMessageProvidedRowEditor<ServiceProductComplete> rowEditor = new VariantMessageProvidedRowEditor<ServiceProductComplete>(model, "");
            SystemSettingsComplete settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
            boolean isNoPro = CompanyUtil.isNoPro((SystemSettingsComplete)settings);
            RDProvider p = this.createProvider(model.isAddRow());
            ServiceProductSpecificationDetailsPanel spDetailsPanel = new ServiceProductSpecificationDetailsPanel((RowEditor<ServiceProductComplete>)rowEditor, p);
            DefaultDetailsPanel d0 = null;
            CombinedDetailsParagraph dx = new CombinedDetailsParagraph();
            VariantSpecificationDetailsPanel d1 = new VariantSpecificationDetailsPanel((RowEditor<ServiceProductComplete>)rowEditor, p);
            TaxDetailsPanel d2 = new TaxDetailsPanel((RowEditor<ServiceProductComplete>)rowEditor, p);
            RecipeDetailsPanel d3 = new RecipeDetailsPanel((RowEditor<ServiceProductComplete>)rowEditor, p);
            if (model.isAddRow()) {
                if (!isNoPro) {
                    d0 = new TemplateDetailsPanel((RowEditor)rowEditor, p);
                    rowEditor.add(d0, (Object)new TableLayoutConstraint(0, 0, 1.0, 1.0));
                    rowEditor.add(spDetailsPanel, (Object)new TableLayoutConstraint(0, 1, 1.0, 1.0));
                } else {
                    rowEditor.add(spDetailsPanel, (Object)new TableLayoutConstraint(0, 0, 1.0, 1.0));
                }
            } else {
                d0 = new VariantDetailsPanel((RowEditor<ServiceProductComplete>)rowEditor, p);
                rowEditor.setVariantPanel(d0);
                rowEditor.add(spDetailsPanel, (Object)new TableLayoutConstraint(0, 0, 1.0, 1.0));
                rowEditor.add(d0, (Object)new TableLayoutConstraint(0, 1, 1.0, 1.0));
            }
            dx.add((Component)d1, new TableLayoutConstraint(0, 0, 0.5, 1.0));
            dx.add((Component)d2, new TableLayoutConstraint(1, 0, 0.5, 1.0));
            rowEditor.add(dx, (Object)new TableLayoutConstraint(0, 2, 1.0, 1.0));
            if (!model.isAddRow() && isNoPro) {
                rowEditor.add(d3, (Object)new TableLayoutConstraint(0, 3, 1.0, 1.0));
            }
            rowEditor.addToFocusQueue(d0);
            rowEditor.addToFocusQueue(d1);
            rowEditor.addToFocusQueue(d2);
            rowEditor.allInstalled();
            rowEditor.setVisibleContainer(this.getTable());
            return rowEditor;
        };
    }

    @Override
    protected IDataHandler getModuleDataHandler() {
        return new ServiceProductModuleDataHandler(this.loadingId, this);
    }

    @Override
    protected List<TableColumnInfo> getTableColumnInfo() {
        ArrayList<TableColumnInfo> info = new ArrayList<TableColumnInfo>();
        info.add(new TableColumnInfo(Words.NO_NUMBER, "", (Class)IntegerConverter.class, (Enum<?>)AServiceProductSearchConfiguration.SERVICE_PRODUCT_COLUMN.NUMBER, ServiceProductComplete_.number, TableColumnInfo.numberColumnWithExpandWidth, TableColumnInfo.numberColumnWithExpandWidth, TableColumnInfo.numberColumnWithExpandWidth));
        info.add(new TableColumnInfo("", "", (Class)DefaultObject2ObjectConverter.class, (Enum<?>)AServiceProductSearchConfiguration.SERVICE_PRODUCT_COLUMN.STATE, "#currentVariant-state", TableColumnInfo.state2, TableColumnInfo.state2, TableColumnInfo.state2));
        info.add(new TableColumnInfo(Words.NAME, "", (Class)StringConverter.class, (Enum<?>)AServiceProductSearchConfiguration.SERVICE_PRODUCT_COLUMN.NAME, "#currentVariant-name", 100, Integer.MAX_VALUE, 100));
        info.add(new TableColumnInfo(Words.CUSTOMER, "", (Class)CustomerCodeConverter.class, (Enum<?>)AServiceProductSearchConfiguration.SERVICE_PRODUCT_COLUMN.CUSTOMER, ServiceProductComplete_.customer, 80, 80, 80));
        info.add(new TableColumnInfo(Words.PRICE, "", PriceConverter3.class, null, "#currentVariant-salesPrice", TableColumnInfo.priceColumnWidth, TableColumnInfo.priceColumnWidth, TableColumnInfo.priceColumnWidth));
        info.add(new TableColumnInfo(Words.VALIDITY, "", (Class)PeriodConverter.class, (Enum<?>)AServiceProductSearchConfiguration.SERVICE_PRODUCT_COLUMN.PERIOD, ServiceProductComplete_.period, TableColumnInfo.periodColumnWidth, TableColumnInfo.periodColumnWidth, TableColumnInfo.periodColumnWidth));
        return info;
    }
}

