/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.sealtracker;

import ch.icit.pegasus.client.gui.screentemplates.overview.ScreenTableView;
import ch.icit.pegasus.client.gui.screentemplates.overview.data.DefaultDataHandler;
import ch.icit.pegasus.client.node.DtoFieldConstants;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.flight.FlightServiceManager;
import ch.icit.pegasus.client.services.interfaces.masterdata.MasterDataServiceManager;
import ch.icit.pegasus.client.util.ProgressListener;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.TrackableItemComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.ColorComplete;
import ch.icit.pegasus.server.core.dtos.tracking.SealComplete;
import ch.icit.pegasus.server.core.i18n.Words;

public class SealTrackerModuleDataHandler
extends DefaultDataHandler<SealComplete, SealComplete> {
    public SealTrackerModuleDataHandler(long id, ScreenTableView tableView) {
        super(id, tableView);
    }

    @Override
    public String getRemoteValidationText() {
        return null;
    }

    @Override
    public void updateData(final Node<SealComplete> node, final RemoteLoader model, ProgressListener l) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                SealComplete d = (SealComplete)node.getValue(SealComplete.class);
                node.removeExistingValues();
                node.setValue((Object)d, 0L);
                node.updateNode();
                return node;
            }

            @Override
            public RemoteLoader getInvoker() {
                return model;
            }

            @Override
            public long getID() {
                return System.currentTimeMillis();
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public Node<SealComplete> createEmptyNode() {
        return null;
    }

    @Override
    public void createNewData(final Node<SealComplete> node, final RemoteLoader model, boolean sameNode, ProgressListener l) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                SealComplete d = (SealComplete)node.getValue(SealComplete.class);
                node.removeExistingValues();
                node.setValue((Object)d, 0L);
                node.updateNode();
                return node;
            }

            @Override
            public RemoteLoader getInvoker() {
                return model;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public void loadMasterData(final long id, RemoteLoader loader, final ProgressListener progressListener) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                SealTrackerModuleDataHandler.this.setCurrentLoadMaximum(1);
                SealTrackerModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(ColorComplete.class);
                return new Node();
            }

            @Override
            public RemoteLoader getInvoker() {
                return SealTrackerModuleDataHandler.this.model;
            }

            @Override
            public long getID() {
                return id;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public boolean reloadDataBeforeOpening(final Node node, final RemoteLoader listener, ProgressListener progressListener) {
        this.showMessage(progressListener, Words.REFRESH_DATA);
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                SealComplete air = (SealComplete)node.getValue(SealComplete.class);
                node.removeExistingValues();
                node.setValue((Object)air, 0L);
                node.updateNode();
                FlightLight nair = (FlightLight)((FlightServiceManager)ServiceManagerRegistry.getService(FlightServiceManager.class)).getAssociatedFlight(air).getValue();
                Node childNamed = node.getChildNamed(DtoFieldConstants.SEAL_FLIGHT);
                if (childNamed == null) {
                    childNamed = INodeCreator.getDefaultImpl().getNode4DTO((Object)nair, false, true);
                    childNamed.setName(DtoFieldConstants.SEAL_FLIGHT);
                    node.addChild(childNamed, 0L);
                }
                childNamed.setValue((Object)nair, 0L);
                TrackableItemComplete seal = ((FlightServiceManager)ServiceManagerRegistry.getService(FlightServiceManager.class)).getAssociatedEquipment(air).unwrap();
                childNamed = node.getChildNamed(DtoFieldConstants.EQUIPMENT);
                if (childNamed == null) {
                    childNamed = INodeCreator.getDefaultImpl().getNode4DTO((Object)seal, false, true);
                    childNamed.setName(DtoFieldConstants.EQUIPMENT);
                    node.addChild(childNamed, 0L);
                }
                childNamed.setValue((Object)seal, 0L);
                return node;
            }

            @Override
            public RemoteLoader getInvoker() {
                return listener;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
        return true;
    }

    @Override
    public Node<SealComplete> resetData(Node<SealComplete> node) {
        return null;
    }

    @Override
    public Class<SealComplete> getCommittingClass() {
        return SealComplete.class;
    }

    @Override
    public void doRemoteValidation(Node<SealComplete> node, RemoteLoader listener, ProgressListener l, boolean validateAll) {
    }
}

