/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.salesperson;

import ch.icit.pegasus.client.gui.screentemplates.overview.ScreenTableView;
import ch.icit.pegasus.client.gui.screentemplates.overview.data.DefaultDataHandler;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.supply.SupplyServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.SystemSettingsServiceManager;
import ch.icit.pegasus.client.util.ProgressListener;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.server.core.dtos.masterdata.ContactComplete;
import ch.icit.pegasus.server.core.dtos.supply.SalesPersonComplete;
import ch.icit.pegasus.server.core.dtos.supply.SalesPersonReference;
import ch.icit.pegasus.server.core.dtos.system.LocationComplete;
import ch.icit.pegasus.server.core.i18n.Words;
import java.util.List;

public class SalesPersonModuleDataHandler
extends DefaultDataHandler<SalesPersonComplete, SalesPersonComplete> {
    public SalesPersonModuleDataHandler(long id, ScreenTableView tableView) {
        super(id, tableView);
    }

    @Override
    public void doRemoteValidation(Node<SalesPersonComplete> node, RemoteLoader listener, ProgressListener l, boolean validateAll) {
    }

    @Override
    public String getRemoteValidationText() {
        return null;
    }

    @Override
    public void updateData(final Node<SalesPersonComplete> node, final RemoteLoader model, ProgressListener l) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                node.commit(SalesPersonComplete.class);
                SalesPersonComplete dto = (SalesPersonComplete)node.getValue(SalesPersonComplete.class);
                SalesPersonModuleDataHandler.this.ensureAllLocationsAreSet(dto);
                SalesPersonComplete nDto = (SalesPersonComplete)((SupplyServiceManager)ServiceManagerRegistry.getService(SupplyServiceManager.class)).updateSalesPerson(dto).getValue();
                node.removeExistingValues();
                node.setValue((Object)nDto, System.currentTimeMillis());
                node.updateNode();
                return node;
            }

            @Override
            public RemoteLoader getInvoker() {
                return model;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    private void ensureAllLocationsAreSet(SalesPersonComplete salesPersonComplete) {
        List value = (List)NodeToolkit.getAffixList(LocationComplete.class).getValue();
        salesPersonComplete.setEligibleLocations(value);
    }

    @Override
    public void createNewData(final Node<SalesPersonComplete> node, final RemoteLoader model, boolean sameNode, ProgressListener l) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                node.commit(SalesPersonComplete.class);
                SalesPersonComplete dto = (SalesPersonComplete)node.getValue();
                SalesPersonModuleDataHandler.this.ensureAllLocationsAreSet(dto);
                SalesPersonComplete nDto = (SalesPersonComplete)((SupplyServiceManager)ServiceManagerRegistry.getService(SupplyServiceManager.class)).createSalesPerson(dto).getValue();
                node.removeExistingValues();
                node.setValue((Object)nDto, 0L);
                node.updateNode();
                return node;
            }

            @Override
            public RemoteLoader getInvoker() {
                return model;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public void loadMasterData(final long id, RemoteLoader loader, final ProgressListener progressListener) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                SalesPersonModuleDataHandler.this.setCurrentLoadMaximum(1);
                SalesPersonModuleDataHandler.this.showNextMessage(progressListener);
                ((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getAllLocationsCached();
                return new Node();
            }

            @Override
            public RemoteLoader getInvoker() {
                return SalesPersonModuleDataHandler.this.model;
            }

            @Override
            public long getID() {
                return id;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public Node<SalesPersonComplete> resetData(Node<SalesPersonComplete> node) {
        return this.createEmptyNode();
    }

    @Override
    public boolean reloadDataBeforeOpening(final Node node, final RemoteLoader listener, ProgressListener pListener) {
        this.showMessage(pListener, Words.REFRESH_DATA);
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                SalesPersonComplete cust = (SalesPersonComplete)node.getValue(SalesPersonComplete.class);
                SalesPersonComplete ncust = (SalesPersonComplete)((SupplyServiceManager)ServiceManagerRegistry.getService(SupplyServiceManager.class)).getSalesPerson(new SalesPersonReference(cust.getId())).getValue();
                node.removeExistingValues();
                node.setValue((Object)ncust, 0L);
                node.updateNode();
                return node;
            }

            @Override
            public RemoteLoader getInvoker() {
                return listener;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
        return true;
    }

    @Override
    public Node<SalesPersonComplete> createEmptyNode() {
        SalesPersonComplete nC = new SalesPersonComplete();
        ContactComplete hq = new ContactComplete();
        hq.setCity("");
        hq.setCountry("");
        hq.setEmail("");
        hq.setFax("");
        hq.setFirstName("");
        hq.setFunction("");
        hq.setLastName("");
        hq.setMobile("");
        hq.setProvince("");
        hq.setSitaCode("");
        hq.setStation("");
        hq.setStreet("");
        hq.setStreetNumber("");
        hq.setTel("");
        hq.setTitle("");
        hq.setZipCode("");
        nC.setContact(hq);
        Node n = INodeCreator.getDefaultImpl().getNode4DTO((Object)nC, false, false);
        INodeCreator.getDefaultImpl().initUpdate(n);
        return n;
    }

    @Override
    public Class<SalesPersonComplete> getCommittingClass() {
        return SalesPersonComplete.class;
    }
}

