/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.retail.details;

import ch.icit.pegasus.client.converter.FlightCategoryConverter;
import ch.icit.pegasus.client.converter.FlightStateEConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.modules.flight.details.utils.EditLegListPopupInsert;
import ch.icit.pegasus.client.gui.modules.flight.details.utils.EnterCancelMessagePopupInsert;
import ch.icit.pegasus.client.gui.modules.flight.details.utils.FlightProviderRule;
import ch.icit.pegasus.client.gui.modules.invoice.InvoiceToolkit;
import ch.icit.pegasus.client.gui.table.DefaultDetailsPanel;
import ch.icit.pegasus.client.gui.table.DetailsEditorInputParagraph;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.InfoButton;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.PopupType;
import ch.icit.pegasus.client.gui.utils.popup.myway.PopupInsert1;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDComboBox;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDTextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextFieldType;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.ListNode;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.server.core.dtos.flightschedule.ALegComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightComplete_;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight_;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightStateE;
import ch.icit.pegasus.server.core.dtos.masterdata.FlightCategoryComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.FlightAccess;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public class StateDetailsPanel
extends DefaultDetailsPanel<FlightLight>
implements DetailsEditorInputParagraph {
    private static final long serialVersionUID = 1L;
    private TitledItem<RDComboBox> box;
    private final TextLabel infoLabel;
    private Node<FlightComplete> node;
    private InfoButton cancelInfo;
    private FlightStateE latestState;
    private TitledItem<TextLabel> number;
    private TitledItem<RDComboBox> category;
    private TitledItem<RDTextField> name;
    private boolean autoName;

    public StateDetailsPanel(RowEditor<FlightLight> editor, RDProvider provider) {
        super(editor, provider);
        this.setTitleText(Words.DETAILS);
        SystemSettingsComplete settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
        this.autoName = Boolean.TRUE.equals(settings.getRetailAutoName());
        this.number = new TitledItem<TextLabel>(new TextLabel(), Words.NUMBER, TitledItem.TitledItemOrientation.NORTH);
        this.number.getElement().setReadOnlyTextField(true);
        if (!this.autoName) {
            this.name = new TitledItem<RDTextField>(new RDTextField(provider, TextFieldType.NORMAL), Words.NAME, TitledItem.TitledItemOrientation.NORTH);
        }
        this.box = new TitledItem<RDComboBox>(new RDComboBox(provider, ConverterRegistry.getConverter(FlightStateEConverter.class)), Words.STATE, TitledItem.TitledItemOrientation.NORTH);
        this.box.getElement().addItemListener(arg0 -> this.setEnabled(this.isEnabled()));
        this.infoLabel = new TextLabel();
        this.cancelInfo = new InfoButton();
        this.category = new TitledItem<RDComboBox>(new RDComboBox(provider, ConverterRegistry.getConverter(FlightCategoryConverter.class), true), Words.CATEGORY, TitledItem.TitledItemOrientation.NORTH);
        this.setCustomLayouter(new Layout());
        this.addToView(this.box);
        this.addToView(this.number);
        this.addToView(this.infoLabel);
        this.addToView(this.cancelInfo);
        this.addToView(this.category);
        if (!this.autoName) {
            this.addToView(this.name);
        }
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> focusList = new ArrayList<Component>();
        CheckedListAdder.addToList(focusList, this.box);
        CheckedListAdder.addToList(focusList, this.cancelInfo);
        CheckedListAdder.addToList(focusList, this.name);
        CheckedListAdder.addToList(focusList, this.category);
        return focusList;
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        super.buttonPressed(source, x, y);
        if (this.node != null) {
            InnerPopUp2 popUp = InnerPopUp2.getInnerPopUp();
            popUp.setAttributes(source, true, true, Words.EDIT_LEGS);
            Node legs = this.node.getChildNamed(FlightComplete_.legs);
            popUp.setView(new EditLegListPopupInsert((Node<List<ALegComplete>>)legs, this.node, this.provider));
            popUp.showPopUp(x, y, 800, 300, (source1, xargs) -> {
                if (this.editor != null && this.editor.getModel() != null && this.editor.getModel().getNode() != null) {
                    this.editor.setEnabled(false);
                    this.editor.getModel().getNode().commit(FlightComplete.class);
                    this.editor.setNode(this.editor.getModel().getNode());
                    this.editor.setEnabled(true);
                } else {
                    this.setEnabled(false);
                    this.node.commit(FlightLight.class);
                    this.setNode(this.node);
                    this.setEnabled(true);
                }
            }, source, PopupType.NORMAL);
        }
    }

    @Override
    public boolean grabsFocus() {
        return true;
    }

    private Node<?> createList() {
        ListNode list;
        block41: {
            boolean isInvoiced;
            boolean isPlannedAllowed;
            Node currentState;
            block38: {
                block39: {
                    block40: {
                        currentState = this.node.getChildNamed(FlightLight_.flightState);
                        Node type = this.node.getChildNamed(FlightLight_.flightType);
                        list = new ListNode();
                        isPlannedAllowed = false;
                        isInvoiced = false;
                        boolean autoCheckout = false;
                        boolean isInvoiceClosed = false;
                        try {
                            isInvoiced = Boolean.TRUE.equals(((FlightComplete)this.node.getValue(FlightComplete.class)).isInvoiced());
                            autoCheckout = Boolean.TRUE.equals(((FlightComplete)this.node.getValue(FlightComplete.class)).getAutoCheckout());
                            isInvoiceClosed = Boolean.TRUE.equals(((FlightComplete)this.node.getValue(FlightComplete.class)).getIsInvoiceClosed());
                            boolean hasTransactions = Boolean.TRUE.equals(((FlightComplete)this.node.getValue(FlightComplete.class)).getHasStockTransactions());
                            boolean hasSubstitutions = Boolean.TRUE.equals(((FlightComplete)this.node.getValue(FlightComplete.class)).getHasSubstitutions());
                            boolean hasIrregularities = !Boolean.TRUE.equals(((FlightComplete)this.node.getValue(FlightComplete.class)).getNoStockIrregularities());
                            boolean hasRetailInMotionTransactions = Boolean.TRUE.equals(((FlightComplete)this.node.getValue(FlightComplete.class)).getHasRetailInMotionTransactions());
                            isPlannedAllowed = !hasTransactions && !hasSubstitutions && !hasIrregularities && !hasRetailInMotionTransactions;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        if (autoCheckout) break block38;
                        if (!isInvoiced) break block39;
                        if (!isInvoiceClosed) break block40;
                        switch ((FlightStateE)currentState.getValue()) {
                            case CANCELLED: {
                                this.addCanceled((Node)list);
                                break;
                            }
                            case CLOSED: {
                                this.addClosed((Node)list);
                                break;
                            }
                            case EN_ROUTE: {
                                break;
                            }
                            case OPEN: {
                                break;
                            }
                            case PLANNED: {
                                break;
                            }
                            case DISPATCHED: {
                                break;
                            }
                        }
                        break block41;
                    }
                    switch ((FlightStateE)currentState.getValue()) {
                        case CANCELLED: 
                        case CLOSED: 
                        case EN_ROUTE: 
                        case OPEN: 
                        case PLANNED: 
                        case DISPATCHED: {
                            this.addOpen((Node)list);
                            this.addCanceled((Node)list);
                            this.addClosed((Node)list);
                            if (isPlannedAllowed) {
                                this.addPlanned((Node)list);
                                break;
                            }
                            break block41;
                        }
                    }
                    break block41;
                }
                switch ((FlightStateE)currentState.getValue()) {
                    case CANCELLED: {
                        this.addCanceled((Node)list);
                        this.box.getElement().setEnabled(false);
                        this.box.setEnabled(false);
                        break;
                    }
                    case CLOSED: 
                    case EN_ROUTE: 
                    case OPEN: 
                    case DISPATCHED: {
                        if (isPlannedAllowed) {
                            this.addPlanned((Node)list);
                        }
                        this.addOpen((Node)list);
                        this.addClosed((Node)list);
                        this.addCanceled((Node)list);
                        break;
                    }
                    case PLANNED: {
                        this.addOpen((Node)list);
                        break;
                    }
                }
                break block41;
            }
            if (isInvoiced) {
                this.infoLabel.setText(this.getInfoText());
                this.addCanceled((Node)list);
                this.addClosed((Node)list);
                switch ((FlightStateE)currentState.getValue()) {
                    case CANCELLED: 
                    case CLOSED: {
                        break;
                    }
                    case EN_ROUTE: {
                        break;
                    }
                    case OPEN: {
                        this.addOpen((Node)list);
                        break;
                    }
                    case PLANNED: {
                        break;
                    }
                    case DISPATCHED: {
                        break;
                    }
                }
            } else {
                this.infoLabel.setText("");
                switch ((FlightStateE)currentState.getValue()) {
                    case CANCELLED: {
                        this.addCanceled((Node)list);
                        break;
                    }
                    case CLOSED: {
                        this.addClosed((Node)list);
                        this.addCanceled((Node)list);
                        break;
                    }
                    case EN_ROUTE: {
                        this.addOpen((Node)list);
                        this.addCanceled((Node)list);
                        break;
                    }
                    case OPEN: {
                        if (isPlannedAllowed) {
                            this.addPlanned((Node)list);
                        }
                        this.addOpen((Node)list);
                        this.addCanceled((Node)list);
                        break;
                    }
                    case PLANNED: {
                        this.addPlanned((Node)list);
                        this.addOpen((Node)list);
                        this.addCanceled((Node)list);
                        break;
                    }
                    case DISPATCHED: {
                        this.addCanceled((Node)list);
                        this.addClosed((Node)list);
                    }
                }
            }
        }
        return list;
    }

    private void addPlanned(Node list) {
        list.addChild(INodeCreator.getDefaultImpl().getNode4DTO((Object)FlightStateE.PLANNED, true, false), 0L);
    }

    private void addOpen(Node list) {
        list.addChild(INodeCreator.getDefaultImpl().getNode4DTO((Object)FlightStateE.OPEN, true, false), 0L);
    }

    private void addEnRoute(Node list) {
        list.addChild(INodeCreator.getDefaultImpl().getNode4DTO((Object)FlightStateE.EN_ROUTE, true, false), 0L);
    }

    private void addDispatched(Node list) {
        list.addChild(INodeCreator.getDefaultImpl().getNode4DTO((Object)FlightStateE.DISPATCHED, true, false), 0L);
    }

    private void addClosed(Node list) {
        list.addChild(INodeCreator.getDefaultImpl().getNode4DTO((Object)FlightStateE.CLOSED, true, false), 0L);
    }

    private void addCanceled(Node list) {
        list.addChild(INodeCreator.getDefaultImpl().getNode4DTO((Object)FlightStateE.CANCELLED, true, false), 0L);
    }

    private String getInfoText() {
        return Words.FLIGHT_UNDELETABLE_ALREADY_INVOICED;
    }

    @Override
    public boolean isInnerComponent(Component c) {
        return this.box.getElement().isInnerComponent(c);
    }

    @Override
    public void setNode(Node<?> node) {
        this.node = node;
        if (this.provider.getAdditionalRule() == null) {
            this.provider.setAdditionalRule(new FlightProviderRule((FlightComplete)node.getValue(FlightComplete.class)));
        }
        this.box.getElement().setNode(node.getChildNamed(FlightLight_.flightState));
        this.box.getElement().refreshPossibleValues(this.createList());
        if (((FlightStateE)node.getChildNamed(FlightLight_.flightState).getValue()).equals((Object)FlightStateE.PLANNED)) {
            node.getChildNamed(FlightLight_.flightState).setValue((Object)FlightStateE.OPEN, 0L);
        }
        this.latestState = (FlightStateE)node.getChildNamed(FlightLight_.flightState).getValue();
        this.category.getElement().refreshPossibleValues(NodeToolkit.getAffixList(FlightCategoryComplete.class));
        this.category.getElement().setNode(node.getChildNamed(FlightLight_.category));
        if (!this.autoName) {
            this.name.getElement().setNode(node.getChildNamed(FlightLight_.outboundCode));
        }
        this.number.getElement().setNode(node.getChildNamed(FlightLight_.trackingNumber));
        Node airportNode = node.getChildNamed(FlightLight_.deliveryAirport);
        if (airportNode != null && airportNode.getValue() == null) {
            SystemSettingsComplete s = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
            airportNode.setValue((Object)s.getHomeBase(), 0L);
        }
        this.cancelInfo.installStringViewer(InvoiceToolkit.getCancelMessage((FlightLight)node.getValue(FlightLight.class), (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue()));
    }

    @Override
    public void switchState(Button.ButtonState newState) {
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.box.kill();
        this.box = null;
        this.category.kill();
        this.category = null;
        if (!this.autoName) {
            this.name.kill();
        }
        this.name = null;
        this.cancelInfo.kill();
        this.cancelInfo = null;
        this.number.kill();
        this.number = null;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        this.box.setEnabled(isEnabled);
        this.number.setEnabled(isEnabled);
        boolean e = false;
        if (this.node != null && this.node.getChildNamed(FlightLight.ID_) != null && this.node.getChildNamed(FlightLight.ID_).getValue() == null) {
            e = true;
        }
        if (this.provider.isWritable(FlightAccess.REMOVE_LEGS)) {
            e = true;
        }
        boolean canceled = false;
        boolean predefine = false;
        boolean open = false;
        if (this.node != null && this.node.getChildNamed(FlightLight_.flightState) != null) {
            if (this.node.getChildNamed(FlightLight_.flightState).getValue() == FlightStateE.CANCELLED) {
                canceled = true;
            }
            if (this.node.getChildNamed(FlightLight_.flightState).getValue() == FlightStateE.OPEN) {
                open = true;
            }
            if (canceled) {
                predefine = canceled && this.provider.isWritable(FlightAccess.PREDEFINE_INVOICE);
            }
        }
        this.cancelInfo.setEnabled(isEnabled && canceled);
        this.category.setEnabled(isEnabled);
        if (!this.autoName) {
            this.name.setEnabled(isEnabled);
        }
    }

    @Override
    public List<ScreenValidationObject> validateParagraph() {
        ArrayList<ScreenValidationObject> validationObjects = new ArrayList<ScreenValidationObject>();
        SystemSettingsComplete settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
        if (this.node == null || this.node.getValue(FlightLight.class) == null) {
            return new ArrayList<ScreenValidationObject>();
        }
        if (((FlightStateE)this.node.getChildNamed(FlightLight_.flightState).getValue()).equals((Object)FlightStateE.PLANNED)) {
            boolean isInvoiced = false;
            if (Boolean.TRUE.equals(this.node.getChildNamed(FlightLight_.invoiceNormalAdditional).getValue())) {
                isInvoiced = true;
            }
            if (Boolean.TRUE.equals(this.node.getChildNamed(FlightLight_.invoiceNormalHandling).getValue())) {
                isInvoiced = true;
            }
            if (Boolean.TRUE.equals(this.node.getChildNamed(FlightLight_.invoiceNormalMeal).getValue())) {
                isInvoiced = true;
            }
            if (Boolean.TRUE.equals(this.node.getChildNamed(FlightLight_.invoiceNormalStandard).getValue())) {
                isInvoiced = true;
            }
            if (isInvoiced) {
                validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.UNABLE_TO_DELETE_FLIGHT_REMOVE_FROM_INVOICE));
            } else if (((FlightLight)this.node.getValue(FlightLight.class)).getFlightState() != FlightStateE.PLANNED) {
                validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.WARNING, Words.FLIGHT_WILL_BE_DELETED));
            } else {
                validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.WARNING, Words.FLIGHT_IS_NOT_OPEN_YET));
            }
        }
        return validationObjects;
    }

    @Override
    public void requestFocusInWindowNow() {
        this.box.requestFocusInWindowNow();
    }

    @Override
    public PopupInsert1 getInputInsert() {
        if (this.latestState != FlightStateE.CANCELLED && this.editor.getModel().getNode().getChildNamed(FlightLight_.flightState).getValue() == FlightStateE.CANCELLED) {
            return new EnterCancelMessagePopupInsert(this.node);
        }
        return null;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int w2tl = (parent.getWidth() - 3 * StateDetailsPanel.this.horizontalBorder) / 2;
            int w3tl = (parent.getWidth() - 3 * StateDetailsPanel.this.horizontalBorder) / 3;
            StateDetailsPanel.this.number.setLocation(StateDetailsPanel.this.horizontalBorder, StateDetailsPanel.this.verticalBorder);
            StateDetailsPanel.this.number.setSize(w3tl, (int)StateDetailsPanel.this.number.getPreferredSize().getHeight());
            if (!StateDetailsPanel.this.autoName) {
                StateDetailsPanel.this.name.setLocation(StateDetailsPanel.this.number.getX() + StateDetailsPanel.this.number.getWidth() + StateDetailsPanel.this.horizontalBorder, StateDetailsPanel.this.verticalBorder);
                StateDetailsPanel.this.name.setSize(parent.getWidth() - (StateDetailsPanel.this.name.getX() + 2 * StateDetailsPanel.this.horizontalBorder), (int)StateDetailsPanel.this.name.getPreferredSize().getHeight());
            }
            StateDetailsPanel.this.box.setLocation(StateDetailsPanel.this.horizontalBorder, StateDetailsPanel.this.number.getY() + StateDetailsPanel.this.number.getHeight() + StateDetailsPanel.this.verticalBorder);
            StateDetailsPanel.this.box.setSize(w2tl > 200 ? 200 : w2tl, (int)StateDetailsPanel.this.box.getPreferredSize().getHeight());
            StateDetailsPanel.this.cancelInfo.setLocation(StateDetailsPanel.this.box.getX() + StateDetailsPanel.this.box.getWidth() + 5, (int)((double)(StateDetailsPanel.this.box.getY() + StateDetailsPanel.this.box.getHeight()) - StateDetailsPanel.this.cancelInfo.getPreferredSize().getHeight()) - 3);
            StateDetailsPanel.this.cancelInfo.setSize(StateDetailsPanel.this.cancelInfo.getPreferredSize());
            StateDetailsPanel.this.category.setLocation(StateDetailsPanel.this.cancelInfo.getX() + StateDetailsPanel.this.cancelInfo.getWidth() + StateDetailsPanel.this.horizontalBorder, StateDetailsPanel.this.box.getY());
            StateDetailsPanel.this.category.setSize(parent.getWidth() - (StateDetailsPanel.this.category.getX() + StateDetailsPanel.this.horizontalBorder), (int)StateDetailsPanel.this.category.getPreferredSize().getHeight());
            StateDetailsPanel.this.infoLabel.setLocation(StateDetailsPanel.this.horizontalBorder, StateDetailsPanel.this.box.getY() + StateDetailsPanel.this.box.getHeight() + StateDetailsPanel.this.inner_verticalBorder);
            StateDetailsPanel.this.infoLabel.setSize(parent.getWidth() - 2 * StateDetailsPanel.this.horizontalBorder, (int)StateDetailsPanel.this.infoLabel.getPreferredSize().getHeight());
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = StateDetailsPanel.this.verticalBorder;
            h = !StateDetailsPanel.this.autoName ? (int)((double)h + StateDetailsPanel.this.name.getPreferredSize().getHeight()) : (int)((double)h + StateDetailsPanel.this.category.getPreferredSize().getHeight());
            h += StateDetailsPanel.this.verticalBorder;
            h = (int)((double)h + StateDetailsPanel.this.box.getPreferredSize().getHeight());
            return new Dimension(300, h += StateDetailsPanel.this.verticalBorder);
        }
    }
}

