/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.recipe.details.utils;

import ch.icit.pegasus.client.converter.TaxZoneConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.popup.PopUpInsert;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2Factory;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.server.core.dtos.masterdata.TaxZoneComplete;
import ch.icit.pegasus.server.core.dtos.recipe.SimpleIngredientComplete;
import ch.icit.pegasus.server.core.dtos.recipe.SimpleIngredientComplete_;
import ch.icit.pegasus.server.core.dtos.supply.SupplierLight;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public class EditRecipeIngredientPopupInsert
extends PopUpInsert {
    private TitledItem<ComboBox> taxZone;
    private TitledItem<SearchTextField2<SupplierLight>> supplier;
    private RDProvider provider;
    private Node<SimpleIngredientComplete> node;

    public EditRecipeIngredientPopupInsert(RDProvider provider, Node<SimpleIngredientComplete> node) {
        this.provider = provider;
        this.node = node;
        this.taxZone = new TitledItem<ComboBox>(new ComboBox(node.getChildNamed(SimpleIngredientComplete_.preferredTaxZone), NodeToolkit.getAffixList(TaxZoneComplete.class), ConverterRegistry.getConverter(TaxZoneConverter.class), true), Words.PREFERRED_TAX_ZONE, TitledItem.TitledItemOrientation.NORTH);
        this.supplier = new TitledItem<SearchTextField2<SupplierLight>>(SearchTextField2Factory.getSupplierSearchField(true, node.getChildNamed(SimpleIngredientComplete_.preferredSupplier)), Words.PREFERRED_SUPPLIER, TitledItem.TitledItemOrientation.NORTH);
        this.setLayout(new Layout());
        this.add(this.taxZone);
        this.add(this.supplier);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        boolean b = this.provider.isWritable(SimpleIngredientComplete_.preferredSupplier);
        this.taxZone.setEnabled(b && enabled);
        this.supplier.setEnabled(b && enabled);
    }

    @Override
    public boolean tryToGrabFocus() {
        return false;
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> a = new ArrayList<Component>();
        CheckedListAdder.addToList(a, this.taxZone);
        CheckedListAdder.addToList(a, this.supplier);
        return a;
    }

    @Override
    public boolean isClosableWithEnter() {
        return false;
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        return new Object[0];
    }

    @Override
    public boolean isInnerComponent(Component c) {
        return false;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = 0;
            h += EditRecipeIngredientPopupInsert.this.border;
            h = (int)((double)h + EditRecipeIngredientPopupInsert.this.taxZone.getPreferredSize().getHeight());
            h += EditRecipeIngredientPopupInsert.this.border;
            h = (int)((double)h + EditRecipeIngredientPopupInsert.this.supplier.getPreferredSize().getHeight());
            return new Dimension(0, h += EditRecipeIngredientPopupInsert.this.border);
        }

        @Override
        public void layoutContainer(Container parent) {
            EditRecipeIngredientPopupInsert.this.taxZone.setLocation(EditRecipeIngredientPopupInsert.this.border, EditRecipeIngredientPopupInsert.this.border);
            EditRecipeIngredientPopupInsert.this.taxZone.setSize(parent.getWidth() - 2 * EditRecipeIngredientPopupInsert.this.border, (int)EditRecipeIngredientPopupInsert.this.taxZone.getPreferredSize().getHeight());
            EditRecipeIngredientPopupInsert.this.supplier.setLocation(EditRecipeIngredientPopupInsert.this.border, EditRecipeIngredientPopupInsert.this.taxZone.getY() + EditRecipeIngredientPopupInsert.this.taxZone.getHeight() + EditRecipeIngredientPopupInsert.this.border);
            EditRecipeIngredientPopupInsert.this.supplier.setSize(parent.getWidth() - 2 * EditRecipeIngredientPopupInsert.this.border, (int)EditRecipeIngredientPopupInsert.this.supplier.getPreferredSize().getHeight());
        }
    }
}

