/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.recipe.details;

import ch.icit.pegasus.client.converter.Converter;
import ch.icit.pegasus.client.converter.RecipeVariantConverter2;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.screentemplates.details.AVariantTemplateDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2Factory;
import ch.icit.pegasus.client.node.impls.DTOProxyNode;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.recipe.RecipeServiceManager;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.masterdata.ModificationStateE;
import ch.icit.pegasus.server.core.dtos.recipe.RecipeComplete;
import ch.icit.pegasus.server.core.dtos.recipe.RecipeReference;
import ch.icit.pegasus.server.core.dtos.recipe.RecipeVariantComplete;
import ch.icit.pegasus.server.core.dtos.recipe.RecipeVariantLight;
import ch.icit.pegasus.server.core.dtos.recipe.RecipeVariantReference;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.ListWrapper;
import ch.icit.pegasus.server.core.dtos.utils.CopyTemplateToolkit;
import ch.icit.pegasus.server.core.i18n.Words;
import java.util.ArrayList;
import java.util.List;

public class TemplateDetailsPanel
extends AVariantTemplateDetailsPanel<RecipeComplete, RecipeVariantLight> {
    private static final long serialVersionUID = 1L;
    private boolean isServiceItem;

    public TemplateDetailsPanel(RowEditor<RecipeComplete> editor, RDProvider provider, boolean isServiceItem) {
        super(editor, provider);
        this.isServiceItem = isServiceItem;
    }

    @Override
    public Converter<?, String> getVariantViewConverter() {
        return ConverterRegistry.getConverter(RecipeVariantConverter2.class);
    }

    @Override
    public SearchTextField2<RecipeComplete> createSearchField() {
        return SearchTextField2Factory.getRecipeSearchField(true, new DTOProxyNode());
    }

    @Override
    public RecipeComplete reloadItem(RecipeComplete item) throws ClientServerCallException {
        return (RecipeComplete)((RecipeServiceManager)ServiceManagerRegistry.getService(RecipeServiceManager.class)).getRecipe((RecipeReference)item).getValue();
    }

    @Override
    public Class<RecipeComplete> getVariantMasterClass() {
        return RecipeComplete.class;
    }

    @Override
    public List<RecipeVariantLight> reloadVariants(List<RecipeVariantLight> variants) throws ClientServerCallException {
        ArrayList<RecipeVariantLight> refs = new ArrayList<RecipeVariantLight>();
        refs.addAll(variants);
        return ((RecipeServiceManager)ServiceManagerRegistry.getService(RecipeServiceManager.class)).getRecipeVariants(new ListWrapper(refs)).getList();
    }

    @Override
    public RecipeComplete copyItem(RecipeComplete master, RecipeVariantLight variant, boolean upload, boolean copyAllVariants) throws ClientServerCallException {
        RecipeVariantComplete variantComplete = !copyAllVariants ? (RecipeVariantComplete)((RecipeServiceManager)ServiceManagerRegistry.getService(RecipeServiceManager.class)).getRecipeVariant((RecipeVariantReference)variant).getValue() : null;
        ArrayList<ADTO> variants = new ArrayList<ADTO>();
        if (copyAllVariants) {
            for (RecipeVariantReference reference : master.getVariants()) {
                variants.add(((RecipeServiceManager)ServiceManagerRegistry.getService(RecipeServiceManager.class)).getRecipeVariant(reference).getValue());
            }
        }
        return CopyTemplateToolkit.copyRecipe((RecipeComplete)master, (RecipeVariantComplete)variantComplete, variants);
    }

    @Override
    public Class<RecipeVariantLight> getVariantClass() {
        return RecipeVariantLight.class;
    }

    @Override
    public void initNewVariant(RecipeComplete newVariant) {
        newVariant.getCurrentVariant().setName("");
        newVariant.getCurrentVariant().setState(ModificationStateE.DRAFT);
    }

    @Override
    public String getSearchFieldTitle() {
        return Words.RECIPE;
    }
}

