/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.radar.view;

import ch.icit.pegasus.client.MainFrame;
import ch.icit.pegasus.client.gui.batch.BatchJob;
import ch.icit.pegasus.client.gui.batch.BatchList;
import ch.icit.pegasus.client.gui.hud.ConnectionToOutside;
import ch.icit.pegasus.client.gui.modules.radar.view.RadarContentPane;
import ch.icit.pegasus.client.gui.modules.radar.view.RadarFlightWidget;
import ch.icit.pegasus.client.gui.modules.radar.view.RadarToolBar;
import ch.icit.pegasus.client.gui.modules.radar.view.utils.RadarHeader;
import ch.icit.pegasus.client.gui.submodules.SubModuleShortCut;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.GlobalKeyListener;
import ch.icit.pegasus.client.gui.utils.ScrollPane;
import ch.icit.pegasus.client.gui.utils.panels.BackgroundedContainer;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight;
import ch.icit.pegasus.server.core.dtos.rightmanagement.access.ModuleAccessRightComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.access.SubModuleAccessRightComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.definition.SubModuleDefinitionComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.RadarAccess;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.KeyEvent;
import java.sql.Date;
import java.sql.Time;
import java.util.ArrayList;
import java.util.List;

public class RadarPanel
extends BackgroundedContainer {
    private static final long serialVersionUID = 1L;
    private final List<SubModuleShortCut> registeredKey = new ArrayList<SubModuleShortCut>();
    private ScrollPane scrollPane;
    private RadarContentPane contentPane;
    private RadarHeader header = new RadarHeader();
    private AWTEventListener keyListener;
    private Time dayStart;
    private Time dayEnd;
    private RadarToolBar toolBar;
    private final Node<List<FlightLight>> node;
    private MainFrame mainFrame;
    private final ConnectionToOutside outSideConnection;
    private final RDProvider currentProvider;

    public RadarPanel(Node<List<FlightLight>> node, ConnectionToOutside connection, RDProvider p) {
        this.node = node;
        this.outSideConnection = connection;
        this.currentProvider = p;
    }

    public ConnectionToOutside getConnection() {
        return this.outSideConnection;
    }

    public BatchList<?, BatchJob<?>> getBatchList() {
        return this.toolBar.getBatchList();
    }

    private SubModuleShortCut createShortCut(SubModuleDefinitionComplete m, int key) {
        SubModuleShortCut s = MainFrame.createShortCut(m, key);
        s.setBatchList(this.toolBar.getBatchList());
        s.setConnectionToOutside(this.outSideConnection);
        s.setMainFrame(this.mainFrame);
        this.registeredKey.add(s);
        return s;
    }

    private void registerKeys() {
        for (ModuleAccessRightComplete m : ((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentUser().getModules()) {
            if (!m.getModule().getInvokingName().equals(RadarAccess.MODULE_RADAR.getIdentifier())) continue;
            for (SubModuleAccessRightComplete sr : m.getSubModules()) {
                if (sr.getModule().getInvokingName().equals(RadarAccess.PRINT_FLIGHT_DELIVERY_SLIP.getIdentifier())) {
                    this.mainFrame.addGlobalKeyListener(this.createShortCut(sr.getModule(), 49));
                }
                if (sr.getModule().getInvokingName().equals(RadarAccess.PRINT_FLIGHT_STOWING_REPORT.getIdentifier())) {
                    this.mainFrame.addGlobalKeyListener(this.createShortCut(sr.getModule(), 50));
                }
                if (sr.getModule().getInvokingName().equals(RadarAccess.PRINT_LABEL.getIdentifier())) {
                    this.mainFrame.addGlobalKeyListener(this.createShortCut(sr.getModule(), 51));
                }
                if (sr.getModule().getInvokingName().equals(RadarAccess.PRINT_RETURNS_COUNT_WORK_SHEET.getIdentifier())) {
                    this.mainFrame.addGlobalKeyListener(this.createShortCut(sr.getModule(), 53));
                }
                if (sr.getModule().getInvokingName().equals(RadarAccess.ANALYSIS_FLIGHT_DAILY_OPS_PLAN.getIdentifier())) {
                    this.mainFrame.addGlobalKeyListener(this.createShortCut(sr.getModule(), 54));
                }
                if (!sr.getModule().getInvokingName().equals(RadarAccess.ACTION_FLIGHT_DETAILS.getIdentifier())) continue;
                this.mainFrame.addGlobalKeyListener(this.createShortCut(sr.getModule(), 79));
            }
            return;
        }
    }

    public void init(MainFrame mainFrame) {
        this.mainFrame = mainFrame;
        this.scrollPane = new ScrollPane();
        this.scrollPane.setOpaque(false);
        this.toolBar = new RadarToolBar(this, this.currentProvider);
        this.installKeyListener();
        this.registerKeys();
        Color c = AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("inner_table_panel_background_color"));
        this.scrollPane.setBackground(c);
        this.scrollPane.getHorizontalScrollBar().setBackground(c);
        this.scrollPane.getVerticalScrollBar().setBackground(c);
        this.scrollPane.setColumnHeaderView(this.header);
        this.contentPane = new RadarContentPane(this, this.node);
        this.scrollPane.setViewportView(this.contentPane);
        this.dayStart = new Time(6, 0, 0);
        this.dayEnd = new Time(23, 59, 59);
        this.updateFlightRange(this.dayStart, this.dayEnd, new Date(System.currentTimeMillis()), 1);
        this.setLayout(new Layout());
        this.add(this.scrollPane);
        this.add(this.toolBar);
    }

    public void updateSelectedDate(Date selectedDate, int days) {
        this.updateFlightRange(this.dayStart, this.dayEnd, selectedDate, days);
    }

    protected MainFrame getMainFrame() {
        return this.mainFrame;
    }

    public Node<FlightLight> getNode() {
        if (this.contentPane.getSelectedFlight() != null) {
            return this.contentPane.getSelectedFlight().getNode();
        }
        return null;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        if (this.scrollPane != null) {
            this.scrollPane.setEnabled(isEnabled);
        }
        if (this.toolBar != null) {
            this.toolBar.setEnabled(isEnabled);
        }
    }

    private void installKeyListener() {
        this.keyListener = new AWTEventListener(){

            @Override
            public void eventDispatched(AWTEvent event) {
                if (((KeyEvent)event).isShiftDown() && ((KeyEvent)event).getID() == 401) {
                    if (((KeyEvent)event).getKeyCode() == 37) {
                        RadarPanel.this.contentPane.moveBackward();
                    } else if (((KeyEvent)event).getKeyCode() == 39) {
                        RadarPanel.this.contentPane.moveForward();
                    }
                }
            }
        };
        Toolkit.getDefaultToolkit().addAWTEventListener(this.keyListener, 8L);
    }

    private void deinstallKeyListener() {
        for (GlobalKeyListener globalKeyListener : this.registeredKey) {
            this.mainFrame.removeGlobalKeyListener(globalKeyListener);
        }
        this.registeredKey.clear();
        Toolkit.getDefaultToolkit().removeAWTEventListener(this.keyListener);
    }

    public void updateFlightRange(Time startTime, Time endTime, Date startDate, int days) {
        this.contentPane.setFlightRange(startTime, endTime, startDate, days);
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.deinstallKeyListener();
        if (this.scrollPane != null) {
            this.scrollPane.kill();
        }
        this.scrollPane = null;
        if (this.header != null) {
            this.header.kill();
        }
        this.header = null;
        if (this.contentPane != null) {
            this.contentPane.kill();
        }
        this.contentPane = null;
    }

    public void revalidatePane() {
        this.scrollPane.revalidate();
    }

    public void selectNode(RadarFlightWidget selectedWidget) {
        if (selectedWidget != null) {
            this.toolBar.setNode(selectedWidget.getNode());
        } else {
            this.toolBar.setNode(null);
        }
        this.repaint(32L);
    }

    public void scrollTo(RadarFlightWidget selectedWidget) {
        if (selectedWidget != null) {
            this.scrollPane.ensureViewable(selectedWidget);
        }
    }

    public RadarContentPane getContentPane() {
        return this.contentPane;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension();
        }

        @Override
        public void layoutContainer(Container parent) {
            int border = 2;
            RadarPanel.this.scrollPane.setLocation(border, border);
            RadarPanel.this.scrollPane.setSize((int)((double)(parent.getWidth() - 3 * border) - RadarPanel.this.toolBar.getPreferredSize().getWidth()), parent.getHeight() - 2 * border);
            RadarPanel.this.toolBar.setLocation(RadarPanel.this.scrollPane.getX() + RadarPanel.this.scrollPane.getWidth() + border, border);
            RadarPanel.this.toolBar.setSize((int)RadarPanel.this.toolBar.getPreferredSize().getWidth(), RadarPanel.this.scrollPane.getHeight());
            int df = (RadarPanel.this.scrollPane.getWidth() - 275) / 6;
            int[] widths = new int[]{100, df, df, df, df, df, df};
            RadarPanel.this.header.setColumnWidths(widths);
            RadarPanel.this.getContentPane().setColumnWidths(widths);
        }
    }
}

