/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.radar.view;

import ch.icit.pegasus.client.MainFrame;
import ch.icit.pegasus.client.gui.modules.flight.details.AdditionalOrderDetailsPanel;
import ch.icit.pegasus.client.gui.modules.flight.details.AlaCarteMenusDetailsPanel;
import ch.icit.pegasus.client.gui.modules.flight.details.BondedEquipmentSealsDetailsPanel;
import ch.icit.pegasus.client.gui.modules.flight.details.CustomsDocumentsDetailsPanel;
import ch.icit.pegasus.client.gui.modules.flight.details.DelaysDetailsPanel;
import ch.icit.pegasus.client.gui.modules.flight.details.EditPaxDetailsPanel;
import ch.icit.pegasus.client.gui.modules.flight.details.FlightStateDetailsPanel;
import ch.icit.pegasus.client.gui.modules.flight.details.RemarkDetailsPanel;
import ch.icit.pegasus.client.gui.modules.flight.details.SealDefinitionDetailsPanel;
import ch.icit.pegasus.client.gui.modules.flight.details.SpecialMenusDetailsPanel;
import ch.icit.pegasus.client.gui.modules.flight.details.TrucksDetailsPanel;
import ch.icit.pegasus.client.gui.modules.flightschedule.details.HandlingCostDetailsPanel;
import ch.icit.pegasus.client.gui.modules.flightschedule.details.StowingListDetailsPanel;
import ch.icit.pegasus.client.gui.table.CombinedDetailsParagraph;
import ch.icit.pegasus.client.gui.table.DefaultDetailsPanel;
import ch.icit.pegasus.client.gui.table.DetailsEditorParagraph;
import ch.icit.pegasus.client.gui.utils.TableLayoutConstraint;
import ch.icit.pegasus.client.gui.utils.focus.VisibleContainer;
import ch.icit.pegasus.client.gui.utils.layouter.DetailsParagraphLayout;
import ch.icit.pegasus.client.gui.utils.panels.ScrollableBackground;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.flight.FlightServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.HUDToolkit;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight_;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightReference;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightStateE;
import ch.icit.pegasus.server.core.dtos.rightmanagement.access.ModuleAccessRightComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.RadarAccess;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;

public class RadarDetailsPanel
extends ScrollableBackground {
    private static final long serialVersionUID = 1L;
    private MainFrame mainFrame;
    private List<DetailsEditorParagraph> paragraphs = new ArrayList<DetailsEditorParagraph>();
    private Node<FlightLight> currentNode;

    public RadarDetailsPanel(MainFrame mainFrame) {
        this.mainFrame = mainFrame;
        ModuleAccessRightComplete m = HUDToolkit.getCurrentAccessRight(RadarAccess.MODULE_RADAR, ((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentUser());
        RDProvider p = new RDProvider(m, false);
        this.getViewPort().setLayout(new DetailsParagraphLayout());
        FlightStateDetailsPanel d1 = new FlightStateDetailsPanel(null, p);
        SpecialMenusDetailsPanel d4 = null;
        AlaCarteMenusDetailsPanel d41 = null;
        AdditionalOrderDetailsPanel d5 = null;
        StowingListDetailsPanel d6 = null;
        RemarkDetailsPanel d7 = null;
        CustomsDocumentsDetailsPanel d8 = null;
        CombinedDetailsParagraph h1 = null;
        CombinedDetailsParagraph h11 = null;
        CombinedDetailsParagraph h2 = null;
        DelaysDetailsPanel d9 = null;
        HandlingCostDetailsPanel d10 = null;
        TrucksDetailsPanel d11 = null;
        EditPaxDetailsPanel d2 = null;
        h1 = new CombinedDetailsParagraph();
        h2 = new CombinedDetailsParagraph();
        d7 = new RemarkDetailsPanel(null, p);
        d9 = new DelaysDetailsPanel(null, p);
        d10 = new HandlingCostDetailsPanel(null, p, false, false);
        d2 = new EditPaxDetailsPanel(null, p);
        d4 = new SpecialMenusDetailsPanel(null, p);
        d41 = new AlaCarteMenusDetailsPanel(null, p);
        d5 = new AdditionalOrderDetailsPanel(null, p);
        SealDefinitionDetailsPanel d12 = new SealDefinitionDetailsPanel(null, p);
        BondedEquipmentSealsDetailsPanel d13 = new BondedEquipmentSealsDetailsPanel(null, p);
        d6 = new StowingListDetailsPanel(null, p, FlightLight_.activeStowingList, true, null, d4, d5, d12, null);
        d8 = new CustomsDocumentsDetailsPanel(null, p);
        d11 = new TrucksDetailsPanel(null, p);
        h1.add((Component)d1, new TableLayoutConstraint(0, 0, 0.5, 1.0));
        h1.add((Component)d2, new TableLayoutConstraint(1, 0, 0.5, 1.0));
        h11 = new CombinedDetailsParagraph();
        h11.add((Component)d9, new TableLayoutConstraint(0, 0, 0.2f, 1.0));
        h11.add(d6, new TableLayoutConstraint(1, 0, 0.8f, 1.0));
        h2.add((Component)d8, new TableLayoutConstraint(0, 0, 0.5, 1.0));
        h2.add(d10, new TableLayoutConstraint(1, 0, 0.5, 1.0));
        this.getViewPort().add((Component)h1, new TableLayoutConstraint(0, 0, 1.0, 0.0));
        this.getViewPort().add((Component)h11, new TableLayoutConstraint(0, 1, 1.0, 0.0));
        this.getViewPort().add((Component)h2, new TableLayoutConstraint(0, 2, 1.0, 0.0));
        this.getViewPort().add((Component)d7, new TableLayoutConstraint(0, 3, 1.0, 0.0));
        this.getViewPort().add((Component)d4, new TableLayoutConstraint(0, 4, 1.0, 0.0));
        this.getViewPort().add((Component)d41, new TableLayoutConstraint(0, 5, 1.0, 0.0));
        this.getViewPort().add((Component)d5, new TableLayoutConstraint(0, 6, 1.0, 0.0));
        this.getViewPort().add((Component)d12, new TableLayoutConstraint(0, 7, 1.0, 1.0));
        this.getViewPort().add((Component)d13, new TableLayoutConstraint(0, 8, 1.0, 1.0));
        this.getViewPort().add((Component)d11, new TableLayoutConstraint(0, 9, 1.0, 1.0));
        this.addToList(d1);
        this.addToList(d2);
        this.addToList(d6);
        this.addToList(d9);
        this.addToList(d8);
        this.addToList(d10);
        this.addToList(d7);
        this.addToList(d4);
        this.addToList(d41);
        this.addToList(d5);
        this.addToList(d11);
    }

    public void allInstalled() {
        this.updateEnableStateToDetailsPanel();
        this.getLayout().layoutContainer(this);
    }

    public void updateEnableStateToDetailsPanel() {
        for (ArrayList<Component> cc : ((DetailsParagraphLayout)this.getViewPort().getLayout()).getComponents()) {
            for (Component c : cc) {
                if (c instanceof DetailsEditorParagraph) {
                    ((DetailsEditorParagraph)((Object)c)).setValid(true);
                    continue;
                }
                if (!(c instanceof CombinedDetailsParagraph)) continue;
                ((CombinedDetailsParagraph)c).setValid(true);
            }
        }
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        for (DetailsEditorParagraph d : this.paragraphs) {
            d.kill();
        }
        this.paragraphs.clear();
        this.paragraphs = null;
    }

    private void addToList(DetailsEditorParagraph d1) {
        this.paragraphs.add(d1);
    }

    @Override
    public List<Component> getFocusComponents() {
        List<Component> a = super.getFocusComponents();
        if (a == null) {
            a = new ArrayList<Component>();
        }
        for (DetailsEditorParagraph d : this.paragraphs) {
            List<Component> b = d.getFocusComponents();
            if (b == null) continue;
            a.addAll(b);
        }
        return a;
    }

    @Override
    public void setVisibleContainer(VisibleContainer pane) {
    }

    @Override
    public void requestFocusInWindowNow() {
        if (!this.paragraphs.isEmpty()) {
            this.paragraphs.get(0).requestFocusInWindowNow();
        }
    }

    public Node<FlightLight> getNode() {
        return this.currentNode;
    }

    public void setNode(final Node<FlightLight> node) {
        this.ensureAnimation("Load Flight Data");
        this.currentNode = node;
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                Node n = node;
                FlightComplete fc = null;
                if (((FlightLight)n.getValue()).getId() == null) {
                    ((FlightLight)node.getValue()).setFlightState(FlightStateE.PLANNED);
                    fc = (FlightComplete)((FlightServiceManager)ServiceManagerRegistry.getService(FlightServiceManager.class)).getPlannedFlightComplete((FlightLight)node.getValue()).getValue();
                } else {
                    fc = (FlightComplete)((FlightServiceManager)ServiceManagerRegistry.getService(FlightServiceManager.class)).getFlight(new FlightReference(((FlightLight)node.getValue()).getId())).getValue();
                }
                node.removeExistingValues();
                node.setValue((Object)fc, 0L);
                node.updateNode();
                return node;
            }

            @Override
            public RemoteLoader getInvoker() {
                return new RemoteLoader(){

                    public void remoteObjectLoaded(Node<?> node) {
                        RadarDetailsPanel.this.applyNodes(node);
                    }

                    public void errorOccurred(ClientException exception) {
                        RadarDetailsPanel.this.hideAnimation();
                        RadarDetailsPanel.this.errorOccurred(exception);
                    }
                };
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    protected void applyNodes(Node<?> flight) {
        for (DetailsEditorParagraph d : this.paragraphs) {
            d.setNode(flight);
        }
        this.hideAnimation();
        this.revalidate();
    }

    public boolean isInnerComponent(Component c) {
        for (DetailsEditorParagraph d : this.paragraphs) {
            if (!(d instanceof DefaultDetailsPanel) || !((DefaultDetailsPanel)d).isInnerComponent(c)) continue;
            return true;
        }
        return false;
    }

    public void showAnimation() {
        if (((FlightLight)this.currentNode.getValue()).getId() == null) {
            this.ensureAnimation("Open Flight");
        } else {
            this.ensureAnimation("Update Flight");
        }
    }
}

