/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.purchaseorder.manager.details;

import ch.icit.pegasus.client.converter.BasicArticleConverter;
import ch.icit.pegasus.client.converter.Converter;
import ch.icit.pegasus.client.converter.DateConverter;
import ch.icit.pegasus.client.converter.DeltaQuantityConverter;
import ch.icit.pegasus.client.converter.FormulaConverter;
import ch.icit.pegasus.client.converter.IntegerPlusPlusConverter;
import ch.icit.pegasus.client.converter.OrderReviewStateConverter;
import ch.icit.pegasus.client.converter.PriceConverter1;
import ch.icit.pegasus.client.converter.PriceConverter3;
import ch.icit.pegasus.client.converter.PriceMutationConverter;
import ch.icit.pegasus.client.converter.PurchaseOrderReviewAcceptationSumConverter;
import ch.icit.pegasus.client.converter.PurchaseOrderReviewPositionSumConverter;
import ch.icit.pegasus.client.converter.PurchasePriceConverter;
import ch.icit.pegasus.client.converter.StoreViewConverter;
import ch.icit.pegasus.client.converter.UnitConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.modules.purchaseorder.manager.utils.PurchasePositionStoreAndDepartmentConverter;
import ch.icit.pegasus.client.gui.modules.purchaseorder.manualcreator.details.utils.PositionNameConverter;
import ch.icit.pegasus.client.gui.modules.requisitionorder.manager.details.utils.OrderAmountChangingPopup;
import ch.icit.pegasus.client.gui.modules.requisitionorder.manager.details.utils.UserAndDateTimeAndCorrectionsConverter;
import ch.icit.pegasus.client.gui.modules.requisitionorder.manager.details.utils.UserAndDateTimeConverter;
import ch.icit.pegasus.client.gui.modules.stock.details.utils.EditChargePriceUnitExpiryPopup;
import ch.icit.pegasus.client.gui.screentemplates.details.TableDetailsPanel;
import ch.icit.pegasus.client.gui.submodules.tool.purchase.receive.ReceiveToolkit;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table.renderer.CellViewOrderReviewStateRenderer;
import ch.icit.pegasus.client.gui.table.renderer.CellViewOrderStateRenderer;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.InnerPopUpListener2;
import ch.icit.pegasus.client.gui.utils.Killable;
import ch.icit.pegasus.client.gui.utils.QuantityRenderer;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.buttons.AllergenButton;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.buttons.CustomsButton;
import ch.icit.pegasus.client.gui.utils.buttons.DeleteButton;
import ch.icit.pegasus.client.gui.utils.buttons.EditButton;
import ch.icit.pegasus.client.gui.utils.buttons.ExpandIcon;
import ch.icit.pegasus.client.gui.utils.buttons.HACCPButton;
import ch.icit.pegasus.client.gui.utils.buttons.HalalButton;
import ch.icit.pegasus.client.gui.utils.buttons.InfoButton;
import ch.icit.pegasus.client.gui.utils.buttons.RemarkButton;
import ch.icit.pegasus.client.gui.utils.buttons.StockTransactionRemarkButton;
import ch.icit.pegasus.client.gui.utils.buttons.TextButton;
import ch.icit.pegasus.client.gui.utils.buttons.TransportCostsButton;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.combobox.InputComboBox;
import ch.icit.pegasus.client.gui.utils.icons.impl.CheckBoxRO;
import ch.icit.pegasus.client.gui.utils.popup.IPopUpInsert;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.popup.TextListPopUpInsert;
import ch.icit.pegasus.client.gui.utils.popup.inserts.HACCPCheckPopUpInsert;
import ch.icit.pegasus.client.gui.utils.popup.inserts.OPRPCheckPopUpInsert;
import ch.icit.pegasus.client.gui.utils.popup.inserts.StringPopUpInsert;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2Factory;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2Listener;
import ch.icit.pegasus.client.gui.utils.skins.SizedSkin1Field;
import ch.icit.pegasus.client.gui.utils.textfield.NumberTextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextFieldType;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.DtoFieldConstants;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.ViewNodeDataChangeHandler;
import ch.icit.pegasus.client.node.impls.DTONode;
import ch.icit.pegasus.client.node.impls.EmbeddedDTONode;
import ch.icit.pegasus.client.node.impls.ListNode;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeListener;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.node.impls.ViewNode;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.HUDToolkit;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.client.util.loaders.BasicArticleLoader;
import ch.icit.pegasus.client.util.toolkits.ArticleToolkit;
import ch.icit.pegasus.client.util.toolkits.OrderToolkit;
import ch.icit.pegasus.client.util.toolkits.TransactionToolkit;
import ch.icit.pegasus.client.util.variantaccessor.CurrencyVariantAccessorImpl;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.company.InternalCostCenterComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.CurrencyVariantComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.QuantityComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.StoreQuantityComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.StoreQuantityComplete_;
import ch.icit.pegasus.server.core.dtos.masterdata.TaxZoneComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.UnitComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.UserLight;
import ch.icit.pegasus.server.core.dtos.ordering.CustomsDocumentComplete_;
import ch.icit.pegasus.server.core.dtos.ordering.OrderPositionComplete_;
import ch.icit.pegasus.server.core.dtos.ordering.OrderReviewStateE;
import ch.icit.pegasus.server.core.dtos.ordering.OrderStateE;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderComplete;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderComplete_;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderLight;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderLight_;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderPositionComplete;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderPositionComplete_;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderPositionLight;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderPositionLight_;
import ch.icit.pegasus.server.core.dtos.ordering.haccp.PurchaseOrderPositionHACCPLogComplete;
import ch.icit.pegasus.server.core.dtos.ordering.transaction.PurchaseOrderAcceptationComplete;
import ch.icit.pegasus.server.core.dtos.ordering.transaction.PurchaseOrderAcceptationComplete_;
import ch.icit.pegasus.server.core.dtos.ordering.transaction.PurchaseOrderPositionCorrectionComplete;
import ch.icit.pegasus.server.core.dtos.ordering.transaction.PurchaseOrderPositionCorrectionComplete_;
import ch.icit.pegasus.server.core.dtos.ordering.transaction.PurchaseOrderPositionMutationComplete;
import ch.icit.pegasus.server.core.dtos.ordering.transaction.PurchaseOrderPositionMutationComplete_;
import ch.icit.pegasus.server.core.dtos.ordering.transaction.PurchaseOrderRejectionComplete;
import ch.icit.pegasus.server.core.dtos.ordering.transaction.PurchaseOrderRejectionComplete_;
import ch.icit.pegasus.server.core.dtos.ordering.transaction.remark.OrderPositionMutationRemarkComplete;
import ch.icit.pegasus.server.core.dtos.ordering.transaction.remark.OrderPositionReceivingRemarkComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.access.DataFieldAccessRightComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.access.ModuleAccessRightComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.PurchaseOrderAccess;
import ch.icit.pegasus.server.core.dtos.store.ArticleChargeComplete;
import ch.icit.pegasus.server.core.dtos.store.ArticleChargeComplete_;
import ch.icit.pegasus.server.core.dtos.store.ArticleChargeLight;
import ch.icit.pegasus.server.core.dtos.store.StoreLight;
import ch.icit.pegasus.server.core.dtos.store.StorePositionLight_;
import ch.icit.pegasus.server.core.dtos.store.transaction.StockTransactionComplete_;
import ch.icit.pegasus.server.core.dtos.store.transaction.remark.StockTransactionRemarkComplete;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleComplete;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleLight;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleLight_;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleReference;
import ch.icit.pegasus.server.core.dtos.supply.PriceComplete;
import ch.icit.pegasus.server.core.dtos.supply.SupplierComplete;
import ch.icit.pegasus.server.core.dtos.supply.SupplierConditionBaseComplete;
import ch.icit.pegasus.server.core.dtos.supply.SupplierConditionComplete;
import ch.icit.pegasus.server.core.dtos.supply.SupplierLight;
import ch.icit.pegasus.server.core.dtos.supply.SupplierReference;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.utils.CopyTemplateToolkit;
import ch.icit.pegasus.server.core.dtos.utils.TransactionType;
import ch.icit.pegasus.server.core.dtos.utils.UnitConversionToolkit;
import ch.icit.pegasus.server.core.dtos.utils.accessor.CurrencyVariantAccessor;
import ch.icit.pegasus.server.core.i18n.Phrase;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public abstract class OrderPositionsDetailsPanel
extends TableDetailsPanel<PurchaseOrderLight> {
    private static final long serialVersionUID = 1L;
    private final boolean isSolarCompany;
    private TextLabel orderCosts;
    private TextButton checkAll;
    private TextLabel deliveryCosts;
    private TextLabel totalCosts;
    private CheckBox inclusiveDeliveryCosts;
    private boolean isDeletable;
    private boolean isChargeEditable;
    private boolean isStateEditable;
    private boolean isDeliveryCostEditable;
    private boolean isEditPreviewState;
    private boolean isCorrectable;
    private CurrencyVariantAccessor accessor = new CurrencyVariantAccessorImpl();

    public OrderPositionsDetailsPanel(RowEditor<PurchaseOrderLight> editor, RDProvider provider, boolean isCheck) {
        super(editor, provider, !isCheck);
        this.setTitleText(Words.PURCHASE_ORDER_POSITIONS);
        this.isSolarCompany = Boolean.TRUE.equals(((SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue()).getCompany().getSolarCompanyType());
        this.isDeletable = provider.isDeletable(PurchaseOrderComplete_.orderPositions);
        this.isChargeEditable = provider.isWritable(PurchaseOrderAccess.CAN_UPDATE_CHARGE);
        this.isStateEditable = provider.isWritable(PurchaseOrderComplete_.state);
        this.isDeliveryCostEditable = provider.isWritable(PurchaseOrderAccess.DELIVERY_COST);
        this.isEditPreviewState = provider.isWritable(PurchaseOrderAccess.EDIT_REVIEW_STATE);
        if (isCheck) {
            this.orderCosts = new TextLabel();
            this.checkAll = new TextButton(Words.CHECK_ALL_UNCHECKED);
            this.orderCosts.setFont(AttributesConverter.getFont4String(LafLoader.getLafLoader().getAttribute("default_font"), LafLoader.getLafLoader().getAttribute("default_font_size"), LafLoader.getLafLoader().getAttribute("productoverview_pricetext_font_type")));
            this.deliveryCosts = new TextLabel();
            this.deliveryCosts.setFont(AttributesConverter.getFont4String(LafLoader.getLafLoader().getAttribute("default_font"), LafLoader.getLafLoader().getAttribute("default_font_size"), LafLoader.getLafLoader().getAttribute("productoverview_pricetext_font_type")));
            this.totalCosts = new TextLabel();
            this.totalCosts.setFont(AttributesConverter.getFont4String(LafLoader.getLafLoader().getAttribute("default_font"), LafLoader.getLafLoader().getAttribute("default_font_size"), LafLoader.getLafLoader().getAttribute("productoverview_pricetext_font_type")));
            this.checkAll.addButtonListener(this);
            this.inclusiveDeliveryCosts = new CheckBox();
            this.inclusiveDeliveryCosts.addButtonListener(this);
            this.addToView(this.orderCosts);
            this.addToView(this.inclusiveDeliveryCosts);
            this.addToView(this.deliveryCosts);
            this.addToView(this.checkAll);
            this.addToView(this.totalCosts);
        }
    }

    private boolean canChangeSupplierCondition() {
        return Boolean.TRUE.equals(this.settings.getAllowTaxZoneRelatedSupplierCondition());
    }

    public abstract boolean isCheckModule();

    @Override
    public List<TableColumnInfo> getColumns(boolean add) {
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        int w1 = this.table.getCellPadding() * 2 + ExpandIcon.getPreferredWidth(SizedSkin1Field.SkinSize.MEDIUM) + 30 + this.table.getInnerCellPadding();
        int w3 = TableColumnInfo.innerState3 + 2 * this.table.getCellPadding();
        columns.add(new TableColumnInfo(Words.NO_NUMBER, "", String.class, null, "", w1, w1, w1));
        columns.add(new TableColumnInfo(Words.STATE, "", String.class, null, "", w3, w3, w3));
        columns.add(new TableColumnInfo(Words.ARTICLE, "", String.class, null, "", new int[0]));
        int tw = InputComboBox.getPreferredWidth(this, InputComboBox.InputComboBoxType.PRICE_DOUBLE) + 10;
        columns.add(new TableColumnInfo(Words.ORDERED, "", String.class, null, "", tw, tw, tw));
        tw = tw + this.table.getInnerCellPadding() + StockTransactionRemarkButton.getPreferredWidth() + 30;
        columns.add(new TableColumnInfo(Words.RECEIVED, "", String.class, null, "", tw, tw, tw));
        columns.add(new TableColumnInfo(Words.REJECTED, "", String.class, null, "", tw, tw, tw));
        if (this.isCheckModule()) {
            int cw = CheckBox.getPreferredWidth();
            columns.add(new TableColumnInfo("Customer owned", "", String.class, null, "", cw += 2 * this.table.getCellPadding(), cw, cw));
            columns.add(new TableColumnInfo(Words.DAY_PRICE, "", String.class, null, "", tw, tw, tw));
            tw = InputComboBox.getPreferredWidth(this, InputComboBox.InputComboBoxType.PRICE_DOUBLE) + 30;
            columns.add(new TableColumnInfo(Words.SUM, "", String.class, null, "", tw, tw, tw));
            columns.add(new TableColumnInfo(Words.STATE, "", String.class, null, "", 100, 100, 100));
        } else {
            if (!Boolean.TRUE.equals(this.settings.getCompany().getSolarCompanyType())) {
                columns.add(new TableColumnInfo(Words.LABELS, "", String.class, null, "", 70, 70, 70));
            }
            columns.add(new TableColumnInfo(Words.STORE, "", String.class, null, "", 150, 150, 150));
            if (Boolean.TRUE.equals(this.settings.getCompany().getSolarCompanyType())) {
                if (this.canChangeSupplierCondition()) {
                    tw = 3 * this.table.getCellPadding() + EditButton.getPreferredWidth(SizedSkin1Field.SkinSize.SMALL) + this.table.getInnerCellPadding() + InfoButton.getPreferredWidth(SizedSkin1Field.SkinSize.SMALL) + this.table.getInnerCellPadding() + DeleteButton.getPreferredWidth(SizedSkin1Field.SkinSize.SMALL) + this.table.getInnerCellPadding() + StockTransactionRemarkButton.getPreferredWidth();
                    if (Boolean.TRUE.equals(this.settings.getUseAllergenCheckForPurchaseOrders())) {
                        tw += AllergenButton.getPreferredWidth(SizedSkin1Field.SkinSize.SMALL) + this.table.getInnerCellPadding();
                    }
                    if (Boolean.TRUE.equals(this.settings.getUseHalalSpotCheck())) {
                        tw += HalalButton.getPreferredWidth(SizedSkin1Field.SkinSize.SMALL) + this.table.getInnerCellPadding();
                    }
                } else {
                    tw = 3 * this.table.getCellPadding() + InfoButton.getPreferredWidth(SizedSkin1Field.SkinSize.SMALL) + this.table.getInnerCellPadding() + DeleteButton.getPreferredWidth(SizedSkin1Field.SkinSize.SMALL) + this.table.getInnerCellPadding() + StockTransactionRemarkButton.getPreferredWidth();
                    if (Boolean.TRUE.equals(this.settings.getUseAllergenCheckForPurchaseOrders())) {
                        tw += AllergenButton.getPreferredWidth(SizedSkin1Field.SkinSize.SMALL) + this.table.getInnerCellPadding();
                    }
                    if (Boolean.TRUE.equals(this.settings.getUseHalalSpotCheck())) {
                        tw += HalalButton.getPreferredWidth(SizedSkin1Field.SkinSize.SMALL) + this.table.getInnerCellPadding();
                    }
                }
            } else if (this.canChangeSupplierCondition()) {
                tw = 3 * this.table.getCellPadding() + EditButton.getPreferredWidth(SizedSkin1Field.SkinSize.SMALL) + this.table.getInnerCellPadding() + CustomsButton.getPreferredWidth(SizedSkin1Field.SkinSize.SMALL) + InfoButton.getPreferredWidth(SizedSkin1Field.SkinSize.SMALL) + this.table.getInnerCellPadding() + DeleteButton.getPreferredWidth(SizedSkin1Field.SkinSize.SMALL) + this.table.getInnerCellPadding() + StockTransactionRemarkButton.getPreferredWidth() + this.table.getInnerCellPadding() + StockTransactionRemarkButton.getPreferredWidth();
                if (Boolean.TRUE.equals(this.settings.getUseAllergenCheckForPurchaseOrders())) {
                    tw += AllergenButton.getPreferredWidth(SizedSkin1Field.SkinSize.SMALL) + this.table.getInnerCellPadding();
                }
                if (Boolean.TRUE.equals(this.settings.getUseHalalSpotCheck())) {
                    tw += HalalButton.getPreferredWidth(SizedSkin1Field.SkinSize.SMALL) + this.table.getInnerCellPadding();
                }
            } else {
                tw = 3 * this.table.getCellPadding() + CustomsButton.getPreferredWidth(SizedSkin1Field.SkinSize.SMALL) + InfoButton.getPreferredWidth(SizedSkin1Field.SkinSize.SMALL) + this.table.getInnerCellPadding() + DeleteButton.getPreferredWidth(SizedSkin1Field.SkinSize.SMALL) + this.table.getInnerCellPadding() + StockTransactionRemarkButton.getPreferredWidth() + this.table.getInnerCellPadding() + StockTransactionRemarkButton.getPreferredWidth();
                if (Boolean.TRUE.equals(this.settings.getUseAllergenCheckForPurchaseOrders())) {
                    tw += AllergenButton.getPreferredWidth(SizedSkin1Field.SkinSize.SMALL) + this.table.getInnerCellPadding();
                }
                if (Boolean.TRUE.equals(this.settings.getUseHalalSpotCheck())) {
                    tw += HalalButton.getPreferredWidth(SizedSkin1Field.SkinSize.SMALL) + this.table.getInnerCellPadding();
                }
            }
            columns.add(new TableColumnInfo("", "", String.class, null, "", tw, tw, tw));
        }
        ((TableColumnInfo)columns.get(0)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(1)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(2)).setxExpand(1.0);
        ((TableColumnInfo)columns.get(3)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(4)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(5)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(6)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(7)).setxExpand(0.0);
        if (columns.size() > 8) {
            ((TableColumnInfo)columns.get(8)).setxExpand(0.0);
        }
        if (columns.size() > 9) {
            ((TableColumnInfo)columns.get(9)).setxExpand(0.0);
        }
        if (columns.size() > 10) {
            ((TableColumnInfo)columns.get(10)).setxExpand(0.0);
        }
        return columns;
    }

    @Override
    public void configTable(Table2 table) {
        table.setDontUseScrollBar(15);
        table.setProvider(this.provider);
        table.setSortedColumn(0);
    }

    @Override
    public void addButtonPressed(int x, int y, Button source) {
        PurchaseOrderPositionComplete p = new PurchaseOrderPositionComplete();
        p.setClientOId(Long.valueOf(ADTO.getNextId()));
        p.setOrder((PurchaseOrderComplete)this.editor.getModel().getNode().getValue(PurchaseOrderComplete.class));
        p.setSequenceNumber(Integer.valueOf(this.table.getRowCount()));
        p.setState(OrderStateE.PLACED);
        p.setReviewState(OrderReviewStateE.UNCHECKED);
        p.setArticleLabelCount(Integer.valueOf(0));
        StoreQuantityComplete q = new StoreQuantityComplete();
        q.setAmount(Long.valueOf(0L));
        p.setQuantity(q);
        Node n = INodeCreator.getDefaultImpl().getNode4DTO((Object)p, true, false);
        this.table.getModel().getNode().addChild(n, System.currentTimeMillis());
        this.editor.revalidate();
    }

    @Override
    public void childRemoved() {
        this.editor.revalidate();
    }

    @Override
    public Table2RowPanel generateView(Table2RowModel model, boolean isHeader) {
        if (model.getNode().getValue() instanceof PurchaseOrderPositionComplete) {
            return new OrderPositionTableRow(model);
        }
        return new ReceivingInspectionRow(model);
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> focusList = new ArrayList<Component>();
        CheckedListAdder.addToList(focusList, this.table);
        return focusList;
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        super.buttonPressed(source, x, y);
        if (source == this.checkAll) {
            for (Table2RowPanel p : this.table.getRows()) {
                OrderPositionTableRow r = (OrderPositionTableRow)p;
                r.checkUnchecked();
            }
        } else if (source == this.inclusiveDeliveryCosts) {
            this.calculateOrderCosts(this.editor.getModel().getNode());
        }
    }

    @Override
    public List<ScreenValidationObject> validateParagraph() {
        ArrayList<ScreenValidationObject> validationObjects = new ArrayList<ScreenValidationObject>();
        if (this.table.isWritable()) {
            Date orderDate;
            if (this.table.getRows().size() == 0) {
                validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.NO_POSITION_DEFINED));
            }
            if ((orderDate = (Date)this.editor.getModel().getNode().getChildNamed(PurchaseOrderComplete_.orderDate).getValue()) == null) {
                orderDate = (Date)this.editor.getModel().getNode().getChildNamed(PurchaseOrderComplete_.deliveryDate).getValue();
            }
            Boolean useTaxZone = (Boolean)this.editor.getModel().getNode().getChildNamed(PurchaseOrderComplete_.useTaxZone).getValue();
            TaxZoneComplete taxZone = (TaxZoneComplete)this.editor.getModel().getNode().getChildNamed(PurchaseOrderComplete_.taxZone).getValue();
            for (Table2RowPanel p : this.table.getRows()) {
                OrderPositionTableRow t = (OrderPositionTableRow)p;
                List<ScreenValidationObject> l = t.validateRow(orderDate, useTaxZone, taxZone);
                validationObjects.addAll(l);
            }
        }
        return validationObjects;
    }

    private void calculateOrderCosts(Node<?> n) {
        String t;
        SystemSettingsComplete s = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
        PurchaseOrderComplete o = (PurchaseOrderComplete)n.getValue();
        Iterator it = n.getChildNamed(PurchaseOrderComplete_.orderPositions).getChilds();
        PriceComplete price = new PriceComplete(s.getCurrency(), Double.valueOf(0.0));
        while (it.hasNext()) {
            Node pos = (Node)it.next();
            Iterator it2 = pos.getChildNamed(PurchaseOrderPositionComplete_.transactions).getChilds();
            while (it2.hasNext()) {
                Node trans = (Node)it2.next();
                if (!(trans.getValue() instanceof PurchaseOrderAcceptationComplete)) continue;
                PurchaseOrderAcceptationComplete a = (PurchaseOrderAcceptationComplete)trans.getValue();
                StoreQuantityComplete q = a.getAmount();
                PriceComplete pr = a.getCharge().getPrice();
                UnitComplete pu = a.getCharge().getPriceUnit();
                BasicArticleComplete article = (BasicArticleComplete)pos.getChildNamed(PurchaseOrderPositionComplete_.article).getValue(BasicArticleComplete.class);
                double na = UnitConversionToolkit.convertUnit((UnitComplete)q.getUnit(), (UnitComplete)pu, (double)q.getAmount().longValue(), (BasicArticleLight)article, (Timestamp)a.getDate());
                double np = pr.getPrice() * na;
                try {
                    CurrencyVariantComplete cu = (CurrencyVariantComplete)this.accessor.loadData((Object)pr.getCurrency(), a.getDate());
                    price.setPrice(Double.valueOf(price.getPrice() + (np *= cu.getExchangeRate().doubleValue())));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        PriceComplete dc = new PriceComplete(s.getCurrency(), Double.valueOf(0.0));
        if (((Boolean)n.getChildNamed(PurchaseOrderComplete_.inclusiveDeliveryCosts).getValue()).booleanValue()) {
            dc = OrderToolkit.getDeliveryCosts((SupplierComplete)n.getChildNamed(PurchaseOrderComplete_.supplier).getValue(SupplierComplete.class), price, s, this.accessor, new Timestamp(o.getOrderDate().getTime()));
        }
        if ((t = ((PriceConverter3)ConverterRegistry.getConverter(PriceConverter3.class)).convert((Object)price, null, new Object[0])) == null || t.isEmpty()) {
            t = "0.0 " + s.getCurrency().getCode();
        }
        t = Phrase.getPhrase((String)Phrase.ORDER_COST_WITHOUT_DELIVERY_COSTS, (Object[])new Object[]{t});
        this.orderCosts.setText(t);
        t = ((PriceConverter3)ConverterRegistry.getConverter(PriceConverter3.class)).convert((Object)dc, null, new Object[0]);
        if (t == null || t.isEmpty()) {
            t = "0.0 " + s.getCurrency().getCode();
        }
        t = Phrase.getPhrase((String)Phrase.ORDER_DELIVERY_COSTS, (Object[])new Object[]{t});
        this.deliveryCosts.setText(t);
        PriceComplete total = new PriceComplete(s.getCurrency(), Double.valueOf(price.getPrice() + dc.getPrice()));
        t = ((PriceConverter3)ConverterRegistry.getConverter(PriceConverter3.class)).convert((Object)total, null, new Object[0]);
        if (t == null || t.isEmpty()) {
            t = "0.0 " + s.getCurrency().getCode();
        }
        t = Phrase.getPhrase((String)Phrase.TOTAL_ORDER_COSTS, (Object[])new Object[]{t});
        this.totalCosts.setText(t);
    }

    @Override
    public void setNode(Node<?> node) {
        OrderStateE e;
        this.table.getModel().setNode(node.getChildNamed(PurchaseOrderComplete_.orderPositions));
        if (this.editor.getModel().getNode().getChildNamed(PurchaseOrderComplete_.reviewState).getValue() == null) {
            this.editor.getModel().getNode().getChildNamed(PurchaseOrderComplete_.reviewState).setValue((Object)OrderReviewStateE.UNCHECKED, 0L);
        }
        if (node.getChildNamed(PurchaseOrderComplete_.inclusiveDeliveryCosts).getValue() == null) {
            node.getChildNamed(PurchaseOrderComplete_.inclusiveDeliveryCosts).setValue((Object)true, 0L);
        }
        if (this.isCheckModule()) {
            this.inclusiveDeliveryCosts.setNode(node.getChildNamed(PurchaseOrderComplete_.inclusiveDeliveryCosts));
            this.calculateOrderCosts(node);
        }
        boolean isClosed = (e = (OrderStateE)this.editor.getModel().getNode().getChildNamed(PurchaseOrderComplete_.state).getValue()).equals((Object)OrderStateE.CLOSED) || e.equals((Object)OrderStateE.PENDING);
        boolean isCancel = e.equals((Object)OrderStateE.CANCELLED);
        OrderReviewStateE o = (OrderReviewStateE)this.editor.getModel().getNode().getChildNamed(PurchaseOrderComplete_.reviewState).getValue();
        boolean isApproved = o.equals((Object)OrderReviewStateE.APPROVED);
        boolean addPositionAnyway = this.provider.isWritable(PurchaseOrderAccess.ADD_POSITION_ANYWAY);
        this.table.ensureAddButton(Words.TABLE_ADD, !isClosed && !isCancel && !isApproved && !this.isCheckModule() || addPositionAnyway && !isCancel);
        this.table.getModel().allInitiated();
    }

    @Override
    public void switchState(Button.ButtonState newState) {
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.isCheckModule()) {
            this.orderCosts.kill();
            this.deliveryCosts.kill();
            this.totalCosts.kill();
            this.checkAll.kill();
            this.inclusiveDeliveryCosts.kill();
            this.orderCosts = null;
            this.checkAll = null;
            this.deliveryCosts = null;
            this.totalCosts = null;
            this.inclusiveDeliveryCosts = null;
        }
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        if (this.isCheckModule()) {
            boolean isApproved = true;
            if (this.table.getModel().getNode() != null) {
                Iterator it = this.table.getModel().getNode().getFailSafeChildIterator();
                while (it.hasNext() && isApproved) {
                    Node n = (Node)it.next();
                    OrderReviewStateE s = (OrderReviewStateE)n.getChildNamed(PurchaseOrderComplete_.reviewState).getValue();
                    if (s == OrderReviewStateE.APPROVED) continue;
                    isApproved = false;
                }
            }
            this.orderCosts.setEnabled(isEnabled);
            this.checkAll.setEnabled(isEnabled && this.isStateEditable && (!isApproved || this.isEditPreviewState));
            this.deliveryCosts.setEnabled(isEnabled);
            this.totalCosts.setEnabled(isEnabled);
            this.inclusiveDeliveryCosts.setEnabled(isEnabled && this.isDeliveryCostEditable && (!isApproved || this.isEditPreviewState));
        }
    }

    @Override
    public void layoutContainer(Container parent) {
        this.table.setLocation(0, 0);
        if (this.isCheckModule()) {
            this.table.setSize(parent.getWidth(), (int)this.table.getPreferredSize().getHeight());
            this.orderCosts.setLocation(this.horizontalBorder, this.table.getY() + this.table.getHeight() + this.inner_verticalBorder);
            this.orderCosts.setSize(this.orderCosts.getPreferredSize());
            this.deliveryCosts.setLocation((int)((double)this.horizontalBorder + this.inclusiveDeliveryCosts.getPreferredSize().getWidth() + (double)this.inner_horizontalBorder), this.orderCosts.getY() + this.orderCosts.getHeight() + this.inner_verticalBorder);
            this.deliveryCosts.setSize(this.deliveryCosts.getPreferredSize());
            this.inclusiveDeliveryCosts.setLocation(this.horizontalBorder, (int)((double)this.deliveryCosts.getY() + ((double)this.deliveryCosts.getHeight() - this.inclusiveDeliveryCosts.getPreferredSize().getHeight()) / 2.0));
            this.inclusiveDeliveryCosts.setSize(this.inclusiveDeliveryCosts.getPreferredSize());
            this.totalCosts.setLocation(this.horizontalBorder, this.deliveryCosts.getY() + this.deliveryCosts.getHeight() + this.inner_verticalBorder);
            this.totalCosts.setSize(this.totalCosts.getPreferredSize());
            this.checkAll.setLocation((int)((double)parent.getWidth() - ((double)this.horizontalBorder + this.checkAll.getPreferredSize().getWidth())), this.orderCosts.getY());
            this.checkAll.setSize(this.checkAll.getPreferredSize());
        } else {
            this.table.setSize(parent.getWidth(), (int)this.table.getPreferredSize().getHeight());
        }
    }

    @Override
    public Dimension calculateContainerPreferredSize() {
        int h = (int)this.table.getPreferredSize().getHeight() + 1;
        if (this.isCheckModule()) {
            h += this.inner_verticalBorder;
            h = (int)((double)h + this.checkAll.getPreferredSize().getHeight());
            h += this.inner_verticalBorder;
            h = (int)((double)h + this.deliveryCosts.getPreferredSize().getHeight());
            h += this.inner_verticalBorder;
            h = (int)((double)h + this.totalCosts.getPreferredSize().getHeight());
            h += this.verticalBorder;
        }
        return new Dimension(0, h);
    }

    @Override
    public void requestFocusInWindowNow() {
    }

    public void enableAmountChange() {
        for (Table2RowPanel p : this.table.getRows()) {
            OrderPositionTableRow tr = (OrderPositionTableRow)p;
            tr.enableAmountChange();
        }
    }

    private class ReceivingInspectionRow
    extends Table2RowPanel
    implements ButtonListener,
    InnerPopUpListener2 {
        private static final long serialVersionUID = 1L;
        private TextLabel userName;
        private TextLabel quantity;
        private TextLabel store;
        private InfoButton overViewButton;
        private EditButton editTransaction;
        private CustomsButton docs;
        private TextLabel sum;
        private EditButton editAmount;
        private StoreQuantityComplete startQuantity;
        private HACCPButton haccpButton;
        private boolean wasPriceChange;
        private ArticleChargeComplete charge;

        public ReceivingInspectionRow(Table2RowModel m) {
            super(m);
            this.userName = new TextLabel(m.getNode(), ConverterRegistry.getConverter(UserAndDateTimeConverter.class));
            this.startQuantity = (StoreQuantityComplete)m.getNode().getChildNamed(StockTransactionComplete_.amount).getValue();
            this.wasPriceChange = true;
            if (m.getNode().getValue() instanceof PurchaseOrderAcceptationComplete) {
                PurchaseOrderAcceptationComplete acc = (PurchaseOrderAcceptationComplete)m.getNode().getValue();
                this.store = OrderPositionsDetailsPanel.this.isCheckModule() ? new TextLabel(m.getNode(), ConverterRegistry.getConverter(PurchasePriceConverter.class)) : new TextLabel(m.getNode().getChildNamed(new DtoField[]{PurchaseOrderAcceptationComplete_.destinationPosition, StorePositionLight_.store}), ConverterRegistry.getConverter(StoreViewConverter.class));
                this.quantity = new QuantityRenderer((Node<?>)m.getNode().getChildNamed(PurchaseOrderAcceptationComplete_.amount));
                this.charge = acc.getCharge();
                if (!OrderPositionsDetailsPanel.this.isCheckModule()) {
                    this.overViewButton = new InfoButton(Words.TRANSACTION_INFO);
                    this.overViewButton.installStringViewer(this.createOverViewPopup());
                    if (!OrderPositionsDetailsPanel.this.isSolarCompany) {
                        boolean writable;
                        this.docs = new CustomsButton();
                        this.docs.addButtonListener(this);
                        if (Boolean.TRUE.equals(OrderPositionsDetailsPanel.this.settings.getUseHACCPLogInPurchaseOrder()) && (writable = OrderPositionsDetailsPanel.this.provider.isWritable(PurchaseOrderAccess.HACCP_CHECK))) {
                            this.haccpButton = new HACCPButton();
                            this.haccpButton.addButtonListener(this);
                        }
                    }
                } else {
                    this.sum = new TextLabel(m.getNode(), ConverterRegistry.getConverter(PurchaseOrderReviewAcceptationSumConverter.class));
                }
            } else if (m.getNode().getValue() instanceof PurchaseOrderRejectionComplete) {
                this.quantity = new QuantityRenderer((Node<?>)m.getNode().getChildNamed(PurchaseOrderRejectionComplete_.amount));
                OrderPositionsDetailsPanel.this.isChargeEditable = false;
            } else if (m.getNode().getValue() instanceof PurchaseOrderPositionMutationComplete) {
                PurchaseOrderPositionMutationComplete mut = (PurchaseOrderPositionMutationComplete)m.getNode().getValue();
                if (mut.getOldPriceUnit() != null && mut.getOldSupplierPrice() != null) {
                    this.quantity = new TextLabel(m.getNode(), ConverterRegistry.getConverter(PriceMutationConverter.class));
                    this.wasPriceChange = true;
                } else if (mut.getQuantity() != null && mut.getQuantity().getUnit() != null) {
                    this.quantity = new QuantityRenderer((Node<?>)m.getNode().getChildNamed(PurchaseOrderPositionMutationComplete_.amount), (Converter<?, ?>)ConverterRegistry.getConverter(DeltaQuantityConverter.class));
                }
            } else if (m.getNode().getValue() instanceof PurchaseOrderPositionCorrectionComplete) {
                PurchaseOrderPositionCorrectionComplete correction = (PurchaseOrderPositionCorrectionComplete)m.getNode().getValue();
                this.userName = new TextLabel(m.getNode(), ConverterRegistry.getConverter(UserAndDateTimeAndCorrectionsConverter.class));
                this.quantity = new TextLabel(m.getNode().getChildNamed(PurchaseOrderPositionCorrectionComplete_.amount));
                OrderPositionsDetailsPanel.this.isChargeEditable = false;
            }
            this.setLayout(new ReceivingLayout());
            this.add(this.userName);
            this.add(this.quantity);
            if (OrderPositionsDetailsPanel.this.isChargeEditable) {
                this.editTransaction = new EditButton();
                this.editTransaction.addButtonListener(this);
                this.add(this.editTransaction);
            }
            if (this.editAmount != null) {
                this.add(this.editAmount);
            }
            if (this.store != null) {
                this.add(this.store);
            }
            if (this.overViewButton != null) {
                this.add(this.overViewButton);
            }
            if (this.sum != null) {
                this.add(this.sum);
            }
            if (this.docs != null) {
                this.add(this.docs);
            }
            if (this.haccpButton != null) {
                this.add(this.haccpButton);
            }
            this.setEnabled(true);
        }

        @Override
        public Object getObject4Column(int column) {
            return null;
        }

        private String createOverViewPopup() {
            ArrayList<String> list = new ArrayList<String>();
            ArticleChargeComplete charge = ((PurchaseOrderAcceptationComplete)this.model.getNode().getValue()).getCharge();
            Date exp = charge.getExpiryDate();
            PriceComplete price = charge.getPrice();
            list.add(Words.EXPIRY_POINT + "  " + ((DateConverter)ConverterRegistry.getConverter(DateConverter.class)).convert((Object)exp, null, new Object[0]));
            list.add(Words.AVERAGE_PRICE + "  " + ((PriceConverter1)ConverterRegistry.getConverter(PriceConverter1.class)).convert(price, null, new Object[0]) + "/" + ((UnitConverter)ConverterRegistry.getConverter(UnitConverter.class)).convert(charge.getBasicArticle().getPriceUnit(), null, new Object[0]));
            list.add(Words.ARTICLE_CHARGE + " " + charge.getNumber());
            String t = "<b>" + charge.getBasicArticle().getName() + "<br/><hr></b><br/>";
            list.add(Words.ORIGIN + ": " + (charge.getOrigin() != null ? charge.getOrigin().getCode() : "-"));
            FormulaConverter formula = (FormulaConverter)ConverterRegistry.getConverter(FormulaConverter.class);
            Node nodes = INodeCreator.getDefaultImpl().createNodes(charge.getPackingQuantities(), false);
            String formulaString = formula.convert((Object)charge.getPackingQuantities(), nodes, new Object[0]);
            t = t + "<b>" + Words.CONVERSION + "</b><br/><ul>";
            t = t + "<li>" + formulaString + "</li></ul>";
            t = t + "<b>" + Words.ACCEPTATIONS + "</b><br/><ul>";
            for (String s : list) {
                t = t + "<li>" + s + "</li>";
            }
            t = t + "</ul>";
            if (charge.getHaccpLog() != null) {
                t = Boolean.TRUE.equals(charge.getHaccpLog().getHaccpSystem()) ? t + "<b>HACCP Log</b><br/><ul>" : t + "<b>OPRP Log</b><br/><ul>";
                t = t + "<li>Truck Type: " + charge.getHaccpLog().getTruckType() + "</li>";
                t = t + "<li>Truck: " + (Boolean.TRUE.equals(charge.getHaccpLog().getTruckOk()) ? "Ok" : "not Ok") + "</li>";
                t = t + "<li>Quality: " + (Boolean.TRUE.equals(charge.getHaccpLog().getQualityCondition()) ? "Ok" : "not Ok") + "</li>";
                t = t + "<li>Temperature: " + charge.getHaccpLog().getTemperature() + " \u00b0C" + "</li>";
                t = t + "<li>Expiry Date: " + ((DateConverter)ConverterRegistry.getConverter(DateConverter.class)).convert((Object)charge.getHaccpLog().getExpiryDate(), null, new Object[0]) + "</li>";
                t = t + "<li>Halal: " + (Boolean.TRUE.equals(charge.getHaccpLog().getHalalState()) ? "Ok" : "not Ok") + "</li>";
                t = t + "<li>State: " + (Boolean.TRUE.equals(charge.getHaccpLog().getOkState()) ? "Ok" : "not Ok") + "</li>";
                t = t + "<li>Comment: " + charge.getHaccpLog().getComment() + "</li>";
                t = t + "</ul>";
            }
            return t;
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.userName.kill();
            this.quantity.kill();
            if (this.store != null) {
                this.store.kill();
            }
            if (this.overViewButton != null) {
                this.overViewButton.kill();
            }
            if (this.editTransaction != null) {
                this.editTransaction.kill();
                this.editTransaction = null;
            }
            if (this.editAmount != null) {
                this.editAmount.kill();
            }
            this.editAmount = null;
            if (this.sum != null) {
                this.sum.kill();
            }
            if (this.docs != null) {
                this.docs.kill();
            }
            this.docs = null;
            if (this.haccpButton != null) {
                this.haccpButton.kill();
            }
            this.haccpButton = null;
            this.userName = null;
            this.quantity = null;
            this.store = null;
            this.overViewButton = null;
            this.sum = null;
        }

        @Override
        public void paint(Graphics g) {
            if (!OrderPositionsDetailsPanel.this.isCheckModule() || !this.wasPriceChange) {
                super.paint(g);
                return;
            }
            Graphics2D g2 = (Graphics2D)g;
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            int aHeight = this.lineDrawingHeight;
            if (aHeight == -1) {
                aHeight = this.getHeight();
            }
            if (this.isSelected == 3) {
                this.selectedSkin.paint(g2, 0, 0, this.getWidth(), 7);
            } else if (this.isSelected == 5) {
                this.selectedSkin.paint(g2, 0, 0, this.getWidth(), 13);
            } else if (this.hasBackground) {
                g2.setColor(this.getRowColor(this));
                g2.fillRect(0, 0, this.getWidth(), aHeight);
            }
            switch (this.useControls) {
                case ONE: {
                    this.tableControlsSkin.paint(g2, this.controlsX, 0, this.getHeight(), SizedSkin1Field.SkinSize.SMALL);
                    break;
                }
                case TWO: {
                    this.tableControlsSkin.paint(g2, this.controlsX, 0, this.getHeight(), SizedSkin1Field.SkinSize.MEDIUM);
                    break;
                }
                case THREE: 
                case FOUR: {
                    this.tableControlsSkin.paint(g2, this.controlsX, 0, this.getHeight(), SizedSkin1Field.SkinSize.BIG);
                    break;
                }
            }
            g2.setColor(this.model.getParentModel().getTable().getLineColor());
            int currentX = this.position2LineOffset;
            for (int i = 0; i < this.model.getParentModel().getColumnCount() - 1; ++i) {
                currentX += this.model.getParentModel().getColumnWidth(i);
                if (i > 2 && i < 6) continue;
                g2.drawLine(currentX, 0, currentX, aHeight);
            }
            this.paintChildren(g2);
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            this.userName.setEnabled(isEnabled);
            this.quantity.setEnabled(isEnabled);
            if (this.editTransaction != null) {
                this.editTransaction.setEnabled(false);
            }
            if (this.store != null) {
                this.store.setEnabled(isEnabled);
            }
            if (this.overViewButton != null) {
                this.overViewButton.setEnabled(isEnabled);
            }
            if (this.sum != null) {
                this.sum.setEnabled(isEnabled);
            }
            if (this.docs != null) {
                this.docs.setEnabled(isEnabled);
            }
            if (this.haccpButton != null) {
                this.haccpButton.setEnabled(isEnabled);
            }
            if (this.editAmount != null) {
                if (isEnabled) {
                    // empty if block
                }
                this.editAmount.setEnabled(false);
            }
        }

        @Override
        public List<Component> getFocusComponents() {
            return null;
        }

        @Override
        public void buttonPressed(Button source, int x, int y) {
            if (source == this.editTransaction) {
                InnerPopUp2 popUp = InnerPopUp2.getInnerPopUp();
                popUp.setAttributes(this.editTransaction, true, true, Words.EDIT_CHARGE);
                popUp.setView(new EditChargePriceUnitExpiryPopup(this.model.getNode(), true));
                popUp.showPopUp(x, y, 250, 260, (source1, xargs) -> {
                    if (xargs != null) {
                        if (this.model.getNode().getParent().getParent().getChildNamed(DtoFieldConstants.UPDATE_CHARGE) == null) {
                            Node updateCharge = new Node();
                            updateCharge.setName(DtoFieldConstants.UPDATE_CHARGE);
                            this.model.getNode().getParent().getParent().addChild(updateCharge, 0L);
                        }
                        this.store.setLeftUpperCornerPainting(true, AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("productionplanner_stocksetted_color")));
                    }
                }, this.editTransaction);
            } else if (source == this.docs) {
                BasicArticleLight article = (BasicArticleLight)this.model.getNode().getChildNamed(new DtoField[]{PurchaseOrderAcceptationComplete_.charge, ArticleChargeComplete_.basicArticle}).getValue();
                boolean editable = Boolean.TRUE.equals(article.getBonded());
                Boolean allowPurchaseBondedRestriction = OrderPositionsDetailsPanel.this.settings.getAllowPurchaseBondedRestriction();
                if (!Boolean.TRUE.equals(allowPurchaseBondedRestriction)) {
                    editable = true;
                }
                if (editable && this.model.getNode().getParent().getParent().getChildNamed(DtoFieldConstants.UPDATE_TRANSACTION) == null) {
                    Node updateCharge = new Node();
                    updateCharge.setName(DtoFieldConstants.UPDATE_TRANSACTION);
                    this.model.getNode().getParent().getParent().addChild(updateCharge, 0L);
                }
                InnerPopupFactory.showCustomsDocumentsEditPopup(this, this.model.getNode().getChildNamed(PurchaseOrderAcceptationComplete_.customsDocs), OrderPositionsDetailsPanel.this.provider, editable, x, y, PurchaseOrderComplete_.customsDocuments.getFieldName());
            } else if (source == this.editAmount) {
                this.changeAmount(x, y);
            } else if (source == this.haccpButton) {
                PurchaseOrderPositionHACCPLogComplete haccpLog = this.charge.getHaccpLog();
                if (haccpLog == null) {
                    haccpLog = new PurchaseOrderPositionHACCPLogComplete();
                    haccpLog.setTruckType("");
                    haccpLog.setTruckOk(Boolean.valueOf(false));
                    haccpLog.setTemperature(Double.valueOf(-1.0));
                    haccpLog.setQualityCondition(Boolean.valueOf(false));
                    haccpLog.setOkState(Boolean.valueOf(false));
                    haccpLog.setHalalState(this.charge.getBasicArticle().getHalal());
                    haccpLog.setFrozenState(Boolean.valueOf(ArticleToolkit.isFrozenArticle(this.charge.getBasicArticle())));
                    haccpLog.setExpiryDate(this.charge.getExpiryDate());
                    haccpLog.setComment("");
                    haccpLog.setChilledState(Boolean.valueOf(ArticleToolkit.isChilledArticle(this.charge.getBasicArticle())));
                    haccpLog.setChargeNo("");
                    haccpLog.setPurchaseCharge(Boolean.valueOf(Boolean.TRUE.equals(this.charge.getBasicArticle().getPurchaseCharge())));
                    haccpLog.setNoPurchaseChargeText("NC");
                    haccpLog.setCheckDate(new Date(System.currentTimeMillis()));
                    haccpLog.setUser((UserLight)((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentUser());
                }
                InnerPopupFactory.showHACCPLog(false, null, source, this.charge.getBasicArticle(), null, null, x, y, new HACCPCheckPopUpInsert.ParameterObject(haccpLog, (ArticleChargeLight)this.charge), new OPRPCheckPopUpInsert.ParameterObject(haccpLog, (ArticleChargeLight)this.charge), false, null);
            }
        }

        private void changeAmount(int x, int y) {
            Node newAmount = this.model.getNode().getChildNamed(DtoFieldConstants.NEW_AMOUNT);
            QuantityComplete q = new QuantityComplete(Double.valueOf(TransactionToolkit.getLongValue(this.model.getNode().getChildNamed(new DtoField[]{StockTransactionComplete_.amount, StoreQuantityComplete_.amount})).doubleValue()), (UnitComplete)this.model.getNode().getChildNamed(new DtoField[]{StockTransactionComplete_.amount, StoreQuantityComplete_.unit}).getValue());
            if (newAmount == null) {
                StoreQuantityComplete sq = new StoreQuantityComplete(Long.valueOf(q.getQuantity().longValue()), q.getUnit());
                newAmount = INodeCreator.getDefaultImpl().getNode4DTO((Object)sq, false, false);
                newAmount.setName(DtoFieldConstants.NEW_AMOUNT);
                this.model.getNode().addChild(newAmount, 0L);
            }
            if (newAmount != null) {
                newAmount.getChildNamed(StoreQuantityComplete_.amount).setValue((Object)q.getQuantity(), 0L);
                newAmount.getChildNamed(StoreQuantityComplete_.unit).setValue((Object)q.getUnit(), 0L);
            }
            InnerPopUp2 popUp = InnerPopUp2.getInnerPopUp();
            popUp.setAttributes(this.editAmount, true, true, Words.CHANGE_AMOUNT);
            Date date = (Date)this.model.getNode().getParent().getParent().getChildNamed(new DtoField[]{PurchaseOrderPositionComplete_.order, PurchaseOrderComplete_.orderDate}).getValue();
            Timestamp validity = new Timestamp(date.getTime());
            popUp.setView(new OrderAmountChangingPopup(newAmount, this.model.getNode().getChildNamed(StockTransactionComplete_.amount), this.model.getNode().getChildNamed(DtoFieldConstants.CHARGE), validity, null, null, TransactionType.PURCHASE));
            popUp.showPopUp(x, y, 200, -1, this, this.editAmount);
        }

        @Override
        public void popUpClosed(InnerPopUp2 source, Object ... xargs) {
            if (xargs == null) {
                return;
            }
            if (source.getCaller() == this.editAmount) {
                Node newAmount = this.model.getNode().getChildNamed(DtoFieldConstants.NEW_AMOUNT);
                Long a = TransactionToolkit.getLongValue(newAmount.getChildNamed(StoreQuantityComplete_.amount));
                Long b = this.startQuantity.getAmount();
                this.model.getNode().getChildNamed(new DtoField[]{StockTransactionComplete_.amount, StoreQuantityComplete_.amount}).setValue(newAmount.getChildNamed(StoreQuantityComplete_.amount).getValue(), System.currentTimeMillis());
                this.model.getNode().getChildNamed(new DtoField[]{StockTransactionComplete_.amount, StoreQuantityComplete_.unit}).setValue(newAmount.getChildNamed(StoreQuantityComplete_.unit).getValue(), System.currentTimeMillis());
                StoreQuantityComplete qq = (StoreQuantityComplete)this.model.getNode().getChildNamed(StockTransactionComplete_.amount).getValue();
                qq.setAmount(a);
                qq.setUnit((UnitComplete)newAmount.getChildNamed(StoreQuantityComplete_.unit).getValue());
                this.model.getNode().getChildNamed(new DtoField[]{StockTransactionComplete_.amount, StoreQuantityComplete_.amount}).setValue((Object)qq.getAmount(), System.currentTimeMillis());
                this.model.getNode().getChildNamed(new DtoField[]{StockTransactionComplete_.amount, StoreQuantityComplete_.unit}).setValue((Object)qq.getUnit(), System.currentTimeMillis());
                if (a.longValue() != b.longValue()) {
                    this.quantity.setLeftUpperCornerPainting(true, AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("productionplanner_stocksetted_color")));
                } else {
                    this.quantity.setLeftUpperCornerPainting(false, AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("productionplanner_stocksetted_color")));
                }
                this.quantity.updateString();
            }
        }

        private class ReceivingLayout
        extends DefaultLayout {
            private ReceivingLayout() {
            }

            @Override
            public void layoutContainer(Container parent) {
                int w;
                int currentX = w = ReceivingInspectionRow.this.model.getParentModel().getColumnWidth(0);
                w = ReceivingInspectionRow.this.model.getParentModel().getColumnWidth(1);
                currentX += w;
                w = ReceivingInspectionRow.this.model.getParentModel().getColumnWidth(2);
                ReceivingInspectionRow.this.userName.setLocation(currentX + OrderPositionsDetailsPanel.this.table.getCellPadding(), (int)(((double)parent.getHeight() - ReceivingInspectionRow.this.userName.getPreferredSize().getHeight()) / 2.0));
                ReceivingInspectionRow.this.userName.setSize(w - 2 * OrderPositionsDetailsPanel.this.table.getCellPadding(), (int)ReceivingInspectionRow.this.userName.getPreferredSize().getHeight());
                currentX += w;
                w = ReceivingInspectionRow.this.model.getParentModel().getColumnWidth(3);
                if (ReceivingInspectionRow.this.model.getNode().getValue() instanceof PurchaseOrderPositionMutationComplete) {
                    ReceivingInspectionRow.this.quantity.setLocation(currentX + OrderPositionsDetailsPanel.this.table.getCellPadding(), (int)(((double)parent.getHeight() - ReceivingInspectionRow.this.quantity.getPreferredSize().getHeight()) / 2.0));
                    if (ReceivingInspectionRow.this.wasPriceChange) {
                        w += ReceivingInspectionRow.this.model.getParentModel().getColumnWidth(4);
                        w += ReceivingInspectionRow.this.model.getParentModel().getColumnWidth(5);
                        w += ReceivingInspectionRow.this.model.getParentModel().getColumnWidth(6);
                    }
                    ReceivingInspectionRow.this.quantity.setSize(w - 2 * OrderPositionsDetailsPanel.this.table.getCellPadding(), (int)ReceivingInspectionRow.this.quantity.getPreferredSize().getHeight());
                }
                currentX += w;
                w = ReceivingInspectionRow.this.model.getParentModel().getColumnWidth(4);
                if (ReceivingInspectionRow.this.model.getNode().getValue() instanceof PurchaseOrderAcceptationComplete) {
                    int offset = 0;
                    if (ReceivingInspectionRow.this.editAmount != null) {
                        offset = (int)((double)offset + ((double)ReceivingInspectionRow.this.getInnerCellPadding() + ReceivingInspectionRow.this.editAmount.getPreferredSize().getWidth()));
                    }
                    ReceivingInspectionRow.this.quantity.setLocation(currentX + OrderPositionsDetailsPanel.this.table.getCellPadding(), (int)(((double)parent.getHeight() - ReceivingInspectionRow.this.quantity.getPreferredSize().getHeight()) / 2.0));
                    ReceivingInspectionRow.this.quantity.setSize(w - (2 * OrderPositionsDetailsPanel.this.table.getCellPadding() + offset), (int)ReceivingInspectionRow.this.quantity.getPreferredSize().getHeight());
                    if (ReceivingInspectionRow.this.editAmount != null) {
                        ReceivingInspectionRow.this.editAmount.setLocation(ReceivingInspectionRow.this.quantity.getX() + ReceivingInspectionRow.this.quantity.getWidth() + ReceivingInspectionRow.this.getInnerCellPadding(), (int)(((double)parent.getHeight() - ReceivingInspectionRow.this.editAmount.getPreferredSize().getHeight()) / 2.0));
                        ReceivingInspectionRow.this.editAmount.setSize(ReceivingInspectionRow.this.editAmount.getPreferredSize());
                    }
                }
                currentX += w;
                w = ReceivingInspectionRow.this.model.getParentModel().getColumnWidth(5);
                if (ReceivingInspectionRow.this.model.getNode().getValue() instanceof PurchaseOrderRejectionComplete) {
                    ReceivingInspectionRow.this.quantity.setLocation(currentX + OrderPositionsDetailsPanel.this.table.getCellPadding(), (int)(((double)parent.getHeight() - ReceivingInspectionRow.this.quantity.getPreferredSize().getHeight()) / 2.0));
                    ReceivingInspectionRow.this.quantity.setSize(w - 2 * OrderPositionsDetailsPanel.this.table.getCellPadding(), (int)ReceivingInspectionRow.this.quantity.getPreferredSize().getHeight());
                }
                currentX += w;
                w = ReceivingInspectionRow.this.model.getParentModel().getColumnWidth(6);
                if (ReceivingInspectionRow.this.model.getNode().getValue() instanceof PurchaseOrderAcceptationComplete) {
                    ReceivingInspectionRow.this.store.setLocation(currentX + OrderPositionsDetailsPanel.this.table.getCellPadding(), (int)(((double)parent.getHeight() - ReceivingInspectionRow.this.store.getPreferredSize().getHeight()) / 2.0));
                    ReceivingInspectionRow.this.store.setSize(w - 2 * OrderPositionsDetailsPanel.this.table.getCellPadding(), (int)ReceivingInspectionRow.this.store.getPreferredSize().getHeight());
                }
                if (!OrderPositionsDetailsPanel.this.isCheckModule()) {
                    currentX += w;
                    w = ReceivingInspectionRow.this.model.getParentModel().getColumnWidth(7);
                    if (!OrderPositionsDetailsPanel.this.isSolarCompany) {
                        currentX += w;
                        w = ReceivingInspectionRow.this.model.getParentModel().getColumnWidth(8);
                    }
                    int cx = currentX + ReceivingInspectionRow.this.getCellPadding() + EditButton.getPreferredWidth(SizedSkin1Field.SkinSize.SMALL) + ReceivingInspectionRow.this.getInnerCellPadding();
                    if (!OrderPositionsDetailsPanel.this.isSolarCompany) {
                        if (ReceivingInspectionRow.this.docs != null) {
                            ReceivingInspectionRow.this.docs.setLocation(cx, (int)((double)parent.getHeight() - ReceivingInspectionRow.this.docs.getPreferredSize().getHeight()) / 2);
                            ReceivingInspectionRow.this.docs.setSize(ReceivingInspectionRow.this.docs.getPreferredSize());
                            cx = ReceivingInspectionRow.this.docs.getX() + ReceivingInspectionRow.this.docs.getWidth() + ReceivingInspectionRow.this.getInnerCellPadding() + TransportCostsButton.getPreferredWidth(SizedSkin1Field.SkinSize.MEDIUM) + ReceivingInspectionRow.this.getInnerCellPadding();
                        } else {
                            cx += TransportCostsButton.getPreferredWidth(SizedSkin1Field.SkinSize.MEDIUM) + ReceivingInspectionRow.this.getInnerCellPadding() + RemarkButton.getPreferredWidth() + ReceivingInspectionRow.this.getInnerCellPadding();
                        }
                    } else {
                        cx = currentX + ReceivingInspectionRow.this.getCellPadding() + 2;
                    }
                    if (ReceivingInspectionRow.this.haccpButton != null) {
                        ReceivingInspectionRow.this.haccpButton.setLocation(cx, (int)((double)parent.getHeight() - ReceivingInspectionRow.this.haccpButton.getPreferredSize().getHeight()) / 2);
                        ReceivingInspectionRow.this.haccpButton.setSize(ReceivingInspectionRow.this.haccpButton.getPreferredSize());
                        cx = ReceivingInspectionRow.this.haccpButton.getX() + ReceivingInspectionRow.this.haccpButton.getWidth() + ReceivingInspectionRow.this.getInnerCellPadding();
                    }
                    if (ReceivingInspectionRow.this.editTransaction != null) {
                        ReceivingInspectionRow.this.editTransaction.setLocation(cx, (int)((double)parent.getHeight() - ReceivingInspectionRow.this.editTransaction.getPreferredSize().getHeight()) / 2);
                        ReceivingInspectionRow.this.editTransaction.setSize(ReceivingInspectionRow.this.editTransaction.getPreferredSize());
                        cx = ReceivingInspectionRow.this.editTransaction.getX() + ReceivingInspectionRow.this.editTransaction.getWidth() + ReceivingInspectionRow.this.getInnerCellPadding();
                    }
                    if (ReceivingInspectionRow.this.overViewButton != null) {
                        ReceivingInspectionRow.this.overViewButton.setLocation(cx - 2, (int)(((double)parent.getHeight() - ReceivingInspectionRow.this.overViewButton.getPreferredSize().getHeight()) / 2.0));
                        ReceivingInspectionRow.this.overViewButton.setSize(ReceivingInspectionRow.this.overViewButton.getPreferredSize());
                    }
                } else {
                    if (ReceivingInspectionRow.this.editTransaction != null) {
                        ReceivingInspectionRow.this.editTransaction.setLocation((int)((double)(currentX + w) - ((double)ReceivingInspectionRow.this.getCellPadding() + ReceivingInspectionRow.this.editTransaction.getPreferredSize().getWidth())), (int)((double)parent.getHeight() - ReceivingInspectionRow.this.editTransaction.getPreferredSize().getHeight()) / 2);
                        ReceivingInspectionRow.this.editTransaction.setSize(ReceivingInspectionRow.this.editTransaction.getPreferredSize());
                    }
                    if (ReceivingInspectionRow.this.sum != null) {
                        currentX += w;
                        w = ReceivingInspectionRow.this.model.getParentModel().getColumnWidth(7);
                        ReceivingInspectionRow.this.sum.setLocation(currentX + ReceivingInspectionRow.this.getCellPadding(), (int)(((double)parent.getHeight() - ReceivingInspectionRow.this.sum.getPreferredSize().getHeight()) / 2.0));
                        ReceivingInspectionRow.this.sum.setSize(w - 2 * ReceivingInspectionRow.this.getCellPadding(), (int)ReceivingInspectionRow.this.sum.getPreferredSize().getHeight());
                    }
                }
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, ReceivingInspectionRow.this.getDefaultRowHeight());
            }
        }
    }

    private class OrderPositionTableRow
    extends Table2RowPanel
    implements NodeListener,
    ButtonListener,
    InnerPopUpListener2,
    SearchTextField2Listener,
    RemoteLoader {
        private static final long serialVersionUID = 1L;
        private ExpandIcon expandIcon;
        private TextLabel label;
        private Component positionState;
        private Component articleName;
        private QuantityRenderer ordered;
        private EditButton changeOrder;
        private TextLabel received;
        private TextLabel rejected;
        private StockTransactionRemarkButton rec_attention;
        private StockTransactionRemarkButton rej_attention;
        private EditButton editPacking;
        private TextLabel targetStoreAndDepartment;
        private EditButton editTargetStoreAndDepartment;
        private NumberTextField labelCount;
        private AllergenButton allergenButton;
        private HalalButton halalButton;
        private InfoButton infoButton;
        private DeleteButton deleteButton;
        private StockTransactionRemarkButton comment;
        private TextLabel price;
        private TextLabel sum;
        private InfoButton articleInfo;
        private ComboBox state;
        private boolean isClosed;
        private boolean isCancelled;
        private StoreQuantityComplete orderedQuantity;
        private List<PurchaseOrderAcceptationComplete> acceptations;
        private List<StockTransactionRemarkComplete> acceptedRemarks;
        private List<StockTransactionRemarkComplete> rejectedRemarks;
        private BasicArticleComplete artC;
        private boolean isSet;
        private boolean isPositionPlaced;
        private boolean isQuantityChangeble;
        private boolean isCommentable;
        private boolean isAmountChange;
        private CustomsButton customs;
        private TransportCostsButton transportTypes;
        private StoreLight backupPos;
        private InternalCostCenterComplete backupDepartment;
        private CheckBoxRO customerOwned;

        public OrderPositionTableRow(Table2RowModel m) {
            boolean writable;
            Node newAmount;
            super(m);
            this.isClosed = false;
            this.isCancelled = false;
            this.isAmountChange = false;
            this.isClosed = m.getNode().getChildNamed(PurchaseOrderPositionComplete_.state).getValue().equals(OrderStateE.CLOSED);
            this.isCancelled = m.getNode().getChildNamed(PurchaseOrderPositionComplete_.state).getValue().equals(OrderStateE.CANCELLED);
            this.isPositionPlaced = m.getNode().getChildNamed(PurchaseOrderPositionComplete_.state).getValue().equals(OrderStateE.PLACED);
            this.isQuantityChangeble = OrderPositionsDetailsPanel.this.provider.isWritable(PurchaseOrderPositionComplete_.quantity);
            this.artC = (BasicArticleComplete)m.getNode().getChildNamed(PurchaseOrderPositionComplete_.article).getValue(BasicArticleComplete.class);
            this.isCommentable = OrderPositionsDetailsPanel.this.provider.isWritable(PurchaseOrderPositionComplete_.comment);
            this.isSet = this.artC != null;
            if (OrderPositionsDetailsPanel.this.isCheckModule()) {
                if (m.getNode().getChildNamed(PurchaseOrderPositionComplete_.reviewState).getValue() == null) {
                    m.getNode().getChildNamed(PurchaseOrderPositionComplete_.reviewState).setValue((Object)OrderReviewStateE.UNCHECKED, System.currentTimeMillis());
                }
                this.customerOwned = new CheckBoxRO((Node<Boolean>)m.getNode().getChildNamed(new DtoField[]{PurchaseOrderPositionLight_.article, BasicArticleLight_.customerIsOwner}));
                this.price = new TextLabel(null, ConverterRegistry.getConverter(PurchasePriceConverter.class));
                this.state = new ComboBox(m.getNode().getChildNamed(PurchaseOrderPositionComplete_.reviewState), NodeToolkit.getAffixList(OrderReviewStateE.class), ConverterRegistry.getConverter(OrderReviewStateConverter.class));
                this.articleInfo = new InfoButton();
                this.sum = new TextLabel(m.getNode(), ConverterRegistry.getConverter(PurchaseOrderReviewPositionSumConverter.class));
            }
            this.acceptedRemarks = new ArrayList<StockTransactionRemarkComplete>();
            this.rejectedRemarks = new ArrayList<StockTransactionRemarkComplete>();
            this.acceptations = new ArrayList<PurchaseOrderAcceptationComplete>();
            if (!OrderPositionsDetailsPanel.this.isCheckModule()) {
                this.comment = new StockTransactionRemarkButton(false, null);
                this.comment.addButtonListener(this);
                this.comment.setToolTipText(Words.SHOW_COMMENT);
                if (!OrderPositionsDetailsPanel.this.isSolarCompany) {
                    this.labelCount = new NumberTextField(m.getNode().getChildNamed(PurchaseOrderPositionComplete_.articleLabelCount), TextFieldType.INT_NULLABLE);
                }
                this.targetStoreAndDepartment = new TextLabel(m.getNode(), ConverterRegistry.getConverter(PurchasePositionStoreAndDepartmentConverter.class));
                this.editTargetStoreAndDepartment = new EditButton();
                this.editTargetStoreAndDepartment.addButtonListener((source, x, y) -> this.showTargetStoreAndDepartmentPopup(source, x, y));
            }
            this.setLayoutInnerChildsSelf(true);
            this.setExpanded(false);
            if (this.isSet) {
                ViewNode receivedView = new ViewNode("AcceptedView");
                receivedView.setChangeHandler((ViewNodeDataChangeHandler)new ViewNodeDataChangeHandler<QuantityComplete>(){

                    public QuantityComplete calculateNewValue(ViewNode node) {
                        Node q;
                        UnitComplete u = OrderPositionsDetailsPanel.this.isCheckModule() ? OrderPositionTableRow.this.artC.getMainStoreUnit() : (UnitComplete)OrderPositionTableRow.this.model.getNode().getChildNamed(new DtoField[]{PurchaseOrderPositionComplete_.article, BasicArticleLight_.mainStoreUnit}).getValue();
                        Date date = (Date)OrderPositionsDetailsPanel.this.editor.getModel().getNode().getChildNamed(PurchaseOrderComplete_.orderDate).getValue();
                        Iterator it = node.getAllChildsNamed(StoreQuantityComplete_.amount.getFieldName());
                        double amount = 0.0;
                        while (it.hasNext()) {
                            q = (Node)it.next();
                            double nd = UnitConversionToolkit.convertUnit((UnitComplete)((StoreQuantityComplete)q.getValue()).getUnit(), (UnitComplete)u, (double)((StoreQuantityComplete)q.getValue()).getAmount().longValue(), (BasicArticleLight)OrderPositionTableRow.this.artC, (Timestamp)new Timestamp(date.getTime()));
                            amount += nd;
                        }
                        q = new QuantityComplete();
                        q.setQuantity(Double.valueOf(amount));
                        q.setUnit(u);
                        return q;
                    }
                });
                ViewNode rejectedView = new ViewNode("RejectedView");
                rejectedView.setChangeHandler((ViewNodeDataChangeHandler)new ViewNodeDataChangeHandler<QuantityComplete>(){

                    public QuantityComplete calculateNewValue(ViewNode node) {
                        Node q;
                        UnitComplete u = null;
                        u = OrderPositionsDetailsPanel.this.isCheckModule() ? OrderPositionTableRow.this.artC.getMainStoreUnit() : (UnitComplete)OrderPositionTableRow.this.model.getNode().getChildNamed(PurchaseOrderPositionComplete_.priceUnit).getValue();
                        Date date = (Date)OrderPositionsDetailsPanel.this.editor.getModel().getNode().getChildNamed(PurchaseOrderComplete_.orderDate).getValue();
                        Iterator it = node.getAllChildsNamed(StoreQuantityComplete_.amount.getFieldName());
                        double amount = 0.0;
                        while (it.hasNext()) {
                            q = (Node)it.next();
                            double nd = UnitConversionToolkit.convertUnit((UnitComplete)((StoreQuantityComplete)q.getValue()).getUnit(), (UnitComplete)u, (double)((StoreQuantityComplete)q.getValue()).getAmount().longValue(), (BasicArticleLight)OrderPositionTableRow.this.artC, (Timestamp)new Timestamp(date.getTime()));
                            amount += nd;
                        }
                        q = new QuantityComplete();
                        q.setQuantity(Double.valueOf(amount));
                        q.setUnit(u);
                        return q;
                    }
                });
                receivedView.updateValue();
                rejectedView.updateValue();
                this.received = new QuantityRenderer((Node<?>)receivedView);
                this.rejected = new QuantityRenderer((Node<?>)rejectedView);
            } else {
                this.received = new TextLabel();
                this.rejected = new TextLabel();
            }
            if (m.getNode().getChildNamed(PurchaseOrderPositionComplete_.sequenceNumber).getValue() == null) {
                int i = m.getNode().getParent().getChildIndex(m.getNode());
                m.getNode().getChildNamed(PurchaseOrderPositionComplete_.sequenceNumber).setValue((Object)i, System.currentTimeMillis());
            }
            this.label = new TextLabel(m.getNode().getChildNamed(PurchaseOrderPositionComplete_.sequenceNumber), ConverterRegistry.getConverter(IntegerPlusPlusConverter.class));
            if (this.isPositionPlaced && !OrderPositionsDetailsPanel.this.isCheckModule() & OrderPositionsDetailsPanel.this.isDeletable) {
                this.deleteButton = new DeleteButton();
                this.deleteButton.addButtonListener(this);
            }
            this.expandIcon = new ExpandIcon();
            if (this.isSet) {
                this.articleName = new TextLabel(m.getNode(), ConverterRegistry.getConverter(PositionNameConverter.class));
            } else {
                SearchTextField2<BasicArticleLight> t = SearchTextField2Factory.getBasicArticleSearchField(false, m.getNode().getChildNamed(PurchaseOrderPositionComplete_.article));
                Object[] o = new Object[8];
                o[0] = ((PurchaseOrderComplete)OrderPositionsDetailsPanel.this.editor.getModel().getNode().getValue(PurchaseOrderComplete.class)).getSupplier();
                o[1] = OrderPositionsDetailsPanel.this.editor.getModel().getNode().getChildNamed(PurchaseOrderLight_.customerOwnedOnly).getValue();
                o[7] = OrderPositionsDetailsPanel.this.editor.getModel().getNode().getChildNamed(PurchaseOrderLight_.halalOrder).getValue();
                t.setAdditionalSearchField(o);
                t.addSearchTextFieldListener(this);
                this.articleName = t;
            }
            if (this.isSet && (newAmount = this.model.getNode().getChildNamed(DtoFieldConstants.NEW_AMOUNT)) == null) {
                newAmount = new EmbeddedDTONode();
                newAmount.setName(DtoFieldConstants.NEW_AMOUNT);
                StoreQuantityComplete q = new StoreQuantityComplete();
                q.setAmount(TransactionToolkit.getLongValue(this.model.getNode().getChildNamed(new DtoField[]{PurchaseOrderPositionComplete_.quantity, StoreQuantityComplete_.amount})));
                q.setUnit((UnitComplete)this.model.getNode().getChildNamed(new DtoField[]{PurchaseOrderPositionComplete_.quantity, StoreQuantityComplete_.unit}).getValue());
                newAmount.setValue((Object)q, 0L);
                this.model.getNode().addChild(newAmount, 0L);
            }
            this.orderedQuantity = (StoreQuantityComplete)m.getNode().getChildNamed(PurchaseOrderPositionComplete_.quantity).getValue();
            ViewNode v = new ViewNode("");
            if (this.artC != null) {
                UnitComplete targetUnit = this.artC.getMainStoreUnit();
                Date date = (Date)OrderPositionsDetailsPanel.this.editor.getModel().getNode().getChildNamed(PurchaseOrderComplete_.orderDate).getValue();
                double nd = UnitConversionToolkit.convertUnit((UnitComplete)this.orderedQuantity.getUnit(), (UnitComplete)targetUnit, (double)this.orderedQuantity.getAmount().longValue(), (BasicArticleLight)this.artC, (Timestamp)new Timestamp(date.getTime()));
                QuantityComplete q = new QuantityComplete();
                q.setQuantity(Double.valueOf(nd));
                q.setUnit(targetUnit);
                v.setValue((Object)q, 0L);
            }
            this.ordered = new QuantityRenderer((Node<?>)v);
            if (!this.isConversionValid()) {
                this.ordered.setInvalid();
            }
            if (!OrderPositionsDetailsPanel.this.isCheckModule()) {
                this.changeOrder = new EditButton();
                this.changeOrder.setEnabled(!this.isClosed & this.isQuantityChangeble && !this.isCancelled);
                this.changeOrder.addButtonListener(this);
            }
            this.rec_attention = new StockTransactionRemarkButton<OrderPositionReceivingRemarkComplete>(false, OrderPositionReceivingRemarkComplete.class);
            this.rej_attention = new StockTransactionRemarkButton(false, null);
            if (!OrderPositionsDetailsPanel.this.isCheckModule()) {
                this.infoButton = new InfoButton(Words.POSITION_INFO);
            }
            Node transactions = m.getNode().getChildNamed(PurchaseOrderPositionComplete_.transactions);
            this.expandIcon.addButtonListener(this);
            this.expandIcon.setEnabled(transactions.getChildCount() > 0);
            this.setLayout(new Layout());
            transactions.addNodeListener((NodeListener)this);
            transactions.getAllChildAddEventsFor((NodeListener)this, new String[0]);
            Object[] o1 = this.createInsert(this.acceptedRemarks);
            Object[] o2 = this.createInsert(this.rejectedRemarks);
            IPopUpInsert ai = (IPopUpInsert)o1[0];
            IPopUpInsert ri = (IPopUpInsert)o2[0];
            this.rec_attention.setPopUpView(ai);
            this.rej_attention.setPopUpView(ri);
            if (((Boolean)o1[1]).booleanValue()) {
                this.rec_attention.setChoosen(true);
            }
            if (((Boolean)o2[1]).booleanValue()) {
                this.rej_attention.setChoosen(true);
            }
            this.rec_attention.addButtonListener(this);
            this.rej_attention.addButtonListener(this);
            if (this.infoButton != null) {
                this.infoButton.installStringViewer(OrderToolkit.createInfoInsert(this.acceptations, (PurchaseOrderComplete)OrderPositionsDetailsPanel.this.editor.getModel().getNode().getValue(PurchaseOrderComplete.class), this.model));
            }
            if (OrderPositionsDetailsPanel.this.isCheckModule()) {
                this.positionState = new CellViewOrderReviewStateRenderer((OrderReviewStateE)m.getNode().getChildNamed(PurchaseOrderPositionComplete_.reviewState).getValue());
                this.articleInfo.installStringViewer(OrderToolkit.createInfoInsert(this.acceptations, (PurchaseOrderComplete)OrderPositionsDetailsPanel.this.editor.getModel().getNode().getValue(PurchaseOrderComplete.class), this.model, true));
            } else {
                this.positionState = new CellViewOrderStateRenderer((OrderStateE)m.getNode().getChildNamed(PurchaseOrderPositionComplete_.state).getValue());
            }
            this.setEnabled(this.isSet);
            this.articleName.setEnabled(true);
            if (this.isPositionPlaced && !OrderPositionsDetailsPanel.this.isCheckModule() && this.deleteButton != null) {
                this.deleteButton.setEnabled(true);
            }
            if (!OrderPositionsDetailsPanel.this.isSolarCompany) {
                this.customs = new CustomsButton();
                this.customs.setToolTipText(Words.CUSTOMS_DOCUMENTS);
                this.customs.addButtonListener(this);
                this.transportTypes = new TransportCostsButton();
                this.transportTypes.setToolTipText(Words.TRANSPORT_COSTS);
                this.transportTypes.addButtonListener(this);
            }
            if (OrderPositionsDetailsPanel.this.canChangeSupplierCondition()) {
                this.editPacking = new EditButton();
                this.editPacking.addButtonListener((source, x, y) -> this.showPackingTable(x, y));
            }
            if (Boolean.TRUE.equals(OrderPositionsDetailsPanel.this.settings.getUseAllergenCheckForPurchaseOrders()) && !OrderPositionsDetailsPanel.this.isCheckModule() && (writable = OrderPositionsDetailsPanel.this.provider.isWritable(PurchaseOrderAccess.ALLERGEN_SPOT_CHECK))) {
                this.allergenButton = new AllergenButton();
                this.allergenButton.addButtonListener(this);
            }
            if (Boolean.TRUE.equals(OrderPositionsDetailsPanel.this.settings.getUseHalalSpotCheck()) && !OrderPositionsDetailsPanel.this.isCheckModule() && (writable = OrderPositionsDetailsPanel.this.provider.isWritable(PurchaseOrderAccess.HALAL_CHECK))) {
                this.halalButton = new HalalButton();
                this.halalButton.addButtonListener(this);
            }
            this.ensureCommentState();
            this.add(this.label);
            this.add(this.expandIcon);
            this.add(this.positionState);
            this.add(this.articleName);
            this.add(this.ordered);
            this.add(this.received);
            this.add(this.rejected);
            this.add(this.rec_attention);
            this.add(this.rej_attention);
            if (OrderPositionsDetailsPanel.this.isCheckModule()) {
                this.add(this.customerOwned);
                this.add(this.price);
                this.add(this.sum);
                this.add(this.state);
                this.add(this.articleInfo);
            } else {
                this.add(this.comment);
                this.add(this.infoButton);
                this.add(this.changeOrder);
                if (this.labelCount != null) {
                    this.add(this.labelCount);
                }
                this.add(this.targetStoreAndDepartment);
                this.add(this.editTargetStoreAndDepartment);
            }
            if (this.deleteButton != null) {
                this.add(this.deleteButton);
            }
            if (!OrderPositionsDetailsPanel.this.isSolarCompany) {
                this.add(this.customs);
                this.add(this.transportTypes);
            }
            if (OrderPositionsDetailsPanel.this.canChangeSupplierCondition()) {
                this.add(this.editPacking);
            }
            if (this.allergenButton != null) {
                this.add(this.allergenButton);
            }
            if (this.halalButton != null) {
                this.add(this.halalButton);
            }
        }

        private void showTargetStoreAndDepartmentPopup(Button source, int x, int y) {
            this.backupPos = (StoreLight)this.model.getNode().getChildNamed(PurchaseOrderPositionComplete_.targetStore).getValue(StoreLight.class);
            this.backupDepartment = (InternalCostCenterComplete)this.model.getNode().getChildNamed(PurchaseOrderPositionComplete_.department).getValue();
            InnerPopupFactory.showStoreChangePopup(x, y, (Node<StoreLight>)this.model.getNode().getChildNamed(PurchaseOrderPositionComplete_.targetStore), (Node<InternalCostCenterComplete>)this.model.getNode().getChildNamed(PurchaseOrderPositionComplete_.department), (Node<Boolean>)this.model.getNode().getChildNamed(PurchaseOrderPositionComplete_.useCommentAsName), (Node<String>)this.model.getNode().getChildNamed(PurchaseOrderPositionComplete_.comment), this.editTargetStoreAndDepartment, (source1, xargs) -> {
                if (xargs == null) {
                    if (this.model.getNode() != null && this.model.getNode().getChildNamed(PurchaseOrderPositionComplete_.targetStore) != null) {
                        this.model.getNode().getChildNamed(PurchaseOrderPositionComplete_.targetStore).setValue((Object)this.backupPos, System.currentTimeMillis());
                    }
                    if (this.model.getNode() != null && this.model.getNode().getChildNamed(PurchaseOrderPositionComplete_.department) != null) {
                        this.model.getNode().getChildNamed(PurchaseOrderPositionComplete_.department).setValue((Object)this.backupDepartment, System.currentTimeMillis());
                    }
                }
                if (this.articleName instanceof TextLabel) {
                    ((TextLabel)this.articleName).updateString();
                }
            });
        }

        private void showPackingTable(int x, int y) {
            SupplierLight supplier = (SupplierLight)OrderPositionsDetailsPanel.this.editor.getModel().getNode().getChildNamed(PurchaseOrderComplete_.supplier).getValue();
            Date date = (Date)OrderPositionsDetailsPanel.this.editor.getModel().getNode().getChildNamed(PurchaseOrderComplete_.orderDate).getValue();
            InnerPopupFactory.showPackingTableWithSupplierCondition(x, y, this, (source, xargs) -> this.conditionPopupClosed(xargs), supplier, date, (Node<PurchaseOrderPositionComplete>)this.model.getNode(), OrderPositionsDetailsPanel.this.provider, false);
        }

        private void conditionPopupClosed(Object[] xargs) {
            if (xargs != null) {
                boolean isPlaced;
                boolean bl = isPlaced = this.model.getNode().getChildNamed(PurchaseOrderPositionComplete_.state).getValue() == OrderStateE.PLACED;
                if (isPlaced) {
                    SupplierConditionComplete condition = (SupplierConditionComplete)xargs[0];
                    SupplierConditionComplete currentCondition = (SupplierConditionComplete)this.model.getNode().getChildNamed(PurchaseOrderPositionComplete_.supplierCondition).getValue();
                    if (!currentCondition.equals((Object)condition)) {
                        SupplierConditionComplete copiedCondition = ch.icit.pegasus.client.util.toolkits.copy.CopyTemplateToolkit.copySupplierCondition(condition);
                        SupplierConditionComplete oldCondition = (SupplierConditionComplete)this.model.getNode().getChildNamed(PurchaseOrderPositionComplete_.supplierCondition).getValue();
                        this.model.getNode().getChildNamed(PurchaseOrderPositionComplete_.supplierCondition).setValue((Object)copiedCondition, 0L);
                        this.model.getNode().getChildNamed(PurchaseOrderPositionComplete_.supplierCondition).updateNode();
                    }
                }
            }
        }

        public List<ScreenValidationObject> validateRow(Date deliveryDate, Boolean useTaxZone, TaxZoneComplete taxZone) {
            ArrayList<ScreenValidationObject> validationObjects = new ArrayList<ScreenValidationObject>();
            if (this.model.getNode().getChildNamed(PurchaseOrderPositionComplete_.article).getValue() == null) {
                if (this.articleName instanceof SearchTextField2) {
                    ((SearchTextField2)this.articleName).setInvalid();
                }
                validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_ARTICLE_IS_SET));
                return validationObjects;
            }
            if (this.model.getNode().getChildNamed(PurchaseOrderPositionComplete_.id).getValue() == null) {
                SupplierLight supplier;
                Date date = (Date)OrderPositionsDetailsPanel.this.editor.getModel().getNode().getChildNamed(PurchaseOrderLight_.orderDate).getValue();
                Timestamp validity = new Timestamp(date.getTime());
                SupplierLight injectedSupplier = (SupplierLight)OrderPositionsDetailsPanel.this.editor.getModel().getNode().getChildNamed(PurchaseOrderComplete_.supplier).getValue();
                Date d = OrderToolkit.getMinDeliveryDate(this.artC, (SupplierReference)injectedSupplier, useTaxZone, taxZone, validity);
                Date d2 = OrderToolkit.shiftDeliveryDate2MidNight(deliveryDate);
                if (d2.getTime() < d.getTime()) {
                    validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.WARNING, Phrase.getPhrase((String)Phrase.DELIVERY_TIME_MUST_BE_GREATER, (Object[])new Object[]{((BasicArticleConverter)ConverterRegistry.getConverter(BasicArticleConverter.class)).convert((BasicArticleLight)this.artC, null, new Object[0])})));
                }
                UnitComplete u = (UnitComplete)this.model.getNode().getChildNamed(new DtoField[]{PurchaseOrderPositionComplete_.quantity, StoreQuantityComplete_.unit}).getValue();
                SupplierConditionComplete conditionComplete = (SupplierConditionComplete)this.model.getNode().getChildNamed(PurchaseOrderPositionComplete_.supplierCondition).getValue();
                if (conditionComplete != null) {
                    double minOAmount = conditionComplete.getMinOrderAmount() != null ? conditionComplete.getMinOrderAmount() : 0.0;
                    Boolean minOAmountMandatory = conditionComplete.getMinOrderAmountIsMandatory();
                    if (minOAmount >= 0.0) {
                        long a = TransactionToolkit.getLongValue(this.model.getNode().getChildNamed(new DtoField[]{PurchaseOrderPositionComplete_.quantity, StoreQuantityComplete_.amount}));
                        UnitComplete unit = conditionComplete.getMinOrderAmountUnit() != null ? conditionComplete.getMinOrderAmountUnit() : conditionComplete.getOrderUnit();
                        long dd = (long)UnitConversionToolkit.convertUnit((UnitComplete)u, (UnitComplete)unit, (double)a, (BasicArticleLight)this.artC, (Timestamp)validity);
                        if (dd != 0L && (double)dd % minOAmount != 0.0) {
                            ScreenValidationObject.ValidationStateE state = Boolean.TRUE.equals(minOAmountMandatory) ? ScreenValidationObject.ValidationStateE.FATAL : ScreenValidationObject.ValidationStateE.WARNING;
                            validationObjects.add(new ScreenValidationObject(state, Phrase.getPhrase((String)Phrase.QUANTITY_OF_ARTICLE_NOT_IN_INTERVAL, (Object[])new Object[]{((BasicArticleConverter)ConverterRegistry.getConverter(BasicArticleConverter.class)).convert((BasicArticleLight)this.artC, null, new Object[0])})));
                        }
                    }
                }
                int i = UnitConversionToolkit.isUnitContaining((UnitComplete)u, (UnitComplete)this.artC.getMainStoreUnit(), (BasicArticleLight)this.artC, (Timestamp)validity);
                switch (i) {
                    case 3: 
                    case 5: {
                        break;
                    }
                    case 11: {
                        validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Phrase.getPhrase((String)Phrase.SELECTED_UNIT_IS_NOT_CONVERTIBLE, (Object[])new Object[]{u, this.artC.getNumber(), this.artC.getName()})));
                    }
                }
                boolean foundSupplier = false;
                for (SupplierConditionBaseComplete base : this.artC.getSuppliers()) {
                    if (!base.getSupplier().equals((Object)injectedSupplier)) continue;
                    foundSupplier = true;
                }
                if (!foundSupplier || conditionComplete == null) {
                    validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Phrase.getPhrase((String)Phrase.ARTICLE_IS_NOT_DELIVERED_BY, (Object[])new Object[]{injectedSupplier.getName(), this.artC.getNumber(), this.artC.getName()})));
                } else if (Boolean.TRUE.equals(OrderPositionsDetailsPanel.this.settings.getAllowPurchaseOrderSupplierBondedRestriction()) && (supplier = conditionComplete.getSupplier()).getBondedState() != null) {
                    switch (supplier.getBondedState()) {
                        case ALL: {
                            break;
                        }
                        case NOT_BONDED: {
                            if (!Boolean.TRUE.equals(this.artC.getBonded())) break;
                            validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Article " + this.artC.getNumber() + " - " + this.artC.getName() + " is bonded but Supplier " + injectedSupplier.getName() + " can only deliver not bonded articles"));
                            break;
                        }
                        case ONLY_BONDED: {
                            if (!Boolean.FALSE.equals(this.artC.getBonded())) break;
                            validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Article " + this.artC.getNumber() + " - " + this.artC.getName() + " is not bonded but Supplier " + injectedSupplier.getName() + " can only deliver bonded articles"));
                        }
                    }
                }
            }
            boolean foundErrorDoc = false;
            Iterator it = this.model.getNode().getChildNamed(PurchaseOrderPositionComplete_.transactions).getFailSafeChildIterator();
            while (it.hasNext()) {
                Node n = (Node)it.next();
                if (!(n.getValue() instanceof PurchaseOrderAcceptationComplete)) continue;
                Iterator docs = n.getChildNamed(PurchaseOrderAcceptationComplete_.customsDocs).getFailSafeChildIterator();
                while (docs.hasNext()) {
                    Node doc = (Node)docs.next();
                    String value = (String)doc.getChildNamed(CustomsDocumentComplete_.customsDocumentId).getValue();
                    if (value == null || value.isEmpty()) {
                        foundErrorDoc = true;
                        continue;
                    }
                    try {
                        Integer integer = Integer.valueOf(value);
                        if (integer != 0) continue;
                        foundErrorDoc = true;
                    }
                    catch (Exception exception) {}
                }
            }
            if (foundErrorDoc) {
                String t = Words.ENSURE_CUSTOMS_DOCS_ID_IS_SET;
                t = t + " " + Words.FOR_POSITION + " ";
                BasicArticleLight artL = (BasicArticleLight)this.model.getNode().getChildNamed(PurchaseOrderPositionComplete_.article).getValue();
                t = t + artL.getNumber() + " - " + artL.getName();
                validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, t));
            }
            return validationObjects;
        }

        public void checkUnchecked() {
            if (OrderPositionsDetailsPanel.this.isCheckModule() && this.model.getNode().getChildNamed(PurchaseOrderPositionComplete_.reviewState).getValue().equals(OrderReviewStateE.UNCHECKED)) {
                this.model.getNode().getChildNamed(PurchaseOrderPositionComplete_.reviewState).setValue((Object)OrderReviewStateE.APPROVED, System.currentTimeMillis());
            }
        }

        @Override
        public Object getObject4Column(int column) {
            switch (column) {
                case 0: {
                    return this.label.getNode().getValue();
                }
                case 1: {
                    return this.positionState.toString();
                }
                case 2: {
                    if (this.articleName instanceof TextLabel) {
                        return ((TextLabel)this.articleName).getText();
                    }
                    return ((SearchTextField2)this.articleName).getText();
                }
                case 3: {
                    return this.ordered.getText();
                }
                case 4: {
                    return this.received.getText();
                }
            }
            return null;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            boolean ec;
            boolean hasTransaction;
            boolean placed;
            boolean bl = placed = this.model.getNode().getChildNamed(PurchaseOrderPositionComplete_.state).getValue() == OrderStateE.PLACED;
            if (this.model.getNode().getChildNamed(PurchaseOrderPositionComplete_.reviewState).getValue() == null) {
                this.model.getNode().getChildNamed(PurchaseOrderPositionComplete_.reviewState).setValue((Object)OrderReviewStateE.UNCHECKED, 0L);
            }
            boolean isSet = this.model.getNode().getChildNamed(PurchaseOrderPositionComplete_.article).getValue(BasicArticleComplete.class) != null;
            boolean isRowApproved = this.model.getNode().getChildNamed(PurchaseOrderPositionComplete_.reviewState).getValue() == OrderReviewStateE.APPROVED;
            boolean bl2 = hasTransaction = this.model.getNode().getChildNamed(PurchaseOrderPositionComplete_.transactions).getChildCount() > 0;
            if (this.expandIcon == null) {
                return;
            }
            this.expandIcon.setEnabled(isEnabled && hasTransaction);
            this.articleName.setEnabled(isEnabled);
            this.ordered.setEnabled(isEnabled);
            if (this.changeOrder != null) {
                this.changeOrder.setEnabled(isEnabled && (!this.isClosed || this.isAmountChange) && this.isQuantityChangeble && isSet && !this.isCancelled);
            }
            this.received.setEnabled(isEnabled);
            this.rejected.setEnabled(isEnabled);
            if (this.infoButton != null) {
                this.infoButton.setEnabled(isEnabled && isSet);
            }
            this.positionState.setEnabled(isEnabled);
            this.label.setEnabled(isEnabled);
            this.rec_attention.setEnabled(isEnabled && isSet);
            this.rej_attention.setEnabled(isEnabled && isSet);
            if (this.targetStoreAndDepartment != null) {
                this.targetStoreAndDepartment.setEnabled(isEnabled && isSet);
            }
            if (this.editTargetStoreAndDepartment != null) {
                this.editTargetStoreAndDepartment.setEnabled(isEnabled && isSet);
            }
            if (OrderPositionsDetailsPanel.this.isCheckModule()) {
                this.customerOwned.setEnabled(isEnabled);
                this.price.setEnabled(isEnabled);
                this.sum.setEnabled(isEnabled);
                this.state.setEnabled(isEnabled && OrderPositionsDetailsPanel.this.isStateEditable && (!isRowApproved || OrderPositionsDetailsPanel.this.isEditPreviewState));
                this.articleInfo.setEnabled(isEnabled);
            } else if (this.labelCount != null) {
                this.labelCount.setEnabled(isEnabled);
            }
            if (this.comment != null) {
                this.comment.setEnabled(isEnabled && isSet);
            }
            if (this.deleteButton != null) {
                this.deleteButton.setEnabled(isEnabled);
            }
            if (this.customs != null) {
                ec = OrderPositionsDetailsPanel.this.provider.isWritable(PurchaseOrderComplete_.customsDocuments);
                this.customs.setEnabled(isEnabled && ec);
            }
            if (this.transportTypes != null) {
                ec = OrderPositionsDetailsPanel.this.provider.isWritable(PurchaseOrderComplete_.transportCosts);
                this.transportTypes.setEnabled(isEnabled && ec);
            }
            if (this.editPacking != null) {
                this.editPacking.setEnabled(isEnabled && this.isPositionPlaced && isSet);
            }
            if (this.allergenButton != null) {
                this.allergenButton.setEnabled(isEnabled);
            }
            if (this.halalButton != null) {
                this.halalButton.setEnabled(isEnabled);
            }
        }

        private boolean isConversionValid() {
            return Boolean.TRUE.equals(this.model.getNode().getChildNamed(PurchaseOrderPositionComplete_.orderUnitConversionValidity).getValue());
        }

        @Override
        public List<Component> getFocusComponents() {
            return null;
        }

        @Override
        public void kill() {
            Node childNamed;
            if (this.isKilled()) {
                return;
            }
            super.kill();
            if (this.model != null && this.model.getNode() != null && (childNamed = this.model.getNode().getChildNamed(PurchaseOrderPositionComplete_.transactions)) != null) {
                childNamed.removeNodeListener((NodeListener)this);
            }
            this.label.kill();
            this.expandIcon.kill();
            if (this.articleName instanceof Killable) {
                ((Killable)((Object)this.articleName)).kill();
            }
            if (OrderPositionsDetailsPanel.this.isCheckModule()) {
                this.customerOwned.kill();
                this.price.kill();
                this.state.kill();
                this.articleInfo.kill();
                this.sum.kill();
            } else {
                if (this.labelCount != null) {
                    this.labelCount.kill();
                }
                this.labelCount = null;
                if (this.targetStoreAndDepartment != null) {
                    this.targetStoreAndDepartment.kill();
                }
                if (this.editTargetStoreAndDepartment != null) {
                    this.editTargetStoreAndDepartment.kill();
                }
            }
            if (!OrderPositionsDetailsPanel.this.isSolarCompany) {
                this.customs.kill();
                this.transportTypes.kill();
            }
            this.ordered.kill();
            if (this.changeOrder != null) {
                this.changeOrder.kill();
            }
            if (this.comment != null) {
                this.comment.kill();
            }
            this.received.kill();
            this.rejected.kill();
            if (this.infoButton != null) {
                this.infoButton.kill();
            }
            if (this.positionState instanceof Killable) {
                ((Killable)((Object)this.positionState)).kill();
            }
            this.rej_attention.kill();
            this.rec_attention.kill();
            if (this.deleteButton != null) {
                this.deleteButton.kill();
            }
            if (OrderPositionsDetailsPanel.this.canChangeSupplierCondition()) {
                this.editPacking.kill();
            }
            if (this.allergenButton != null) {
                this.allergenButton.kill();
            }
            if (this.halalButton != null) {
                this.halalButton.kill();
            }
            this.customerOwned = null;
            this.halalButton = null;
            this.allergenButton = null;
            this.label = null;
            this.comment = null;
            this.expandIcon = null;
            this.articleName = null;
            this.ordered = null;
            this.changeOrder = null;
            this.received = null;
            this.rejected = null;
            this.infoButton = null;
            this.positionState = null;
            this.rej_attention = null;
            this.rec_attention = null;
            this.deleteButton = null;
            this.price = null;
            this.state = null;
            this.articleInfo = null;
            this.sum = null;
            this.customs = null;
            this.transportTypes = null;
            this.editPacking = null;
            this.targetStoreAndDepartment = null;
            this.editTargetStoreAndDepartment = null;
        }

        private Object[] createInsert(List<StockTransactionRemarkComplete> remarks) {
            ArrayList<String> strings = new ArrayList<String>();
            for (StockTransactionRemarkComplete r : remarks) {
                if (strings.contains(r.getDescription())) continue;
                strings.add(r.getDescription());
            }
            boolean isChoosen = true;
            if (strings.size() == 0) {
                isChoosen = false;
                strings.add(Words.NO_REMARK);
            }
            Object[] o = new Object[]{new TextListPopUpInsert(strings), isChoosen};
            return o;
        }

        public void childAdded(Node<?> source, Node<?> child) {
            if (source.getName().equals(PurchaseOrderPositionComplete_.transactions.getFieldName())) {
                Node nq = child.getChildNamed(StockTransactionComplete_.amount);
                if (child.getValue() instanceof PurchaseOrderAcceptationComplete) {
                    if (this.price != null) {
                        this.price.setNode((Node)child);
                    }
                    this.received.getNode().addChild(nq, 0L);
                    ((ViewNode)this.received.getNode()).updateValue();
                    this.received.updateString();
                    Node remark = child.getChildNamed(PurchaseOrderAcceptationComplete_.remark);
                    if (remark.getValue() != null) {
                        this.acceptedRemarks.add((StockTransactionRemarkComplete)remark.getValue());
                    }
                    this.acceptations.add((PurchaseOrderAcceptationComplete)child.getValue());
                } else if (child.getValue() instanceof PurchaseOrderRejectionComplete) {
                    this.rejected.getNode().addChild(nq, 0L);
                    ((ViewNode)this.rejected.getNode()).updateValue();
                    this.rejected.updateString();
                    Node remark = child.getChildNamed(PurchaseOrderAcceptationComplete_.remark);
                    if (remark.getValue() != null) {
                        this.rejectedRemarks.add((StockTransactionRemarkComplete)remark.getValue());
                    }
                }
                this.addRow(child);
            }
        }

        public void childRemoved(Node<?> source, Node<?> child) {
        }

        public void valueChanged(Node<?> node) {
        }

        @Override
        public void buttonPressed(Button source, int x, int y) {
            if (source == this.expandIcon) {
                this.setExpanded(!this.isExpanded(), true);
                OrderPositionsDetailsPanel.this.editor.validate();
            } else if (source == this.rec_attention || source == this.rej_attention) {
                InnerPopUp2 popUp = InnerPopUp2.getInnerPopUp();
                popUp.setAttributes(null, false, false, Words.REMARKS);
                StockTransactionRemarkButton b = (StockTransactionRemarkButton)source;
                popUp.setView(b.getPopUpView());
                popUp.showPopUp(x, y, 150, -1, null, b);
            } else if (source == this.changeOrder) {
                this.changeAmount(x, y);
            } else if (source == this.deleteButton) {
                this.getModel().getNode().getParent().removeChild(this.getModel().getNode(), System.currentTimeMillis());
            } else if (source == this.comment) {
                if (this.isPositionPlaced && this.isCommentable) {
                    InnerPopupFactory.showEnterMessagePopup(Words.ENTER_COMMENT, this, this.comment, this.model.getNode().getChildNamed(PurchaseOrderPositionComplete_.comment), x, y);
                } else {
                    InnerPopUp2 popUp = InnerPopUp2.getInnerPopUp();
                    popUp.setAttributes(source, false, false, Words.COMMENT);
                    popUp.hideCancelButton();
                    popUp.hideOkButton();
                    popUp.setView(new StringPopUpInsert((String)this.model.getNode().getChildNamed(PurchaseOrderPositionComplete_.comment).getValue()));
                    popUp.showPopUp(x, y, 200, 50, null, source);
                }
            } else if (source == this.customs) {
                InnerPopupFactory.showCustomsDocumentsEditPopup(source, this.getModel().getNode().getChildNamed(PurchaseOrderPositionComplete_.customsDocuments), OrderPositionsDetailsPanel.this.provider, false, x, y, PurchaseOrderPositionComplete_.customsDocuments.getFieldName(), Words.ASSOCIATED_DOCUMENTS);
            } else if (source == this.transportTypes) {
                InnerPopupFactory.showTransportCostsEditPopup(source, this.getModel().getNode().getChildNamed(PurchaseOrderPositionComplete_.transactions), OrderPositionsDetailsPanel.this.provider, !OrderPositionsDetailsPanel.this.isCheckModule(), x, y, PurchaseOrderPositionComplete_.transactions.getFieldName());
            } else if (source == this.allergenButton) {
                if (this.artC != null) {
                    boolean spotCheckAllowed = OrderPositionsDetailsPanel.this.provider.isWritable(PurchaseOrderAccess.ALLERGEN_SPOT_CHECK);
                    InnerPopupFactory.showAllergenInfo(source, (PurchaseOrderPositionLight)this.getModel().getNode().getValue(), this.artC, OrderPositionsDetailsPanel.this.provider, x, y, !spotCheckAllowed);
                }
            } else if (source == this.halalButton && this.artC != null) {
                boolean spotCheckAllowed = OrderPositionsDetailsPanel.this.provider.isWritable(PurchaseOrderAccess.HALAL_CHECK);
                InnerPopupFactory.showHalalInfo(source, (PurchaseOrderPositionLight)this.getModel().getNode().getValue(), this.artC, OrderPositionsDetailsPanel.this.provider, x, y, !spotCheckAllowed);
            }
        }

        private void ensureCommentState() {
            if (this.comment == null) {
                return;
            }
            if (this.model.getNode().getChildNamed(PurchaseOrderPositionComplete_.comment).getValue() == null || ((String)this.model.getNode().getChildNamed(PurchaseOrderPositionComplete_.comment).getValue()).isEmpty()) {
                this.comment.setChoosen(false);
            } else {
                this.comment.setChoosen(true);
            }
        }

        public void childrenAdded(Node<?> source, Node<?> ... nodes) {
        }

        private void changeAmount(int x, int y) {
            UnitComplete unit;
            double amount;
            Node amountNode;
            Node oldPriceNode;
            Node oldPrice;
            Node newPriceNode;
            Node newPrice;
            Node oldPriceUnit;
            Node newPriceUnit;
            Node newAmount = this.model.getNode().getChildNamed(DtoFieldConstants.NEW_AMOUNT);
            Node remarks = this.model.getNode().getChildNamed(DtoFieldConstants.REMARKS);
            if (remarks == null) {
                remarks = new ListNode();
                remarks.setName(DtoFieldConstants.REMARKS);
                this.model.getNode().addChild(remarks, 0L);
            }
            if ((newPriceUnit = this.model.getNode().getChildNamed(DtoFieldConstants.NEW_PRICE_UNIT)) == null) {
                newPriceUnit = new DTONode();
                newPriceUnit.setName(DtoFieldConstants.NEW_PRICE_UNIT.getFieldName());
                UnitComplete unit2 = (UnitComplete)this.model.getNode().getChildNamed(PurchaseOrderPositionComplete_.priceUnit).getValue();
                newPriceUnit.setValue((Object)unit2, 0L);
                this.model.getNode().addChild(newPriceUnit, 0L);
            }
            if ((oldPriceUnit = this.model.getNode().getChildNamed(DtoFieldConstants.OLD_PRICE_UNIT)) == null) {
                oldPriceUnit = new DTONode();
                oldPriceUnit.setName(DtoFieldConstants.OLD_PRICE_UNIT.getFieldName());
                UnitComplete unit3 = (UnitComplete)this.model.getNode().getChildNamed(PurchaseOrderPositionComplete_.priceUnit).getValue();
                oldPriceUnit.setValue((Object)unit3, 0L);
                this.model.getNode().addChild(oldPriceUnit, 0L);
            }
            if ((newPrice = (newPriceNode = this.model.getNode().getChildNamed(DtoFieldConstants.NEW_PRICE))) == null) {
                newPrice = new DTONode();
                newPrice.setName(DtoFieldConstants.NEW_PRICE.getFieldName());
                PriceComplete price = (PriceComplete)this.model.getNode().getChildNamed(PurchaseOrderPositionComplete_.supplierPrice).getValue();
                newPrice.setValue((Object)price, 0L);
                this.model.getNode().addChild(newPrice, 0L);
            }
            if ((oldPrice = (oldPriceNode = this.model.getNode().getChildNamed(DtoFieldConstants.OLD_PRICE))) == null) {
                oldPrice = new DTONode();
                oldPrice.setName(DtoFieldConstants.OLD_PRICE.getFieldName());
                PriceComplete price = (PriceComplete)this.model.getNode().getChildNamed(PurchaseOrderPositionComplete_.supplierPrice).getValue();
                oldPrice.setValue((Object)price, 0L);
                this.model.getNode().addChild(oldPrice, 0L);
            }
            if ((amountNode = this.ordered.getNode().getChildNamed(StoreQuantityComplete_.amount)) != null) {
                amount = TransactionToolkit.getLongValue(amountNode).doubleValue();
            } else {
                PurchaseOrderPositionComplete order = (PurchaseOrderPositionComplete)this.model.getNode().getValue();
                amount = order.getQuantity().getAmount().doubleValue();
            }
            Node unitNode = this.ordered.getNode().getChildNamed(StoreQuantityComplete_.unit);
            if (unitNode != null) {
                unit = (UnitComplete)unitNode.getValue();
            } else {
                PurchaseOrderPositionComplete order = (PurchaseOrderPositionComplete)this.model.getNode().getValue();
                unit = order.getQuantity().getUnit();
            }
            QuantityComplete q = new QuantityComplete(Double.valueOf(amount), unit);
            if (newAmount == null) {
                newAmount = new EmbeddedDTONode();
                newAmount.setName(DtoFieldConstants.NEW_AMOUNT);
                StoreQuantityComplete qt = new StoreQuantityComplete();
                qt.setAmount(TransactionToolkit.getLongValue(this.model.getNode().getChildNamed(new DtoField[]{PurchaseOrderPositionComplete_.quantity, StoreQuantityComplete_.amount})));
                qt.setUnit((UnitComplete)this.model.getNode().getChildNamed(new DtoField[]{PurchaseOrderPositionComplete_.quantity, StoreQuantityComplete_.unit}).getValue());
                newAmount.setValue((Object)qt, 0L);
                this.model.getNode().addChild(newAmount, 0L);
            }
            InnerPopUp2 popUp = InnerPopUp2.getInnerPopUp();
            popUp.setAttributes(this.changeOrder, true, true, Words.CHANGE_ORDER_AMOUNT);
            Date date = (Date)this.model.getNode().getChildNamed(new DtoField[]{PurchaseOrderPositionComplete_.order, PurchaseOrderComplete_.orderDate}).getValue();
            Timestamp validity = new Timestamp(date.getTime());
            Node oldAmount = this.model.getNode().getChildNamed(PurchaseOrderPositionComplete_.quantity);
            popUp.setView(new OrderAmountChangingPopup<OrderPositionMutationRemarkComplete>(newAmount, oldAmount, this.model.getNode().getChildNamed(PurchaseOrderPositionComplete_.article), validity, this.model.getNode().getChildNamed(DtoFieldConstants.NEW_PRICE), this.model.getNode().getChildNamed(DtoFieldConstants.OLD_PRICE), this.model.getNode().getChildNamed(DtoFieldConstants.NEW_PRICE_UNIT), this.model.getNode().getChildNamed(DtoFieldConstants.OLD_PRICE_UNIT), this.model.getNode().getChildNamed(DtoFieldConstants.REMARKS), OrderPositionMutationRemarkComplete.class, (Node<SupplierConditionComplete>)this.model.getNode().getChildNamed(PurchaseOrderPositionComplete_.supplierCondition), this.isConversionValid(), TransactionType.PURCHASE));
            popUp.showPopUp(x, y, 200, -1, this, this.changeOrder);
        }

        @Override
        public void popUpClosed(InnerPopUp2 source, Object ... xargs) {
            if (xargs == null) {
                return;
            }
            if (source.getCaller() == this.changeOrder) {
                Node newAmount = this.model.getNode().getChildNamed(DtoFieldConstants.NEW_AMOUNT);
                newAmount.commitThis();
                Node priceUnit = this.model.getNode().getChildNamed(DtoFieldConstants.NEW_PRICE_UNIT);
                Node newPrice = this.model.getNode().getChildNamed(DtoFieldConstants.NEW_PRICE);
                StoreQuantityComplete oldQuantity = new StoreQuantityComplete();
                oldQuantity.setAmount(TransactionToolkit.getLongValue(this.model.getNode().getChildNamed(new DtoField[]{OrderPositionComplete_.quantity, StoreQuantityComplete_.amount})));
                oldQuantity.setUnit((UnitComplete)this.model.getNode().getChildNamed(new DtoField[]{OrderPositionComplete_.quantity, StoreQuantityComplete_.unit}).getValue());
                Date orderDate = (Date)OrderPositionsDetailsPanel.this.editor.getModel().getNode().getChildNamed(PurchaseOrderComplete_.orderDate).getValue();
                if (orderDate == null) {
                    orderDate = (Date)OrderPositionsDetailsPanel.this.editor.getModel().getNode().getChildNamed(PurchaseOrderComplete_.deliveryDate).getValue();
                }
                ModuleAccessRightComplete br = HUDToolkit.getCurrentAccessRight(PurchaseOrderAccess.MODULE_PURCHASE, OrderPositionsDetailsPanel.this.currentUser);
                boolean canOverrideThreshold = false;
                for (DataFieldAccessRightComplete access : br.getFieldAccessRights()) {
                    if (!access.getField().getName().equals(PurchaseOrderAccess.IGNORE_ORDER_AMOUNT_THRESHOLD.getName())) continue;
                    canOverrideThreshold = true;
                }
                if (!canOverrideThreshold) {
                    ArrayList<Object> validationObjects;
                    SupplierLight supplier = (SupplierLight)OrderPositionsDetailsPanel.this.editor.getModel().getNode().getChildNamed(PurchaseOrderComplete_.supplier).getValue();
                    if (!ReceiveToolkit.isAmountOverflow(this.orderedQuantity, new StoreQuantityComplete(Long.valueOf(0L), this.artC.getMainStoreUnit()), new QuantityComplete(Double.valueOf(((StoreQuantityComplete)newAmount.getValue()).getAmount().doubleValue()), ((StoreQuantityComplete)newAmount.getValue()).getUnit()), OrderPositionsDetailsPanel.this.settings, supplier, this.artC, new Timestamp(orderDate.getTime()))) {
                        validationObjects = new ArrayList<ScreenValidationObject>();
                        validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "New amount is more than " + OrderPositionsDetailsPanel.this.settings.getReceiveThreshold() + "% bigger than old amount"));
                        InnerPopupFactory.showErrorDialog(validationObjects, "Unable to change order amount", (Component)this);
                        return;
                    }
                    if (!ReceiveToolkit.isAmountUnderflow(this.orderedQuantity, new StoreQuantityComplete(Long.valueOf(0L), this.artC.getMainStoreUnit()), new QuantityComplete(Double.valueOf(((StoreQuantityComplete)newAmount.getValue()).getAmount().doubleValue()), ((StoreQuantityComplete)newAmount.getValue()).getUnit()), OrderPositionsDetailsPanel.this.settings, supplier, this.artC, new Timestamp(orderDate.getTime()))) {
                        validationObjects = new ArrayList();
                        validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "New amount is more than " + OrderPositionsDetailsPanel.this.settings.getReceiveThresholdUnderflow() + "% smaller than old amount"));
                        InnerPopupFactory.showErrorDialog(validationObjects, "Unable to change order amount", (Component)this);
                        return;
                    }
                }
                this.model.getNode().getChildNamed(PurchaseOrderPositionComplete_.priceUnit).setValue(priceUnit.getValue(), 0L);
                this.model.getNode().getChildNamed(PurchaseOrderPositionComplete_.supplierPrice).setValue(newPrice.getValue(), 0L);
                this.changeOrder.setEnabled(true);
                this.model.getNode().getChildNamed(PurchaseOrderPositionComplete_.orderUnitConversionValidity).setValue((Object)true, 0L);
                Long a = TransactionToolkit.getLongValue(newAmount.getChildNamed(StoreQuantityComplete_.amount));
                Long b = this.orderedQuantity.getAmount();
                this.ordered.getNode().setValue(newAmount.getValue(), System.currentTimeMillis());
                UnitComplete newUnit = (UnitComplete)newAmount.getChildNamed(StoreQuantityComplete_.unit).getValue();
                StoreQuantityComplete qq = (StoreQuantityComplete)this.ordered.getNode().getValue();
                boolean unitChange = !qq.getUnit().equals((Object)newUnit);
                qq.setAmount(a);
                qq.setUnit(newUnit);
                this.model.getNode().getChildNamed(OrderPositionComplete_.quantity).setValue((Object)qq, 0L);
                if ((this.model.getNode().getChildNamed(PurchaseOrderPositionComplete_.state) == null || this.model.getNode().getChildNamed(PurchaseOrderPositionComplete_.state).getValue() == OrderStateE.PLACED) && OrderPositionsDetailsPanel.this.editor.getModel().getNode().getChildNamed(PurchaseOrderPositionComplete_.state).getValue() == OrderStateE.PLACED && this.model.getNode().getChildNamed(DtoFieldConstants.HAS_QUANTITY_CHANGE) == null) {
                    Node n = new Node();
                    n.setName(DtoFieldConstants.HAS_QUANTITY_CHANGE);
                    this.model.getNode().addChild(n, 0L);
                }
                if (a.longValue() != b.longValue() || unitChange) {
                    this.ordered.setLeftUpperCornerPainting(true, AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("productionplanner_stocksetted_color")));
                } else {
                    this.ordered.setLeftUpperCornerPainting(false, AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("productionplanner_stocksetted_color")));
                }
                this.ordered.updateString();
            }
            if (this.infoButton != null) {
                this.infoButton.installStringViewer(OrderToolkit.createInfoInsert(this.acceptations, (PurchaseOrderComplete)OrderPositionsDetailsPanel.this.editor.getModel().getNode().getValue(PurchaseOrderComplete.class), this.model));
            }
            this.ensureCommentState();
        }

        @Override
        public void newValueSelected(SearchTextField2 source, Node<?> n) {
            new BasicArticleLoader((BasicArticleReference)n.getValue(BasicArticleLight.class), this, n, this);
        }

        @Override
        public void remoteObjectLoaded(Node<?> node) {
            Node newAmount;
            this.artC = (BasicArticleComplete)node.getValue(BasicArticleComplete.class);
            this.model.getNode().getChildNamed(new DtoField[]{PurchaseOrderPositionComplete_.quantity, StoreQuantityComplete_.unit}).setValue((Object)this.artC.getMainStoreUnit(), System.currentTimeMillis());
            this.model.getNode().getChildNamed(new DtoField[]{PurchaseOrderPositionComplete_.quantity, StoreQuantityComplete_.amount}).setValue((Object)0L, System.currentTimeMillis());
            this.model.getNode().getChildNamed(PurchaseOrderPositionComplete_.quantity).commitThis(StoreQuantityComplete.class);
            if (this.model.getNode().getChildNamed(PurchaseOrderPositionComplete_.supplierPrice).getValue() == null) {
                this.model.getNode().getChildNamed(PurchaseOrderPositionComplete_.supplierPrice).setValue((Object)new PriceComplete(), 0L);
            }
            this.model.getNode().getChildNamed(PurchaseOrderPositionComplete_.priceUnit).setValue((Object)this.artC.getPriceUnit(), 0L);
            this.model.getNode().getChildNamed(new DtoField[]{PurchaseOrderPositionComplete_.quantity, StoreQuantityComplete_.unit}).removeNodeListener((NodeListener)this);
            this.model.getNode().getChildNamed(new DtoField[]{PurchaseOrderPositionComplete_.quantity, StoreQuantityComplete_.unit}).addNodeListener((NodeListener)this);
            this.model.getNode().getChildNamed(new DtoField[]{PurchaseOrderPositionComplete_.quantity, StoreQuantityComplete_.amount}).removeNodeListener((NodeListener)this);
            this.model.getNode().getChildNamed(new DtoField[]{PurchaseOrderPositionComplete_.quantity, StoreQuantityComplete_.amount}).addNodeListener((NodeListener)this);
            Boolean useTaxZone = (Boolean)OrderPositionsDetailsPanel.this.editor.getModel().getNode().getChildNamed(PurchaseOrderComplete_.useTaxZone).getValue();
            TaxZoneComplete taxZone = (TaxZoneComplete)OrderPositionsDetailsPanel.this.editor.getModel().getNode().getChildNamed(PurchaseOrderComplete_.taxZone).getValue();
            Date date = (Date)OrderPositionsDetailsPanel.this.editor.getModel().getNode().getChildNamed(PurchaseOrderLight_.orderDate).getValue();
            Timestamp validity = new Timestamp(date.getTime());
            SupplierConditionComplete c = ArticleToolkit.getSupplierCondition(this.artC, (SupplierReference)OrderPositionsDetailsPanel.this.editor.getModel().getNode().getChildNamed(PurchaseOrderComplete_.supplier).getValue(), useTaxZone, taxZone, validity);
            if (c != null) {
                this.model.getNode().getChildNamed(PurchaseOrderPositionComplete_.supplierCondition).setValue((Object)CopyTemplateToolkit.copySupplierCondition((SupplierConditionComplete)c), 0L);
            }
            if ((newAmount = this.model.getNode().getChildNamed(DtoFieldConstants.NEW_AMOUNT)) == null) {
                newAmount = new EmbeddedDTONode();
                newAmount.setName(DtoFieldConstants.NEW_AMOUNT);
                StoreQuantityComplete q = new StoreQuantityComplete();
                q.setAmount(TransactionToolkit.getLongValue(this.model.getNode().getChildNamed(new DtoField[]{PurchaseOrderPositionComplete_.quantity, StoreQuantityComplete_.amount})));
                q.setUnit((UnitComplete)this.model.getNode().getChildNamed(new DtoField[]{PurchaseOrderPositionComplete_.quantity, StoreQuantityComplete_.unit}).getValue());
                newAmount.setValue((Object)q, 0L);
                this.model.getNode().addChild(newAmount, 0L);
            } else {
                StoreQuantityComplete q = new StoreQuantityComplete();
                q.setUnit((UnitComplete)this.model.getNode().getChildNamed(new DtoField[]{PurchaseOrderPositionComplete_.quantity, StoreQuantityComplete_.unit}).getValue());
                q.setAmount(Long.valueOf(0L));
                newAmount.setValue((Object)q, 0L);
                newAmount.updateNode();
            }
            if (this.ordered != null) {
                this.ordered.setNode(newAmount);
            }
            if (this.infoButton != null) {
                this.infoButton.installStringViewer(OrderToolkit.createInfoInsert(this.acceptations, (PurchaseOrderComplete)OrderPositionsDetailsPanel.this.editor.getModel().getNode().getValue(PurchaseOrderComplete.class), this.model));
            }
            this.setEnabled(true);
        }

        public boolean isSwingOnly() {
            return true;
        }

        public void enableAmountChange() {
            this.isAmountChange = true;
        }

        @Override
        public void errorOccurred(ClientException exception) {
        }

        private class Layout
        extends DefaultLayout {
            private Layout() {
            }

            @Override
            public void layoutContainer(Container parent) {
                int w = OrderPositionTableRow.this.model.getParentModel().getColumnWidth(0);
                int currentX = 0;
                OrderPositionTableRow.this.label.setLocation(OrderPositionTableRow.this.getCellPadding(), (int)(((double)parent.getHeight() - OrderPositionTableRow.this.label.getPreferredSize().getHeight()) / 2.0));
                OrderPositionTableRow.this.label.setSize(30, (int)OrderPositionTableRow.this.label.getPreferredSize().getHeight());
                OrderPositionTableRow.this.expandIcon.setLocation((int)((double)(currentX + w) - ((double)OrderPositionTableRow.this.getCellPadding() + OrderPositionTableRow.this.expandIcon.getPreferredSize().getWidth())), (int)(((double)parent.getHeight() - OrderPositionTableRow.this.expandIcon.getPreferredSize().getHeight()) / 2.0));
                OrderPositionTableRow.this.expandIcon.setSize(OrderPositionTableRow.this.expandIcon.getPreferredSize());
                currentX += w;
                w = OrderPositionTableRow.this.model.getParentModel().getColumnWidth(1);
                OrderPositionTableRow.this.positionState.setLocation(currentX + OrderPositionsDetailsPanel.this.table.getCellPadding(), (int)(((double)parent.getHeight() - OrderPositionTableRow.this.positionState.getPreferredSize().getHeight()) / 2.0));
                OrderPositionTableRow.this.positionState.setSize(w - 2 * OrderPositionsDetailsPanel.this.table.getCellPadding(), (int)OrderPositionTableRow.this.positionState.getPreferredSize().getHeight());
                currentX += w;
                w = OrderPositionTableRow.this.model.getParentModel().getColumnWidth(2);
                OrderPositionTableRow.this.articleName.setLocation(currentX + OrderPositionsDetailsPanel.this.table.getCellPadding(), (int)(((double)parent.getHeight() - OrderPositionTableRow.this.articleName.getPreferredSize().getHeight()) / 2.0));
                OrderPositionTableRow.this.articleName.setSize(w - 2 * OrderPositionsDetailsPanel.this.table.getCellPadding(), (int)OrderPositionTableRow.this.articleName.getPreferredSize().getHeight());
                currentX += w;
                w = OrderPositionTableRow.this.model.getParentModel().getColumnWidth(3);
                int o = 0;
                if (OrderPositionTableRow.this.changeOrder != null) {
                    o = (int)OrderPositionTableRow.this.changeOrder.getPreferredSize().getWidth() + OrderPositionTableRow.this.getInnerCellPadding();
                }
                OrderPositionTableRow.this.ordered.setLocation(currentX + OrderPositionsDetailsPanel.this.table.getCellPadding(), (int)(((double)parent.getHeight() - OrderPositionTableRow.this.ordered.getPreferredSize().getHeight()) / 2.0));
                OrderPositionTableRow.this.ordered.setSize(w - (2 * OrderPositionsDetailsPanel.this.table.getCellPadding() + o), (int)OrderPositionTableRow.this.ordered.getPreferredSize().getHeight());
                if (OrderPositionTableRow.this.changeOrder != null) {
                    OrderPositionTableRow.this.changeOrder.setLocation(OrderPositionTableRow.this.ordered.getX() + OrderPositionTableRow.this.ordered.getWidth() + OrderPositionsDetailsPanel.this.table.getInnerCellPadding(), (int)(((double)parent.getHeight() - OrderPositionTableRow.this.changeOrder.getPreferredSize().getHeight()) / 2.0));
                    OrderPositionTableRow.this.changeOrder.setSize(OrderPositionTableRow.this.changeOrder.getPreferredSize());
                }
                currentX += w;
                w = OrderPositionTableRow.this.model.getParentModel().getColumnWidth(4);
                OrderPositionTableRow.this.received.setLocation(currentX + OrderPositionsDetailsPanel.this.table.getCellPadding(), (int)(((double)parent.getHeight() - OrderPositionTableRow.this.received.getPreferredSize().getHeight()) / 2.0));
                OrderPositionTableRow.this.received.setSize((int)OrderPositionTableRow.this.received.getPreferredSize().getWidth(), (int)OrderPositionTableRow.this.received.getPreferredSize().getHeight());
                OrderPositionTableRow.this.rec_attention.setLocation(OrderPositionTableRow.this.received.getX() + OrderPositionTableRow.this.received.getWidth() + OrderPositionTableRow.this.getInnerCellPadding(), (int)(((double)parent.getHeight() - OrderPositionTableRow.this.rec_attention.getPreferredSize().getHeight()) / 2.0));
                OrderPositionTableRow.this.rec_attention.setSize(OrderPositionTableRow.this.rec_attention.getPreferredSize());
                currentX += w;
                w = OrderPositionTableRow.this.model.getParentModel().getColumnWidth(5);
                OrderPositionTableRow.this.rejected.setLocation(currentX + OrderPositionsDetailsPanel.this.table.getCellPadding(), (int)(((double)parent.getHeight() - OrderPositionTableRow.this.rejected.getPreferredSize().getHeight()) / 2.0));
                OrderPositionTableRow.this.rejected.setSize((int)OrderPositionTableRow.this.rejected.getPreferredSize().getWidth(), (int)OrderPositionTableRow.this.rejected.getPreferredSize().getHeight());
                OrderPositionTableRow.this.rej_attention.setLocation(OrderPositionTableRow.this.rejected.getX() + OrderPositionTableRow.this.rejected.getWidth() + OrderPositionTableRow.this.getInnerCellPadding(), (int)(((double)parent.getHeight() - OrderPositionTableRow.this.rej_attention.getPreferredSize().getHeight()) / 2.0));
                OrderPositionTableRow.this.rej_attention.setSize(OrderPositionTableRow.this.rej_attention.getPreferredSize());
                currentX += w;
                w = OrderPositionTableRow.this.model.getParentModel().getColumnWidth(6);
                if (OrderPositionsDetailsPanel.this.isCheckModule()) {
                    OrderPositionTableRow.this.customerOwned.setLocation(currentX + OrderPositionTableRow.this.getCellPadding(), (int)(((double)parent.getHeight() - OrderPositionTableRow.this.customerOwned.getPreferredSize().getHeight()) / 2.0));
                    OrderPositionTableRow.this.customerOwned.setSize(OrderPositionTableRow.this.customerOwned.getPreferredSize());
                    currentX += w;
                    w = OrderPositionTableRow.this.model.getParentModel().getColumnWidth(7);
                    OrderPositionTableRow.this.price.setLocation(currentX + OrderPositionTableRow.this.getCellPadding(), (int)(((double)parent.getHeight() - OrderPositionTableRow.this.price.getPreferredSize().getHeight()) / 2.0));
                    OrderPositionTableRow.this.price.setSize((int)((double)w - ((double)(2 * OrderPositionTableRow.this.getCellPadding() + 2 * OrderPositionTableRow.this.getInnerCellPadding()) + OrderPositionTableRow.this.articleInfo.getPreferredSize().getWidth() + OrderPositionTableRow.this.customs.getPreferredSize().getWidth())), (int)OrderPositionTableRow.this.price.getPreferredSize().getHeight());
                    currentX += w;
                    w = OrderPositionTableRow.this.model.getParentModel().getColumnWidth(8);
                    OrderPositionTableRow.this.articleInfo.setLocation((int)((double)currentX - ((double)OrderPositionTableRow.this.getCellPadding() + OrderPositionTableRow.this.articleInfo.getPreferredSize().getWidth())), (int)(((double)parent.getHeight() - OrderPositionTableRow.this.articleInfo.getPreferredSize().getHeight()) / 2.0));
                    OrderPositionTableRow.this.articleInfo.setSize(OrderPositionTableRow.this.articleInfo.getPreferredSize());
                    OrderPositionTableRow.this.transportTypes.setLocation(OrderPositionTableRow.this.articleInfo.getX() - (OrderPositionTableRow.this.transportTypes.getWidth() + OrderPositionTableRow.this.getInnerCellPadding()), (int)(((double)parent.getHeight() - OrderPositionTableRow.this.transportTypes.getPreferredSize().getHeight()) / 2.0));
                    OrderPositionTableRow.this.transportTypes.setSize(OrderPositionTableRow.this.transportTypes.getPreferredSize());
                    OrderPositionTableRow.this.customs.setLocation((int)((double)OrderPositionTableRow.this.transportTypes.getX() - (OrderPositionTableRow.this.customs.getPreferredSize().getWidth() + (double)OrderPositionTableRow.this.getCellPadding())), (int)(((double)parent.getHeight() - OrderPositionTableRow.this.customs.getPreferredSize().getHeight()) / 2.0));
                    OrderPositionTableRow.this.customs.setSize(OrderPositionTableRow.this.customs.getPreferredSize());
                    OrderPositionTableRow.this.sum.setLocation(currentX + OrderPositionTableRow.this.getCellPadding(), (int)(((double)parent.getHeight() - OrderPositionTableRow.this.sum.getPreferredSize().getHeight()) / 2.0));
                    OrderPositionTableRow.this.sum.setSize(w - 2 * OrderPositionTableRow.this.getCellPadding(), (int)OrderPositionTableRow.this.sum.getPreferredSize().getHeight());
                    currentX += w;
                    w = OrderPositionTableRow.this.model.getParentModel().getColumnWidth(9);
                    OrderPositionTableRow.this.state.setLocation(currentX + OrderPositionTableRow.this.getCellPadding(), (int)(((double)parent.getHeight() - OrderPositionTableRow.this.state.getPreferredSize().getHeight()) / 2.0));
                    OrderPositionTableRow.this.state.setSize(w - 2 * OrderPositionTableRow.this.getCellPadding(), (int)OrderPositionTableRow.this.state.getPreferredSize().getHeight());
                } else {
                    int index = 7;
                    if (OrderPositionTableRow.this.labelCount != null) {
                        OrderPositionTableRow.this.labelCount.setLocation(currentX + OrderPositionTableRow.this.getCellPadding(), (int)(((double)parent.getHeight() - OrderPositionTableRow.this.labelCount.getPreferredSize().getHeight()) / 2.0));
                        OrderPositionTableRow.this.labelCount.setSize(w - 2 * OrderPositionTableRow.this.getCellPadding(), (int)OrderPositionTableRow.this.label.getPreferredSize().getHeight());
                        currentX += w;
                        w = OrderPositionTableRow.this.model.getParentModel().getColumnWidth(index++);
                    }
                    if (OrderPositionTableRow.this.targetStoreAndDepartment != null) {
                        OrderPositionTableRow.this.targetStoreAndDepartment.setLocation(currentX + OrderPositionTableRow.this.getCellPadding(), (int)(((double)parent.getHeight() - OrderPositionTableRow.this.targetStoreAndDepartment.getPreferredSize().getWidth()) / 2.0));
                        OrderPositionTableRow.this.targetStoreAndDepartment.setSize((int)((double)(w - 2 * OrderPositionTableRow.this.getCellPadding()) - ((double)OrderPositionTableRow.this.getInnerCellPadding() + OrderPositionTableRow.this.editTargetStoreAndDepartment.getPreferredSize().getWidth())), (int)OrderPositionTableRow.this.targetStoreAndDepartment.getPreferredSize().getHeight());
                        OrderPositionTableRow.this.editTargetStoreAndDepartment.setLocation(OrderPositionTableRow.this.targetStoreAndDepartment.getX() + OrderPositionTableRow.this.targetStoreAndDepartment.getWidth() + OrderPositionTableRow.this.getInnerCellPadding(), (int)(((double)parent.getHeight() - OrderPositionTableRow.this.editTargetStoreAndDepartment.getPreferredSize().getHeight()) / 2.0));
                        OrderPositionTableRow.this.editTargetStoreAndDepartment.setSize(OrderPositionTableRow.this.editTargetStoreAndDepartment.getPreferredSize());
                    }
                    currentX += w;
                    w = OrderPositionTableRow.this.model.getParentModel().getColumnWidth(index++);
                    int nx = currentX + OrderPositionTableRow.this.getCellPadding();
                    if (OrderPositionsDetailsPanel.this.canChangeSupplierCondition()) {
                        OrderPositionTableRow.this.editPacking.setLocation(currentX + OrderPositionTableRow.this.getCellPadding(), (int)(((double)parent.getHeight() - OrderPositionTableRow.this.editPacking.getPreferredSize().getHeight()) / 2.0));
                        OrderPositionTableRow.this.editPacking.setSize(OrderPositionTableRow.this.editPacking.getPreferredSize());
                        nx = OrderPositionTableRow.this.editPacking.getX() + OrderPositionTableRow.this.editPacking.getWidth() + OrderPositionTableRow.this.getInnerCellPadding();
                    }
                    if (!OrderPositionsDetailsPanel.this.isSolarCompany) {
                        OrderPositionTableRow.this.customs.setLocation(nx, (int)(((double)parent.getHeight() - OrderPositionTableRow.this.customs.getPreferredSize().getHeight()) / 2.0));
                        OrderPositionTableRow.this.customs.setSize(OrderPositionTableRow.this.customs.getPreferredSize());
                        OrderPositionTableRow.this.transportTypes.setLocation(OrderPositionTableRow.this.customs.getX() + OrderPositionTableRow.this.customs.getWidth() + OrderPositionsDetailsPanel.this.table.getInnerCellPadding(), (int)(((double)parent.getHeight() - OrderPositionTableRow.this.transportTypes.getPreferredSize().getHeight()) / 2.0));
                        OrderPositionTableRow.this.transportTypes.setSize(OrderPositionTableRow.this.transportTypes.getPreferredSize());
                        nx = OrderPositionTableRow.this.transportTypes.getX() + OrderPositionTableRow.this.transportTypes.getWidth();
                    }
                    OrderPositionTableRow.this.comment.setLocation(nx + OrderPositionsDetailsPanel.this.table.getInnerCellPadding(), (int)(((double)parent.getHeight() - OrderPositionTableRow.this.comment.getPreferredSize().getHeight()) / 2.0));
                    OrderPositionTableRow.this.comment.setSize(OrderPositionTableRow.this.comment.getPreferredSize());
                    OrderPositionTableRow.this.infoButton.setLocation(OrderPositionTableRow.this.comment.getX() + OrderPositionTableRow.this.comment.getWidth() + OrderPositionsDetailsPanel.this.table.getInnerCellPadding(), (int)(((double)parent.getHeight() - OrderPositionTableRow.this.infoButton.getPreferredSize().getHeight()) / 2.0));
                    OrderPositionTableRow.this.infoButton.setSize(OrderPositionTableRow.this.infoButton.getPreferredSize());
                    nx = OrderPositionTableRow.this.infoButton.getX() + OrderPositionTableRow.this.infoButton.getWidth();
                    if (OrderPositionTableRow.this.allergenButton != null) {
                        OrderPositionTableRow.this.allergenButton.setLocation(OrderPositionTableRow.this.infoButton.getX() + OrderPositionTableRow.this.infoButton.getWidth() + OrderPositionTableRow.this.getInnerCellPadding(), (int)(((double)parent.getHeight() - OrderPositionTableRow.this.allergenButton.getPreferredSize().getHeight()) / 2.0));
                        OrderPositionTableRow.this.allergenButton.setSize(OrderPositionTableRow.this.allergenButton.getPreferredSize());
                        nx = OrderPositionTableRow.this.allergenButton.getX() + OrderPositionTableRow.this.allergenButton.getWidth();
                    }
                    if (OrderPositionTableRow.this.halalButton != null) {
                        OrderPositionTableRow.this.halalButton.setLocation(nx + OrderPositionTableRow.this.getInnerCellPadding(), (int)(((double)parent.getHeight() - OrderPositionTableRow.this.halalButton.getPreferredSize().getHeight()) / 2.0));
                        OrderPositionTableRow.this.halalButton.setSize(OrderPositionTableRow.this.halalButton.getPreferredSize());
                        nx = OrderPositionTableRow.this.halalButton.getX() + OrderPositionTableRow.this.halalButton.getWidth();
                    }
                    if (OrderPositionTableRow.this.deleteButton != null) {
                        OrderPositionTableRow.this.deleteButton.setLocation(nx + OrderPositionTableRow.this.getCellPadding(), (int)(((double)parent.getHeight() - OrderPositionTableRow.this.deleteButton.getPreferredSize().getHeight()) / 2.0));
                        OrderPositionTableRow.this.deleteButton.setSize(OrderPositionTableRow.this.deleteButton.getPreferredSize());
                    }
                }
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, OrderPositionTableRow.this.getDefaultRowHeight());
            }
        }
    }
}

