/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.purchaseorder.manager.details;

import ch.icit.pegasus.client.converter.CustomsDocumentTypeConverter;
import ch.icit.pegasus.client.converter.DateTimeConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.screentemplates.details.TableDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.server.core.dtos.ordering.CustomsDocumentComplete_;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderComplete_;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderLight;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public class CustomsDocumentDetailsPanel
extends TableDetailsPanel<PurchaseOrderLight> {
    private static final long serialVersionUID = 3691326433843000027L;

    public CustomsDocumentDetailsPanel(RowEditor<PurchaseOrderLight> rowEditor, RDProvider p) {
        super(rowEditor, p, false);
        this.setTitleText(Words.ASSOCIATED_DOCUMENTS);
    }

    @Override
    public List<TableColumnInfo> getColumns(boolean add) {
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        columns.add(new TableColumnInfo(Words.DOC_TYPE, 120));
        columns.add(new TableColumnInfo(Words.DOC_ID, 120));
        columns.add(new TableColumnInfo(Words.CUSTOM_OFFICE, 100));
        columns.add(new TableColumnInfo(Words.DATE, 140));
        columns.add(new TableColumnInfo(Words.COMMENT, 120));
        ((TableColumnInfo)columns.get(0)).setxExpand(0.2);
        ((TableColumnInfo)columns.get(1)).setxExpand(0.2);
        ((TableColumnInfo)columns.get(2)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(3)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(4)).setxExpand(0.6);
        return columns;
    }

    @Override
    public void configTable(Table2 table) {
        table.setOverrideName(PurchaseOrderComplete_.customsDocuments);
    }

    @Override
    public void addButtonPressed(int x, int y, Button source) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setNode(Node<?> node) {
        this.table.getModel().setNode(node.getChildNamed(PurchaseOrderComplete_.customsDocuments));
    }

    @Override
    public void childRemoved() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Table2RowPanel generateView(Table2RowModel model, boolean isHeader) {
        return new TableRowImpl(model);
    }

    private class TableRowImpl
    extends Table2RowPanel
    implements ButtonListener {
        private static final long serialVersionUID = 1L;
        private TextLabel type;
        private TextLabel docID;
        private TextLabel comment;
        private TextLabel customOffice;
        private TextLabel date;

        public TableRowImpl(Table2RowModel m) {
            super(m);
            this.type = new TextLabel(m.getNode().getChildNamed(CustomsDocumentComplete_.customsDocumentType), ConverterRegistry.getConverter(CustomsDocumentTypeConverter.class));
            this.docID = new TextLabel(m.getNode().getChildNamed(CustomsDocumentComplete_.customsDocumentId));
            this.comment = new TextLabel(m.getNode().getChildNamed(CustomsDocumentComplete_.comment));
            this.customOffice = new TextLabel(m.getNode().getChildNamed(CustomsDocumentComplete_.customOffice));
            this.date = new TextLabel(m.getNode().getChildNamed(CustomsDocumentComplete_.receiveTime), ConverterRegistry.getConverter(DateTimeConverter.class));
            this.setLayout(new InnerLayout());
            this.type.setProgress(1.0f);
            this.docID.setProgress(1.0f);
            this.add(this.type);
            this.add(this.docID);
            this.add(this.comment);
            this.add(this.customOffice);
            this.add(this.date);
        }

        @Override
        public Object getObject4Column(int column) {
            switch (column) {
                case 0: {
                    return this.model.getNode().getChildNamed(CustomsDocumentComplete_.customsDocumentType).getValue();
                }
                case 1: {
                    return this.model.getNode().getChildNamed(CustomsDocumentComplete_.customsDocumentId).getValue();
                }
                case 2: {
                    return this.model.getNode().getChildNamed(CustomsDocumentComplete_.customOffice).getValue();
                }
                case 3: {
                    return this.model.getNode().getChildNamed(CustomsDocumentComplete_.receiveTime).getValue();
                }
                case 4: {
                    return this.model.getNode().getChildNamed(CustomsDocumentComplete_.comment).getValue();
                }
            }
            return null;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            if (this.type != null) {
                this.type.setEnabled(isEnabled);
            }
            if (this.docID != null) {
                this.docID.setEnabled(isEnabled);
            }
            if (this.comment != null) {
                this.comment.setEnabled(isEnabled);
            }
            if (this.customOffice != null) {
                this.customOffice.setEnabled(isEnabled);
            }
            if (this.date != null) {
                this.date.setEnabled(isEnabled);
            }
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.type.kill();
            this.type = null;
            this.docID.kill();
            this.docID = null;
            this.comment.kill();
            this.comment = null;
            this.customOffice.kill();
            this.customOffice = null;
            this.date.kill();
            this.date = null;
        }

        @Override
        public List<Component> getFocusComponents() {
            ArrayList<Component> focusList = new ArrayList<Component>();
            return focusList;
        }

        @Override
        public void requestFocusInWindowNow() {
        }

        @Override
        public void buttonPressed(Button source, int x, int y) {
            this.model.getNode().getParent().removeChild(this.model.getNode(), 0L);
        }

        private class InnerLayout
        extends DefaultLayout {
            private InnerLayout() {
            }

            @Override
            public void layoutContainer(Container parent) {
                int w = TableRowImpl.this.model.getParentModel().getColumnWidth(0);
                int currentX = 0;
                TableRowImpl.this.type.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.type.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.type.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.type.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(1);
                TableRowImpl.this.docID.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.docID.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.docID.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.docID.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(2);
                TableRowImpl.this.customOffice.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.customOffice.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.customOffice.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.customOffice.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(3);
                TableRowImpl.this.date.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.date.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.date.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.date.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(4);
                TableRowImpl.this.comment.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.comment.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.comment.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.comment.getPreferredSize().getHeight());
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TableRowImpl.this.getDefaultRowHeight());
            }
        }
    }
}

