/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.product.details.utils;

import ch.icit.pegasus.client.comparators.controller.ComparatorRegistry;
import ch.icit.pegasus.client.converter.PriceConverter2;
import ch.icit.pegasus.client.converter.SalesPriceFactorConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.modules.product.details.ProcessCostsDetailsPanel;
import ch.icit.pegasus.client.gui.modules.product.details.utils.GroupedLoader;
import ch.icit.pegasus.client.gui.modules.product.details.utils.SalePriceFactorsComparator;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2ButtonHandler;
import ch.icit.pegasus.client.gui.table2.Table2Model;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.buttons.DeleteButton;
import ch.icit.pegasus.client.gui.utils.buttons.InfoButton;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.priceanimation.CalculationRunnable;
import ch.icit.pegasus.client.gui.utils.priceanimation.LoadingGroup;
import ch.icit.pegasus.client.gui.utils.priceanimation.ReloadablePriceView;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDComboBox;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDTextField;
import ch.icit.pegasus.client.gui.utils.skins.SizedSkin1Field;
import ch.icit.pegasus.client.gui.utils.textfield.TextFieldType;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.EmbeddedDTONode;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeListener;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.util.toolkits.PriceToolkit;
import ch.icit.pegasus.client.util.toolkits.ProductToolkit;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.masterdata.SalesPriceFactorComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.SalesPriceFactorComplete_;
import ch.icit.pegasus.server.core.dtos.masterdata.SalesPriceFactorPriceVariantComplete;
import ch.icit.pegasus.server.core.dtos.product.ProductPriceFactorComplete;
import ch.icit.pegasus.server.core.dtos.product.ProductPriceFactorComplete_;
import ch.icit.pegasus.server.core.dtos.supply.PriceComplete;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public abstract class ProductPriceFactorTable
extends Table2 {
    private static final long serialVersionUID = 1L;
    private Component toplevelParent;
    private RDProvider provider;
    private boolean isDeletable;
    private GroupedLoader loader;
    private ProcessCostsDetailsPanel processCostView;

    public ProductPriceFactorTable(Component parent, RDProvider provider, boolean isDeletable, boolean external, GroupedLoader loader, ProcessCostsDetailsPanel d2) {
        this(parent, provider, isDeletable, external, loader, d2, false);
    }

    public ProductPriceFactorTable(Component parent, RDProvider provider, boolean isDeletable, boolean external, GroupedLoader loader, ProcessCostsDetailsPanel d2, boolean withBackground) {
        super(true, Words.ADD, withBackground);
        this.toplevelParent = parent;
        this.isDeletable = isDeletable;
        this.provider = provider;
        this.loader = loader;
        this.processCostView = d2;
        this.loader = loader;
        this.setDontUseScrollBar(15);
        this.setProvider(provider);
        this.setComparator(ComparatorRegistry.getComparator(SalePriceFactorsComparator.class));
        this.setButtonHandler(new Table2ButtonHandler(){

            @Override
            public void childRemoved() {
                ProductPriceFactorTable.this.writeNumbers();
                ProductPriceFactorTable.this.ensureSelectables();
                ProductPriceFactorTable.this.ensureAddButtonState();
                ProductPriceFactorTable.this.load(true);
            }

            @Override
            public void addButtonPressed(int x, int y, Button source) {
                SalesPriceFactorComplete f = ProductPriceFactorTable.this.getFreeFactor();
                if (f == null) {
                    ProductPriceFactorTable.this.ensureAddButtonState();
                    return;
                }
                ProductPriceFactorComplete p = new ProductPriceFactorComplete();
                p.setClientOId(Long.valueOf(ADTO.getNextId()));
                p.setSalesPriceFactor(f);
                p.setFactor(p.getSalesPriceFactor().getDefaultValue());
                p.setPrint(p.getSalesPriceFactor().getDefaultPrint());
                p.setFixPrice(p.getSalesPriceFactor().getDefaultFixPrice());
                p.setNumber(Integer.valueOf(ProductPriceFactorTable.this.getRowCount() + 1));
                Node n = INodeCreator.getDefaultImpl().getNode4DTO((Object)p, true, false);
                ProductPriceFactorTable.this.getModel().getNode().addChild(n, System.currentTimeMillis());
                ProductPriceFactorTable.this.ensureSelectables();
                ProductPriceFactorTable.this.ensureAddButtonState();
            }
        });
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        columns.add(new TableColumnInfo(Words.FACTOR, null, null, null, "", 30, 30, 30));
        columns.add(new TableColumnInfo(Words.AMOUNT, null, null, null, "", 30, 30, 30));
        columns.add(new TableColumnInfo(Words.COST, null, null, null, "", 30, 30, 30));
        columns.add(new TableColumnInfo(Words.PRINT, null, null, null, "", 50, 50, 50));
        int pCw = this.getCellPadding() * 2 + DeleteButton.getPreferredWidth(SizedSkin1Field.SkinSize.SMALL);
        columns.add(new TableColumnInfo("", null, null, null, "", pCw, pCw, pCw));
        ((TableColumnInfo)columns.get(0)).setxExpand(0.4);
        ((TableColumnInfo)columns.get(1)).setxExpand(0.3);
        ((TableColumnInfo)columns.get(2)).setxExpand(0.3);
        ((TableColumnInfo)columns.get(3)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(4)).setxExpand(0.0);
        this.setModel(new Table2Model(columns, model1 -> new TableRowImpl(model1)));
    }

    private void ensureAddButtonState() {
        this.enableAddButton(this.getFreeFactor() != null);
    }

    private void writeNumbers() {
        int count = 1;
        long currentID = System.currentTimeMillis();
        for (Table2RowPanel p : this.getRows()) {
            p.getModel().getNode().getChildNamed(ProductPriceFactorComplete_.number).setValue((Object)count, currentID);
        }
    }

    private void ensureSelectables() {
        ArrayList<Node> usedNodes = new ArrayList<Node>();
        Iterator it = NodeToolkit.getAffixList(SalesPriceFactorComplete.class).getChilds();
        while (it.hasNext()) {
            Node s = (Node)it.next();
            boolean found = false;
            for (Table2RowPanel p : this.getRows()) {
                if (!p.getModel().getNode().getChildNamed(ProductPriceFactorComplete_.salesPriceFactor).getValue().equals(s.getValue())) continue;
                found = true;
            }
            if (!found) continue;
            usedNodes.add(s);
        }
        for (Table2RowPanel p : this.getRows()) {
            TableRowImpl pp = (TableRowImpl)p;
            pp.updateSelectables(usedNodes);
        }
    }

    private SalesPriceFactorComplete getFreeFactor() {
        Iterator it = NodeToolkit.getAffixList(SalesPriceFactorComplete.class).getChilds();
        while (it.hasNext()) {
            Node s = (Node)it.next();
            boolean found = false;
            for (Table2RowPanel p : this.getRows()) {
                if (!p.getModel().getNode().getChildNamed(ProductPriceFactorComplete_.salesPriceFactor).getValue().equals(s.getValue())) continue;
                found = true;
            }
            if (found) continue;
            return (SalesPriceFactorComplete)s.getValue();
        }
        return null;
    }

    public abstract void load(boolean var1);

    public void setNode(Node node) {
        this.getModel().setNode(node);
        this.getModel().allInitiated();
        this.ensureSelectables();
        this.ensureAddButtonState();
    }

    @Override
    public int getRowCount() {
        return this.getRows().size();
    }

    public abstract void addCostFactor(ReloadablePriceView var1);

    public abstract void removeCostFactor(ReloadablePriceView var1);

    @Override
    public boolean isInnerComponent(Component c) {
        for (Table2RowPanel p : this.getRows()) {
            TableRowImpl pp = (TableRowImpl)p;
            if (!pp.isInnerComponent(c)) continue;
            return true;
        }
        return false;
    }

    private class TableRowImpl
    extends Table2RowPanel
    implements NodeListener,
    ButtonListener,
    ItemListener {
        private static final long serialVersionUID = 1L;
        private RDComboBox factor;
        private InfoButton info;
        private RDTextField amountValue;
        private TextLabel percentage;
        private ReloadablePriceView costs;
        private CheckBox print;
        private DeleteButton delete;
        private CheckBox fixCosts;
        private Boolean variantPrice;

        public TableRowImpl(Table2RowModel m) {
            super(m);
            this.setUseControlSkin(Table2RowPanel.TableControlsType.ONE);
            this.setLayout(new TableRowLayout());
            this.factor = new RDComboBox(ProductPriceFactorTable.this.provider, ConverterRegistry.getConverter(SalesPriceFactorConverter.class));
            this.factor.refreshPossibleValues(NodeToolkit.getAffixList(SalesPriceFactorComplete.class));
            this.factor.setNode(m.getNode().getChildNamed(ProductPriceFactorComplete_.salesPriceFactor));
            this.info = new InfoButton();
            this.info.installStringViewer(ProductToolkit.getAdditionalInfoString((SalesPriceFactorComplete)m.getNode().getChildNamed(ProductPriceFactorComplete_.salesPriceFactor).getValue()));
            this.fixCosts = new CheckBox((Node<Boolean>)m.getNode().getChildNamed(ProductPriceFactorComplete_.fixPrice));
            this.variantPrice = Boolean.TRUE.equals(m.getNode().getChildNamed(new DtoField[]{ProductPriceFactorComplete_.salesPriceFactor, SalesPriceFactorComplete_.useVariantsPricing}).getValue());
            this.amountValue = new RDTextField(ProductPriceFactorTable.this.provider, TextFieldType.DOUBLE);
            this.amountValue.setNode(m.getNode().getChildNamed(ProductPriceFactorComplete_.factor));
            this.percentage = new TextLabel("%");
            if (ProductPriceFactorTable.this.isDeletable) {
                this.delete = new DeleteButton();
                this.delete.addButtonListener(this);
                this.add(this.delete);
            }
            this.costs = new ReloadablePriceView((LoadingGroup)ProductPriceFactorTable.this.loader, PriceConverter2.class);
            this.setRunnable();
            m.getNode().getChildNamed(ProductPriceFactorComplete_.fixPrice).addNodeListener((NodeListener)this);
            m.getNode().getChildNamed(ProductPriceFactorComplete_.factor).addNodeListener((NodeListener)this);
            m.getNode().getChildNamed(ProductPriceFactorComplete_.number).addNodeListener((NodeListener)this);
            m.getNode().getChildNamed(ProductPriceFactorComplete_.print).addNodeListener((NodeListener)this);
            m.getNode().getChildNamed(ProductPriceFactorComplete_.salesPriceFactor).addNodeListener((NodeListener)this);
            ProductPriceFactorTable.this.loader.addAdditionalCost(this.costs);
            this.print = new CheckBox((Node<Boolean>)m.getNode().getChildNamed(new String[]{"print"}));
            if (this.factor.getEditor() != null) {
                this.factor.addItemListener(this);
            }
            this.factor.setProgress(1.0f);
            this.amountValue.setProgress(1.0f);
            this.percentage.setProgress(1.0f);
            this.costs.setProgress(1.0f);
            this.print.setProgress(1.0f);
            this.fixCosts.setProgress(1.0f);
            this.add(this.factor);
            this.add(this.amountValue);
            this.add(this.percentage);
            this.add(this.costs);
            this.add(this.print);
            this.add(this.info);
            this.add(this.fixCosts);
            this.ensureSuffix();
            this.updateValues();
        }

        private void ensureSuffix() {
            if (Boolean.TRUE.equals(this.variantPrice)) {
                Date dueDate = ProductPriceFactorTable.this.processCostView.getDueDate();
                SalesPriceFactorComplete factor = (SalesPriceFactorComplete)this.model.getNode().getChildNamed(ProductPriceFactorComplete_.salesPriceFactor).getValue();
                for (SalesPriceFactorPriceVariantComplete priceVariant : factor.getPriceVariants()) {
                    if (!priceVariant.getValidity().within(dueDate).booleanValue()) continue;
                    Boolean isFix = Boolean.TRUE.equals(priceVariant.getUsePrice());
                    SystemSettingsComplete settingsComplete = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
                    if (Boolean.TRUE.equals(isFix)) {
                        this.percentage.setText(settingsComplete.getCurrency().getCode());
                        continue;
                    }
                    this.percentage.setText("%");
                }
            } else {
                Boolean isFix = (Boolean)this.model.getNode().getChildNamed(ProductPriceFactorComplete_.fixPrice).getValue();
                SystemSettingsComplete settingsComplete = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
                if (Boolean.TRUE.equals(isFix)) {
                    this.percentage.setText(settingsComplete.getCurrency().getCode());
                } else {
                    this.percentage.setText("%");
                }
            }
        }

        protected void updateSelectables(List<Node> used) {
            List<Node<?>> l = used;
            this.factor.updateSelectableValues(l);
        }

        @Override
        public Object getObject4Column(int column) {
            switch (column) {
                case 0: {
                    return this.factor.getStringValue();
                }
                case 1: {
                    return this.amountValue.getStringValue();
                }
                case 2: {
                    return this.costs.getTextLabel().getText();
                }
                case 3: {
                    return this.print.getStringValue();
                }
            }
            return null;
        }

        @Override
        public void requestFocusInWindowNow() {
            if (this.factor != null) {
                this.factor.requestFocusInWindowNow();
            }
        }

        private void setRunnable() {
            CalculationRunnable run = new CalculationRunnable(){

                @Override
                public void run() {
                    try {
                        PriceComplete p2;
                        if (TableRowImpl.this.costs != null && TableRowImpl.this.isEnabled() && (p2 = ProductPriceFactorTable.this.processCostView.getProductionCost()) != null) {
                            PriceComplete p3 = new PriceComplete();
                            p3.setCurrency(p2.getCurrency());
                            p3.setPrice(p2.getPrice());
                            SalesPriceFactorComplete factor = (SalesPriceFactorComplete)TableRowImpl.this.model.getNode().getChildNamed(ProductPriceFactorComplete_.salesPriceFactor).getValue();
                            if (TableRowImpl.this.variantPrice.booleanValue()) {
                                Date dueDate = ProductPriceFactorTable.this.processCostView.getDueDate();
                                for (SalesPriceFactorPriceVariantComplete priceVariant : factor.getPriceVariants()) {
                                    if (!priceVariant.getValidity().within(dueDate).booleanValue()) continue;
                                    Boolean isFix = Boolean.TRUE.equals(priceVariant.getUsePrice());
                                    double d = priceVariant.getValue();
                                    if (Boolean.TRUE.equals(isFix)) {
                                        p3.setPrice(Double.valueOf(d));
                                        TableRowImpl.this.amountValue.getNode().setValueSilent((Object)p3.getPrice(), true, 0L, null);
                                        TableRowImpl.this.amountValue.setNode(TableRowImpl.this.amountValue.getNode());
                                    } else {
                                        double np = p3.getPrice() * d;
                                        p3.setPrice(Double.valueOf(np /= 100.0));
                                        TableRowImpl.this.amountValue.getNode().setValueSilent((Object)d, true, 0L, null);
                                        TableRowImpl.this.amountValue.setNode(TableRowImpl.this.amountValue.getNode());
                                    }
                                    TableRowImpl.this.fixCosts.getNode().setValueSilent((Object)isFix, true, 0L, null);
                                    TableRowImpl.this.fixCosts.setNode(TableRowImpl.this.fixCosts.getNode());
                                }
                            } else {
                                Boolean isFix = (Boolean)TableRowImpl.this.model.getNode().getChildNamed(ProductPriceFactorComplete_.fixPrice).getValue();
                                double d = (Double)TableRowImpl.this.model.getNode().getChildNamed(ProductPriceFactorComplete_.factor).getValue();
                                if (Boolean.TRUE.equals(isFix)) {
                                    p3.setPrice(Double.valueOf(d));
                                } else {
                                    double np = p3.getPrice() * d;
                                    p3.setPrice(Double.valueOf(np /= 100.0));
                                }
                            }
                            if (TableRowImpl.this.costs != null) {
                                Node pn = TableRowImpl.this.costs.getNode();
                                if (pn == null) {
                                    pn = new EmbeddedDTONode();
                                    TableRowImpl.this.costs.setNode(pn);
                                }
                                p3.setPrice(PriceToolkit.ensureDoubleFinite(p3.getPrice()));
                                pn.setValue((Object)p3, 0L);
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }

                @Override
                public boolean isAlive() {
                    if (TableRowImpl.this.costs == null) {
                        return false;
                    }
                    return !TableRowImpl.this.costs.isKilled();
                }
            };
            this.costs.setRunnable(run);
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.model.getNode().getChildNamed(ProductPriceFactorComplete_.fixPrice).removeNodeListener((NodeListener)this);
            this.model.getNode().getChildNamed(ProductPriceFactorComplete_.factor).removeNodeListener((NodeListener)this);
            this.model.getNode().getChildNamed(ProductPriceFactorComplete_.number).removeNodeListener((NodeListener)this);
            this.model.getNode().getChildNamed(ProductPriceFactorComplete_.print).removeNodeListener((NodeListener)this);
            this.model.getNode().getChildNamed(ProductPriceFactorComplete_.salesPriceFactor).removeNodeListener((NodeListener)this);
            ProductPriceFactorTable.this.loader.removeAdditionalCost(this.costs);
            if (this.delete != null) {
                this.delete.kill();
            }
            this.info.kill();
            this.factor.kill();
            this.amountValue.kill();
            this.percentage.kill();
            this.costs.kill();
            this.print.kill();
            this.fixCosts.kill();
            this.factor = null;
            this.amountValue = null;
            this.percentage = null;
            this.costs = null;
            this.print = null;
            this.delete = null;
            this.info = null;
            this.fixCosts = null;
        }

        @Override
        public List<Component> getFocusComponents() {
            ArrayList<Component> a = new ArrayList<Component>();
            CheckedListAdder.addToList(a, this.factor);
            CheckedListAdder.addToList(a, this.fixCosts);
            CheckedListAdder.addToList(a, this.amountValue);
            CheckedListAdder.addToList(a, this.print);
            CheckedListAdder.addToList(a, this.delete);
            return a;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            this.factor.setEnabled(isEnabled);
            this.info.setEnabled(this.getModel().getParentModel().getTable().isEnabled());
            this.amountValue.setEnabled(isEnabled && this.variantPrice == false);
            this.percentage.setEnabled(isEnabled);
            this.costs.setEnabled(isEnabled);
            this.print.setEnabled(isEnabled);
            this.fixCosts.setEnabled(isEnabled && this.variantPrice == false);
            if (this.delete != null) {
                this.delete.setEnabled(isEnabled);
            }
        }

        public void childAdded(Node<?> source, Node<?> child) {
        }

        public void childRemoved(Node<?> source, Node<?> child) {
        }

        public void childrenAdded(Node<?> source, Node<?> ... nodes) {
        }

        public void valueChanged(Node<?> node) {
            this.ensureSuffix();
            if (node.getValue() != null) {
                this.updateValues();
            }
        }

        private void updateValues() {
            this.costs.load(true);
        }

        @Override
        public void buttonPressed(Button source, int x, int y) {
            if (source == this.delete) {
                this.getModel().getNode().getParent().removeChild(this.getModel().getNode(), 0L);
            }
        }

        public boolean isSwingOnly() {
            return true;
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                Node n = (Node)((ComboBox)this.factor.getEditor()).getSelectedItem();
                SalesPriceFactorComplete factor = (SalesPriceFactorComplete)n.getValue();
                this.variantPrice = Boolean.TRUE.equals(factor.getUseVariantsPricing());
                if (!Boolean.TRUE.equals(this.variantPrice)) {
                    this.model.getNode().getChildNamed(ProductPriceFactorComplete_.factor).setValue((Object)factor.getDefaultValue(), 0L);
                    this.model.getNode().getChildNamed(ProductPriceFactorComplete_.print).setValue((Object)factor.getDefaultPrint(), 0L);
                    this.model.getNode().getChildNamed(ProductPriceFactorComplete_.fixPrice).setValue((Object)factor.getDefaultFixPrice(), 0L);
                }
                this.info.installStringViewer(ProductToolkit.getAdditionalInfoString(factor));
                this.setEnabled(this.isEnabled());
                ProductPriceFactorTable.this.loader.updateMe(this.costs);
            }
        }

        private class TableRowLayout
        extends DefaultLayout {
            private TableRowLayout() {
            }

            @Override
            public void layoutContainer(Container parent) {
                int w = TableRowImpl.this.model.getParentModel().getColumnWidth(0);
                int currentX = 0;
                TableRowImpl.this.factor.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.factor.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.factor.setSize((int)((double)w - ((double)(2 * TableRowImpl.this.getCellPadding() + TableRowImpl.this.getInnerCellPadding()) + TableRowImpl.this.info.getPreferredSize().getWidth())), (int)TableRowImpl.this.factor.getPreferredSize().getHeight());
                TableRowImpl.this.info.setLocation(TableRowImpl.this.factor.getX() + TableRowImpl.this.factor.getWidth() + TableRowImpl.this.getInnerCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.info.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.info.setSize(TableRowImpl.this.info.getPreferredSize());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(1);
                int tfw = w - 2 * TableRowImpl.this.getCellPadding();
                tfw -= 2 * TableRowImpl.this.getInnerCellPadding();
                tfw = (int)((double)tfw - TableRowImpl.this.percentage.getPreferredSize().getWidth());
                tfw = (int)((double)tfw - TableRowImpl.this.fixCosts.getPreferredSize().getWidth());
                TableRowImpl.this.fixCosts.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.fixCosts.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.fixCosts.setSize(TableRowImpl.this.fixCosts.getPreferredSize());
                TableRowImpl.this.amountValue.setLocation(TableRowImpl.this.fixCosts.getX() + TableRowImpl.this.fixCosts.getWidth() + TableRowImpl.this.getInnerCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.amountValue.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.amountValue.setSize(tfw, (int)TableRowImpl.this.amountValue.getPreferredSize().getHeight());
                TableRowImpl.this.percentage.setLocation(TableRowImpl.this.amountValue.getX() + TableRowImpl.this.amountValue.getWidth() + TableRowImpl.this.getInnerCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.percentage.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.percentage.setSize(TableRowImpl.this.percentage.getPreferredSize());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(2);
                TableRowImpl.this.costs.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.costs.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.costs.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.costs.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(3);
                TableRowImpl.this.print.setLocation((int)((double)currentX + ((double)w - TableRowImpl.this.print.getPreferredSize().getWidth()) / 2.0), (int)((double)parent.getHeight() - TableRowImpl.this.print.getPreferredSize().getHeight()) / 2);
                TableRowImpl.this.print.setSize(TableRowImpl.this.print.getPreferredSize());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(4);
                TableRowImpl.this.setControlsX(currentX);
                if (TableRowImpl.this.delete != null) {
                    TableRowImpl.this.delete.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.delete.getPreferredSize().getHeight()) / 2.0));
                    TableRowImpl.this.delete.setSize(TableRowImpl.this.delete.getPreferredSize());
                }
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TableRowImpl.this.getDefaultRowHeight());
            }
        }
    }
}

