/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.mealplan.details;

import ch.icit.pegasus.client.gui.screentemplates.details.StateDependantDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDSearchTextField2;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.server.core.dtos.masterdata.ModificationStateE;
import ch.icit.pegasus.server.core.dtos.mealplan.MealPlanComplete_;
import ch.icit.pegasus.server.core.dtos.mealplan.MealPlanLight;
import ch.icit.pegasus.server.core.dtos.product.ProductCatalogLight;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public class CatalogDetailsPanel
extends StateDependantDetailsPanel<MealPlanLight> {
    private static final long serialVersionUID = 1L;
    private TitledItem<RDSearchTextField2<ProductCatalogLight>> specialMealCatalog;
    private TitledItem<RDSearchTextField2<ProductCatalogLight>> alaCarteCatalog;

    public CatalogDetailsPanel(RowEditor<MealPlanLight> editor, RDProvider provider) {
        super(editor, provider);
        this.setTitleText(Words.CATALOGS);
        this.setCustomLayouter(new Layout());
        this.specialMealCatalog = new TitledItem(new RDSearchTextField2(provider, RDSearchTextField2.SearchTypes.SPML_CATALOG, provider.isWritable(MealPlanComplete_.spmlCatalog)), Words.SPECIAL_MEAL_CATALOG, TitledItem.TitledItemOrientation.NORTH);
        this.alaCarteCatalog = new TitledItem(new RDSearchTextField2(provider, RDSearchTextField2.SearchTypes.ALACARTE_CATALOG, provider.isWritable(MealPlanComplete_.alaCarteCatalog)), Words.ALA_CARTE_CATALOG, TitledItem.TitledItemOrientation.NORTH);
        this.addToView(this.specialMealCatalog);
        this.addToView(this.alaCarteCatalog);
    }

    @Override
    public DtoField<ModificationStateE> getStateChildName() {
        return MealPlanComplete_.state;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        boolean isDraft = this.isStateDraft();
        boolean b = isEnabled && isDraft;
        this.specialMealCatalog.setEnabled(b);
        this.alaCarteCatalog.setEnabled(b);
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.specialMealCatalog.kill();
        this.specialMealCatalog = null;
        this.alaCarteCatalog.kill();
        this.alaCarteCatalog = null;
    }

    @Override
    public void setNode(Node<?> node) {
        super.setNode(node);
        this.specialMealCatalog.getElement().setNode(node.getChildNamed(MealPlanComplete_.spmlCatalog));
        this.alaCarteCatalog.getElement().setNode(node.getChildNamed(MealPlanComplete_.alaCarteCatalog));
        this.setEnabled(this.isEnabled());
    }

    @Override
    public void requestFocusInWindowNow() {
        this.specialMealCatalog.requestFocusInWindowNow();
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> focusList = new ArrayList<Component>();
        CheckedListAdder.addToList(focusList, this.specialMealCatalog);
        CheckedListAdder.addToList(focusList, this.alaCarteCatalog);
        return focusList;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = CatalogDetailsPanel.this.verticalBorder;
            h = (int)((double)h + CatalogDetailsPanel.this.specialMealCatalog.getPreferredSize().getHeight());
            h += CatalogDetailsPanel.this.inner_verticalBorder;
            h = (int)((double)h + CatalogDetailsPanel.this.alaCarteCatalog.getPreferredSize().getHeight());
            return new Dimension(0, h += CatalogDetailsPanel.this.verticalBorder);
        }

        @Override
        public void layoutContainer(Container parent) {
            CatalogDetailsPanel.this.specialMealCatalog.setLocation(CatalogDetailsPanel.this.horizontalBorder, CatalogDetailsPanel.this.verticalBorder);
            CatalogDetailsPanel.this.specialMealCatalog.setSize(parent.getWidth() - 2 * CatalogDetailsPanel.this.horizontalBorder, (int)CatalogDetailsPanel.this.specialMealCatalog.getPreferredSize().getHeight());
            CatalogDetailsPanel.this.alaCarteCatalog.setLocation(CatalogDetailsPanel.this.horizontalBorder, CatalogDetailsPanel.this.specialMealCatalog.getY() + CatalogDetailsPanel.this.specialMealCatalog.getHeight() + CatalogDetailsPanel.this.inner_verticalBorder);
            CatalogDetailsPanel.this.alaCarteCatalog.setSize(parent.getWidth() - 2 * CatalogDetailsPanel.this.horizontalBorder, (int)CatalogDetailsPanel.this.alaCarteCatalog.getPreferredSize().getHeight());
        }
    }
}

