/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.matdispocalculation.details;

import ch.icit.pegasus.client.converter.DateTimeConverter;
import ch.icit.pegasus.client.converter.PaxFigureStringConverter;
import ch.icit.pegasus.client.converter.PaxFigureTypeConverter;
import ch.icit.pegasus.client.converter.StringConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.table.DefaultDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2Model;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.DeleteButton;
import ch.icit.pegasus.client.gui.utils.buttons.TextButton;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.searchfield.SearchTextField;
import ch.icit.pegasus.client.gui.utils.skins.SizedSkin1Field;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.ViewNode;
import ch.icit.pegasus.client.search.SearchResultIterator;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight_;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightStateE;
import ch.icit.pegasus.server.core.dtos.masterdata.TimestampPeriodComplete;
import ch.icit.pegasus.server.core.dtos.matdispo.MaterialDispositionCalculationComplete_;
import ch.icit.pegasus.server.core.dtos.matdispo.MaterialDispositionCalculationLight;
import ch.icit.pegasus.server.core.dtos.search.FlightSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.supply.CustomerLight;
import ch.icit.pegasus.server.core.general.ASearchConfiguration;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public class FlightDetailsPanel
extends DefaultDetailsPanel<MaterialDispositionCalculationLight> {
    private Table2 flightTable;
    private TitledItem<SearchTextField> flightSearchField;
    private TextButton addButton;
    private TextButton clearButton;

    public FlightDetailsPanel(RowEditor<MaterialDispositionCalculationLight> editor, RDProvider provider) {
        super(editor, provider, true, true, true);
        this.setTitleText(Words.FLIGHTS);
        this.flightSearchField = new TitledItem<SearchTextField>(new SearchTextField(), Words.FLIGHT_CODE, TitledItem.TitledItemOrientation.NORTH);
        this.addButton = new TextButton(Words.ADD);
        this.clearButton = new TextButton(Words.CLEAR_ALL);
        this.addButton.addButtonListener((source, x, y) -> this.addFlight());
        this.clearButton.addButtonListener((source, x, y) -> this.flightTable.getModel().getNode().removeAllChilds());
        this.flightTable = new Table2(false, "", true, true);
        this.flightTable.setTitleText(Words.FLIGHTS);
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        columns.add(new TableColumnInfo(Words.FLIGHT_NUMBER, null, null, null, "", 80, 80, 80));
        int tw = TableColumnInfo.dateTimeColumnWidth + 2 * this.flightTable.getCellPadding();
        columns.add(new TableColumnInfo(Words.DATE, null, null, null, "", tw, tw, tw));
        columns.add(new TableColumnInfo(Words.PAX_TYPE, null, null, null, "", 90, 90, 90));
        columns.add(new TableColumnInfo(Words.PAX, null, null, null, "", 30, 30, 30));
        tw = 2 * this.flightTable.getCellPadding() + this.flightTable.getInnerCellPadding() + DeleteButton.getPreferredWidth(SizedSkin1Field.SkinSize.MEDIUM);
        columns.add(new TableColumnInfo("", null, null, null, "", tw, tw, tw));
        ((TableColumnInfo)columns.get(0)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(1)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(2)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(3)).setxExpand(1.0);
        ((TableColumnInfo)columns.get(4)).setxExpand(0.0);
        this.flightTable.setModel(new Table2Model(columns, model -> new TableRowImpl(model)));
        this.setCustomLayouter(new Layout());
        this.addToView(this.flightSearchField);
        this.addToView(this.addButton);
        this.addToView(this.clearButton);
        this.addToView(this.flightTable);
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> focusList = new ArrayList<Component>();
        CheckedListAdder.addToList(focusList, this.flightSearchField);
        CheckedListAdder.addToList(focusList, this.addButton);
        CheckedListAdder.addToList(focusList, this.clearButton);
        CheckedListAdder.addToList(focusList, this.flightTable);
        return focusList;
    }

    private void showAnimation(boolean show, String text) {
        if (show) {
            this.flightTable.showLoadingAnimation(text);
        } else {
            this.flightTable.hideLoadingAnimation();
        }
    }

    @Override
    public void setNode(Node<?> node) {
        super.setNode(node);
        this.flightTable.getModel().setNode(node.getChildNamed(MaterialDispositionCalculationComplete_.flights));
    }

    private void addFlight() {
        this.showAnimation(true, Words.ADD_FLIGHT);
        final FlightSearchConfiguration c = new FlightSearchConfiguration();
        if (Boolean.TRUE.equals(this.editor.getModel().getNode().getChildNamed(MaterialDispositionCalculationComplete_.useHaulType).getValue())) {
            this.editor.getModel().getNode().getChildNamed(MaterialDispositionCalculationComplete_.haulTypes).commitThis();
            List haulType = (List)this.editor.getModel().getNode().getChildNamed(MaterialDispositionCalculationComplete_.haulTypes).getValue();
            c.setHaulTypeList(haulType);
            c.setShowNullHaulTypes(Boolean.valueOf(true));
        }
        c.setCustomer((CustomerLight)this.editor.getModel().getNode().getChildNamed(MaterialDispositionCalculationComplete_.customer).getValue());
        c.setFlightNumber(this.flightSearchField.getElement().getText());
        this.editor.getModel().getNode().getChildNamed(MaterialDispositionCalculationComplete_.period).commitThis();
        TimestampPeriodComplete stamp = (TimestampPeriodComplete)this.editor.getModel().getNode().getChildNamed(MaterialDispositionCalculationComplete_.period).getValue();
        c.setDayTimePeriod(stamp);
        c.setFlightStdSta(FlightSearchConfiguration.FLIGHT_STD_STA.stdOnly);
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                boolean excludeCanceledFlights = (Boolean)FlightDetailsPanel.this.editor.getModel().getNode().getChildNamed(MaterialDispositionCalculationComplete_.excludeCanceledFlights).getValue();
                SearchResultIterator sri = new SearchResultIterator((ASearchConfiguration)c);
                ViewNode n = new ViewNode("");
                ArrayList<FlightLight> r = new ArrayList<FlightLight>();
                for (FlightLight f : sri) {
                    if (excludeCanceledFlights) {
                        if (f.getFlightState() == FlightStateE.CANCELLED) continue;
                        r.add(f);
                        continue;
                    }
                    r.add(f);
                }
                n.setValue(r, 0L);
                return n;
            }

            @Override
            public RemoteLoader getInvoker() {
                return new RemoteLoader(){

                    public void remoteObjectLoaded(Node<?> node) {
                        List r = (List)node.getValue();
                        if (r.isEmpty()) {
                            InnerPopupFactory.showErrorDialog("No Flight found for this configuration", "No Flight found", (Component)FlightDetailsPanel.this.flightSearchField);
                        } else {
                            FlightDetailsPanel.this.editor.getModel().getNode().getChildNamed(MaterialDispositionCalculationComplete_.period).commitThis();
                            TimestampPeriodComplete stamp2 = (TimestampPeriodComplete)FlightDetailsPanel.this.editor.getModel().getNode().getChildNamed(MaterialDispositionCalculationComplete_.period).getValue();
                            for (FlightLight f : r) {
                                if (f.getFlightState() == FlightStateE.PLANNED || FlightDetailsPanel.this.containsFlight(f) || f.getStd().getTime() < stamp2.getStartTime().getTime() || f.getStd().getTime() > stamp2.getEndTime().getTime()) continue;
                                Node n = INodeCreator.getDefaultImpl().getNode4DTO((Object)f, true, false);
                                FlightDetailsPanel.this.flightTable.getModel().getNode().addChild(n, 0L);
                            }
                            FlightDetailsPanel.this.revalidate();
                        }
                        FlightDetailsPanel.this.showAnimation(false, "");
                    }

                    public void errorOccurred(ClientException exception) {
                        InnerPopupFactory.showErrorDialog((Exception)exception, null);
                    }
                };
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    private boolean containsFlight(FlightLight l) {
        for (Table2RowPanel p : this.flightTable.getRows()) {
            if (!p.getModel().getNode().getValue().equals(l)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void requestFocusInWindowNow() {
    }

    private class TableRowImpl
    extends Table2RowPanel
    implements ButtonListener {
        private static final long serialVersionUID = 1L;
        private TextLabel flightNo;
        private TextLabel flightDate;
        private TextLabel paxType;
        private TextLabel paxFigures;
        private DeleteButton delete;

        public TableRowImpl(Table2RowModel mR) {
            super(mR);
            this.setUseControlSkin(Table2RowPanel.TableControlsType.ONE);
            this.flightNo = new TextLabel(mR.getNode().getChildNamed(new String[]{"outboundCode"}), ConverterRegistry.getConverter(StringConverter.class));
            this.flightDate = new TextLabel(mR.getNode().getChildNamed(new String[]{"std"}), ConverterRegistry.getConverter(DateTimeConverter.class));
            this.paxType = new TextLabel(mR.getNode().getChildNamed(FlightLight_.selectedPaxType), ConverterRegistry.getConverter(PaxFigureTypeConverter.class));
            this.paxFigures = new TextLabel(mR.getNode().getChildNamed(new String[]{"legs"}), ConverterRegistry.getConverter(PaxFigureStringConverter.class));
            this.delete = new DeleteButton();
            this.delete.addButtonListener(this);
            this.setLayout(new Layout());
            this.add(this.flightDate);
            this.add(this.flightNo);
            this.add(this.paxType);
            this.add(this.paxFigures);
            this.add(this.delete);
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.flightDate.kill();
            this.flightNo.kill();
            this.paxFigures.kill();
            this.delete.kill();
            this.paxType.kill();
            this.flightDate = null;
            this.flightNo = null;
            this.paxFigures = null;
            this.delete = null;
            this.paxType = null;
        }

        @Override
        public List<Component> getFocusComponents() {
            return this.delete.getFocusComponents();
        }

        @Override
        public Object getObject4Column(int column) {
            switch (column) {
                case 0: {
                    return this.model.getNode().getChildNamed(new String[]{"outboundCode"}).getValue();
                }
                case 1: {
                    return this.model.getNode().getChildNamed(new String[]{"std"}).getValue();
                }
                case 2: {
                    return this.model.getNode().getChildNamed(FlightLight_.selectedPaxType).getValue();
                }
                case 3: {
                    return this.paxFigures.getText();
                }
            }
            return null;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            super.setEnabled(isEnabled);
            this.flightDate.setEnabled(isEnabled);
            this.flightNo.setEnabled(isEnabled);
            this.paxFigures.setEnabled(isEnabled);
            this.delete.setEnabled(isEnabled);
            this.paxType.setEnabled(isEnabled);
        }

        @Override
        public void buttonPressed(Button source, int x, int y) {
            if (this.delete == source) {
                FlightDetailsPanel.this.flightTable.getModel().getNode().removeChild(this.model.getNode(), 0L);
            }
        }

        private class Layout
        extends DefaultLayout {
            private Layout() {
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TableRowImpl.this.getDefaultRowHeight());
            }

            @Override
            public void layoutContainer(Container parent) {
                int currentX = 0;
                int w = TableRowImpl.this.model.getParentModel().getColumnWidth(0);
                TableRowImpl.this.flightNo.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.flightNo.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.flightNo.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.flightNo.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(1);
                TableRowImpl.this.flightDate.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.flightDate.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.flightDate.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.flightDate.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(2);
                TableRowImpl.this.paxType.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.paxType.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.paxType.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.paxType.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(3);
                TableRowImpl.this.paxFigures.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.paxFigures.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.paxFigures.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.paxFigures.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(4);
                TableRowImpl.this.delete.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.delete.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.delete.setSize(TableRowImpl.this.delete.getPreferredSize());
            }
        }
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = FlightDetailsPanel.this.verticalBorder;
            h = (int)((double)h + FlightDetailsPanel.this.flightSearchField.getPreferredSize().getHeight());
            h += FlightDetailsPanel.this.inner_verticalBorder;
            h = (int)((double)h + FlightDetailsPanel.this.addButton.getPreferredSize().getHeight());
            h += FlightDetailsPanel.this.verticalBorder;
            h += 400;
            return new Dimension(0, h += FlightDetailsPanel.this.verticalBorder);
        }

        @Override
        public void layoutContainer(Container parent) {
            FlightDetailsPanel.this.flightSearchField.setLocation(FlightDetailsPanel.this.horizontalBorder, FlightDetailsPanel.this.verticalBorder);
            FlightDetailsPanel.this.flightSearchField.setSize(200, (int)FlightDetailsPanel.this.flightSearchField.getPreferredSize().getHeight());
            FlightDetailsPanel.this.addButton.setLocation(FlightDetailsPanel.this.flightSearchField.getX() + FlightDetailsPanel.this.flightSearchField.getWidth() + FlightDetailsPanel.this.horizontalBorder, (int)((double)(FlightDetailsPanel.this.flightSearchField.getY() + FlightDetailsPanel.this.flightSearchField.getHeight()) - FlightDetailsPanel.this.addButton.getPreferredSize().getHeight()));
            FlightDetailsPanel.this.addButton.setSize(FlightDetailsPanel.this.addButton.getPreferredSize());
            FlightDetailsPanel.this.clearButton.setLocation(FlightDetailsPanel.this.addButton.getX() + FlightDetailsPanel.this.addButton.getWidth() + FlightDetailsPanel.this.inner_horizontalBorder, FlightDetailsPanel.this.addButton.getY());
            FlightDetailsPanel.this.clearButton.setSize(FlightDetailsPanel.this.clearButton.getPreferredSize());
            FlightDetailsPanel.this.flightTable.setLocation(FlightDetailsPanel.this.horizontalBorder, FlightDetailsPanel.this.clearButton.getY() + FlightDetailsPanel.this.clearButton.getHeight() + FlightDetailsPanel.this.verticalBorder);
            FlightDetailsPanel.this.flightTable.setSize(parent.getWidth() - 2 * FlightDetailsPanel.this.horizontalBorder, parent.getHeight() - (FlightDetailsPanel.this.flightTable.getY() + FlightDetailsPanel.this.verticalBorder));
        }
    }
}

