/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.masterdata.panels;

import ch.icit.pegasus.client.converter.Converter;
import ch.icit.pegasus.client.converter.StringConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.modules.masterdata.MasterDataModule;
import ch.icit.pegasus.client.gui.modules.masterdata.panels.DetailsPanel;
import ch.icit.pegasus.client.gui.modules.masterdata.panels.MasterDataInsert;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.focus.VisibleContainer;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.masterdata.TransportCostTypeComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.TransportCostTypeComplete_;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class TransportCostTypeConfig
extends MasterDataInsert<TransportCostTypeComplete> {
    private static final long serialVersionUID = 1L;

    public TransportCostTypeConfig(MasterDataModule p) {
        super(p);
    }

    @Override
    public DetailsPanel getDetails() {
        return new TransportCostTypePanel();
    }

    @Override
    public TransportCostTypeComplete getNewObject() {
        TransportCostTypeComplete a = new TransportCostTypeComplete();
        a.setClientOId(Long.valueOf(ADTO.getNextId()));
        return a;
    }

    @Override
    public Class<TransportCostTypeComplete> getMasterDataClass() {
        return TransportCostTypeComplete.class;
    }

    @Override
    public String getInsertName() {
        return "Aircraft Types";
    }

    @Override
    public List<ScreenValidationObject> validateInsert() {
        ArrayList<ScreenValidationObject> a = new ArrayList<ScreenValidationObject>();
        Iterator it = this.masterDataTable.getModel().getNode().getChilds();
        HashSet<String> codes = new HashSet<String>();
        boolean codeSet = true;
        while (it.hasNext()) {
            Node n = (Node)it.next();
            if (n.getChildNamed(TransportCostTypeComplete_.name).getValue() == null) {
                codeSet = false;
                continue;
            }
            if (codes.contains(n.getChildNamed(TransportCostTypeComplete_.name).getValue())) {
                a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Name " + n.getChildNamed(TransportCostTypeComplete_.name).getValue() + " is not unique."));
                continue;
            }
            codes.add((String)n.getChildNamed(TransportCostTypeComplete_.name).getValue());
        }
        if (!codeSet) {
            a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Ensure all Codes are set"));
        }
        return a;
    }

    private class TransportCostTypePanel
    extends DetailsPanel {
        private static final long serialVersionUID = 1L;
        private TitledItem<TextField> Name;
        private TitledItem<TextField> description;

        public TransportCostTypePanel() {
            this.setBackground(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("inner_panel_background_color")));
            this.Name = new TitledItem<TextField>(new TextField(null), Words.NAME, TitledItem.TitledItemOrientation.NORTH);
            this.description = new TitledItem<TextField>(new TextField(null), "Description", TitledItem.TitledItemOrientation.NORTH);
            this.setLayout(new AALayout());
            this.add(this.Name);
            this.add(this.description);
        }

        @Override
        public List<Component> getFocusComponents() {
            List<Component> a = this.Name.getFocusComponents();
            a.addAll(this.description.getFocusComponents());
            return a;
        }

        @Override
        public void requestFocusInWindowNow() {
            this.Name.requestFocusInWindowNow();
        }

        @Override
        public void setVisibleContainer(VisibleContainer pane) {
            this.Name.setVisibleContainer(pane);
            this.description.setVisibleContainer(pane);
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.Name.kill();
            this.description.kill();
            this.Name = null;
            this.description = null;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            boolean b = isEnabled;
            b = this.isNodeSet() ? isEnabled : false;
            super.setEnabled(b);
            this.Name.setEnabled(b);
            this.description.setEnabled(b);
        }

        public Converter getConverter() {
            return ConverterRegistry.getConverter(StringConverter.class);
        }

        @Override
        public void setNode(Node<?> node) {
            super.setNode(node);
            this.Name.getElement().setNode(node.getChildNamed(TransportCostTypeComplete_.name));
            this.description.getElement().setNode(node.getChildNamed(TransportCostTypeComplete_.description));
            this.setEnabled(true);
            TransportCostTypeConfig.this.setEnabled(true);
        }

        @Override
        public DtoField getAttributeName() {
            return TransportCostTypeComplete_.name;
        }

        private class AALayout
        extends DefaultLayout {
            private AALayout() {
            }

            @Override
            public void layoutContainer(Container parent) {
                TransportCostTypePanel.this.Name.setLocation(TransportCostTypeConfig.this.masterDataTable.getCellPadding(), TransportCostTypeConfig.this.masterDataTable.getCellPadding());
                TransportCostTypePanel.this.Name.setSize(200, (int)TransportCostTypePanel.this.Name.getPreferredSize().getHeight());
                TransportCostTypePanel.this.description.setLocation(TransportCostTypeConfig.this.masterDataTable.getCellPadding(), TransportCostTypePanel.this.Name.getY() + TransportCostTypePanel.this.Name.getHeight() + TransportCostTypeConfig.this.masterDataTable.getCellPadding());
                TransportCostTypePanel.this.description.setSize(200, (int)TransportCostTypePanel.this.description.getPreferredSize().getHeight());
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension();
            }
        }
    }
}

