/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.masterdata.panels;

import ch.icit.pegasus.client.gui.modules.masterdata.AbstractDataInsertModule;
import ch.icit.pegasus.client.gui.modules.masterdata.panels.DefaultDataInsert;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.InnerPopUpListener2;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.focus.VisibleContainer;
import ch.icit.pegasus.client.gui.utils.panels.ScrollableBackground;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.tables.CustomerUpdateColumnCountTable;
import ch.icit.pegasus.client.gui.utils.tables.WeeklyPlanStoreConfigurationTable;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextFieldType;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.StaticEnumServiceManager;
import ch.icit.pegasus.client.services.interfaces.masterdata.MasterDataServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.SystemSettingsServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.company.InternalCostCenterComplete;
import ch.icit.pegasus.server.core.dtos.production_new.UpdateConfigurationComplete;
import ch.icit.pegasus.server.core.dtos.production_new.WeeklyPlanSettingsComplete;
import ch.icit.pegasus.server.core.dtos.production_new.WeeklyPlanSettingsComplete_;
import ch.icit.pegasus.server.core.dtos.utils.DateUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public class SettingsWeeklyPlanConfig
extends DefaultDataInsert
implements ButtonListener,
InnerPopUpListener2 {
    private static final long serialVersionUID = 1L;
    private ScrollableBackground scrollPane;
    private Node<WeeklyPlanSettingsComplete> node;
    private TitledItem<TextField> dayStart;
    private TitledItem<TextField> dayEnd;
    private TitledItem<CheckBox> useProductionCharges;
    private TitledItem<CheckBox> useWeeklyPlan;
    private CustomerUpdateColumnCountTable moTable;
    private CustomerUpdateColumnCountTable tuTable;
    private CustomerUpdateColumnCountTable weTable;
    private CustomerUpdateColumnCountTable thTable;
    private CustomerUpdateColumnCountTable frTable;
    private CustomerUpdateColumnCountTable saTable;
    private CustomerUpdateColumnCountTable suTable;
    private WeeklyPlanStoreConfigurationTable storeConfig;

    public SettingsWeeklyPlanConfig(AbstractDataInsertModule parent) {
        super(parent);
        this.setLayout(new Layout2());
    }

    @Override
    public void insertElements() {
        this.scrollPane = new ScrollableBackground(false);
        this.useWeeklyPlan = new TitledItem<CheckBox>(new CheckBox(), "Use Weekly Plan", TitledItem.TitledItemOrientation.EAST);
        this.dayStart = new TitledItem<TextField>(new TextField(null, TextFieldType.DAYTIME), "Day Start", TitledItem.TitledItemOrientation.NORTH);
        this.dayEnd = new TitledItem<TextField>(new TextField(null, TextFieldType.DAYTIME), "Day End", TitledItem.TitledItemOrientation.NORTH);
        this.useProductionCharges = new TitledItem<CheckBox>(new CheckBox(), "Use Production Charges", TitledItem.TitledItemOrientation.EAST);
        this.moTable = new CustomerUpdateColumnCountTable("Monday");
        this.tuTable = new CustomerUpdateColumnCountTable("Tuesday");
        this.weTable = new CustomerUpdateColumnCountTable("Wednesday");
        this.thTable = new CustomerUpdateColumnCountTable("Thursday");
        this.frTable = new CustomerUpdateColumnCountTable("Friday");
        this.saTable = new CustomerUpdateColumnCountTable("Saturday");
        this.suTable = new CustomerUpdateColumnCountTable("Sunday");
        this.storeConfig = new WeeklyPlanStoreConfigurationTable();
        this.scrollPane.getViewPort().setLayout(new Layout());
        this.scrollPane.getViewPort().add(this.useWeeklyPlan);
        this.scrollPane.getViewPort().add(this.dayStart);
        this.scrollPane.getViewPort().add(this.dayEnd);
        this.scrollPane.getViewPort().add(this.useProductionCharges);
        this.scrollPane.getViewPort().add(this.moTable);
        this.scrollPane.getViewPort().add(this.tuTable);
        this.scrollPane.getViewPort().add(this.weTable);
        this.scrollPane.getViewPort().add(this.thTable);
        this.scrollPane.getViewPort().add(this.frTable);
        this.scrollPane.getViewPort().add(this.saTable);
        this.scrollPane.getViewPort().add(this.suTable);
        this.scrollPane.getViewPort().add(this.storeConfig);
        this.add(this.scrollPane);
        this.isInserted = true;
    }

    @Override
    public String getInsertName() {
        return "Weekly Plan Settings";
    }

    @Override
    public Node getNode() {
        return this.node;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.isInserted) {
            this.useWeeklyPlan.kill();
            this.dayStart.kill();
            this.dayEnd.kill();
            this.useProductionCharges.kill();
            this.moTable.kill();
            this.tuTable.kill();
            this.weTable.kill();
            this.thTable.kill();
            this.frTable.kill();
            this.saTable.kill();
            this.suTable.kill();
            this.storeConfig.kill();
        }
        this.useWeeklyPlan = null;
        this.dayStart = null;
        this.dayEnd = null;
        this.useProductionCharges = null;
        this.moTable = null;
        this.tuTable = null;
        this.weTable = null;
        this.thTable = null;
        this.frTable = null;
        this.saTable = null;
        this.suTable = null;
        this.storeConfig = null;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        if (this.isInserted) {
            boolean and = this.useWeeklyPlan.getElement().isChecked();
            this.useWeeklyPlan.setEnabled(isEnabled);
            this.dayStart.setEnabled(isEnabled && and);
            this.dayEnd.setEnabled(isEnabled && and);
            this.useProductionCharges.setEnabled(isEnabled && and);
            this.moTable.setEnabled(isEnabled && and);
            this.tuTable.setEnabled(isEnabled && and);
            this.weTable.setEnabled(isEnabled && and);
            this.thTable.setEnabled(isEnabled && and);
            this.frTable.setEnabled(isEnabled && and);
            this.saTable.setEnabled(isEnabled && and);
            this.suTable.setEnabled(isEnabled && and);
            this.storeConfig.setEnabled(isEnabled && and);
        }
    }

    @Override
    public List<Component> getFocusComponents() {
        if (this.isInserted) {
            ArrayList<Component> focusList = new ArrayList<Component>();
            CheckedListAdder.addToList(focusList, this.useWeeklyPlan);
            CheckedListAdder.addToList(focusList, this.dayStart);
            CheckedListAdder.addToList(focusList, this.dayEnd);
            CheckedListAdder.addToList(focusList, this.useProductionCharges);
            CheckedListAdder.addToList(focusList, this.moTable);
            CheckedListAdder.addToList(focusList, this.tuTable);
            CheckedListAdder.addToList(focusList, this.weTable);
            CheckedListAdder.addToList(focusList, this.thTable);
            CheckedListAdder.addToList(focusList, this.frTable);
            CheckedListAdder.addToList(focusList, this.saTable);
            CheckedListAdder.addToList(focusList, this.suTable);
            CheckedListAdder.addToList(focusList, this.storeConfig);
            return focusList;
        }
        return null;
    }

    @Override
    public void setVisibleContainer(VisibleContainer pane) {
    }

    @Override
    public void requestFocusInWindowNow() {
        if (this.isInserted) {
            this.dayStart.requestFocusInWindowNow();
        }
    }

    @Override
    public void saveIt() {
        super.saveIt();
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                SettingsWeeklyPlanConfig.this.node.commitThis(WeeklyPlanSettingsComplete.class);
                WeeklyPlanSettingsComplete s = (WeeklyPlanSettingsComplete)SettingsWeeklyPlanConfig.this.node.getValue(WeeklyPlanSettingsComplete.class);
                if (s.getDayStart() == null) {
                    s.setDayStart(DateUtil.getSQLTime((int)6, (int)0, (int)0));
                }
                if (s.getDayEnd() == null) {
                    s.setDayEnd(DateUtil.getSQLTime((int)20, (int)0, (int)0));
                }
                if (s.getUseProductionCharges() == null) {
                    s.setUseProductionCharges(Boolean.valueOf(false));
                }
                s = (WeeklyPlanSettingsComplete)((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).updateWeeklyPlanSettings(s).getValue();
                SettingsWeeklyPlanConfig.this.node.removeExistingValues();
                SettingsWeeklyPlanConfig.this.node.setValue((Object)s, 0L);
                SettingsWeeklyPlanConfig.this.node.updateNode();
                return SettingsWeeklyPlanConfig.this.node;
            }

            @Override
            public RemoteLoader getInvoker() {
                return SettingsWeeklyPlanConfig.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    private void initDefaultConfiguration(List<UpdateConfigurationComplete> list, int count) {
        for (UpdateConfigurationComplete updateConfigurationComplete : list) {
            if (updateConfigurationComplete.getCustomer() != null) continue;
            return;
        }
        UpdateConfigurationComplete config = new UpdateConfigurationComplete();
        config.setClientOId(Long.valueOf(ADTO.getNextId()));
        config.setColumnCount(Integer.valueOf(count));
        list.add(config);
    }

    @Override
    public void loadData() {
        super.loadData();
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                StaticEnumServiceManager.getAllWeeklyPlanStoreTypes();
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(InternalCostCenterComplete.class);
                SettingsWeeklyPlanConfig.this.changeLoadingState("Load 1/1 Modules");
                Node settings = ((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getWeeklyPlanSettingsCached();
                if (settings.getValue() == null) {
                    WeeklyPlanSettingsComplete settingsComplete = new WeeklyPlanSettingsComplete();
                    settingsComplete.setClientOId(Long.valueOf(ADTO.getNextId()));
                    settings.setValue((Object)settingsComplete, 0L);
                }
                if (((WeeklyPlanSettingsComplete)settings.getValue()).getDayStart() == null) {
                    ((WeeklyPlanSettingsComplete)settings.getValue()).setDayStart(DateUtil.getSQLTime((int)6, (int)0, (int)0));
                }
                if (((WeeklyPlanSettingsComplete)settings.getValue()).getDayEnd() == null) {
                    ((WeeklyPlanSettingsComplete)settings.getValue()).setDayEnd(DateUtil.getSQLTime((int)20, (int)0, (int)0));
                }
                if (((WeeklyPlanSettingsComplete)settings.getValue()).getUseProductionCharges() == null) {
                    ((WeeklyPlanSettingsComplete)settings.getValue()).setUseProductionCharges(Boolean.valueOf(false));
                }
                SettingsWeeklyPlanConfig.this.initDefaultConfiguration(((WeeklyPlanSettingsComplete)settings.getValue()).getMondayUpdateCount(), 0);
                SettingsWeeklyPlanConfig.this.initDefaultConfiguration(((WeeklyPlanSettingsComplete)settings.getValue()).getTuesdayUpdateCount(), 0);
                SettingsWeeklyPlanConfig.this.initDefaultConfiguration(((WeeklyPlanSettingsComplete)settings.getValue()).getWednesdayUpdateCount(), 0);
                SettingsWeeklyPlanConfig.this.initDefaultConfiguration(((WeeklyPlanSettingsComplete)settings.getValue()).getThursdayUpdateCount(), 0);
                SettingsWeeklyPlanConfig.this.initDefaultConfiguration(((WeeklyPlanSettingsComplete)settings.getValue()).getFridayUpdateCount(), 0);
                SettingsWeeklyPlanConfig.this.initDefaultConfiguration(((WeeklyPlanSettingsComplete)settings.getValue()).getSaturdayUpdateCount(), 0);
                SettingsWeeklyPlanConfig.this.initDefaultConfiguration(((WeeklyPlanSettingsComplete)settings.getValue()).getSundayUpdateCount(), 0);
                return settings;
            }

            @Override
            public RemoteLoader getInvoker() {
                return SettingsWeeklyPlanConfig.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public void remoteObjectLoaded(Node<?> node) {
        super.remoteObjectLoaded(node);
        this.setNode(node);
    }

    private void setNode(Node<WeeklyPlanSettingsComplete> node) {
        this.node = node;
        if (!this.isInserted) {
            return;
        }
        node.updateNode();
        this.useWeeklyPlan.getElement().setNode(node.getChildNamed(WeeklyPlanSettingsComplete_.useWeeklyPlan));
        this.dayStart.getElement().setNode(node.getChildNamed(WeeklyPlanSettingsComplete_.dayStart));
        this.dayEnd.getElement().setNode(node.getChildNamed(WeeklyPlanSettingsComplete_.dayEnd));
        this.useProductionCharges.getElement().setNode(node.getChildNamed(WeeklyPlanSettingsComplete_.useProductionCharges));
        this.moTable.setNode(node.getChildNamed(WeeklyPlanSettingsComplete_.mondayUpdateCount));
        this.tuTable.setNode(node.getChildNamed(WeeklyPlanSettingsComplete_.tuesdayUpdateCount));
        this.weTable.setNode(node.getChildNamed(WeeklyPlanSettingsComplete_.wednesdayUpdateCount));
        this.thTable.setNode(node.getChildNamed(WeeklyPlanSettingsComplete_.thursdayUpdateCount));
        this.frTable.setNode(node.getChildNamed(WeeklyPlanSettingsComplete_.fridayUpdateCount));
        this.saTable.setNode(node.getChildNamed(WeeklyPlanSettingsComplete_.saturdayUpdateCount));
        this.suTable.setNode(node.getChildNamed(WeeklyPlanSettingsComplete_.sundayUpdateCount));
        this.storeConfig.setNode(node);
        this.setEnabled(true);
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
    }

    @Override
    public void popUpClosed(InnerPopUp2 source, Object ... xargs) {
    }

    @Override
    public List<ScreenValidationObject> validateInsert() {
        ArrayList<ScreenValidationObject> validationObjects = new ArrayList<ScreenValidationObject>();
        return validationObjects;
    }

    private class Layout2
    extends DefaultLayout {
        private Layout2() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension(0, 0);
        }

        @Override
        public void layoutContainer(Container parent) {
            SettingsWeeklyPlanConfig.this.layoutAnimation(parent);
            if (SettingsWeeklyPlanConfig.this.isInserted) {
                SettingsWeeklyPlanConfig.this.scrollPane.setLocation(1, 1);
                SettingsWeeklyPlanConfig.this.scrollPane.setSize(parent.getWidth() - 2, parent.getHeight() - 2);
            }
        }
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int border;
            int h = border = 10;
            if (SettingsWeeklyPlanConfig.this.isInserted) {
                h += 2000;
            }
            return new Dimension(0, h);
        }

        @Override
        public void layoutContainer(Container parent) {
            int border = 10;
            if (SettingsWeeklyPlanConfig.this.isInserted) {
                SettingsWeeklyPlanConfig.this.useWeeklyPlan.setLocation(border, border * 2);
                SettingsWeeklyPlanConfig.this.useWeeklyPlan.setSize(SettingsWeeklyPlanConfig.this.useWeeklyPlan.getPreferredSize());
                SettingsWeeklyPlanConfig.this.dayStart.setLocation(border, SettingsWeeklyPlanConfig.this.useWeeklyPlan.getY() + SettingsWeeklyPlanConfig.this.useWeeklyPlan.getHeight() + border);
                SettingsWeeklyPlanConfig.this.dayStart.setSize(SettingsWeeklyPlanConfig.this.dayStart.getPreferredSize());
                SettingsWeeklyPlanConfig.this.dayEnd.setLocation(border, SettingsWeeklyPlanConfig.this.dayStart.getY() + SettingsWeeklyPlanConfig.this.dayStart.getHeight() + border);
                SettingsWeeklyPlanConfig.this.dayEnd.setSize(SettingsWeeklyPlanConfig.this.dayEnd.getPreferredSize());
                SettingsWeeklyPlanConfig.this.useProductionCharges.setLocation(border, SettingsWeeklyPlanConfig.this.dayEnd.getY() + SettingsWeeklyPlanConfig.this.dayEnd.getHeight() + border);
                SettingsWeeklyPlanConfig.this.useProductionCharges.setSize(SettingsWeeklyPlanConfig.this.useProductionCharges.getPreferredSize());
                SettingsWeeklyPlanConfig.this.moTable.setLocation(border, SettingsWeeklyPlanConfig.this.useProductionCharges.getY() + SettingsWeeklyPlanConfig.this.useProductionCharges.getHeight() + border);
                SettingsWeeklyPlanConfig.this.moTable.setSize(500, 200);
                SettingsWeeklyPlanConfig.this.tuTable.setLocation(border, SettingsWeeklyPlanConfig.this.moTable.getY() + SettingsWeeklyPlanConfig.this.moTable.getHeight() + border);
                SettingsWeeklyPlanConfig.this.tuTable.setSize(500, 200);
                SettingsWeeklyPlanConfig.this.weTable.setLocation(border, SettingsWeeklyPlanConfig.this.tuTable.getY() + SettingsWeeklyPlanConfig.this.tuTable.getHeight() + border);
                SettingsWeeklyPlanConfig.this.weTable.setSize(500, 200);
                SettingsWeeklyPlanConfig.this.thTable.setLocation(border, SettingsWeeklyPlanConfig.this.weTable.getY() + SettingsWeeklyPlanConfig.this.weTable.getHeight() + border);
                SettingsWeeklyPlanConfig.this.thTable.setSize(500, 200);
                SettingsWeeklyPlanConfig.this.frTable.setLocation(border, SettingsWeeklyPlanConfig.this.thTable.getY() + SettingsWeeklyPlanConfig.this.thTable.getHeight() + border);
                SettingsWeeklyPlanConfig.this.frTable.setSize(500, 200);
                SettingsWeeklyPlanConfig.this.saTable.setLocation(border, SettingsWeeklyPlanConfig.this.frTable.getY() + SettingsWeeklyPlanConfig.this.frTable.getHeight() + border);
                SettingsWeeklyPlanConfig.this.saTable.setSize(500, 200);
                SettingsWeeklyPlanConfig.this.suTable.setLocation(border, SettingsWeeklyPlanConfig.this.saTable.getY() + SettingsWeeklyPlanConfig.this.saTable.getHeight() + border);
                SettingsWeeklyPlanConfig.this.suTable.setSize(500, 200);
                SettingsWeeklyPlanConfig.this.storeConfig.setLocation(border, SettingsWeeklyPlanConfig.this.suTable.getY() + SettingsWeeklyPlanConfig.this.suTable.getHeight() + border);
                SettingsWeeklyPlanConfig.this.storeConfig.setSize(500, 200);
            }
        }
    }
}

