/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.masterdata.panels;

import ch.icit.pegasus.client.gui.modules.masterdata.AbstractDataInsertModule;
import ch.icit.pegasus.client.gui.modules.masterdata.panels.DefaultDataInsert;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.InnerPopUpListener2;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.focus.VisibleContainer;
import ch.icit.pegasus.client.gui.utils.panels.ScrollableBackground;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.system.SystemSettingsServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.server.core.dtos.system.TrolleyScanSettingsComplete;
import ch.icit.pegasus.server.core.dtos.system.TrolleyScanSettingsComplete_;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public class SettingsTrolleyScanConfig
extends DefaultDataInsert
implements ButtonListener,
InnerPopUpListener2 {
    private static final long serialVersionUID = 1L;
    private ScrollableBackground scrollPane;
    private Node<TrolleyScanSettingsComplete> node;
    private TitledItem<CheckBox> useTrolleyScan;
    private TitledItem<CheckBox> scanTruck;
    private TitledItem<CheckBox> scanTruckSeal;
    private TitledItem<CheckBox> scanDriver;

    public SettingsTrolleyScanConfig(AbstractDataInsertModule parent) {
        super(parent);
        this.setLayout(new Layout2());
    }

    @Override
    public void insertElements() {
        this.scrollPane = new ScrollableBackground(false);
        this.useTrolleyScan = new TitledItem<CheckBox>(new CheckBox(), "Use Trolley Scan", TitledItem.TitledItemOrientation.EAST);
        this.scanTruck = new TitledItem<CheckBox>(new CheckBox(), "Scan Truck", TitledItem.TitledItemOrientation.EAST);
        this.scanTruckSeal = new TitledItem<CheckBox>(new CheckBox(), "Scan Truck Seal", TitledItem.TitledItemOrientation.EAST);
        this.scanDriver = new TitledItem<CheckBox>(new CheckBox(), "Scan Driver", TitledItem.TitledItemOrientation.EAST);
        this.scrollPane.getViewPort().setLayout(new Layout());
        this.scrollPane.getViewPort().add(this.useTrolleyScan);
        this.scrollPane.getViewPort().add(this.scanTruck);
        this.scrollPane.getViewPort().add(this.scanTruckSeal);
        this.scrollPane.getViewPort().add(this.scanDriver);
        this.add(this.scrollPane);
        this.isInserted = true;
    }

    @Override
    public String getInsertName() {
        return "Settings Trolley Scan";
    }

    @Override
    public Node getNode() {
        return this.node;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.isInserted) {
            this.scanTruck.kill();
            this.scanTruckSeal.kill();
            this.useTrolleyScan.kill();
            this.scanDriver.kill();
        }
        this.scanTruck = null;
        this.scanTruckSeal = null;
        this.useTrolleyScan = null;
        this.scanDriver = null;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        this.useTrolleyScan.setEnabled(isEnabled);
        this.scanTruck.setEnabled(isEnabled);
        this.scanTruckSeal.setEnabled(isEnabled);
        this.scanDriver.setEnabled(isEnabled);
    }

    @Override
    public List<ScreenValidationObject> validateInsert() {
        ArrayList<ScreenValidationObject> validationObjects = new ArrayList<ScreenValidationObject>();
        return validationObjects;
    }

    @Override
    public List<Component> getFocusComponents() {
        if (this.isInserted) {
            ArrayList<Component> focusList = new ArrayList<Component>();
            CheckedListAdder.addToList(focusList, this.useTrolleyScan);
            CheckedListAdder.addToList(focusList, this.scanTruck);
            CheckedListAdder.addToList(focusList, this.scanTruckSeal);
            CheckedListAdder.addToList(focusList, this.scanDriver);
            return focusList;
        }
        return null;
    }

    @Override
    public void setVisibleContainer(VisibleContainer pane) {
    }

    @Override
    public void requestFocusInWindowNow() {
        if (this.isInserted) {
            this.scanTruck.requestFocusInWindowNow();
        }
    }

    @Override
    public void saveIt() {
        super.saveIt();
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                SettingsTrolleyScanConfig.this.node.commitThis(TrolleyScanSettingsComplete.class);
                TrolleyScanSettingsComplete s = (TrolleyScanSettingsComplete)SettingsTrolleyScanConfig.this.node.getValue(TrolleyScanSettingsComplete.class);
                s = (TrolleyScanSettingsComplete)((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).updateTrolleyScanSettings(s).getValue();
                SettingsTrolleyScanConfig.this.node.removeExistingValues();
                SettingsTrolleyScanConfig.this.node.setValue((Object)s, 0L);
                SettingsTrolleyScanConfig.this.node.updateNode();
                return null;
            }

            @Override
            public RemoteLoader getInvoker() {
                return SettingsTrolleyScanConfig.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public void loadData() {
        super.loadData();
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                SettingsTrolleyScanConfig.this.changeLoadingState("Load 1/1 Modules");
                TrolleyScanSettingsComplete value = (TrolleyScanSettingsComplete)((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getTrolleyScanSettings().getValue();
                return INodeCreator.getDefaultImpl().getNode4DTO((Object)value, false, false);
            }

            @Override
            public RemoteLoader getInvoker() {
                return SettingsTrolleyScanConfig.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public void remoteObjectLoaded(Node<?> node) {
        super.remoteObjectLoaded(node);
        if (this.currentState == DefaultDataInsert.LoadingState.LOAD) {
            this.setNode(node);
        }
    }

    private void setNode(Node<TrolleyScanSettingsComplete> node) {
        this.node = node;
        if (!this.isInserted) {
            return;
        }
        this.useTrolleyScan.getElement().setNode(node.getChildNamed(TrolleyScanSettingsComplete_.useTrolleyScan));
        this.scanTruck.getElement().setNode(node.getChildNamed(TrolleyScanSettingsComplete_.scanTruck));
        this.scanTruckSeal.getElement().setNode(node.getChildNamed(TrolleyScanSettingsComplete_.scanTruckSeal));
        this.scanDriver.getElement().setNode(node.getChildNamed(TrolleyScanSettingsComplete_.scanTruckDriver));
        this.setEnabled(true);
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
    }

    @Override
    public void popUpClosed(InnerPopUp2 source, Object ... xargs) {
    }

    private class Layout2
    extends DefaultLayout {
        private Layout2() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension(0, 0);
        }

        @Override
        public void layoutContainer(Container parent) {
            SettingsTrolleyScanConfig.this.layoutAnimation(parent);
            if (SettingsTrolleyScanConfig.this.isInserted) {
                SettingsTrolleyScanConfig.this.scrollPane.setLocation(1, 1);
                SettingsTrolleyScanConfig.this.scrollPane.setSize(parent.getWidth() - 2, parent.getHeight() - 2);
            }
        }
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int border;
            int h = border = 10;
            if (SettingsTrolleyScanConfig.this.isInserted) {
                h = (int)((double)h + (SettingsTrolleyScanConfig.this.useTrolleyScan.getPreferredSize().getHeight() + (double)border));
                h = (int)((double)h + (SettingsTrolleyScanConfig.this.scanTruck.getPreferredSize().getHeight() + (double)border));
                h = (int)((double)h + (SettingsTrolleyScanConfig.this.scanTruckSeal.getPreferredSize().getHeight() + (double)border));
                h = (int)((double)h + (SettingsTrolleyScanConfig.this.scanDriver.getPreferredSize().getHeight() + (double)border));
            }
            return new Dimension(0, h);
        }

        @Override
        public void layoutContainer(Container parent) {
            int w = parent.getWidth() - 40;
            int border = 10;
            if (SettingsTrolleyScanConfig.this.isInserted) {
                SettingsTrolleyScanConfig.this.useTrolleyScan.setLocation(border, border * 2);
                SettingsTrolleyScanConfig.this.useTrolleyScan.setSize(SettingsTrolleyScanConfig.this.useTrolleyScan.getPreferredSize());
                SettingsTrolleyScanConfig.this.scanTruck.setLocation(border, SettingsTrolleyScanConfig.this.useTrolleyScan.getY() + SettingsTrolleyScanConfig.this.useTrolleyScan.getHeight() + border);
                SettingsTrolleyScanConfig.this.scanTruck.setSize(SettingsTrolleyScanConfig.this.scanTruck.getPreferredSize());
                SettingsTrolleyScanConfig.this.scanTruckSeal.setLocation(SettingsTrolleyScanConfig.this.scanTruck.getX(), SettingsTrolleyScanConfig.this.scanTruck.getY() + SettingsTrolleyScanConfig.this.scanTruck.getHeight() + border);
                SettingsTrolleyScanConfig.this.scanTruckSeal.setSize(SettingsTrolleyScanConfig.this.scanTruckSeal.getPreferredSize());
                SettingsTrolleyScanConfig.this.scanDriver.setLocation(SettingsTrolleyScanConfig.this.scanTruckSeal.getX(), SettingsTrolleyScanConfig.this.scanTruckSeal.getY() + SettingsTrolleyScanConfig.this.scanTruckSeal.getHeight() + border);
                SettingsTrolleyScanConfig.this.scanDriver.setSize(SettingsTrolleyScanConfig.this.scanDriver.getPreferredSize());
            }
        }
    }
}

