/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.masterdata.panels;

import ch.icit.pegasus.client.converter.Converter;
import ch.icit.pegasus.client.converter.StringConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.modules.masterdata.MasterDataModule;
import ch.icit.pegasus.client.gui.modules.masterdata.panels.DetailsPanel;
import ch.icit.pegasus.client.gui.modules.masterdata.panels.MasterDataInsert;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.focus.VisibleContainer;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.supply.OrderTypeComplete;
import ch.icit.pegasus.server.core.dtos.supply.OrderTypeComplete_;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class OrderTypeConfig
extends MasterDataInsert<OrderTypeComplete> {
    private static final long serialVersionUID = 1L;

    public OrderTypeConfig(MasterDataModule p) {
        super(p);
    }

    @Override
    public DetailsPanel getDetails() {
        return new OrderTypeConfigPanel();
    }

    @Override
    public String getInsertName() {
        return "Order Types";
    }

    @Override
    public OrderTypeComplete getNewObject() {
        OrderTypeComplete a = new OrderTypeComplete();
        a.setClientOId(Long.valueOf(ADTO.getNextId()));
        return a;
    }

    @Override
    public Class<? extends OrderTypeComplete> getMasterDataClass() {
        return OrderTypeComplete.class;
    }

    @Override
    public List<ScreenValidationObject> validateInsert() {
        ArrayList<ScreenValidationObject> a = new ArrayList<ScreenValidationObject>();
        Iterator it = this.masterDataTable.getModel().getNode().getChilds();
        HashSet<String> names = new HashSet<String>();
        boolean nameSet = true;
        while (it.hasNext()) {
            Node n = (Node)it.next();
            if (n.getChildNamed(OrderTypeComplete_.name).getValue() == null) {
                nameSet = false;
                continue;
            }
            if (names.contains(n.getChildNamed(OrderTypeComplete_.name).getValue())) {
                a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Name " + n.getChildNamed(OrderTypeComplete_.name).getValue() + " is not unique."));
                continue;
            }
            names.add((String)n.getChildNamed(OrderTypeComplete_.name).getValue());
        }
        if (!nameSet) {
            a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Ensure all Codes are set"));
        }
        return a;
    }

    private class OrderTypeConfigPanel
    extends DetailsPanel {
        private static final long serialVersionUID = 1L;
        private TitledItem<TextField> name;
        private TitledItem<CheckBox> isEmail;

        public OrderTypeConfigPanel() {
            this.setBackground(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("inner_panel_background_color")));
            this.name = new TitledItem<TextField>(new TextField(null), "Name", TitledItem.TitledItemOrientation.NORTH);
            this.isEmail = new TitledItem<CheckBox>(new CheckBox(), "is Email", TitledItem.TitledItemOrientation.NORTH);
            this.setLayout(new AALayout());
            this.add(this.name);
            this.add(this.isEmail);
        }

        @Override
        public List<Component> getFocusComponents() {
            List<Component> a = this.name.getFocusComponents();
            a.addAll(this.isEmail.getFocusComponents());
            return a;
        }

        @Override
        public void requestFocusInWindowNow() {
            this.name.requestFocusInWindowNow();
        }

        @Override
        public void setVisibleContainer(VisibleContainer pane) {
            this.name.setVisibleContainer(pane);
            this.isEmail.setVisibleContainer(pane);
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.name.kill();
            this.isEmail.kill();
            this.name = null;
            this.isEmail = null;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            boolean b = isEnabled;
            b = this.isNodeSet() ? isEnabled : false;
            super.setEnabled(b);
            this.name.setEnabled(b);
            this.isEmail.setEnabled(b);
        }

        public Converter getConverter() {
            return ConverterRegistry.getConverter(StringConverter.class);
        }

        @Override
        public void setNode(Node<?> node) {
            super.setNode(node);
            this.name.getElement().setNode(node.getChildNamed(OrderTypeComplete_.name));
            this.isEmail.getElement().setNode(node.getChildNamed(OrderTypeComplete_.isEmail));
            this.setEnabled(true);
            OrderTypeConfig.this.setEnabled(true);
        }

        @Override
        public DtoField getAttributeName() {
            return OrderTypeComplete_.name;
        }

        private class AALayout
        extends DefaultLayout {
            private AALayout() {
            }

            @Override
            public void layoutContainer(Container parent) {
                OrderTypeConfigPanel.this.name.setLocation(OrderTypeConfig.this.masterDataTable.getCellPadding(), OrderTypeConfig.this.masterDataTable.getCellPadding());
                OrderTypeConfigPanel.this.name.setSize(200, (int)OrderTypeConfigPanel.this.name.getPreferredSize().getHeight());
                OrderTypeConfigPanel.this.isEmail.setLocation(OrderTypeConfig.this.masterDataTable.getCellPadding(), OrderTypeConfigPanel.this.name.getY() + OrderTypeConfigPanel.this.name.getHeight() + OrderTypeConfig.this.masterDataTable.getCellPadding());
                OrderTypeConfigPanel.this.isEmail.setSize(200, (int)OrderTypeConfigPanel.this.isEmail.getPreferredSize().getHeight());
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension();
            }
        }
    }
}

